/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.panama;

import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.runtime.panama.AbstractArgumentsCalculator;
import com.oracle.truffle.espresso.runtime.panama.Platform;
import com.oracle.truffle.espresso.runtime.panama.VMStorage;

public class DefaultArgumentsCalculator
extends AbstractArgumentsCalculator {
    protected int intIndex;
    protected int floatIndex;
    protected int globalIndex;

    public DefaultArgumentsCalculator(Platform platform, VMStorage[] callIntRegs, VMStorage[] callFloatRegs, VMStorage intReturn, VMStorage floatReturn) {
        super(platform, callIntRegs, callFloatRegs, intReturn, floatReturn);
    }

    @Override
    public int getNextInputIndex(VMStorage reg, Klass type, VMStorage nextReg, Klass nextType) {
        assert (DefaultArgumentsCalculator.isInt(type) || DefaultArgumentsCalculator.isFloat(type)) : this.platform.toString(reg) + ": " + type;
        if (this.intIndex < this.callIntRegs.length && this.callIntRegs[this.intIndex].equals(reg)) {
            assert (DefaultArgumentsCalculator.isInt(type)) : this.platform.toString(reg) + ": " + type;
            ++this.intIndex;
            return this.globalIndex++;
        }
        if (this.floatIndex < this.callFloatRegs.length && this.callFloatRegs[this.floatIndex].equals(reg)) {
            assert (DefaultArgumentsCalculator.isFloat(type)) : this.platform.toString(reg) + ": " + type;
            ++this.floatIndex;
            return this.globalIndex++;
        }
        if (reg.type(this.platform).isStack()) {
            assert (!DefaultArgumentsCalculator.isInt(type) || this.intIndex == this.callIntRegs.length) : this.platform.toString(reg) + ": " + type;
            assert (!DefaultArgumentsCalculator.isFloat(type) || this.floatIndex == this.callFloatRegs.length) : this.platform.toString(reg) + ": " + type;
            return this.globalIndex++;
        }
        return -1;
    }

    @Override
    public boolean checkReturn(VMStorage reg, Klass type) {
        if (this.intReturn.equals(reg)) {
            assert (DefaultArgumentsCalculator.isInt(type)) : this.platform.toString(reg) + ": " + type;
            return true;
        }
        if (this.floatReturn.equals(reg)) {
            assert (DefaultArgumentsCalculator.isFloat(type)) : this.platform.toString(reg) + ": " + type;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVarArg(VMStorage reg, Klass type, VMStorage nextReg, Klass nextType) {
        return false;
    }

    public String toString() {
        return "DefaultArgumentsCalculator{platform=" + this.platform + ", intIndex=" + this.intIndex + ", floatIndex=" + this.floatIndex + ", globalIndex=" + this.globalIndex + "}";
    }
}

