/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.panama;

import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.OS;
import com.oracle.truffle.espresso.runtime.panama.ArgumentsCalculator;
import com.oracle.truffle.espresso.runtime.panama.StorageType;
import com.oracle.truffle.espresso.runtime.panama.VMStorage;
import com.oracle.truffle.espresso.runtime.panama.aarch64.AAPCS64;
import com.oracle.truffle.espresso.runtime.panama.aarch64.DarwinAAPCS64;
import com.oracle.truffle.espresso.runtime.panama.x64.SysVx64;
import com.oracle.truffle.espresso.runtime.panama.x64.WindowsX64;
import java.util.Locale;

public abstract class Platform {
    public static Platform getHostPlatform() {
        String arch;
        return switch (arch = System.getProperty("os.arch").toLowerCase(Locale.ROOT)) {
            case "x86_64", "amd64" -> {
                switch (OS.getCurrent()) {
                    case Linux: 
                    case Darwin: {
                        yield SysVx64.INSTANCE;
                    }
                    case Windows: {
                        yield WindowsX64.INSTANCE;
                    }
                }
                throw EspressoError.unimplemented(OS.getCurrent() + "-x86_64");
            }
            case "aarch64", "arm64" -> {
                switch (OS.getCurrent()) {
                    case Linux: {
                        yield AAPCS64.INSTANCE;
                    }
                    case Darwin: {
                        yield DarwinAAPCS64.INSTANCE;
                    }
                }
                throw EspressoError.unimplemented(OS.getCurrent() + "-aarch64");
            }
            default -> throw EspressoError.unimplemented(arch);
        };
    }

    public abstract StorageType getStorageType(byte var1);

    public abstract boolean ignoreDownCallArgument(VMStorage var1);

    public abstract ArgumentsCalculator getArgumentsCalculator();

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public String toString(VMStorage reg) {
        StorageType type = reg.type(this);
        if (type.isPlaceholder()) {
            return reg.getStubLocation(this).toString();
        }
        if (type.isStack()) {
            return "stack[" + reg.indexOrOffset() + ";" + reg.segmentMaskOrSize() + "]";
        }
        if (type.isInteger()) {
            return this.getIntegerRegisterName(reg.indexOrOffset(), reg.segmentMaskOrSize());
        }
        if (type.isVector()) {
            return this.getVectorRegisterName(reg.indexOrOffset(), reg.segmentMaskOrSize());
        }
        return "??[" + type + ", " + reg.indexOrOffset() + ", " + reg.segmentMaskOrSize() + "]";
    }

    protected abstract String getIntegerRegisterName(int var1, int var2);

    protected abstract String getVectorRegisterName(int var1, int var2);
}

