/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.ref.EspressoReference;
import com.oracle.truffle.espresso.ref.FinalizationSupport;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;

@EspressoSubstitutions
public final class Target_java_lang_ref_Reference {
    @Substitution(hasReceiver=true, methodName="<init>")
    public static void init(@JavaType(value=Reference.class) StaticObject self, @JavaType(value=Object.class) StaticObject referent, @JavaType(value=ReferenceQueue.class) StaticObject queue, @Inject EspressoContext context) {
        EspressoReference ref = null;
        Meta meta = context.getMeta();
        if (InterpreterToVM.instanceOf(self, meta.java_lang_ref_WeakReference)) {
            ref = EspressoReference.createWeak(context, self, referent);
        } else if (InterpreterToVM.instanceOf(self, meta.java_lang_ref_SoftReference)) {
            ref = EspressoReference.createSoft(context, self, referent);
        } else if (InterpreterToVM.instanceOf(self, meta.java_lang_ref_FinalReference)) {
            ref = EspressoReference.createFinal(context, self, referent);
        } else if (InterpreterToVM.instanceOf(self, meta.java_lang_ref_PhantomReference)) {
            ref = EspressoReference.createPhantom(context, self, referent);
        }
        if (ref != null) {
            meta.HIDDEN_HOST_REFERENCE.setHiddenObject(self, ref);
        } else {
            meta.java_lang_ref_Reference_referent.set(self, referent);
        }
        if (StaticObject.isNull(queue)) {
            meta.java_lang_ref_Reference_queue.set(self, meta.java_lang_ref_ReferenceQueue_NULL.get(meta.java_lang_ref_ReferenceQueue.tryInitializeAndGetStatics()));
        } else {
            meta.java_lang_ref_Reference_queue.set(self, queue);
        }
    }

    @Substitution(hasReceiver=true)
    public static @JavaType(value=Object.class) StaticObject get(@JavaType(value=Reference.class) StaticObject self, @Inject Meta meta) {
        assert (!InterpreterToVM.instanceOf(self, meta.java_lang_ref_PhantomReference)) : "Cannot call Reference.get on PhantomReference";
        if (InterpreterToVM.instanceOf(self, meta.java_lang_ref_WeakReference) || InterpreterToVM.instanceOf(self, meta.java_lang_ref_SoftReference) || InterpreterToVM.instanceOf(self, meta.java_lang_ref_FinalReference)) {
            EspressoReference ref = (EspressoReference)meta.HIDDEN_HOST_REFERENCE.getHiddenObject(self);
            if (ref == null) {
                return StaticObject.NULL;
            }
            assert (ref instanceof Reference);
            StaticObject obj = ref.get();
            return obj == null ? StaticObject.NULL : obj;
        }
        return meta.java_lang_ref_Reference_referent.getObject(self);
    }

    @Substitution(hasReceiver=true)
    public static void clear(@JavaType(value=Reference.class) StaticObject self, @Inject Meta meta) {
        if (InterpreterToVM.instanceOf(self, meta.java_lang_ref_WeakReference) || InterpreterToVM.instanceOf(self, meta.java_lang_ref_SoftReference) || InterpreterToVM.instanceOf(self, meta.java_lang_ref_PhantomReference) || InterpreterToVM.instanceOf(self, meta.java_lang_ref_FinalReference)) {
            EspressoReference ref = (EspressoReference)meta.HIDDEN_HOST_REFERENCE.getHiddenObject(self);
            if (ref != null) {
                assert (ref instanceof Reference);
                ref.clear();
                meta.HIDDEN_HOST_REFERENCE.setHiddenObject(self, null);
            }
        } else {
            meta.java_lang_ref_Reference_referent.set(self, StaticObject.NULL);
        }
    }

    @Substitution(isTrivial=true)
    public static void reachabilityFence(@JavaType(value=Object.class) StaticObject ref) {
        Reference.reachabilityFence(ref);
    }

    static {
        FinalizationSupport.ensureInitialized();
    }

    @Substitution(hasReceiver=true)
    static abstract class Enqueue
    extends SubstitutionNode {
        Enqueue() {
        }

        abstract boolean execute(@JavaType(value=Reference.class) StaticObject var1);

        @Specialization
        boolean doCached(@JavaType(value=Reference.class) StaticObject self, @Bind(value="getContext()") EspressoContext context, @Cached(value="create(context.getMeta().java_lang_ref_Reference_enqueue.getCallTargetNoSubstitution())") DirectCallNode originalEnqueue) {
            if (context.getJavaVersion().java9OrLater()) {
                EspressoReference ref;
                Meta meta = context.getMeta();
                if ((InterpreterToVM.instanceOf(self, meta.java_lang_ref_WeakReference) || InterpreterToVM.instanceOf(self, meta.java_lang_ref_SoftReference) || InterpreterToVM.instanceOf(self, meta.java_lang_ref_PhantomReference) || InterpreterToVM.instanceOf(self, meta.java_lang_ref_FinalReference)) && (ref = (EspressoReference)meta.HIDDEN_HOST_REFERENCE.getHiddenObject(self)) != null) {
                    assert (ref instanceof Reference);
                    ref.clear();
                }
            }
            return (Boolean)originalEnqueue.call(new Object[]{self});
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class ClearInactiveFinalReference
    extends SubstitutionNode {
        ClearInactiveFinalReference() {
        }

        abstract void execute(@JavaType(value=Reference.class) StaticObject var1);

        @Specialization
        void doCached(@JavaType(value=Reference.class) StaticObject self, @Bind(value="getMeta()") Meta meta, @Cached(value="create(meta.java_lang_ref_Reference_clearInactiveFinalReference.getCallTargetNoSubstitution())") DirectCallNode original) {
            original.call(new Object[]{self});
            Target_java_lang_ref_Reference.clear(self, meta);
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class GetFromInactiveFinalReference
    extends SubstitutionNode {
        GetFromInactiveFinalReference() {
        }

        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Reference.class) StaticObject var1);

        @Specialization
        @JavaType(value=Object.class) StaticObject doCached(@JavaType(value=Reference.class) StaticObject self, @Bind(value="getMeta()") Meta meta, @Cached(value="create(meta.java_lang_ref_Reference_getFromInactiveFinalReference.getCallTargetNoSubstitution())") DirectCallNode original) {
            original.call(new Object[]{self});
            return Target_java_lang_ref_Reference.get(self, meta);
        }
    }
}

