/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.ModuleExtension;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNamesProvider;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import java.util.Set;

@EspressoSubstitutions(nameProvider=Provider.class)
public final class Target_jdk_internal_module_ModuleLoaderMap_Modules {
    private static final String[] TARGET_NAME = new String[]{"Target_jdk_internal_module_ModuleLoaderMap$Modules"};

    public static class Provider
    extends SubstitutionNamesProvider {
        public static final Provider INSTANCE = new Provider();

        @Override
        public String[] substitutionClassNames() {
            return TARGET_NAME;
        }
    }

    @Substitution(methodName="<clinit>")
    public static abstract class Clinit
    extends SubstitutionNode {
        public abstract void execute();

        @Specialization
        public void clinit(@Bind(value="getContext()") EspressoContext context, @Cached(value="create(context.getMeta().jdk_internal_module_ModuleLoaderMap_Modules_clinit.getCallTargetNoSubstitution())") DirectCallNode original) {
            Meta meta = context.getMeta();
            assert (meta.getJavaVersion().java17OrLater());
            original.call(new Object[0]);
            ModuleExtension[] toAdd = ModuleExtension.get(context);
            if (toAdd.length == 0) {
                return;
            }
            this.spoofBootModules(meta, toAdd);
        }

        @CompilerDirectives.TruffleBoundary
        private void spoofBootModules(Meta meta, ModuleExtension[] toAdd) {
            EspressoLanguage language = this.getLanguage();
            Field bootModulesField = meta.jdk_internal_module_ModuleLoaderMap_Modules.lookupDeclaredField(Symbol.Name.bootModules, Symbol.Type.java_util_Set);
            Method setOf = meta.java_util_Set.lookupMethod(Symbol.Name.of, Symbol.Signature.java_util_Set_Object_array);
            StaticObject staticStorage = meta.jdk_internal_module_ModuleLoaderMap_Modules.tryInitializeAndGetStatics();
            @JavaType(value=Set.class) StaticObject originalResult = bootModulesField.getObject(staticStorage);
            Method toArray = originalResult.getKlass().lookupMethod(meta.getNames().getOrCreate("toArray"), Symbol.Signature.Object_array_Object_array);
            StaticObject array = (StaticObject)toArray.invokeDirect(originalResult, meta.java_lang_String.allocateReferenceArray(0));
            assert (array.isArray());
            StaticObject[] unwrapped = (StaticObject[])array.unwrap(language);
            StaticObject resultArray = meta.java_lang_String.allocateReferenceArray(unwrapped.length + toAdd.length);
            StaticObject[] unwrappedResult = (StaticObject[])resultArray.unwrap(language);
            System.arraycopy(unwrapped, 0, unwrappedResult, toAdd.length, unwrapped.length);
            for (int i = 0; i < toAdd.length; ++i) {
                unwrappedResult[i] = meta.toGuestString(toAdd[i].moduleName());
            }
            bootModulesField.setObject(staticStorage, setOf.invokeDirect(null, resultArray));
        }
    }
}

