/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.espresso.runtime.JavaVersion;

@FunctionalInterface
public interface VersionFilter {
    public boolean isValidFor(JavaVersion var1);

    public static final class Java20OrLater
    implements VersionFilter {
        public static final Java20OrLater INSTANCE = new Java20OrLater();

        private Java20OrLater() {
        }

        @Override
        public boolean isValidFor(JavaVersion version) {
            return version.java20OrLater();
        }
    }

    public static final class Java19OrLater
    implements VersionFilter {
        public static final Java19OrLater INSTANCE = new Java19OrLater();

        private Java19OrLater() {
        }

        @Override
        public boolean isValidFor(JavaVersion version) {
            return version.java19OrLater();
        }
    }

    public static final class Java18OrEarlier
    implements VersionFilter {
        public static final Java18OrEarlier INSTANCE = new Java18OrEarlier();

        private Java18OrEarlier() {
        }

        @Override
        public boolean isValidFor(JavaVersion version) {
            return version.java18OrEarlier();
        }
    }

    public static final class Java13OrEarlier
    implements VersionFilter {
        public static final Java13OrEarlier INSTANCE = new Java13OrEarlier();

        private Java13OrEarlier() {
        }

        @Override
        public boolean isValidFor(JavaVersion version) {
            return version.java13OrEarlier();
        }
    }

    public static final class Java11OrEarlier
    implements VersionFilter {
        public static final Java11OrEarlier INSTANCE = new Java11OrEarlier();

        private Java11OrEarlier() {
        }

        @Override
        public boolean isValidFor(JavaVersion version) {
            return version.java11OrEarlier();
        }
    }

    public static final class Java9OrLater
    implements VersionFilter {
        public static final Java9OrLater INSTANCE = new Java9OrLater();

        private Java9OrLater() {
        }

        @Override
        public boolean isValidFor(JavaVersion version) {
            return version.java9OrLater();
        }
    }

    public static final class Java8OrEarlier
    implements VersionFilter {
        public static final Java8OrEarlier INSTANCE = new Java8OrEarlier();

        private Java8OrEarlier() {
        }

        @Override
        public boolean isValidFor(JavaVersion version) {
            return version.java8OrEarlier();
        }
    }

    public static final class NoFilter
    implements VersionFilter {
        public static final NoFilter INSTANCE = new NoFilter();

        private NoFilter() {
        }

        @Override
        public boolean isValidFor(JavaVersion version) {
            return false;
        }
    }
}

