/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.threads;

import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.EspressoExitException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

final class GuestRunnable
implements Runnable {
    private final EspressoContext context;
    private final StaticObject thread;
    private final DirectCallNode exit;
    private final DirectCallNode dispatchUncaught;

    GuestRunnable(EspressoContext context, StaticObject thread, DirectCallNode exit, DirectCallNode dispatchUncaught) {
        this.context = context;
        this.thread = thread;
        this.exit = exit;
        this.dispatchUncaught = dispatchUncaught;
    }

    @Override
    public void run() {
        try {
            this.context.registerCurrentThread(this.thread);
            this.context.getVM().attachThread(Thread.currentThread());
            try {
                this.context.getThreadAccess().fullSafePoint(this.thread);
                this.thread.getKlass().vtableLookup(this.context.getMeta().java_lang_Thread_run.getVTableIndex()).invokeDirect(this.thread, new Object[0]);
                this.context.getThreadAccess().fullSafePoint(this.thread);
            }
            catch (EspressoException uncaught) {
                this.dispatchUncaught.call(new Object[]{this.thread, uncaught.getGuestException()});
            }
        }
        catch (EspressoExitException espressoExitException) {
            this.context.getThreadAccess().terminate(this.thread, this.exit);
            if (this.context.isClosing()) {
                return;
            }
        }
        finally {
            this.context.getThreadAccess().terminate(this.thread, this.exit);
            if (this.context.isClosing()) {
                return;
            }
        }
    }
}

