/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.verifier.MethodVerifier;
import com.oracle.truffle.espresso.verifier.Operand;
import com.oracle.truffle.espresso.verifier.ReferenceOperand;
import com.oracle.truffle.espresso.verifier.StackFrame;
import com.oracle.truffle.espresso.verifier.UninitReferenceOperand;

final class OperandStack {
    final Operand[] stack;
    int top;
    int size;

    OperandStack(int maxStack) {
        this.stack = new Operand[maxStack];
        this.top = 0;
        this.size = 0;
    }

    public Operand[] extract() {
        Operand[] result = new Operand[this.top];
        System.arraycopy(this.stack, 0, result, 0, this.top);
        return result;
    }

    void procSize(int modif) {
        this.size += modif;
        MethodVerifier.verifyGuarantee(this.size <= this.stack.length, "insufficent stack size: " + this.stack.length);
        MethodVerifier.verifyGuarantee(this.size >= 0, "invalid stack access: " + this.size);
    }

    void pushInt() {
        this.push(MethodVerifier.Int);
    }

    void pushFloat() {
        this.push(MethodVerifier.Float);
    }

    void pushDouble() {
        this.push(MethodVerifier.Double);
    }

    void pushLong() {
        this.push(MethodVerifier.Long);
    }

    void push(Operand kind) {
        this.procSize(kind.slots());
        this.stack[this.top++] = kind.getKind().isStackInt() ? MethodVerifier.Int : kind;
    }

    private Operand popAny() {
        MethodVerifier.verifyGuarantee(this.top > 0, "Popping an empty stack");
        Operand op = this.stack[--this.top];
        this.procSize(-op.slots());
        return op;
    }

    Operand popRef() {
        Operand op = this.popAny();
        MethodVerifier.verifyGuarantee(op.isReference(), "Invalid operand. Expected a reference, found: " + op);
        return op;
    }

    Operand popRef(Operand kind) {
        Operand op = this.popRef();
        MethodVerifier.verifyGuarantee(op.compliesWith(kind), "Type check error: " + op + " cannot be merged into " + kind);
        return op;
    }

    public Operand popUninitRef(Operand kind) {
        Operand op = this.popRef(kind);
        MethodVerifier.verifyGuarantee(op.isUninit(), "Calling initialization method on already initialized reference.");
        return op;
    }

    Operand popArray() {
        Operand op = this.popRef();
        MethodVerifier.verifyGuarantee(op == MethodVerifier.Null || op.isArrayType(), "Invalid operand. Expected array, found: " + op);
        return op;
    }

    void popInt() {
        this.pop(MethodVerifier.Int);
    }

    void popFloat() {
        this.pop(MethodVerifier.Float);
    }

    void popDouble() {
        this.pop(MethodVerifier.Double);
    }

    void popLong() {
        this.pop(MethodVerifier.Long);
    }

    Operand popObjOrRA() {
        Operand op = this.popAny();
        MethodVerifier.verifyGuarantee(op.isReference() || op.isReturnAddress(), op + " on stack, required: Reference or ReturnAddress");
        return op;
    }

    Operand pop(Operand k) {
        if (!k.getKind().isStackInt() || k == MethodVerifier.Int) {
            Operand op = this.popAny();
            MethodVerifier.verifyGuarantee(op.compliesWith(k), op + " on stack, required: " + k);
            return op;
        }
        return this.pop(MethodVerifier.Int);
    }

    void dup() {
        this.procSize(1);
        Operand v = this.stack[this.top - 1];
        MethodVerifier.verifyGuarantee(!MethodVerifier.isType2(v), "type 2 operand for dup.");
        MethodVerifier.verifyGuarantee(!v.isTopOperand(), "dup of Top type.");
        this.stack[this.top] = v;
        ++this.top;
    }

    void pop() {
        this.procSize(-1);
        Operand v = this.stack[this.top - 1];
        MethodVerifier.verifyGuarantee(!MethodVerifier.isType2(v), "type 2 operand for pop.");
        MethodVerifier.verifyGuarantee(!v.isTopOperand(), "dup2x2 of Top type.");
        --this.top;
    }

    void pop2() {
        this.procSize(-2);
        Operand v1 = this.stack[this.top - 1];
        MethodVerifier.verifyGuarantee(!v1.isTopOperand(), "dup2x2 of Top type.");
        if (MethodVerifier.isType2(v1)) {
            --this.top;
            return;
        }
        Operand v2 = this.stack[this.top - 2];
        MethodVerifier.verifyGuarantee(!v2.isTopOperand(), "dup2x2 of Top type.");
        MethodVerifier.verifyGuarantee(!MethodVerifier.isType2(v2), "type 2 second operand for pop2.");
        this.top -= 2;
    }

    void dupx1() {
        this.procSize(1);
        Operand v1 = this.stack[this.top - 1];
        Operand v2 = this.stack[this.top - 2];
        MethodVerifier.verifyGuarantee(!MethodVerifier.isType2(v1) && !MethodVerifier.isType2(v2), "type 2 operand for dupx1.");
        MethodVerifier.verifyGuarantee(!v1.isTopOperand() && !v2.isTopOperand(), "dupx1 of Top type.");
        System.arraycopy(this.stack, this.top - 2, this.stack, this.top - 1, 2);
        ++this.top;
        this.stack[this.top - 3] = v1;
    }

    void dupx2() {
        this.procSize(1);
        Operand v1 = this.stack[this.top - 1];
        Operand v2 = this.stack[this.top - 2];
        MethodVerifier.verifyGuarantee(!MethodVerifier.isType2(v1), "type 2 first operand for dupx2.");
        MethodVerifier.verifyGuarantee(!v1.isTopOperand() && !v2.isTopOperand(), "dupx2 of Top type.");
        if (MethodVerifier.isType2(v2)) {
            System.arraycopy(this.stack, this.top - 2, this.stack, this.top - 1, 2);
            ++this.top;
            this.stack[this.top - 3] = v1;
        } else {
            Operand v3 = this.stack[this.top - 3];
            MethodVerifier.verifyGuarantee(!MethodVerifier.isType2(v3), "type 2 third operand for dupx2.");
            MethodVerifier.verifyGuarantee(!v3.isTopOperand(), "dupx2 of Top type.");
            System.arraycopy(this.stack, this.top - 3, this.stack, this.top - 2, 3);
            ++this.top;
            this.stack[this.top - 4] = v1;
        }
    }

    void dup2() {
        this.procSize(2);
        Operand v1 = this.stack[this.top - 1];
        if (MethodVerifier.isType2(v1)) {
            this.stack[this.top] = v1;
            ++this.top;
        } else {
            Operand v2 = this.stack[this.top - 2];
            MethodVerifier.verifyGuarantee(!MethodVerifier.isType2(v2), "type 2 second operand for dup2.");
            MethodVerifier.verifyGuarantee(!v1.isTopOperand() && !v2.isTopOperand(), "dup2 of Top type.");
            System.arraycopy(this.stack, this.top - 2, this.stack, this.top, 2);
            this.top += 2;
        }
    }

    void dup2x1() {
        this.procSize(2);
        Operand v1 = this.stack[this.top - 1];
        Operand v2 = this.stack[this.top - 2];
        MethodVerifier.verifyGuarantee(!MethodVerifier.isType2(v2), "type 2 second operand for dup2x1");
        MethodVerifier.verifyGuarantee(!v2.isTopOperand() && !v1.isTopOperand(), "dup2x1 of Top type.");
        if (MethodVerifier.isType2(v1)) {
            System.arraycopy(this.stack, this.top - 2, this.stack, this.top - 1, 2);
            ++this.top;
            this.stack[this.top - 3] = v1;
            return;
        }
        Operand v3 = this.stack[this.top - 3];
        MethodVerifier.verifyGuarantee(!MethodVerifier.isType2(v3), "type 2 third operand for dup2x1.");
        MethodVerifier.verifyGuarantee(!v3.isTopOperand(), "dup2x1 of Top type.");
        System.arraycopy(this.stack, this.top - 3, this.stack, this.top - 1, 3);
        this.top += 2;
        this.stack[this.top - 5] = v2;
        this.stack[this.top - 4] = v1;
    }

    void dup2x2() {
        this.procSize(2);
        Operand v1 = this.stack[this.top - 1];
        Operand v2 = this.stack[this.top - 2];
        boolean b1 = MethodVerifier.isType2(v1);
        boolean b2 = MethodVerifier.isType2(v2);
        MethodVerifier.verifyGuarantee(!v1.isTopOperand() && !v2.isTopOperand(), "dup2x2 of Top type.");
        if (b1 && b2) {
            System.arraycopy(this.stack, this.top - 2, this.stack, this.top - 1, 2);
            this.stack[this.top - 2] = v1;
            ++this.top;
            return;
        }
        Operand v3 = this.stack[this.top - 3];
        boolean b3 = MethodVerifier.isType2(v3);
        MethodVerifier.verifyGuarantee(!v3.isTopOperand(), "dup2x2 of Top type.");
        if (!b1 && !b2 && b3) {
            System.arraycopy(this.stack, this.top - 3, this.stack, this.top - 1, 3);
            this.stack[this.top - 3] = v2;
            this.stack[this.top - 2] = v1;
            this.top += 2;
            return;
        }
        if (b1 && !b2 && !b3) {
            System.arraycopy(this.stack, this.top - 3, this.stack, this.top - 2, 3);
            this.stack[this.top - 3] = v1;
            ++this.top;
            return;
        }
        Operand v4 = this.stack[this.top - 4];
        MethodVerifier.verifyGuarantee(!v4.isTopOperand(), "dup2x2 of Top type.");
        boolean b4 = MethodVerifier.isType2(v4);
        if (!(b1 || b2 || b3 || b4)) {
            System.arraycopy(this.stack, this.top - 4, this.stack, this.top - 2, 4);
            this.stack[this.top - 4] = v2;
            this.stack[this.top - 3] = v1;
            this.top += 2;
            return;
        }
        throw MethodVerifier.failVerify("Calling dup2x2 with operands: " + v1 + ", " + v2 + ", " + v3 + ", " + v4);
    }

    void swap() {
        Operand v1 = this.stack[this.top - 1];
        Operand v2 = this.stack[this.top - 2];
        MethodVerifier.verifyGuarantee(!MethodVerifier.isType2(v1) && !MethodVerifier.isType2(v2), "Type 2 operand for SWAP");
        MethodVerifier.verifyGuarantee(!v1.isTopOperand() && !v2.isTopOperand(), "swap of Top type.");
        this.stack[this.top - 1] = v2;
        this.stack[this.top - 2] = v1;
    }

    int mergeInto(StackFrame stackFrame) {
        MethodVerifier.verifyGuarantee(this.size == stackFrame.stackSize, "Inconsistent stack height: " + this.size + " != " + stackFrame.stackSize);
        int secondIndex = 0;
        for (int index = 0; index < this.top; ++index) {
            Operand op2;
            Operand op1 = this.stack[index];
            if (!op1.compliesWithInMerge(op2 = stackFrame.stack[secondIndex++])) {
                return index;
            }
            if (!MethodVerifier.isType2(op1) || !op2.isTopOperand()) continue;
            MethodVerifier.verifyGuarantee(stackFrame.stack[secondIndex++].isTopOperand(), "Inconsistent stack Map: " + op1 + " vs. " + op2 + " and " + stackFrame.stack[secondIndex - 1]);
        }
        return -1;
    }

    Operand initUninit(UninitReferenceOperand toInit) {
        ReferenceOperand init = toInit.init();
        for (int i = 0; i < this.top; ++i) {
            if (!this.stack[i].isUninit() || ((UninitReferenceOperand)this.stack[i]).newBCI != toInit.newBCI) continue;
            this.stack[i] = init;
        }
        return init;
    }
}

