/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.verifier.VerificationTypeInfo;
import java.io.PrintStream;

abstract class StackMapFrame {
    protected final int frameType;

    public int getFrameType() {
        return this.frameType;
    }

    StackMapFrame(int frameType) {
        this.frameType = frameType;
    }

    public int getChopped() {
        throw EspressoError.shouldNotReachHere("Asking for chopped value of non chopped frame");
    }

    public VerificationTypeInfo getStackItem() {
        throw EspressoError.shouldNotReachHere("Asking for stack item of incompatible stackMap frame");
    }

    public VerificationTypeInfo[] getStack() {
        throw EspressoError.shouldNotReachHere("Asking for stack of incompatible stackMap frame");
    }

    public VerificationTypeInfo[] getLocals() {
        throw EspressoError.shouldNotReachHere("Asking for locals of incompatible stackMap frame");
    }

    public abstract int getOffset();

    public void print(Klass klass, PrintStream out) {
        out.println("        " + this.getClass().getSimpleName() + " {");
        out.println("            Offset: " + this.getOffset());
    }
}

