/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm.structs;

import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.structs.MemberOffsetGetter;
import com.oracle.truffle.espresso.vm.structs.StructStorage;
import com.oracle.truffle.espresso.vm.structs.StructWrapper;

public final class JvmtiClassDefinition
extends StructStorage<JvmtiClassDefinitionWrapper> {
    final int klass;
    final int class_byte_count;
    final int class_bytes;

    JvmtiClassDefinition(MemberOffsetGetter offsetGetter) {
        super(offsetGetter.getInfo("_jvmtiClassDefinition"));
        this.klass = (int)offsetGetter.getOffset("_jvmtiClassDefinition", "klass");
        this.class_byte_count = (int)offsetGetter.getOffset("_jvmtiClassDefinition", "class_byte_count");
        this.class_bytes = (int)offsetGetter.getOffset("_jvmtiClassDefinition", "class_bytes");
    }

    @Override
    public JvmtiClassDefinitionWrapper wrap(JniEnv jni, TruffleObject pointer) {
        return new JvmtiClassDefinitionWrapper(jni, pointer);
    }

    public final class JvmtiClassDefinitionWrapper
    extends StructWrapper {
        JvmtiClassDefinitionWrapper(JniEnv jni, TruffleObject pointer) {
            super(jni, pointer, JvmtiClassDefinition.this.structSize);
        }

        public StaticObject klass() {
            return this.getObject(JvmtiClassDefinition.this.klass);
        }

        public void klass(StaticObject valueToPut) {
            this.putObject(JvmtiClassDefinition.this.klass, valueToPut);
        }

        public int classByteCount() {
            return this.getInt(JvmtiClassDefinition.this.class_byte_count);
        }

        public void classByteCount(int valueToPut) {
            this.putInt(JvmtiClassDefinition.this.class_byte_count, valueToPut);
        }

        public TruffleObject classBytes() {
            return this.getPointer(JvmtiClassDefinition.this.class_bytes);
        }

        public void classBytes(TruffleObject valueToPut) {
            this.putPointer(JvmtiClassDefinition.this.class_bytes, valueToPut);
        }
    }
}

