/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso;

import com.oracle.truffle.api.TruffleOptionDescriptors;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.espresso.EspressoOptions;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionStability;
import org.graalvm.polyglot.SandboxPolicy;

@GeneratedBy(value=EspressoOptions.class)
final class EspressoOptionsOptionDescriptors
implements TruffleOptionDescriptors {
    EspressoOptionsOptionDescriptors() {
    }

    public OptionDescriptor get(String optionName) {
        if (optionName.startsWith("java.AgentLib.") || optionName.equals("java.AgentLib")) {
            return OptionDescriptor.newBuilder(EspressoOptions.AgentLib, (String)"java.AgentLib").deprecated(false).help("Load native agents from standard library paths. \nKeys represent the agent library name, values are the corresponding agent options.\nAgents are not fully implemented yet.").usageSyntax("<agentOptions>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
        }
        if (optionName.startsWith("java.AgentPath.") || optionName.equals("java.AgentPath")) {
            return OptionDescriptor.newBuilder(EspressoOptions.AgentPath, (String)"java.AgentPath").deprecated(false).help("Load native agents from an absolute path. \nKeys represent the agent library full absolute path, values are the corresponding agent options.\nAgents are not fully implemented yet.").usageSyntax("<librarypath>=<agentOptions>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
        }
        if (optionName.startsWith("java.PolyglotTypeConverters.") || optionName.equals("java.PolyglotTypeConverters")) {
            return OptionDescriptor.newBuilder(EspressoOptions.PolyglotTypeConverters, (String)"java.PolyglotTypeConverters").deprecated(false).help("Option to enable target type conversion by specifying a conversion class.").usageSyntax("java.PolyglotTypeConverters.java.lang.Optional=my.type.conversion.Implementation").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
        }
        if (optionName.startsWith("java.Properties.") || optionName.equals("java.Properties")) {
            return OptionDescriptor.newBuilder(EspressoOptions.Properties, (String)"java.Properties").deprecated(false).help("User-defined system properties.").usageSyntax("<value>").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
        }
        if (optionName.startsWith("java.VMArguments.") || optionName.equals("java.VMArguments")) {
            return OptionDescriptor.newBuilder(EspressoOptions.VMArguments, (String)"java.VMArguments").deprecated(false).help("Used internally to keep track of the command line arguments given to the vm in order to support VM.getRuntimeArguments().\nSetting this option is the responsibility of the context creator if such support is required.\nUsage:\nFor each argument [arg<i>] passed to the context (excluding the main class args):\n    builder.option(java.VMArguments.<i>, [arg<i>]);").usageSyntax("<argument>").category(OptionCategory.INTERNAL).stability(OptionStability.STABLE).build();
        }
        switch (optionName) {
            case "java.AddExports": {
                return OptionDescriptor.newBuilder(EspressoOptions.AddExports, (String)"java.AddExports").deprecated(false).help("A '" + File.pathSeparator + "' separated list of root modules beyond the initial module.\nEquivalent to '--add-exports=<module>'").usageSyntax("<module>" + File.pathSeparator + "<module>" + File.pathSeparator + "...").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "java.AddModules": {
                return OptionDescriptor.newBuilder(EspressoOptions.AddModules, (String)"java.AddModules").deprecated(false).help("A '" + File.pathSeparator + "' separated list of root modules beyond the initial module.\nEquivalent to '--add-modules=<module>'").usageSyntax("<module>" + File.pathSeparator + "<module>" + File.pathSeparator + "...").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "java.AddOpens": {
                return OptionDescriptor.newBuilder(EspressoOptions.AddOpens, (String)"java.AddOpens").deprecated(false).help("A '" + File.pathSeparator + "' separated list of root modules beyond the initial module.\nEquivalent to '--add-opens=<module>'").usageSyntax("<module>" + File.pathSeparator + "<module>" + File.pathSeparator + "...").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "java.AddReads": {
                return OptionDescriptor.newBuilder(EspressoOptions.AddReads, (String)"java.AddReads").deprecated(false).help("A '" + File.pathSeparator + "'separated list of root modules beyond the initial module.\nEquivalent to '--add-reads=<module>'").usageSyntax("<module>" + File.pathSeparator + "<module>" + File.pathSeparator + "...").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "java.BootClasspath": {
                return OptionDescriptor.newBuilder(EspressoOptions.BootClasspath, (String)"java.BootClasspath").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories, JAR files, and ZIP archives to search for boot class files. These are used in place of the boot class files included in the JDK.").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.BootClasspathAppend": {
                return OptionDescriptor.newBuilder(EspressoOptions.BootClasspathAppend, (String)"java.BootClasspathAppend").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories, JAR files, and ZIP archives to append to the front of the default bootstrap class path.").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.BootClasspathPrepend": {
                return OptionDescriptor.newBuilder(EspressoOptions.BootClasspathPrepend, (String)"java.BootClasspathPrepend").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories, JAR files, and ZIP archives to prepend to the end of the default bootstrap class path.").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.BootLibraryPath": {
                return OptionDescriptor.newBuilder(EspressoOptions.BootLibraryPath, (String)"java.BootLibraryPath").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories to search for system libraries.").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "java.BuiltInPolyglotCollections": {
                return OptionDescriptor.newBuilder(EspressoOptions.BuiltInPolyglotCollections, (String)"java.BuiltInPolyglotCollections").deprecated(false).help("Enable built in polyglot collection support in Espresso.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.BytecodeLevelInlining": {
                return OptionDescriptor.newBuilder(EspressoOptions.BytecodeLevelInlining, (String)"java.BytecodeLevelInlining").deprecated(false).help("Speculatively inline field accessors.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.CHA": {
                return OptionDescriptor.newBuilder(EspressoOptions.CHA, (String)"java.CHA").deprecated(false).help("Enable Class Hierarchy Analysis, which optimizes instanceof checks and virtual method calls by keeping track of descendants of a given class or interface.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.Classpath": {
                return OptionDescriptor.newBuilder(EspressoOptions.Classpath, (String)"java.Classpath").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories, JAR archives, and ZIP archives to search for class files.").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "java.EnableAgents": {
                return OptionDescriptor.newBuilder(EspressoOptions.EnableAgents, (String)"java.EnableAgents").deprecated(false).help("Enables java agents. Support is currently very limited.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.EnableAssertions": {
                return OptionDescriptor.newBuilder(EspressoOptions.EnableAssertions, (String)"java.EnableAssertions").deprecated(false).help("Enable assertions.").usageSyntax("false|true").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "java.EnableManagement": {
                return OptionDescriptor.newBuilder(EspressoOptions.EnableManagement, (String)"java.EnableManagement").deprecated(false).help("Enable experimental java.lang.management APIs. Incur a bookkeeping overhead.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.EnableNativeAccess": {
                return OptionDescriptor.newBuilder(EspressoOptions.EnableNativeAccess, (String)"java.EnableNativeAccess").deprecated(false).help("A '" + File.pathSeparator + "' separated list of modules that are permitted to perform restricted native operations.\nEquivalent to '--enable-native-access=<module>'").usageSyntax("<module>" + File.pathSeparator + "<module>" + File.pathSeparator + "...").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "java.EnablePreview": {
                return OptionDescriptor.newBuilder(EspressoOptions.EnablePreview, (String)"java.EnablePreview").deprecated(false).help("Enables preview features.").usageSyntax("false|true").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "java.EnableSignals": {
                return OptionDescriptor.newBuilder(EspressoOptions.EnableSignals, (String)"java.EnableSignals").deprecated(false).help("Enables the signal API (sun.misc.Signal or jdk.internal.misc.Signal).").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.EnableSystemAssertions": {
                return OptionDescriptor.newBuilder(EspressoOptions.EnableSystemAssertions, (String)"java.EnableSystemAssertions").deprecated(false).help("Enable system assertions.").usageSyntax("false|true").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "java.EnableTimers": {
                return OptionDescriptor.newBuilder(EspressoOptions.EnableTimers, (String)"java.EnableTimers").deprecated(false).help("Enables espresso runtime timers.").usageSyntax("false|true").category(OptionCategory.INTERNAL).stability(OptionStability.STABLE).build();
            }
            case "java.ExitHost": {
                return OptionDescriptor.newBuilder(EspressoOptions.ExitHost, (String)"java.ExitHost").deprecated(false).help("Allows Espresso to use host System.exit() on context exit when there are unresponsive threads. This should not be used in most cases as it will take down the whole host VM abruptly, possibly preventing other languages from performing their own exit sequence.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.ExposeNativeJavaVM": {
                return OptionDescriptor.newBuilder(EspressoOptions.ExposeNativeJavaVM, (String)"java.ExposeNativeJavaVM").deprecated(false).help("Expose the <JavaVM> binding.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.ExtDirs": {
                return OptionDescriptor.newBuilder(EspressoOptions.ExtDirs, (String)"java.ExtDirs").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories to search for extensions.").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "java.HotSwapAPI": {
                return OptionDescriptor.newBuilder(EspressoOptions.HotSwapAPI, (String)"java.HotSwapAPI").deprecated(false).help("Enable hotspot extension API.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.InlineMethodHandle": {
                return OptionDescriptor.newBuilder(EspressoOptions.InlineMethodHandle, (String)"java.InlineMethodHandle").deprecated(false).help("Enable inlining through method handle calls.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.JDWPOptions": {
                return OptionDescriptor.newBuilder(EspressoOptions.JDWPOptions, (String)"java.JDWPOptions").deprecated(false).help("JDWP agent Options. e.g. -agentlib:jdwp=transport=dt_socket,server=y,address=localhost:8000,suspend=y").usageSyntax("[transport=dt_socket],[server=y|n],[address=[<host>:]<port>,[suspend=y|n]]").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "java.JImage": {
                return OptionDescriptor.newBuilder(EspressoOptions.JImage, (String)"java.JImage").deprecated(false).help("Selects the jimage reader.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.JVMLibraryPath": {
                return OptionDescriptor.newBuilder(EspressoOptions.JVMLibraryPath, (String)"java.JVMLibraryPath").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories to search for Espresso's (lib)?jvm.(so|dll|dylib).").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.JavaAgent": {
                return OptionDescriptor.newBuilder(EspressoOptions.JavaAgent, (String)"java.JavaAgent").deprecated(false).help("Load a Java programming language agent for the given jar file. \nKeys represent the jar path, values are the corresponding agent options.\nAgents are not fully implemented yet.").usageSyntax("<agent>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.JavaHome": {
                return OptionDescriptor.newBuilder(EspressoOptions.JavaHome, (String)"java.JavaHome").deprecated(false).help("Installation directory for Java Runtime Environment (JRE).").usageSyntax("<path>").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "java.JavaLibraryPath": {
                return OptionDescriptor.newBuilder(EspressoOptions.JavaLibraryPath, (String)"java.JavaLibraryPath").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories to search for user libraries.").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "java.LivenessAnalysis": {
                return OptionDescriptor.newBuilder(EspressoOptions.LivenessAnalysis, (String)"java.LivenessAnalysis").deprecated(false).help("Controls static liveness analysis of bytecodes, allowing to clear local variables during execution if they become stale.\nLiveness analysis, if enabled, only affects compiled code.").usageSyntax("auto|true|all|false|none").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "java.LivenessAnalysisMinimumLocals": {
                return OptionDescriptor.newBuilder(EspressoOptions.LivenessAnalysisMinimumLocals, (String)"java.LivenessAnalysisMinimumLocals").deprecated(false).help("Minimum number of locals to run liveness analysis.\nLiveness analysis, if enabled, only affects compiled code.").usageSyntax("[0, 65535]").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.MaxDirectMemorySize": {
                return OptionDescriptor.newBuilder(EspressoOptions.MaxDirectMemorySize, (String)"java.MaxDirectMemorySize").deprecated(false).help("Maximum total size of NIO direct-buffer allocations.").usageSyntax("<size>[<unit>]").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "java.Module": {
                return OptionDescriptor.newBuilder(EspressoOptions.Module, (String)"java.Module").deprecated(false).help("Specifies in which module the main class is located. Can also specify the main class name by appending it after a \"/\"").usageSyntax("<module>[/<mainclass>]").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "java.ModulePath": {
                return OptionDescriptor.newBuilder(EspressoOptions.ModulePath, (String)"java.ModulePath").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories to search for modules.").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "java.MultiThreaded": {
                return OptionDescriptor.newBuilder(EspressoOptions.MultiThreaded, (String)"java.MultiThreaded").deprecated(false).help("Enable support for threads. In single-threaded mode, Thread.start is disabled, weak references and finalizers won't be processed. Lock operations may be optimized away.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.NativeBackend": {
                return OptionDescriptor.newBuilder(EspressoOptions.NativeBackend, (String)"java.NativeBackend").deprecated(false).help("Native backend used by Espresso, if not specified, Espresso will pick one depending on the environment.").usageSyntax("<nativeBackend>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.Polyglot": {
                return OptionDescriptor.newBuilder(EspressoOptions.Polyglot, (String)"java.Polyglot").deprecated(false).help("Enable polyglot support in Espresso.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.PolyglotInterfaceMappings": {
                return OptionDescriptor.newBuilder(EspressoOptions.PolyglotInterfaceMappings, (String)"java.PolyglotInterfaceMappings").deprecated(false).help("A ';' separated list of fully qualified interface names that enables interface type mapping in polyglot usage.").usageSyntax("my.first.MyInterface;my.second.MySecondInterface;...").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.PreInitializationClasslist": {
                return OptionDescriptor.newBuilder(EspressoOptions.PreInitializationClasslist, (String)"java.PreInitializationClasslist").deprecated(false).help("User-specified classlist used to warmup Espresso during context pre-initialization. The file should contain one class per line (see lib/classlist for an example).").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.SoftExit": {
                return OptionDescriptor.newBuilder(EspressoOptions.SoftExit, (String)"java.SoftExit").deprecated(false).help("Enables graceful teardown of the VM on exit. Rather than abruptly terminating execution, gives all leftover non-daemon thread some leeway to finish executing in guest.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.SpecCompliance": {
                return OptionDescriptor.newBuilder(EspressoOptions.SpecCompliance, (String)"java.SpecCompliance").deprecated(false).help("Force mimicking of hotspot behavior on unrespected specs points").usageSyntax("hotspot|strict").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.SplitMethodHandles": {
                return OptionDescriptor.newBuilder(EspressoOptions.SplitMethodHandles, (String)"java.SplitMethodHandles").deprecated(false).help("All method handle call site have a different inline cache.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.StringSharing": {
                return OptionDescriptor.newBuilder(EspressoOptions.StringSharing, (String)"java.StringSharing").deprecated(false).help("Enable string representation sharing between host and guest (If both have the same string representation). When enabled, reflective modifications to the underlying array of guest strings may reflect on host strings, and vice-versa. ").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.TrivialMethodSize": {
                return OptionDescriptor.newBuilder(EspressoOptions.TrivialMethodSize, (String)"java.TrivialMethodSize").deprecated(false).help("Maximum bytecode size (in bytes) for a method to be considered trivial.").usageSyntax("[0, 65535]").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.UseBindingsLoader": {
                return OptionDescriptor.newBuilder(EspressoOptions.UseBindingsLoader, (String)"java.UseBindingsLoader").deprecated(false).help("Use Custom ClassLoader for Bindings, allowing the addition of new locations for loading.").usageSyntax("false|true").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.UseHostFinalReference": {
                return OptionDescriptor.newBuilder(EspressoOptions.UseHostFinalReference, (String)"java.UseHostFinalReference").deprecated(false).help("Use the host FinalReference to implement guest finalizers. If set to false, FinalReference will fallback to WeakReference semantics.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "java.Verify": {
                return OptionDescriptor.newBuilder(EspressoOptions.Verify, (String)"java.Verify").deprecated(false).help("Sets the mode of the bytecode verifier.").usageSyntax("remote|none|all").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            }
            case "java.WhiteBoxAPI": {
                return OptionDescriptor.newBuilder(EspressoOptions.WhiteBoxAPI, (String)"java.WhiteBoxAPI").deprecated(false).help("Enables the WhiteBox API.").usageSyntax("false|true").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
        }
        return null;
    }

    public SandboxPolicy getSandboxPolicy(String optionName) {
        assert (this.get(optionName) != null) : "Unknown option " + optionName;
        return SandboxPolicy.TRUSTED;
    }

    public Iterator<OptionDescriptor> iterator() {
        return Arrays.asList(OptionDescriptor.newBuilder(EspressoOptions.AddExports, (String)"java.AddExports").deprecated(false).help("A '" + File.pathSeparator + "' separated list of root modules beyond the initial module.\nEquivalent to '--add-exports=<module>'").usageSyntax("<module>" + File.pathSeparator + "<module>" + File.pathSeparator + "...").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.AddModules, (String)"java.AddModules").deprecated(false).help("A '" + File.pathSeparator + "' separated list of root modules beyond the initial module.\nEquivalent to '--add-modules=<module>'").usageSyntax("<module>" + File.pathSeparator + "<module>" + File.pathSeparator + "...").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.AddOpens, (String)"java.AddOpens").deprecated(false).help("A '" + File.pathSeparator + "' separated list of root modules beyond the initial module.\nEquivalent to '--add-opens=<module>'").usageSyntax("<module>" + File.pathSeparator + "<module>" + File.pathSeparator + "...").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.AddReads, (String)"java.AddReads").deprecated(false).help("A '" + File.pathSeparator + "'separated list of root modules beyond the initial module.\nEquivalent to '--add-reads=<module>'").usageSyntax("<module>" + File.pathSeparator + "<module>" + File.pathSeparator + "...").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.AgentLib, (String)"java.AgentLib").deprecated(false).help("Load native agents from standard library paths. \nKeys represent the agent library name, values are the corresponding agent options.\nAgents are not fully implemented yet.").usageSyntax("<agentOptions>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.AgentPath, (String)"java.AgentPath").deprecated(false).help("Load native agents from an absolute path. \nKeys represent the agent library full absolute path, values are the corresponding agent options.\nAgents are not fully implemented yet.").usageSyntax("<librarypath>=<agentOptions>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.BootClasspath, (String)"java.BootClasspath").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories, JAR files, and ZIP archives to search for boot class files. These are used in place of the boot class files included in the JDK.").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.BootClasspathAppend, (String)"java.BootClasspathAppend").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories, JAR files, and ZIP archives to append to the front of the default bootstrap class path.").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.BootClasspathPrepend, (String)"java.BootClasspathPrepend").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories, JAR files, and ZIP archives to prepend to the end of the default bootstrap class path.").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.BootLibraryPath, (String)"java.BootLibraryPath").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories to search for system libraries.").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.BuiltInPolyglotCollections, (String)"java.BuiltInPolyglotCollections").deprecated(false).help("Enable built in polyglot collection support in Espresso.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.BytecodeLevelInlining, (String)"java.BytecodeLevelInlining").deprecated(false).help("Speculatively inline field accessors.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.CHA, (String)"java.CHA").deprecated(false).help("Enable Class Hierarchy Analysis, which optimizes instanceof checks and virtual method calls by keeping track of descendants of a given class or interface.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.Classpath, (String)"java.Classpath").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories, JAR archives, and ZIP archives to search for class files.").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.EnableAgents, (String)"java.EnableAgents").deprecated(false).help("Enables java agents. Support is currently very limited.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.EnableAssertions, (String)"java.EnableAssertions").deprecated(false).help("Enable assertions.").usageSyntax("false|true").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.EnableManagement, (String)"java.EnableManagement").deprecated(false).help("Enable experimental java.lang.management APIs. Incur a bookkeeping overhead.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.EnableNativeAccess, (String)"java.EnableNativeAccess").deprecated(false).help("A '" + File.pathSeparator + "' separated list of modules that are permitted to perform restricted native operations.\nEquivalent to '--enable-native-access=<module>'").usageSyntax("<module>" + File.pathSeparator + "<module>" + File.pathSeparator + "...").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.EnablePreview, (String)"java.EnablePreview").deprecated(false).help("Enables preview features.").usageSyntax("false|true").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.EnableSignals, (String)"java.EnableSignals").deprecated(false).help("Enables the signal API (sun.misc.Signal or jdk.internal.misc.Signal).").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.EnableSystemAssertions, (String)"java.EnableSystemAssertions").deprecated(false).help("Enable system assertions.").usageSyntax("false|true").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.EnableTimers, (String)"java.EnableTimers").deprecated(false).help("Enables espresso runtime timers.").usageSyntax("false|true").category(OptionCategory.INTERNAL).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.ExitHost, (String)"java.ExitHost").deprecated(false).help("Allows Espresso to use host System.exit() on context exit when there are unresponsive threads. This should not be used in most cases as it will take down the whole host VM abruptly, possibly preventing other languages from performing their own exit sequence.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.ExposeNativeJavaVM, (String)"java.ExposeNativeJavaVM").deprecated(false).help("Expose the <JavaVM> binding.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.ExtDirs, (String)"java.ExtDirs").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories to search for extensions.").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.HotSwapAPI, (String)"java.HotSwapAPI").deprecated(false).help("Enable hotspot extension API.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.InlineMethodHandle, (String)"java.InlineMethodHandle").deprecated(false).help("Enable inlining through method handle calls.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.JDWPOptions, (String)"java.JDWPOptions").deprecated(false).help("JDWP agent Options. e.g. -agentlib:jdwp=transport=dt_socket,server=y,address=localhost:8000,suspend=y").usageSyntax("[transport=dt_socket],[server=y|n],[address=[<host>:]<port>,[suspend=y|n]]").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.JImage, (String)"java.JImage").deprecated(false).help("Selects the jimage reader.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.JVMLibraryPath, (String)"java.JVMLibraryPath").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories to search for Espresso's (lib)?jvm.(so|dll|dylib).").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.JavaAgent, (String)"java.JavaAgent").deprecated(false).help("Load a Java programming language agent for the given jar file. \nKeys represent the jar path, values are the corresponding agent options.\nAgents are not fully implemented yet.").usageSyntax("<agent>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.JavaHome, (String)"java.JavaHome").deprecated(false).help("Installation directory for Java Runtime Environment (JRE).").usageSyntax("<path>").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.JavaLibraryPath, (String)"java.JavaLibraryPath").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories to search for user libraries.").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.LivenessAnalysis, (String)"java.LivenessAnalysis").deprecated(false).help("Controls static liveness analysis of bytecodes, allowing to clear local variables during execution if they become stale.\nLiveness analysis, if enabled, only affects compiled code.").usageSyntax("auto|true|all|false|none").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.LivenessAnalysisMinimumLocals, (String)"java.LivenessAnalysisMinimumLocals").deprecated(false).help("Minimum number of locals to run liveness analysis.\nLiveness analysis, if enabled, only affects compiled code.").usageSyntax("[0, 65535]").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.MaxDirectMemorySize, (String)"java.MaxDirectMemorySize").deprecated(false).help("Maximum total size of NIO direct-buffer allocations.").usageSyntax("<size>[<unit>]").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.Module, (String)"java.Module").deprecated(false).help("Specifies in which module the main class is located. Can also specify the main class name by appending it after a \"/\"").usageSyntax("<module>[/<mainclass>]").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.ModulePath, (String)"java.ModulePath").deprecated(false).help("A '" + File.pathSeparator + "' separated list of directories to search for modules.").usageSyntax("<path>" + File.pathSeparator + "<path>" + File.pathSeparator + "...").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.MultiThreaded, (String)"java.MultiThreaded").deprecated(false).help("Enable support for threads. In single-threaded mode, Thread.start is disabled, weak references and finalizers won't be processed. Lock operations may be optimized away.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.NativeBackend, (String)"java.NativeBackend").deprecated(false).help("Native backend used by Espresso, if not specified, Espresso will pick one depending on the environment.").usageSyntax("<nativeBackend>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.Polyglot, (String)"java.Polyglot").deprecated(false).help("Enable polyglot support in Espresso.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.PolyglotInterfaceMappings, (String)"java.PolyglotInterfaceMappings").deprecated(false).help("A ';' separated list of fully qualified interface names that enables interface type mapping in polyglot usage.").usageSyntax("my.first.MyInterface;my.second.MySecondInterface;...").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.PolyglotTypeConverters, (String)"java.PolyglotTypeConverters").deprecated(false).help("Option to enable target type conversion by specifying a conversion class.").usageSyntax("java.PolyglotTypeConverters.java.lang.Optional=my.type.conversion.Implementation").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.PreInitializationClasslist, (String)"java.PreInitializationClasslist").deprecated(false).help("User-specified classlist used to warmup Espresso during context pre-initialization. The file should contain one class per line (see lib/classlist for an example).").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.Properties, (String)"java.Properties").deprecated(false).help("User-defined system properties.").usageSyntax("<value>").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.SoftExit, (String)"java.SoftExit").deprecated(false).help("Enables graceful teardown of the VM on exit. Rather than abruptly terminating execution, gives all leftover non-daemon thread some leeway to finish executing in guest.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.SpecCompliance, (String)"java.SpecCompliance").deprecated(false).help("Force mimicking of hotspot behavior on unrespected specs points").usageSyntax("hotspot|strict").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.SplitMethodHandles, (String)"java.SplitMethodHandles").deprecated(false).help("All method handle call site have a different inline cache.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.StringSharing, (String)"java.StringSharing").deprecated(false).help("Enable string representation sharing between host and guest (If both have the same string representation). When enabled, reflective modifications to the underlying array of guest strings may reflect on host strings, and vice-versa. ").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.TrivialMethodSize, (String)"java.TrivialMethodSize").deprecated(false).help("Maximum bytecode size (in bytes) for a method to be considered trivial.").usageSyntax("[0, 65535]").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.UseBindingsLoader, (String)"java.UseBindingsLoader").deprecated(false).help("Use Custom ClassLoader for Bindings, allowing the addition of new locations for loading.").usageSyntax("false|true").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.UseHostFinalReference, (String)"java.UseHostFinalReference").deprecated(false).help("Use the host FinalReference to implement guest finalizers. If set to false, FinalReference will fallback to WeakReference semantics.").usageSyntax("false|true").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(EspressoOptions.VMArguments, (String)"java.VMArguments").deprecated(false).help("Used internally to keep track of the command line arguments given to the vm in order to support VM.getRuntimeArguments().\nSetting this option is the responsibility of the context creator if such support is required.\nUsage:\nFor each argument [arg<i>] passed to the context (excluding the main class args):\n    builder.option(java.VMArguments.<i>, [arg<i>]);").usageSyntax("<argument>").category(OptionCategory.INTERNAL).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.Verify, (String)"java.Verify").deprecated(false).help("Sets the mode of the bytecode verifier.").usageSyntax("remote|none|all").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(EspressoOptions.WhiteBoxAPI, (String)"java.WhiteBoxAPI").deprecated(false).help("Enables the WhiteBox API.").usageSyntax("false|true").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build()).iterator();
    }
}

