/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.blocking;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.blocking.BlockingSupport;
import com.oracle.truffle.espresso.blocking.EspressoLockImpl;
import com.oracle.truffle.espresso.blocking.GuestInterruptedException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public interface EspressoLock {
    @CompilerDirectives.TruffleBoundary
    public static EspressoLock create(BlockingSupport<?> blockingSupport) {
        return new EspressoLockImpl(blockingSupport);
    }

    public void lock();

    public boolean tryLock();

    public void lockInterruptible() throws GuestInterruptedException;

    public void unlock();

    default public boolean await(long timeout) throws GuestInterruptedException {
        return this.await(timeout, TimeUnit.MILLISECONDS);
    }

    default public boolean await(long timeout, TimeUnit unit) throws GuestInterruptedException {
        return this.await(timeout, unit, null, null);
    }

    public boolean await(long var1, TimeUnit var3, StaticObject var4, StaticObject var5) throws GuestInterruptedException;

    public boolean awaitUntil(Date var1) throws GuestInterruptedException;

    public void signal();

    public void signalAll();

    public boolean isHeldByCurrentThread();

    public Thread getOwnerThread();

    public int getEntryCount();
}

