/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.attributes;

import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.jdwp.api.LineNumberTableRef;
import com.oracle.truffle.espresso.runtime.Attribute;
import java.util.AbstractList;
import java.util.List;

public final class LineNumberTableAttribute
extends Attribute
implements LineNumberTableRef {
    public static final Symbol<Symbol.Name> NAME = Symbol.Name.LineNumberTable;
    public static final LineNumberTableAttribute EMPTY = new LineNumberTableAttribute(NAME, new char[0]);
    private final char[] bciToLineEntries;
    private int lastLine = -1;
    private int firstLine = -1;

    public LineNumberTableAttribute(Symbol<Symbol.Name> name, char[] entries) {
        super(name, null);
        assert (entries.length % 2 == 0);
        this.bciToLineEntries = entries;
    }

    public List<Entry> getEntries() {
        return new ListWrapper();
    }

    private int length() {
        return this.bciToLineEntries.length >> 1;
    }

    public int getLineNumber(int atBci) {
        for (int i = 0; i < this.length() - 1; ++i) {
            if (this.bciAt(i) > atBci || atBci >= this.bciAt(i + 1)) continue;
            return this.lineAt(i);
        }
        return this.lineAt(this.length() - 1);
    }

    public long getBCI(int line) {
        for (int i = 0; i < this.length(); ++i) {
            if (this.lineAt(i) != line) continue;
            return this.bciAt(i);
        }
        return -1L;
    }

    public int getLastLine() {
        if (this.lastLine != -1) {
            return this.lastLine;
        }
        int max = -1;
        for (int i = 0; i < this.length(); ++i) {
            max = Math.max(max, this.lineAt(i));
        }
        return max;
    }

    public int getFirstLine() {
        if (this.firstLine != -1) {
            return this.firstLine;
        }
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.length(); ++i) {
            min = Math.min(min, this.lineAt(i));
        }
        return min;
    }

    public int getNextLine(int line) {
        int next = Integer.MAX_VALUE;
        for (int i = 0; i < this.length(); ++i) {
            if (this.lineAt(i) <= line) continue;
            next = Math.min(next, this.lineAt(i));
        }
        return next;
    }

    private int bciAt(int i) {
        return this.bciToLineEntries[i * 2];
    }

    private int lineAt(int i) {
        return this.bciToLineEntries[i * 2 + 1];
    }

    private class ListWrapper
    extends AbstractList<Entry> {
        private ListWrapper() {
        }

        @Override
        public Entry get(int index) {
            if (index >= 0 && index < this.size()) {
                return new Entry(LineNumberTableAttribute.this.bciAt(index), LineNumberTableAttribute.this.lineAt(index));
            }
            throw new IndexOutOfBoundsException("index " + index + " out of bounds for list of size " + LineNumberTableAttribute.this.length() + ".");
        }

        @Override
        public int size() {
            return LineNumberTableAttribute.this.length();
        }
    }

    public static final class Entry
    implements LineNumberTableRef.EntryRef {
        private final int bci;
        private final int lineNumber;

        public Entry(int bci, int lineNumber) {
            this.bci = bci;
            this.lineNumber = lineNumber;
        }

        @Override
        public int getBCI() {
            return this.bci;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

