/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.MemberRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.NeedsFreshResolutionException;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.perf.DebugCounter;
import com.oracle.truffle.espresso.redefinition.ClassRedefinition;
import com.oracle.truffle.espresso.runtime.EspressoException;
import java.util.Objects;

public interface FieldRefConstant
extends MemberRefConstant {
    public static final DebugCounter FIELDREF_RESOLVE_COUNT = DebugCounter.create("FieldREf.resolve calls");

    public static FieldRefConstant create(int classIndex, int nameAndTypeIndex) {
        return new Indexes(classIndex, nameAndTypeIndex);
    }

    public static Resolvable.ResolvedConstant fromPreResolved(Field field) {
        return new Resolved(field);
    }

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.FIELD_REF;
    }

    default public Symbol<Symbol.Type> getType(ConstantPool pool) {
        return Types.fromDescriptor(this.getDescriptor(pool));
    }

    public static final class Indexes
    extends MemberRefConstant.Indexes
    implements FieldRefConstant,
    Resolvable {
        Indexes(int classIndex, int nameAndTypeIndex) {
            super(classIndex, nameAndTypeIndex);
        }

        private static Field lookupField(Klass seed, Symbol<Symbol.Name> name, Symbol<Symbol.Type> type) {
            Field f = seed.lookupDeclaredField(name, type);
            if (f != null) {
                return f;
            }
            for (ObjectKlass i : seed.getSuperInterfaces()) {
                f = Indexes.lookupField(i, name, type);
                if (f == null) continue;
                return f;
            }
            if (seed.getSuperKlass() != null) {
                return Indexes.lookupField(seed.getSuperKlass(), name, type);
            }
            return null;
        }

        @Override
        public Resolvable.ResolvedConstant resolve(RuntimeConstantPool pool, int thisIndex, Klass accessingKlass) {
            FIELDREF_RESOLVE_COUNT.inc();
            Klass holderKlass = this.getResolvedHolderKlass(accessingKlass, pool);
            Symbol<Symbol.Name> name = this.getName(pool);
            Symbol<Symbol.Type> type = this.getType(pool);
            Field field = Indexes.lookupField(holderKlass, name, type);
            if (field == null) {
                ClassRedefinition classRedefinition = pool.getContext().getClassRedefinition();
                if (classRedefinition != null) {
                    classRedefinition.check();
                    field = Indexes.lookupField(holderKlass, name, type);
                }
                if (field == null) {
                    Meta meta = pool.getContext().getMeta();
                    EspressoException failure = EspressoException.wrap(Meta.initExceptionWithMessage(meta.java_lang_NoSuchFieldError, name.toString()), meta);
                    Assumption missingFieldAssumption = classRedefinition != null ? classRedefinition.getMissingFieldAssumption() : Assumption.ALWAYS_VALID;
                    return new Missing(failure, missingFieldAssumption);
                }
            }
            MemberRefConstant.doAccessCheck(accessingKlass, holderKlass, field, pool.getContext().getMeta());
            field.checkLoadingConstraints(accessingKlass.getDefiningClassLoader(), field.getDeclaringKlass().getDefiningClassLoader());
            return new Resolved(field);
        }

        @Override
        public void validate(ConstantPool pool) {
            super.validate(pool);
            pool.nameAndTypeAt(this.nameAndTypeIndex).validateField(pool);
        }
    }

    public static final class Resolved
    implements FieldRefConstant,
    Resolvable.ResolvedConstant {
        private final Field resolved;

        Resolved(Field resolvedField) {
            Objects.requireNonNull(resolvedField);
            this.resolved = resolvedField;
        }

        @Override
        public Symbol<Symbol.Type> getType(ConstantPool pool) {
            return this.resolved.getType();
        }

        @Override
        public Field value() {
            return this.resolved;
        }

        @Override
        public Symbol<Symbol.Name> getHolderKlassName(ConstantPool pool) {
            throw EspressoError.shouldNotReachHere("Field already resolved");
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            return this.resolved.getName();
        }

        @Override
        public Symbol<? extends Symbol.Descriptor> getDescriptor(ConstantPool pool) {
            return this.getType(pool);
        }
    }

    public static final class Missing
    implements FieldRefConstant,
    Resolvable.ResolvedConstant {
        private final EspressoException failure;
        private final Assumption assumption;

        public Missing(EspressoException failure, Assumption missingFieldAssumption) {
            this.failure = failure;
            this.assumption = missingFieldAssumption;
        }

        @Override
        public Symbol<Symbol.Type> getType(ConstantPool pool) {
            throw EspressoError.shouldNotReachHere();
        }

        @Override
        public Field value() {
            if (this.assumption.isValid()) {
                throw this.failure;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new NeedsFreshResolutionException();
        }

        @Override
        public Symbol<Symbol.Name> getHolderKlassName(ConstantPool pool) {
            throw EspressoError.shouldNotReachHere();
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            throw EspressoError.shouldNotReachHere();
        }

        @Override
        public Symbol<? extends Symbol.Descriptor> getDescriptor(ConstantPool pool) {
            throw EspressoError.shouldNotReachHere();
        }

        @Override
        public boolean isSuccess() {
            return false;
        }
    }
}

