/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.nio.ByteBuffer;

public interface StringConstant
extends PoolConstant {
    public static StringConstant create(int utf8Index) {
        return new Index(utf8Index);
    }

    public static StringConstant preResolved(StaticObject resolved) {
        return new PreResolved(resolved);
    }

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.STRING;
    }

    @Override
    default public String toString(ConstantPool pool) {
        return this.getSymbol(pool).toString();
    }

    public Symbol<Symbol.ModifiedUTF8> getSymbol(ConstantPool var1);

    public static final class Index
    implements StringConstant,
    Resolvable {
        private final char utf8Index;

        @Override
        public Symbol<Symbol.ModifiedUTF8> getSymbol(ConstantPool pool) {
            return pool.symbolAt(this.utf8Index);
        }

        Index(int utf8Index) {
            this.utf8Index = PoolConstant.u2(utf8Index);
        }

        @Override
        public Resolvable.ResolvedConstant resolve(RuntimeConstantPool pool, int thisIndex, Klass accessingKlass) {
            return new Resolved(pool.getContext().getStrings().intern(this.getSymbol(pool)));
        }

        @Override
        public void validate(ConstantPool pool) {
            pool.utf8At(this.utf8Index).validateUTF8();
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar(this.utf8Index);
        }
    }

    public static final class PreResolved
    implements StringConstant,
    Resolvable {
        private final StaticObject resolved;

        @Override
        public Symbol<Symbol.ModifiedUTF8> getSymbol(ConstantPool pool) {
            throw EspressoError.shouldNotReachHere("String already Pre-Resolved");
        }

        PreResolved(StaticObject resolved) {
            this.resolved = resolved;
        }

        @Override
        public Resolvable.ResolvedConstant resolve(RuntimeConstantPool pool, int thisIndex, Klass accessingKlass) {
            return new Resolved(this.resolved);
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar('\u0000');
        }
    }

    public static final class Resolved
    implements StringConstant,
    Resolvable.ResolvedConstant {
        private final StaticObject resolved;

        Resolved(StaticObject resolved) {
            this.resolved = resolved;
        }

        @Override
        public StaticObject value() {
            return this.resolved;
        }

        @Override
        public Symbol<Symbol.ModifiedUTF8> getSymbol(ConstantPool pool) {
            throw EspressoError.shouldNotReachHere("String already resolved");
        }
    }
}

