/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.ffi.nfi;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.ffi.NativeAccess;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.Pointer;
import com.oracle.truffle.espresso.ffi.nfi.NFINativeAccess;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.EspressoProperties;
import com.oracle.truffle.espresso.substitutions.Collect;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.graalvm.home.HomeFinder;
import org.graalvm.options.OptionValues;

public final class NFISulongNativeAccess
extends NFINativeAccess {
    @Override
    protected String nfiStringSignature(NativeSignature nativeSignature, boolean fromJava) {
        String res = super.nfiStringSignature(nativeSignature, fromJava);
        if (fromJava) {
            return "with llvm " + res;
        }
        return res;
    }

    NFISulongNativeAccess(TruffleLanguage.Env env) {
        super(env);
    }

    @Override
    protected @Pointer TruffleObject loadLibrary0(Path libraryPath) {
        String nfiSource = String.format("with llvm load(RTLD_LAZY|RTLD_LOCAL) '%s'", libraryPath);
        return this.loadLibraryHelper(nfiSource);
    }

    @Override
    public @Pointer TruffleObject loadDefaultLibrary() {
        return null;
    }

    static String getJavaVersion(Path javaHome) {
        Path releaseFile = javaHome.resolve("release");
        if (!Files.isRegularFile(releaseFile, new LinkOption[0])) {
            return null;
        }
        try {
            for (String line : Files.readAllLines(releaseFile)) {
                if (!line.startsWith("JAVA_VERSION=")) continue;
                String version = line.substring("JAVA_VERSION=".length()).trim();
                if (version.length() > 2 && version.startsWith("\"") && version.endsWith("\"")) {
                    version = version.substring(1, version.length() - 1);
                }
                return version;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private Path legacyGraalvmllvmBootLibraryPath(String javaVersion, Path llvmRoot) {
        Path llvmDefault = llvmRoot.resolve("default");
        if (!Files.exists(llvmDefault, new LinkOption[0])) {
            this.getLogger().warning(() -> "espresso-llvm (default) component not found. Install it, if available for your platform.");
        }
        String llvmDefaultVersion = NFISulongNativeAccess.getJavaVersion(llvmDefault);
        this.getLogger().fine(() -> "Check " + llvmDefault + " with Java version: " + llvmDefaultVersion);
        if (javaVersion.equals(llvmDefaultVersion)) {
            return llvmDefault;
        }
        if (!Files.exists(llvmRoot, new LinkOption[0])) {
            return null;
        }
        List sortedPaths = null;
        try {
            sortedPaths = Files.list(llvmRoot).filter(f -> !llvmDefault.equals(f) && Files.isDirectory(f, new LinkOption[0])).sorted().collect(Collectors.toList());
        }
        catch (IOException e) {
            throw EspressoError.shouldNotReachHere(e.getMessage(), e);
        }
        for (Path llvmImpl : sortedPaths) {
            String llvmImplVersion = NFISulongNativeAccess.getJavaVersion(llvmImpl);
            this.getLogger().fine(() -> "Checking " + llvmImpl + " with Java version: " + llvmImplVersion);
            if (!javaVersion.equals(llvmImplVersion)) continue;
            return llvmImpl;
        }
        return null;
    }

    @Override
    public void updateEspressoProperties(EspressoProperties.Builder builder, OptionValues options) {
        if (options.hasBeenSet(EspressoOptions.BootLibraryPath)) {
            this.getLogger().info("--java.BootLibraryPath was set by the user, skipping override for nfi-llvm");
        } else {
            String targetJavaVersion = NFISulongNativeAccess.getJavaVersion(builder.javaHome());
            if (targetJavaVersion == null) {
                this.getLogger().warning("Cannot determine the Java version for '" + builder.javaHome() + "'. The default --java.BootLibraryPath will be used.");
            } else {
                Path espressoHome = (Path)HomeFinder.getInstance().getLanguageHomes().get("java");
                if (espressoHome != null && Files.isDirectory(espressoHome, new LinkOption[0])) {
                    Path llvmRoot = espressoHome.resolve("lib").resolve("llvm");
                    Path llvmBootLibraryPath = this.legacyGraalvmllvmBootLibraryPath(targetJavaVersion, llvmRoot);
                    if (llvmBootLibraryPath == null) {
                        this.getLogger().warning("Couldn't find libraries with LLVM bitcode for Java version '" + targetJavaVersion + "'. The default --java.BootLibraryPath will be used.");
                    } else {
                        builder.bootLibraryPath(Collections.singletonList(llvmBootLibraryPath));
                    }
                } else {
                    Path llvmRoot = builder.javaHome().resolve("lib").resolve("llvm");
                    if (Files.isDirectory(llvmRoot, new LinkOption[0])) {
                        builder.bootLibraryPath(Collections.singletonList(llvmRoot));
                    } else {
                        this.getLogger().warning("Couldn't find libraries with LLVM bitcode. The default --java.BootLibraryPath will be used.");
                    }
                }
            }
        }
        if (options.hasBeenSet(EspressoOptions.JVMLibraryPath)) {
            this.getLogger().info("--java.JVMLibraryPath was set by the user, skipping override for nfi-llvm");
        } else {
            builder.jvmLibraryPath(Collections.singletonList(builder.espressoLibs()));
        }
    }

    @Collect(value={NativeAccess.class})
    public static final class Provider
    implements NativeAccess.Provider {
        public static final String ID = "nfi-llvm";

        @Override
        public String id() {
            return ID;
        }

        @Override
        public NativeAccess create(TruffleLanguage.Env env) {
            return new NFISulongNativeAccess(env);
        }
    }
}

