/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.staticobject.StaticProperty;
import com.oracle.truffle.espresso.descriptors.ByteSequence;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.impl.ParserField;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.runtime.Attribute;

final class LinkedField
extends StaticProperty {
    private final ParserField parserField;
    private final int slot;

    LinkedField(ParserField parserField, int slot, IdMode mode) {
        this.parserField = LinkedField.maybeCorrectParserField(parserField, mode);
        this.slot = slot;
    }

    private static ParserField maybeCorrectParserField(ParserField parserField, IdMode mode) {
        switch (mode) {
            case REGULAR: {
                return parserField;
            }
            case WITH_TYPE: {
                return parserField.withFlags(0x1000000);
            }
            case OBFUSCATED: {
                return parserField.withFlags(0x2000000);
            }
        }
        throw EspressoError.shouldNotReachHere();
    }

    protected String getId() {
        Symbol<Symbol.Name> name = this.getName();
        switch (this.idMode()) {
            case WITH_TYPE: {
                return LinkedField.idFromNameAndType(name, this.getType());
            }
            case OBFUSCATED: {
                return (this.getKind().isPrimitive() ? "primitive" : (this.isHidden() ? "hidden" : "reference")) + "Field" + this.slot;
            }
            case REGULAR: {
                return name.toString();
            }
        }
        throw EspressoError.shouldNotReachHere();
    }

    private IdMode idMode() {
        int flags = this.getFlags();
        if ((flags & 0x1000000) == 0x1000000) {
            return IdMode.WITH_TYPE;
        }
        if ((flags & 0x2000000) == 0x2000000) {
            return IdMode.OBFUSCATED;
        }
        return IdMode.REGULAR;
    }

    static String idFromNameAndType(Symbol<Symbol.Name> name, ByteSequence t) {
        int arrayDims = Types.getArrayDimensions(t);
        if (arrayDims > 0) {
            StringBuilder typeString = new StringBuilder(LinkedField.idFromNameAndType(name, t.subSequence(arrayDims, t.length() - arrayDims)));
            typeString.append('_');
            while (arrayDims > 0) {
                typeString.append(']');
                --arrayDims;
            }
            return typeString.toString();
        }
        String typeString = t.toString();
        if (Types.isReference(t)) {
            typeString = typeString.substring(1, typeString.length() - 1);
            typeString = typeString.replace('/', '_');
        }
        return name.toString() + "_" + typeString;
    }

    public Symbol<Symbol.Name> getName() {
        return this.parserField.getName();
    }

    public int getSlot() {
        return this.slot;
    }

    public Symbol<Symbol.Type> getType() {
        return this.getParserField().getType();
    }

    public int getFlags() {
        return this.getParserField().getFlags();
    }

    public JavaKind getKind() {
        return this.parserField.getKind();
    }

    public Attribute getAttribute(Symbol<Symbol.Name> name) {
        for (Attribute a : this.getParserField().getAttributes()) {
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    public boolean isHidden() {
        return this.getParserField().isHidden();
    }

    ParserField getParserField() {
        return this.parserField;
    }

    static enum IdMode {
        REGULAR,
        WITH_TYPE,
        OBFUSCATED;

    }
}

