/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.EntryTable;
import com.oracle.truffle.espresso.jdwp.api.ModuleRef;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.ArrayList;
import java.util.concurrent.locks.ReadWriteLock;

public class ModuleTable
extends EntryTable<ModuleEntry, ClassRegistry> {
    public ModuleTable(ReadWriteLock lock) {
        super(lock);
    }

    @Override
    protected ModuleEntry createEntry(Symbol<Symbol.Name> name, ClassRegistry registry) {
        return new ModuleEntry(name, registry);
    }

    public ModuleEntry createAndAddEntry(Symbol<Symbol.Name> name, ClassRegistry registry, boolean isOpen, StaticObject module) {
        ModuleEntry moduleEntry = (ModuleEntry)this.createAndAddEntry(name, registry);
        if (moduleEntry == null) {
            return null;
        }
        moduleEntry.setModule(module);
        moduleEntry.isOpen = isOpen;
        return moduleEntry;
    }

    public static class ModuleEntry
    extends EntryTable.NamedEntry
    implements ModuleRef {
        private final ClassRegistry registry;
        private StaticObject module = StaticObject.NULL;
        private boolean isOpen = false;
        private boolean canReadAllUnnamed = false;
        private ArrayList<ModuleEntry> reads;

        ModuleEntry(Symbol<Symbol.Name> name, ClassRegistry data) {
            super(name);
            this.registry = data;
        }

        @Override
        public String jdwpName() {
            if (this.name == null) {
                return "";
            }
            return this.name.toString();
        }

        @Override
        public Object classLoader() {
            return this.registry.getClassLoader();
        }

        public static ModuleEntry createUnnamedModuleEntry(StaticObject module, ClassRegistry registry) {
            ModuleEntry result = new ModuleEntry(null, registry);
            result.setCanReadAllUnnamed();
            if (!StaticObject.isNull(module)) {
                result.setModule(module);
            }
            result.isOpen = true;
            return result;
        }

        public ClassRegistry registry() {
            return this.registry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addReads(ModuleEntry from) {
            if (!this.isNamed()) {
                return;
            }
            ModuleEntry moduleEntry = this;
            synchronized (moduleEntry) {
                if (from == null) {
                    this.setCanReadAllUnnamed();
                    return;
                }
                if (this.reads == null) {
                    this.reads = new ArrayList();
                }
                if (!this.contains(from)) {
                    this.reads.add(from);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean canRead(ModuleEntry m, EspressoContext context) {
            if (!this.isNamed() || m.isJavaBase(context)) {
                return true;
            }
            ModuleEntry moduleEntry = this;
            synchronized (moduleEntry) {
                if (!this.hasReads()) {
                    return false;
                }
                return this.contains(m);
            }
        }

        private boolean contains(ModuleEntry from) {
            return this.reads.contains(from);
        }

        public void setModule(StaticObject module) {
            this.module = module;
        }

        public StaticObject module() {
            return this.module;
        }

        public void setCanReadAllUnnamed() {
            this.canReadAllUnnamed = true;
        }

        public boolean canReadAllUnnamed() {
            return this.canReadAllUnnamed;
        }

        public boolean isOpen() {
            return this.isOpen;
        }

        public boolean isNamed() {
            return this.getName() != null;
        }

        public boolean isJavaBase(EspressoContext context) {
            return this == context.getRegistries().getJavaBaseModule();
        }

        public boolean hasReads() {
            return this.reads != null && !this.reads.isEmpty();
        }
    }
}

