/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.api;

import com.oracle.truffle.espresso.jdwp.api.KlassRef;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerController;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Ids<T> {
    private volatile long uniqueID = 1L;
    private WeakReference<T>[] objects;
    private final T nullObject;
    public static final Pattern ANON_INNER_CLASS_PATTERN = Pattern.compile(".*\\$\\d+.*");
    private HashMap<String, Long> innerClassIDMap = new HashMap(16);
    private DebuggerController controller;

    public Ids(T nullObject) {
        this.nullObject = nullObject;
        this.objects = new WeakReference[]{new WeakReference<T>(nullObject)};
    }

    public long getIdAsLong(T object) {
        KlassRef klass;
        Long id;
        if (object == null) {
            this.log(() -> "Null object when getting ID");
            return 0L;
        }
        for (int i = 1; i < this.objects.length; ++i) {
            if (this.objects[i].get() != object) continue;
            int index = i;
            this.log(() -> "ID cache hit for object: " + object + " with ID: " + index);
            return i;
        }
        if (object instanceof KlassRef && (id = this.innerClassIDMap.get((klass = (KlassRef)object).getNameAsString())) != null) {
            this.objects[(int)id.longValue()] = new WeakReference<T>(object);
            return id;
        }
        return this.generateUniqueId(object);
    }

    public long getId(Object object) {
        for (int i = 1; i < this.objects.length; ++i) {
            if (this.objects[i].get() != object) continue;
            int index = i;
            this.log(() -> "ID cache hit for object: " + object + " with ID: " + index);
            return i;
        }
        return -1L;
    }

    public T fromId(int id) {
        if (id == 0) {
            this.log(() -> "Null object from ID: " + id);
            return this.nullObject;
        }
        if (id > this.objects.length) {
            this.log(() -> "Unknown object ID: " + id);
            return null;
        }
        WeakReference<T> ref = this.objects[id];
        Object o = ref.get();
        if (o == null) {
            this.log(() -> "object with ID: " + id + " was garbage collected");
            return null;
        }
        this.log(() -> "returning object: " + o + " for ID: " + id);
        return o;
    }

    private synchronized long generateUniqueId(T object) {
        KlassRef klass;
        Matcher matcher;
        long id = this.uniqueID++;
        assert ((long)this.objects.length == id);
        WeakReference<T>[] expandedArray = Arrays.copyOf(this.objects, this.objects.length + 1);
        expandedArray[this.objects.length] = new WeakReference<T>(object);
        this.objects = expandedArray;
        this.log(() -> "Generating new ID: " + id + " for object: " + object);
        if (object instanceof KlassRef && (matcher = ANON_INNER_CLASS_PATTERN.matcher((klass = (KlassRef)object).getNameAsString())).matches()) {
            this.innerClassIDMap.put(klass.getNameAsString(), id);
        }
        return id;
    }

    public void replaceObject(T original, T replacement) {
        int id = (int)this.getIdAsLong(original);
        this.objects[id] = new WeakReference<T>(replacement);
        this.log(() -> "Replaced ID: " + id);
    }

    public void updateId(KlassRef klass) {
        this.removeId(klass);
        Long theId = this.innerClassIDMap.get(klass.getNameAsString());
        if (theId != null) {
            this.objects[(int)theId.longValue()] = new WeakReference<KlassRef>(klass);
        }
    }

    private void removeId(KlassRef klass) {
        int id = (int)this.getId(klass);
        if (id > 0) {
            this.objects[id] = new WeakReference<Object>(null);
        }
    }

    public boolean checkRemoved(long refTypeId) {
        return this.innerClassIDMap.containsValue(refTypeId);
    }

    public void injectController(DebuggerController control) {
        this.controller = control;
    }

    private void log(Supplier<String> supplier) {
        if (this.controller != null) {
            this.controller.finest(supplier);
        }
    }
}

