/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.espresso.jdwp.api.JDWPContext;
import com.oracle.truffle.espresso.jdwp.api.KlassRef;
import com.oracle.truffle.espresso.jdwp.api.MethodRef;
import com.oracle.truffle.espresso.jdwp.impl.NoSuchSourceLineException;

public final class SourceLocator {
    private final JDWPContext context;

    SourceLocator(JDWPContext context) {
        this.context = context;
    }

    public Source lookupSource(String slashName, int lineNumber) throws NoSuchSourceLineException {
        KlassRef[] klass = this.context.findLoadedClass(slashName);
        if (klass == null) {
            throw new RuntimeException("not implemented yet!");
        }
        for (MethodRef method : klass[0].getDeclaredMethodRefs()) {
            if (!method.hasLine(lineNumber)) continue;
            return method.getSource();
        }
        throw new NoSuchSourceLineException();
    }
}

