/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.espresso.nodes.EspressoBaseStatementNode;

@GeneratedBy(value=EspressoBaseStatementNode.class)
final class EspressoBaseStatementNodeWrapper
extends EspressoBaseStatementNode
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private EspressoBaseStatementNode delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    EspressoBaseStatementNodeWrapper(EspressoBaseStatementNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public EspressoBaseStatementNode getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    @Override
    public void execute(VirtualFrame frame) {
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                this.delegateNode.execute(frame);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, null);
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) break;
                throw t;
            }
            break;
        }
    }

    @Override
    public int getBci(Frame frame) {
        return this.delegateNode.getBci(frame);
    }
}

