/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.EspressoInstrumentableRootNodeImpl;
import com.oracle.truffle.espresso.perf.DebugCounter;
import com.oracle.truffle.espresso.substitutions.JavaSubstitution;
import java.util.Arrays;

final class IntrinsicSubstitutorNode
extends EspressoInstrumentableRootNodeImpl {
    @Node.Child
    private JavaSubstitution substitution;
    private final DebugCounter nbSplits;

    IntrinsicSubstitutorNode(Method.MethodVersion methodVersion, JavaSubstitution.Factory factory) {
        super(methodVersion);
        this.substitution = factory.create();
        EspressoError.guarantee(!this.substitution.isTrivial() || !methodVersion.isSynchronized(), "Substitution for synchronized method cannot be marked as trivial", methodVersion);
        this.nbSplits = this.substitution.canSplit() ? DebugCounter.create("Splits for: " + Arrays.toString(factory.getMethodNames())) : null;
    }

    private IntrinsicSubstitutorNode(IntrinsicSubstitutorNode toSplit) {
        super(toSplit.getMethodVersion());
        assert (toSplit.substitution.canSplit());
        this.substitution = toSplit.substitution.split();
        this.nbSplits = toSplit.nbSplits;
    }

    @Override
    void beforeInstumentation(VirtualFrame frame) {
    }

    @Override
    Object execute(VirtualFrame frame) {
        return this.substitution.invoke(frame.getArguments());
    }

    @Override
    public boolean canSplit() {
        return this.substitution.canSplit();
    }

    @Override
    public IntrinsicSubstitutorNode split() {
        this.nbSplits.inc();
        return new IntrinsicSubstitutorNode(this);
    }

    public Node copy() {
        return this.split();
    }

    @Override
    public int getBci(Frame frame) {
        return -2;
    }

    @Override
    boolean isTrivial() {
        return this.substitution.isTrivial();
    }
}

