/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.bytecodes;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.NullCheck;
import com.oracle.truffle.espresso.nodes.quick.interop.ForeignArrayUtils;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@NodeInfo(shortName="CALOAD")
@GenerateUncached
public abstract class CharArrayLoad
extends EspressoNode {
    public abstract char execute(StaticObject var1, int var2);

    @Specialization
    char doWithNullCheck(StaticObject array, int index, @Cached NullCheck nullCheck, @Cached WithoutNullCheck charArrayLoad) {
        return charArrayLoad.execute(nullCheck.execute(array), index);
    }

    @NodeInfo(shortName="CALOAD !nullcheck")
    @GenerateUncached
    public static abstract class WithoutNullCheck
    extends EspressoNode {
        static final int LIMIT = 2;

        public abstract char execute(StaticObject var1, int var2);

        @Specialization(guards={"array.isForeignObject()"})
        char doForeign(StaticObject array, int index, @CachedLibrary(limit="LIMIT") InteropLibrary arrayInterop, @CachedLibrary(limit="LIMIT") InteropLibrary elemInterop, @Cached BranchProfile exceptionProfile) {
            assert (!StaticObject.isNull(array));
            Meta meta = this.getMeta();
            Object element = ForeignArrayUtils.readForeignArrayElement(array, index, this.getLanguage(), meta, arrayInterop, exceptionProfile);
            try {
                String string1 = elemInterop.asString(element);
                if (string1.length() == 1) {
                    return string1.charAt(0);
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            exceptionProfile.enter();
            throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "Could not cast foreign array element to char");
        }

        @Specialization(guards={"array.isEspressoObject()"})
        char doEspresso(StaticObject array, int index) {
            assert (!StaticObject.isNull(array));
            return this.getContext().getInterpreterToVM().getArrayChar(this.getLanguage(), index, array);
        }
    }
}

