/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.commands;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.interop.LookupDeclaredMethod;
import com.oracle.truffle.espresso.nodes.interop.LookupDeclaredMethodNodeGen;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class AddPathToBindingsCache {
    static final String NEW_FILE = "<init>/(Ljava/lang/String;)V";
    static final String TO_URI = "toURI/()Ljava/net/URI;";
    static final String TO_URL = "toURL/()Ljava/net/URL;";
    static final String ADD_URL = "addURL/(Ljava/net/URL;)V";
    static final String FILE_CLASSNAME = "java/io/File";
    static final String URI_CLASSNAME = "java/net/URI";
    private final ObjectKlass fileKlass;
    private final DirectCallNode newFile;
    private final DirectCallNode toUri;
    private final DirectCallNode toUrl;
    private final DirectCallNode addUrl;
    private final StaticObject loader;

    public AddPathToBindingsCache(EspressoContext context) {
        this.fileKlass = (ObjectKlass)context.getMeta().loadKlassOrNull(context.getTypes().fromClassGetName(FILE_CLASSNAME), StaticObject.NULL, StaticObject.NULL);
        ObjectKlass uriKlass = (ObjectKlass)context.getMeta().loadKlassOrNull(context.getTypes().fromClassGetName(URI_CLASSNAME), StaticObject.NULL, StaticObject.NULL);
        LookupDeclaredMethod lookup = LookupDeclaredMethodNodeGen.getUncached();
        this.newFile = DirectCallNode.create((CallTarget)AddPathToBindingsCache.doLookup(this.fileKlass, NEW_FILE, lookup).getCallTargetForceInit());
        this.toUri = DirectCallNode.create((CallTarget)AddPathToBindingsCache.doLookup(this.fileKlass, TO_URI, lookup).getCallTargetForceInit());
        this.toUrl = DirectCallNode.create((CallTarget)AddPathToBindingsCache.doLookup(uriKlass, TO_URL, lookup).getCallTargetForceInit());
        this.loader = context.getBindingsLoader();
        this.addUrl = DirectCallNode.create((CallTarget)AddPathToBindingsCache.doLookup(this.loader.getKlass(), ADD_URL, lookup).getCallTargetForceInit());
    }

    public void execute(StaticObject path) {
        StaticObject file = this.fileKlass.allocateInstance();
        this.newFile.call(new Object[]{file, path});
        Object uri = this.toUri.call(new Object[]{file});
        Object url = this.toUrl.call(new Object[]{uri});
        this.addUrl.call(new Object[]{this.loader, url});
    }

    private static Method doLookup(Klass klass, String key, LookupDeclaredMethod lookup) {
        try {
            return lookup.execute(klass, key, false, false, -1)[0];
        }
        catch (InteropException e) {
            throw EspressoError.shouldNotReachHere();
        }
    }
}

