/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.interop;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.bytecode.Bytecodes;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.bytecodes.DoubleArrayStore;
import com.oracle.truffle.espresso.nodes.bytecodes.DoubleArrayStoreNodeGen;
import com.oracle.truffle.espresso.nodes.quick.QuickNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class DoubleArrayStoreQuickNode
extends QuickNode {
    static final int stackEffectOf_DASTORE = Bytecodes.stackEffectOf(82);
    @Node.Child
    DoubleArrayStore.WithoutNullCheck doubleArrayStore = DoubleArrayStoreNodeGen.WithoutNullCheckNodeGen.create();

    public DoubleArrayStoreQuickNode(int top, int callerBCI) {
        super(top, callerBCI);
    }

    @Override
    public int execute(VirtualFrame frame) {
        double value = EspressoFrame.popDouble((Frame)frame, this.top - 1);
        int index = EspressoFrame.popInt((Frame)frame, this.top - 3);
        StaticObject array = this.nullCheck(EspressoFrame.popObject((Frame)frame, this.top - 4));
        this.doubleArrayStore.execute(array, index, value);
        return stackEffectOf_DASTORE;
    }
}

