/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.interop;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.helper.AbstractGetFieldNode;
import com.oracle.truffle.espresso.nodes.quick.QuickNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class QuickenedGetFieldNode
extends QuickNode {
    private final int statementIndex;
    @Node.Child
    AbstractGetFieldNode getFieldNode;

    public QuickenedGetFieldNode(int top, int callerBCI, int statementIndex, Field field) {
        super(top, callerBCI);
        assert (!field.isStatic());
        this.getFieldNode = AbstractGetFieldNode.create(field);
        this.statementIndex = statementIndex;
    }

    @Override
    public int execute(VirtualFrame frame) {
        BytecodeNode root = this.getBytecodeNode();
        StaticObject receiver = this.nullCheck(EspressoFrame.popObject((Frame)frame, this.top - 1));
        return this.getFieldNode.getField(frame, root, receiver, this.top - 1, this.statementIndex) - 1;
    }
}

