/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.invoke;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.EspressoRootNode;
import com.oracle.truffle.espresso.nodes.bytecodes.InvokeStatic;
import com.oracle.truffle.espresso.nodes.bytecodes.InvokeStaticNodeGen;
import com.oracle.truffle.espresso.nodes.quick.invoke.InvokeQuickNode;
import com.oracle.truffle.espresso.vm.VM;

public final class InvokeStaticQuickNode
extends InvokeQuickNode {
    @Node.Child
    InvokeStatic invokeStatic;
    final boolean isDoPrivilegedCall;

    public InvokeStaticQuickNode(Method method, int top, int curBCI) {
        super(method, top, curBCI);
        assert (method.isStatic());
        this.isDoPrivilegedCall = method.getMeta().java_security_AccessController.equals(method.getDeclaringKlass()) && Symbol.Name.doPrivileged.equals(method.getName());
        this.invokeStatic = (InvokeStatic)this.insert(InvokeStaticNodeGen.create(method));
    }

    @Override
    public int execute(VirtualFrame frame) {
        EspressoRootNode rootNode;
        if (this.isDoPrivilegedCall && (rootNode = (EspressoRootNode)this.getRootNode()) != null) {
            rootNode.setFrameId((Frame)frame, VM.GlobalFrameIDs.getID());
        }
        Object[] args = this.getArguments(frame);
        return this.pushResult(frame, this.invokeStatic.execute(args));
    }
}

