/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick.invoke.inline.bodies;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.GuardedInlinedMethodNode;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedFrameAccess;
import com.oracle.truffle.espresso.nodes.quick.invoke.inline.InlinedMethodNode;
import com.oracle.truffle.espresso.substitutions.JavaSubstitution;

public final class InlinedSubstitutionBodyNode
extends InlinedMethodNode.BodyNode {
    @Node.Child
    JavaSubstitution substitution;

    InlinedSubstitutionBodyNode(Method.MethodVersion m, JavaSubstitution substitution) {
        super(m);
        this.substitution = (JavaSubstitution)this.insert(substitution);
    }

    public static InlinedMethodNode create(Method inlinedMethod, int top, int opcode, int callerBCI, int statementIndex, JavaSubstitution.Factory factory) {
        Method.MethodVersion methodVersion = inlinedMethod.getMethodVersion();
        InlinedSubstitutionBodyNode bodyNode = new InlinedSubstitutionBodyNode(methodVersion, factory.create());
        if (factory.guard() != null) {
            return new GuardedInlinedMethodNode(methodVersion, top, opcode, callerBCI, statementIndex, (InlinedMethodNode.BodyNode)bodyNode, factory.guard());
        }
        return new InlinedMethodNode(methodVersion, top, opcode, callerBCI, statementIndex, bodyNode);
    }

    @Override
    public void execute(VirtualFrame frame, InlinedFrameAccess frameAccess) {
        this.substitution.invokeInlined(frame, frameAccess.top(), frameAccess);
    }
}

