/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.EmptyKeysArray;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.KeysArray;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.meta.ModifiersProvider;
import com.oracle.truffle.espresso.nodes.interop.CandidateMethodWithArgs;
import com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode;
import com.oracle.truffle.espresso.nodes.interop.LookupInstanceFieldNode;
import com.oracle.truffle.espresso.nodes.interop.LookupVirtualMethodNode;
import com.oracle.truffle.espresso.nodes.interop.MethodArgsUtils;
import com.oracle.truffle.espresso.nodes.interop.OverLoadedMethodSelectorNode;
import com.oracle.truffle.espresso.nodes.interop.ToEspressoNode;
import com.oracle.truffle.espresso.nodes.interop.ToReference;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.EspressoFunction;
import com.oracle.truffle.espresso.runtime.InteropUtils;
import com.oracle.truffle.espresso.runtime.dispatch.messages.GenerateInteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.messages.Shareable;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;

@ExportLibrary(value=InteropLibrary.class, receiverType=StaticObject.class)
@GenerateInteropNodes
@Shareable
public class EspressoInterop
extends BaseInterop {
    static final Object[] EMPTY_ARGS = new Object[0];
    private static final String[] CLASS_KEYS = new String[]{"static", "class"};

    public static Meta getMeta() {
        return EspressoContext.get(null).getMeta();
    }

    @ExportMessage
    static boolean isBoolean(StaticObject receiver) {
        receiver.checkNotForeign();
        assert (!EspressoInterop.isNull(receiver)) : "Null espresso object should be dispatched to BaseInterop";
        return receiver.getKlass() == receiver.getKlass().getMeta().java_lang_Boolean;
    }

    @ExportMessage
    static boolean asBoolean(StaticObject receiver) throws UnsupportedMessageException {
        receiver.checkNotForeign();
        if (!EspressoInterop.isBoolean(receiver)) {
            throw UnsupportedMessageException.create();
        }
        return (Boolean)receiver.getKlass().getMeta().java_lang_Boolean_value.get(receiver);
    }

    @ExportMessage
    static boolean isNumber(StaticObject receiver) {
        receiver.checkNotForeign();
        if (EspressoInterop.isNull(receiver)) {
            return false;
        }
        Meta meta = receiver.getKlass().getMeta();
        return receiver.getKlass() == meta.java_lang_Byte || receiver.getKlass() == meta.java_lang_Short || receiver.getKlass() == meta.java_lang_Integer || receiver.getKlass() == meta.java_lang_Long || receiver.getKlass() == meta.java_lang_Float || receiver.getKlass() == meta.java_lang_Double;
    }

    @ExportMessage
    static boolean fitsInByte(StaticObject receiver) {
        receiver.checkNotForeign();
        if (EspressoInterop.isNull(receiver)) {
            return false;
        }
        Klass klass = receiver.getKlass();
        if (InteropUtils.isAtMostByte(klass)) {
            return true;
        }
        Meta meta = klass.getMeta();
        if (klass == meta.java_lang_Short) {
            short content = meta.java_lang_Short_value.getShort(receiver);
            return (byte)content == content;
        }
        if (klass == meta.java_lang_Integer) {
            int content = meta.java_lang_Integer_value.getInt(receiver);
            return (byte)content == content;
        }
        if (klass == meta.java_lang_Long) {
            long content = meta.java_lang_Long_value.getLong(receiver);
            return (long)((byte)content) == content;
        }
        if (klass == meta.java_lang_Float) {
            float content = meta.java_lang_Float_value.getFloat(receiver);
            return (float)((byte)content) == content && !InteropUtils.isNegativeZero(content);
        }
        if (klass == meta.java_lang_Double) {
            double content = meta.java_lang_Double_value.getDouble(receiver);
            return (double)((byte)content) == content && !InteropUtils.isNegativeZero(content);
        }
        return false;
    }

    @ExportMessage
    static boolean fitsInShort(StaticObject receiver) {
        receiver.checkNotForeign();
        if (EspressoInterop.isNull(receiver)) {
            return false;
        }
        Klass klass = receiver.getKlass();
        if (InteropUtils.isAtMostShort(klass)) {
            return true;
        }
        Meta meta = klass.getMeta();
        if (klass == meta.java_lang_Integer) {
            int content = meta.java_lang_Integer_value.getInt(receiver);
            return (short)content == content;
        }
        if (klass == meta.java_lang_Long) {
            long content = meta.java_lang_Long_value.getLong(receiver);
            return (long)((short)content) == content;
        }
        if (klass == meta.java_lang_Float) {
            float content = meta.java_lang_Float_value.getFloat(receiver);
            return (float)((short)content) == content && !InteropUtils.isNegativeZero(content);
        }
        if (klass == meta.java_lang_Double) {
            double content = meta.java_lang_Double_value.getDouble(receiver);
            return (double)((short)content) == content && !InteropUtils.isNegativeZero(content);
        }
        return false;
    }

    @ExportMessage
    static boolean fitsInInt(StaticObject receiver) {
        receiver.checkNotForeign();
        if (EspressoInterop.isNull(receiver)) {
            return false;
        }
        Klass klass = receiver.getKlass();
        if (InteropUtils.isAtMostInt(klass)) {
            return true;
        }
        Meta meta = klass.getMeta();
        if (klass == meta.java_lang_Long) {
            long content = meta.java_lang_Long_value.getLong(receiver);
            return (long)((int)content) == content;
        }
        if (klass == meta.java_lang_Float) {
            float content = meta.java_lang_Float_value.getFloat(receiver);
            return !InteropUtils.isNegativeZero(content) && (float)((int)content) == content && (int)content != Integer.MAX_VALUE;
        }
        if (klass == meta.java_lang_Double) {
            double content = meta.java_lang_Double_value.getDouble(receiver);
            return (double)((int)content) == content && !InteropUtils.isNegativeZero(content);
        }
        return false;
    }

    @ExportMessage
    static boolean fitsInLong(StaticObject receiver) {
        receiver.checkNotForeign();
        if (EspressoInterop.isNull(receiver)) {
            return false;
        }
        Klass klass = receiver.getKlass();
        if (InteropUtils.isAtMostLong(klass)) {
            return true;
        }
        Meta meta = klass.getMeta();
        if (klass == meta.java_lang_Float) {
            float content = meta.java_lang_Float_value.getFloat(receiver);
            return !InteropUtils.isNegativeZero(content) && (float)((long)content) == content && (long)content != Long.MAX_VALUE;
        }
        if (klass == meta.java_lang_Double) {
            double content = meta.java_lang_Double_value.getDouble(receiver);
            return !InteropUtils.isNegativeZero(content) && (double)((long)content) == content && (long)content != Long.MAX_VALUE;
        }
        return false;
    }

    @ExportMessage
    static boolean fitsInFloat(StaticObject receiver) {
        receiver.checkNotForeign();
        if (EspressoInterop.isNull(receiver)) {
            return false;
        }
        Klass klass = receiver.getKlass();
        if (InteropUtils.isAtMostFloat(klass)) {
            return true;
        }
        Meta meta = klass.getMeta();
        if (klass == meta.java_lang_Integer) {
            int content = meta.java_lang_Integer_value.getInt(receiver);
            float floatContent = content;
            return content != Integer.MAX_VALUE && (int)floatContent == content;
        }
        if (klass == meta.java_lang_Long) {
            long content = meta.java_lang_Long_value.getLong(receiver);
            float floatContent = content;
            return content != Long.MAX_VALUE && (long)floatContent == content;
        }
        if (klass == meta.java_lang_Double) {
            double content = meta.java_lang_Double_value.getDouble(receiver);
            return !Double.isFinite(content) || (double)((float)content) == content;
        }
        return false;
    }

    @ExportMessage
    static boolean fitsInDouble(StaticObject receiver) {
        receiver.checkNotForeign();
        if (EspressoInterop.isNull(receiver)) {
            return false;
        }
        Klass klass = receiver.getKlass();
        Meta meta = klass.getMeta();
        if (InteropUtils.isAtMostInt(klass) || klass == meta.java_lang_Double) {
            return true;
        }
        if (klass == meta.java_lang_Long) {
            long content = meta.java_lang_Long_value.getLong(receiver);
            double doubleContent = content;
            return content != Long.MAX_VALUE && (long)doubleContent == content;
        }
        if (klass == meta.java_lang_Float) {
            float content = meta.java_lang_Float_value.getFloat(receiver);
            return !Float.isFinite(content) || (double)content == (double)content;
        }
        return false;
    }

    private static Number readNumberValue(StaticObject receiver) throws UnsupportedMessageException {
        assert (receiver.isEspressoObject());
        Klass klass = receiver.getKlass();
        Meta meta = klass.getMeta();
        if (klass == meta.java_lang_Byte) {
            return (Byte)meta.java_lang_Byte_value.get(receiver);
        }
        if (klass == meta.java_lang_Short) {
            return (Short)meta.java_lang_Short_value.get(receiver);
        }
        if (klass == meta.java_lang_Integer) {
            return (Integer)meta.java_lang_Integer_value.get(receiver);
        }
        if (klass == meta.java_lang_Long) {
            return (Long)meta.java_lang_Long_value.get(receiver);
        }
        if (klass == meta.java_lang_Float) {
            return (Float)meta.java_lang_Float_value.get(receiver);
        }
        if (klass == meta.java_lang_Double) {
            return (Double)meta.java_lang_Double_value.get(receiver);
        }
        CompilerDirectives.transferToInterpreter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static byte asByte(StaticObject receiver) throws UnsupportedMessageException {
        receiver.checkNotForeign();
        if (!EspressoInterop.fitsInByte(receiver)) {
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedMessageException.create();
        }
        return EspressoInterop.readNumberValue(receiver).byteValue();
    }

    @ExportMessage
    static short asShort(StaticObject receiver) throws UnsupportedMessageException {
        receiver.checkNotForeign();
        if (!EspressoInterop.fitsInShort(receiver)) {
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedMessageException.create();
        }
        return EspressoInterop.readNumberValue(receiver).shortValue();
    }

    @ExportMessage
    static int asInt(StaticObject receiver) throws UnsupportedMessageException {
        receiver.checkNotForeign();
        if (!EspressoInterop.fitsInInt(receiver)) {
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedMessageException.create();
        }
        return EspressoInterop.readNumberValue(receiver).intValue();
    }

    @ExportMessage
    static long asLong(StaticObject receiver) throws UnsupportedMessageException {
        receiver.checkNotForeign();
        if (!EspressoInterop.fitsInLong(receiver)) {
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedMessageException.create();
        }
        return EspressoInterop.readNumberValue(receiver).longValue();
    }

    @ExportMessage
    static float asFloat(StaticObject receiver) throws UnsupportedMessageException {
        receiver.checkNotForeign();
        if (!EspressoInterop.fitsInFloat(receiver)) {
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedMessageException.create();
        }
        return EspressoInterop.readNumberValue(receiver).floatValue();
    }

    @ExportMessage
    static double asDouble(StaticObject receiver) throws UnsupportedMessageException {
        receiver.checkNotForeign();
        if (!EspressoInterop.fitsInDouble(receiver)) {
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedMessageException.create();
        }
        return EspressoInterop.readNumberValue(receiver).doubleValue();
    }

    @ExportMessage
    static long getArraySize(StaticObject receiver, @CachedLibrary(value="receiver") InteropLibrary receiverLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        receiver.checkNotForeign();
        if (!receiver.isArray()) {
            error.enter();
            throw UnsupportedMessageException.create();
        }
        return receiver.length(EspressoLanguage.get((Node)receiverLib));
    }

    @ExportMessage
    static boolean hasArrayElements(StaticObject receiver) {
        if (receiver.isForeignObject()) {
            return false;
        }
        return receiver.isArray();
    }

    @ExportMessage
    @Shareable(value=false)
    static Object readArrayElement(StaticObject receiver, long index, @Cached Nodes.ReadArrayElementImplNode readArrayElementNode) throws UnsupportedMessageException, InvalidArrayIndexException {
        return readArrayElementNode.execute(receiver, index);
    }

    @ExportMessage
    @Shareable(value=false)
    static void writeArrayElement(StaticObject receiver, long index, Object value, @Cached Nodes.WriteArrayElementImplNode writeArrayElementNode) throws UnsupportedMessageException, InvalidArrayIndexException, UnsupportedTypeException {
        writeArrayElementNode.execute(receiver, index, value);
    }

    public static boolean isBooleanArray(StaticObject object) {
        return !EspressoInterop.isNull(object) && object.getKlass().equals(object.getKlass().getMeta()._boolean_array);
    }

    public static boolean isCharArray(StaticObject object) {
        return !EspressoInterop.isNull(object) && object.getKlass().equals(object.getKlass().getMeta()._char_array);
    }

    public static boolean isByteArray(StaticObject object) {
        return !EspressoInterop.isNull(object) && object.getKlass().equals(object.getKlass().getMeta()._byte_array);
    }

    public static boolean isShortArray(StaticObject object) {
        return !EspressoInterop.isNull(object) && object.getKlass().equals(object.getKlass().getMeta()._short_array);
    }

    public static boolean isIntArray(StaticObject object) {
        return !EspressoInterop.isNull(object) && object.getKlass().equals(object.getKlass().getMeta()._int_array);
    }

    public static boolean isLongArray(StaticObject object) {
        return !EspressoInterop.isNull(object) && object.getKlass().equals(object.getKlass().getMeta()._long_array);
    }

    public static boolean isFloatArray(StaticObject object) {
        return !EspressoInterop.isNull(object) && object.getKlass().equals(object.getKlass().getMeta()._float_array);
    }

    public static boolean isDoubleArray(StaticObject object) {
        return !EspressoInterop.isNull(object) && object.getKlass().equals(object.getKlass().getMeta()._double_array);
    }

    public static boolean isStringArray(StaticObject object) {
        return !EspressoInterop.isNull(object) && object.getKlass().equals(object.getKlass().getMeta().java_lang_String.array());
    }

    public static boolean isPrimitiveArray(StaticObject object) {
        return EspressoInterop.isBooleanArray(object) || EspressoInterop.isCharArray(object) || EspressoInterop.isByteArray(object) || EspressoInterop.isShortArray(object) || EspressoInterop.isIntArray(object) || EspressoInterop.isLongArray(object) || EspressoInterop.isFloatArray(object) || EspressoInterop.isDoubleArray(object);
    }

    public static boolean isStaticObject(Object object) {
        return object instanceof StaticObject;
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isArrayElementModifiable"), @ExportMessage})
    static boolean isArrayElementReadable(StaticObject receiver, long index, @CachedLibrary(value="receiver") InteropLibrary receiverLib) {
        receiver.checkNotForeign();
        return receiver.isArray() && 0L <= index && index < (long)receiver.length(EspressoLanguage.get((Node)receiverLib));
    }

    @ExportMessage
    static boolean isArrayElementInsertable(StaticObject receiver, long index) {
        return false;
    }

    @ExportMessage
    @Shareable(value=false)
    static Object readMember(StaticObject receiver, String member, @Cached @Cached.Exclusive LookupInstanceFieldNode lookupField, @Cached @Cached.Exclusive LookupVirtualMethodNode lookupMethod) throws UnknownIdentifierException {
        receiver.checkNotForeign();
        if (StaticObject.notNull(receiver)) {
            Field f = lookupField.execute(EspressoInterop.getInteropKlass(receiver), member);
            if (f != null) {
                return InteropUtils.unwrap(EspressoLanguage.get(lookupField), f.get(receiver), receiver.getKlass().getMeta());
            }
            try {
                Method[] candidates = lookupMethod.execute(EspressoInterop.getInteropKlass(receiver), member, -1);
                if (candidates != null && candidates.length == 1) {
                    return EspressoFunction.createInstanceInvocable(candidates[0], receiver);
                }
            }
            catch (ArityException arityException) {
                // empty catch block
            }
            if ("static".equals(member) && receiver.getKlass() == receiver.getKlass().getMeta().java_lang_Class) {
                return receiver.getMirrorKlass();
            }
            if ("class".equals(member) && receiver.getKlass() == receiver.getKlass().getMeta().java_lang_Class) {
                return receiver;
            }
        }
        throw UnknownIdentifierException.create((String)member);
    }

    @ExportMessage
    static boolean hasMembers(StaticObject receiver) {
        if (receiver.isForeignObject()) {
            return false;
        }
        return StaticObject.notNull(receiver);
    }

    @ExportMessage
    @Shareable(value=false)
    static boolean isMemberReadable(StaticObject receiver, String member, @Cached @Cached.Exclusive LookupInstanceFieldNode lookupField, @Cached @Cached.Exclusive LookupVirtualMethodNode lookupMethod) {
        receiver.checkNotForeign();
        Field f = lookupField.execute(EspressoInterop.getInteropKlass(receiver), member);
        if (f != null) {
            return true;
        }
        if (lookupMethod.isInvocable(EspressoInterop.getInteropKlass(receiver), member)) {
            return true;
        }
        return StaticObject.notNull(receiver) && receiver.getKlass() == receiver.getKlass().getMeta().java_lang_Class && ("static".equals(member) || "class".equals(member));
    }

    @ExportMessage
    @Shareable(value=false)
    static boolean isMemberModifiable(StaticObject receiver, String member, @Cached @Cached.Exclusive LookupInstanceFieldNode lookup) {
        receiver.checkNotForeign();
        Field f = lookup.execute(EspressoInterop.getInteropKlass(receiver), member);
        if (f != null) {
            return !f.isFinalFlagSet();
        }
        return false;
    }

    @ExportMessage
    @Shareable(value=false)
    static void writeMember(StaticObject receiver, String member, Object value, @Cached @Cached.Exclusive LookupInstanceFieldNode lookup, @Cached @Cached.Exclusive ToEspressoNode.DynamicToEspresso toEspresso, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedTypeException, UnknownIdentifierException, UnsupportedMessageException {
        receiver.checkNotForeign();
        Field f = lookup.execute(EspressoInterop.getInteropKlass(receiver), member);
        if (f != null) {
            if (f.isFinalFlagSet()) {
                error.enter();
                throw UnsupportedMessageException.create();
            }
            f.set(receiver, toEspresso.execute(value, f.resolveTypeKlass()));
            return;
        }
        error.enter();
        throw UnknownIdentifierException.create((String)member);
    }

    @ExportMessage
    static boolean isMemberInsertable(StaticObject receiver, String member) {
        return false;
    }

    public static ObjectKlass getInteropKlass(StaticObject receiver) {
        if (receiver.getKlass().isArray()) {
            return receiver.getKlass().getMeta().java_lang_Object;
        }
        assert (!receiver.getKlass().isPrimitive()) : "Static Object should not represent a primitive.";
        return (ObjectKlass)receiver.getKlass();
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    static Object getMembers(StaticObject receiver, boolean includeInternal) {
        receiver.checkNotForeign();
        if (EspressoInterop.isNull(receiver)) {
            return EmptyKeysArray.INSTANCE;
        }
        ArrayList<String> members = new ArrayList<String>();
        if (receiver.getKlass() == receiver.getKlass().getMeta().java_lang_Class) {
            for (String s : CLASS_KEYS) {
                members.add(s);
            }
        }
        ObjectKlass k = EspressoInterop.getInteropKlass(receiver);
        for (Field field : k.getFieldTable()) {
            if (!field.isPublic() || field.isRemoved()) continue;
            members.add(field.getNameAsString());
        }
        for (ModifiersProvider modifiersProvider : k.getVTable()) {
            if (!LookupVirtualMethodNode.isCandidate(((Method.MethodVersion)modifiersProvider).getMethod())) continue;
            members.add(((Method.MethodVersion)modifiersProvider).getMethod().getInteropString());
        }
        String[] array = new String[members.size()];
        int pos = 0;
        for (String string : members) {
            array[pos++] = string;
        }
        return new KeysArray<String>(array);
    }

    @ExportMessage
    @Shareable(value=false)
    static boolean isMemberInvocable(StaticObject receiver, String member, @Cached.Exclusive @Cached LookupVirtualMethodNode lookupMethod) {
        receiver.checkNotForeign();
        if (EspressoInterop.isNull(receiver)) {
            return false;
        }
        ObjectKlass k = EspressoInterop.getInteropKlass(receiver);
        return lookupMethod.isInvocable(k, member);
    }

    @ExportMessage
    @Shareable(value=false)
    static Object invokeMember(StaticObject receiver, String member, Object[] arguments, @Cached.Exclusive @Cached LookupVirtualMethodNode lookupMethod, @Cached.Exclusive @Cached OverLoadedMethodSelectorNode selectorNode, @Cached.Exclusive @Cached InvokeEspressoNode invoke, @Cached.Exclusive @Cached ToEspressoNode.DynamicToEspresso toEspressoNode) throws ArityException, UnknownIdentifierException, UnsupportedTypeException {
        Method[] candidates = lookupMethod.execute(receiver.getKlass(), member, arguments.length);
        try {
            if (candidates != null) {
                if (candidates.length == 1) {
                    Method m = candidates[0];
                    assert (!m.isStatic() && m.isPublic());
                    assert (member.startsWith(m.getNameAsString()));
                    if (!m.isVarargs()) {
                        assert (m.getParameterCount() == arguments.length);
                        return invoke.execute(m, receiver, arguments);
                    }
                    CandidateMethodWithArgs matched = MethodArgsUtils.matchCandidate(m, arguments, m.resolveParameterKlasses(), toEspressoNode);
                    if (matched != null && (matched = MethodArgsUtils.ensureVarArgsArrayCreated(matched, toEspressoNode)) != null) {
                        return invoke.execute(matched.getMethod(), receiver, matched.getConvertedArgs(), true);
                    }
                } else {
                    CandidateMethodWithArgs typeMatched = selectorNode.execute(candidates, arguments);
                    if (typeMatched != null) {
                        return invoke.execute(typeMatched.getMethod(), receiver, typeMatched.getConvertedArgs(), true);
                    }
                    throw UnknownIdentifierException.create((String)member);
                }
            }
            throw UnknownIdentifierException.create((String)member);
        }
        catch (EspressoException e) {
            Meta meta = e.getGuestException().getKlass().getMeta();
            if (meta.polyglot != null && e.getGuestException().getKlass() == meta.polyglot.ForeignException) {
                EspressoLanguage language = receiver.getKlass().getContext().getLanguage();
                throw (AbstractTruffleException)((Object)meta.java_lang_Throwable_backtrace.getObject(e.getGuestException()).rawForeignObject(language));
            }
            throw e;
        }
    }

    @ExportMessage
    static boolean isDate(StaticObject receiver) {
        receiver.checkNotForeign();
        if (EspressoInterop.isNull(receiver)) {
            return false;
        }
        Meta meta = receiver.getKlass().getMeta();
        return InterpreterToVM.instanceOf(receiver, meta.java_time_LocalDate) || InterpreterToVM.instanceOf(receiver, meta.java_time_LocalDateTime) || InterpreterToVM.instanceOf(receiver, meta.java_time_Instant) || InterpreterToVM.instanceOf(receiver, meta.java_time_ZonedDateTime) || InterpreterToVM.instanceOf(receiver, meta.java_util_Date);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    static LocalDate asDate(StaticObject receiver, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        receiver.checkNotForeign();
        if (EspressoInterop.isDate(receiver)) {
            Meta meta = receiver.getKlass().getMeta();
            if (InterpreterToVM.instanceOf(receiver, meta.java_time_LocalDate)) {
                int year = (Integer)meta.java_time_LocalDate_year.get(receiver);
                short month = (Short)meta.java_time_LocalDate_month.get(receiver);
                short day = (Short)meta.java_time_LocalDate_day.get(receiver);
                return LocalDate.of(year, month, (int)day);
            }
            if (InterpreterToVM.instanceOf(receiver, meta.java_time_LocalDateTime)) {
                StaticObject localDate = (StaticObject)meta.java_time_LocalDateTime_toLocalDate.invokeDirect(receiver, new Object[0]);
                assert (InterpreterToVM.instanceOf(localDate, meta.java_time_LocalDate));
                return EspressoInterop.asDate(localDate, error);
            }
            if (InterpreterToVM.instanceOf(receiver, meta.java_time_Instant)) {
                StaticObject zoneIdUTC = (StaticObject)meta.java_time_ZoneId_of.invokeDirect(null, meta.toGuestString("UTC"));
                assert (InterpreterToVM.instanceOf(zoneIdUTC, meta.java_time_ZoneId));
                StaticObject zonedDateTime = (StaticObject)meta.java_time_Instant_atZone.invokeDirect(receiver, zoneIdUTC);
                assert (InterpreterToVM.instanceOf(zonedDateTime, meta.java_time_ZonedDateTime));
                StaticObject localDate = (StaticObject)meta.java_time_ZonedDateTime_toLocalDate.invokeDirect(zonedDateTime, new Object[0]);
                assert (InterpreterToVM.instanceOf(localDate, meta.java_time_LocalDate));
                return EspressoInterop.asDate(localDate, error);
            }
            if (InterpreterToVM.instanceOf(receiver, meta.java_time_ZonedDateTime)) {
                StaticObject localDate = (StaticObject)meta.java_time_ZonedDateTime_toLocalDate.invokeDirect(receiver, new Object[0]);
                assert (InterpreterToVM.instanceOf(localDate, meta.java_time_LocalDate));
                return EspressoInterop.asDate(localDate, error);
            }
            if (InterpreterToVM.instanceOf(receiver, meta.java_util_Date)) {
                int index = meta.java_util_Date_toInstant.getVTableIndex();
                Method virtualToInstant = receiver.getKlass().vtableLookup(index);
                StaticObject instant = (StaticObject)virtualToInstant.invokeDirect(receiver, new Object[0]);
                return EspressoInterop.asDate(instant, error);
            }
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean isTime(StaticObject receiver) {
        receiver.checkNotForeign();
        if (EspressoInterop.isNull(receiver)) {
            return false;
        }
        Meta meta = receiver.getKlass().getMeta();
        return InterpreterToVM.instanceOf(receiver, meta.java_time_LocalTime) || InterpreterToVM.instanceOf(receiver, meta.java_time_Instant) || InterpreterToVM.instanceOf(receiver, meta.java_time_ZonedDateTime) || InterpreterToVM.instanceOf(receiver, meta.java_util_Date);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    static LocalTime asTime(StaticObject receiver, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        receiver.checkNotForeign();
        if (EspressoInterop.isTime(receiver)) {
            Meta meta = receiver.getKlass().getMeta();
            if (InterpreterToVM.instanceOf(receiver, meta.java_time_LocalTime)) {
                byte hour = (Byte)meta.java_time_LocalTime_hour.get(receiver);
                byte minute = (Byte)meta.java_time_LocalTime_minute.get(receiver);
                byte second = (Byte)meta.java_time_LocalTime_second.get(receiver);
                int nano = (Integer)meta.java_time_LocalTime_nano.get(receiver);
                return LocalTime.of(hour, minute, second, nano);
            }
            if (InterpreterToVM.instanceOf(receiver, meta.java_time_LocalDateTime)) {
                StaticObject localTime = (StaticObject)meta.java_time_LocalDateTime_toLocalTime.invokeDirect(receiver, new Object[0]);
                return EspressoInterop.asTime(localTime, error);
            }
            if (InterpreterToVM.instanceOf(receiver, meta.java_time_ZonedDateTime)) {
                StaticObject localTime = (StaticObject)meta.java_time_ZonedDateTime_toLocalTime.invokeDirect(receiver, new Object[0]);
                return EspressoInterop.asTime(localTime, error);
            }
            if (InterpreterToVM.instanceOf(receiver, meta.java_time_Instant)) {
                StaticObject zoneIdUTC = (StaticObject)meta.java_time_ZoneId_of.invokeDirect(null, meta.toGuestString("UTC"));
                assert (InterpreterToVM.instanceOf(zoneIdUTC, meta.java_time_ZoneId));
                StaticObject zonedDateTime = (StaticObject)meta.java_time_Instant_atZone.invokeDirect(receiver, zoneIdUTC);
                assert (InterpreterToVM.instanceOf(zonedDateTime, meta.java_time_ZonedDateTime));
                StaticObject localTime = (StaticObject)meta.java_time_ZonedDateTime_toLocalTime.invokeDirect(zonedDateTime, new Object[0]);
                assert (InterpreterToVM.instanceOf(localTime, meta.java_time_LocalTime));
                return EspressoInterop.asTime(localTime, error);
            }
            if (InterpreterToVM.instanceOf(receiver, meta.java_util_Date)) {
                int index = meta.java_util_Date_toInstant.getVTableIndex();
                Method virtualToInstant = receiver.getKlass().vtableLookup(index);
                StaticObject instant = (StaticObject)virtualToInstant.invokeDirect(receiver, new Object[0]);
                return EspressoInterop.asTime(instant, error);
            }
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean isTimeZone(StaticObject receiver) {
        receiver.checkNotForeign();
        if (EspressoInterop.isNull(receiver)) {
            return false;
        }
        Meta meta = receiver.getKlass().getMeta();
        return InterpreterToVM.instanceOf(receiver, meta.java_time_ZoneId) || InterpreterToVM.instanceOf(receiver, meta.java_time_Instant) || InterpreterToVM.instanceOf(receiver, meta.java_time_ZonedDateTime) || InterpreterToVM.instanceOf(receiver, meta.java_util_Date);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    static ZoneId asTimeZone(StaticObject receiver, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        receiver.checkNotForeign();
        if (EspressoInterop.isTimeZone(receiver)) {
            Meta meta = receiver.getKlass().getMeta();
            if (InterpreterToVM.instanceOf(receiver, meta.java_time_ZoneId)) {
                int index = meta.java_time_ZoneId_getId.getVTableIndex();
                StaticObject zoneIdEspresso = (StaticObject)receiver.getKlass().vtableLookup(index).invokeDirect(receiver, new Object[0]);
                String zoneId = Meta.toHostStringStatic(zoneIdEspresso);
                return ZoneId.of(zoneId, ZoneId.SHORT_IDS);
            }
            if (InterpreterToVM.instanceOf(receiver, meta.java_time_ZonedDateTime)) {
                StaticObject zoneId = (StaticObject)meta.java_time_ZonedDateTime_getZone.invokeDirect(receiver, new Object[0]);
                return EspressoInterop.asTimeZone(zoneId, error);
            }
            if (InterpreterToVM.instanceOf(receiver, meta.java_time_Instant) || InterpreterToVM.instanceOf(receiver, meta.java_util_Date)) {
                return ZoneId.of("UTC");
            }
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    static Instant asInstant(StaticObject receiver, @CachedLibrary(value="receiver") InteropLibrary receiverLibrary, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        receiver.checkNotForeign();
        if (receiverLibrary.isInstant((Object)receiver)) {
            StaticObject instant;
            Meta meta = receiver.getKlass().getMeta();
            if (InterpreterToVM.instanceOf(receiver, meta.java_time_ZonedDateTime)) {
                instant = (StaticObject)meta.java_time_ZonedDateTime_toInstant.invokeDirect(receiver, new Object[0]);
            } else if (InterpreterToVM.instanceOf(receiver, meta.java_util_Date)) {
                int index = meta.java_util_Date_toInstant.getVTableIndex();
                Method virtualToInstant = receiver.getKlass().vtableLookup(index);
                instant = (StaticObject)virtualToInstant.invokeDirect(receiver, new Object[0]);
            } else {
                instant = receiver;
            }
            assert (InterpreterToVM.instanceOf(instant, meta.java_time_Instant));
            long seconds = (Long)meta.java_time_Instant_seconds.get(instant);
            int nanos = (Integer)meta.java_time_Instant_nanos.get(instant);
            return Instant.ofEpochSecond(seconds, nanos);
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean isDuration(StaticObject receiver) {
        receiver.checkNotForeign();
        if (EspressoInterop.isNull(receiver)) {
            return false;
        }
        Meta meta = receiver.getKlass().getMeta();
        return InterpreterToVM.instanceOf(receiver, meta.java_time_Duration);
    }

    @ExportMessage
    static Duration asDuration(StaticObject receiver, @Cached.Shared(value="error") @Cached BranchProfile error) throws UnsupportedMessageException {
        receiver.checkNotForeign();
        if (EspressoInterop.isDuration(receiver)) {
            Meta meta = receiver.getKlass().getMeta();
            long seconds = (Long)meta.java_time_Duration_seconds.get(receiver);
            int nanos = (Integer)meta.java_time_Duration_nanos.get(receiver);
            return Duration.ofSeconds(seconds, nanos);
        }
        error.enter();
        throw UnsupportedMessageException.create();
    }

    public static class Nodes {

        @GenerateUncached
        @ImportStatic(value={EspressoInterop.class})
        static abstract class WriteArrayElementImplNode
        extends Node {
            WriteArrayElementImplNode() {
            }

            public abstract void execute(StaticObject var1, long var2, Object var4) throws InvalidArrayIndexException, UnsupportedMessageException, UnsupportedTypeException;

            @Specialization(guards={"isBooleanArray(receiver)", "receiver.isEspressoObject()"})
            static void doBoolean(StaticObject receiver, long index, Object value, @CachedLibrary(limit="1") InteropLibrary receiverLib, @CachedLibrary(limit="3") InteropLibrary valueLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException, UnsupportedTypeException {
                boolean boolValue;
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                try {
                    boolValue = valueLib.asBoolean(value);
                }
                catch (UnsupportedMessageException e) {
                    error.enter();
                    throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)WriteArrayElementImplNode.getMessageBoundary(e));
                }
                ((byte[])receiver.unwrap((EspressoLanguage)language))[(int)index] = boolValue ? (byte)1 : 0;
            }

            @Specialization(guards={"isCharArray(receiver)", "receiver.isEspressoObject()"})
            static void doChar(StaticObject receiver, long index, Object value, @CachedLibrary(limit="1") InteropLibrary receiverLib, @CachedLibrary(limit="3") InteropLibrary valueLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException, UnsupportedTypeException {
                char charValue;
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                try {
                    String s = valueLib.asString(value);
                    if (s.length() != 1) {
                        error.enter();
                        String message = EspressoError.format("Expected a string of length 1 as an element of char array, got %s", s);
                        throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)message);
                    }
                    charValue = s.charAt(0);
                }
                catch (UnsupportedMessageException e) {
                    error.enter();
                    throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)WriteArrayElementImplNode.getMessageBoundary(e));
                }
                ((char[])receiver.unwrap((EspressoLanguage)language))[(int)index] = charValue;
            }

            @Specialization(guards={"isByteArray(receiver)", "receiver.isEspressoObject()"})
            static void doByte(StaticObject receiver, long index, Object value, @CachedLibrary(limit="1") InteropLibrary receiverLib, @CachedLibrary(limit="3") InteropLibrary valueLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException, UnsupportedTypeException {
                byte byteValue;
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                try {
                    byteValue = valueLib.asByte(value);
                }
                catch (UnsupportedMessageException e) {
                    error.enter();
                    throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)WriteArrayElementImplNode.getMessageBoundary(e));
                }
                ((byte[])receiver.unwrap((EspressoLanguage)language))[(int)index] = byteValue;
            }

            @Specialization(guards={"isShortArray(receiver)", "receiver.isEspressoObject()"})
            static void doShort(StaticObject receiver, long index, Object value, @CachedLibrary(limit="1") InteropLibrary receiverLib, @CachedLibrary(limit="3") InteropLibrary valueLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException, UnsupportedTypeException {
                short shortValue;
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                try {
                    shortValue = valueLib.asShort(value);
                }
                catch (UnsupportedMessageException e) {
                    error.enter();
                    throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)WriteArrayElementImplNode.getMessageBoundary(e));
                }
                ((short[])receiver.unwrap((EspressoLanguage)language))[(int)index] = shortValue;
            }

            @Specialization(guards={"isIntArray(receiver)", "receiver.isEspressoObject()"})
            static void doInt(StaticObject receiver, long index, Object value, @CachedLibrary(limit="1") InteropLibrary receiverLib, @CachedLibrary(limit="3") InteropLibrary valueLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException, UnsupportedTypeException {
                int intValue;
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                try {
                    intValue = valueLib.asInt(value);
                }
                catch (UnsupportedMessageException e) {
                    error.enter();
                    throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)WriteArrayElementImplNode.getMessageBoundary(e));
                }
                ((int[])receiver.unwrap((EspressoLanguage)language))[(int)index] = intValue;
            }

            @Specialization(guards={"isLongArray(receiver)", "receiver.isEspressoObject()"})
            static void doLong(StaticObject receiver, long index, Object value, @CachedLibrary(limit="1") InteropLibrary receiverLib, @CachedLibrary(limit="3") InteropLibrary valueLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException, UnsupportedTypeException {
                long longValue;
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                try {
                    longValue = valueLib.asLong(value);
                }
                catch (UnsupportedMessageException e) {
                    error.enter();
                    throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)WriteArrayElementImplNode.getMessageBoundary(e));
                }
                ((long[])receiver.unwrap((EspressoLanguage)language))[(int)index] = longValue;
            }

            @Specialization(guards={"isFloatArray(receiver)", "receiver.isEspressoObject()"})
            static void doFloat(StaticObject receiver, long index, Object value, @CachedLibrary(limit="1") InteropLibrary receiverLib, @CachedLibrary(limit="3") InteropLibrary valueLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException, UnsupportedTypeException {
                float floatValue;
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                try {
                    floatValue = valueLib.asFloat(value);
                }
                catch (UnsupportedMessageException e) {
                    error.enter();
                    throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)WriteArrayElementImplNode.getMessageBoundary(e));
                }
                ((float[])receiver.unwrap((EspressoLanguage)language))[(int)index] = floatValue;
            }

            @Specialization(guards={"isDoubleArray(receiver)", "receiver.isEspressoObject()"})
            static void doDouble(StaticObject receiver, long index, Object value, @CachedLibrary(limit="1") InteropLibrary receiverLib, @CachedLibrary(limit="3") InteropLibrary valueLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException, UnsupportedTypeException {
                double doubleValue;
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                try {
                    doubleValue = valueLib.asDouble(value);
                }
                catch (UnsupportedMessageException e) {
                    error.enter();
                    throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)WriteArrayElementImplNode.getMessageBoundary(e));
                }
                ((double[])receiver.unwrap((EspressoLanguage)language))[(int)index] = doubleValue;
            }

            @Specialization(guards={"isStringArray(receiver)", "receiver.isEspressoObject()"})
            static void doString(StaticObject receiver, long index, Object value, @CachedLibrary(limit="1") InteropLibrary receiverLib, @CachedLibrary(limit="3") InteropLibrary valueLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException, UnsupportedTypeException {
                StaticObject stringValue;
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                try {
                    stringValue = receiver.getKlass().getMeta().toGuestString(valueLib.asString(value));
                }
                catch (UnsupportedMessageException e) {
                    error.enter();
                    throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)WriteArrayElementImplNode.getMessageBoundary(e));
                }
                ((StaticObject[])receiver.unwrap((EspressoLanguage)language))[(int)index] = stringValue;
            }

            @Specialization(guards={"receiver.isArray()", "!isStringArray(receiver)", "receiver.isEspressoObject()", "!isPrimitiveArray(receiver)"})
            static void doEspressoObject(StaticObject receiver, long index, StaticObject value, @CachedLibrary(limit="1") InteropLibrary receiverLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException, UnsupportedTypeException {
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                Klass componentType = ((ArrayKlass)receiver.getKlass()).getComponentType();
                if (!StaticObject.isNull(value) && !InterpreterToVM.instanceOf(value, componentType)) {
                    error.enter();
                    throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)"Incompatible types");
                }
                ((StaticObject[])receiver.unwrap((EspressoLanguage)language))[(int)index] = value;
            }

            @CompilerDirectives.TruffleBoundary
            private static String getMessageBoundary(Throwable e) {
                return e.getMessage();
            }

            @Specialization(guards={"receiver.isArray()", "!isStringArray(receiver)", "receiver.isEspressoObject()", "!isPrimitiveArray(receiver)", "!isStaticObject(value)"})
            static void doEspressoGeneric(StaticObject receiver, long index, Object value, @CachedLibrary(limit="1") InteropLibrary receiverLib, @Cached ToReference.DynamicToReference toEspressoNode, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException, UnsupportedTypeException {
                StaticObject espressoValue;
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                try {
                    Klass componentType = ((ArrayKlass)receiver.getKlass()).getComponentType();
                    espressoValue = toEspressoNode.execute(value, componentType);
                }
                catch (UnsupportedOperationException e) {
                    error.enter();
                    throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)WriteArrayElementImplNode.getMessageBoundary(e));
                }
                ((StaticObject[])receiver.unwrap((EspressoLanguage)language))[(int)index] = espressoValue;
            }

            @Specialization(guards={"invalidReceiver(receiver)"})
            static void doOther(StaticObject receiver, long index, Object value) throws UnsupportedMessageException {
                throw UnsupportedMessageException.create();
            }

            public static boolean invalidReceiver(StaticObject receiver) {
                return !receiver.isArray() || !receiver.isEspressoObject();
            }
        }

        @GenerateUncached
        @ImportStatic(value={EspressoInterop.class})
        static abstract class ReadArrayElementImplNode
        extends Node {
            ReadArrayElementImplNode() {
            }

            public abstract Object execute(StaticObject var1, long var2) throws InvalidArrayIndexException, UnsupportedMessageException;

            @Specialization(guards={"isBooleanArray(receiver)", "receiver.isEspressoObject()"})
            static boolean doBoolean(StaticObject receiver, long index, @CachedLibrary(limit="1") InteropLibrary receiverLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException {
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                return ((byte[])receiver.unwrap(language))[(int)index] != 0;
            }

            @Specialization(guards={"isCharArray(receiver)", "receiver.isEspressoObject()"})
            static char doChar(StaticObject receiver, long index, @CachedLibrary(limit="1") InteropLibrary receiverLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException {
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                return ((char[])receiver.unwrap(language))[(int)index];
            }

            @Specialization(guards={"isByteArray(receiver)", "receiver.isEspressoObject()"})
            static byte doByte(StaticObject receiver, long index, @CachedLibrary(limit="1") InteropLibrary receiverLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException {
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                return ((byte[])receiver.unwrap(language))[(int)index];
            }

            @Specialization(guards={"isShortArray(receiver)", "receiver.isEspressoObject()"})
            static short doShort(StaticObject receiver, long index, @CachedLibrary(limit="1") InteropLibrary receiverLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException {
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                return ((short[])receiver.unwrap(language))[(int)index];
            }

            @Specialization(guards={"isIntArray(receiver)", "receiver.isEspressoObject()"})
            static int doInt(StaticObject receiver, long index, @CachedLibrary(limit="1") InteropLibrary receiverLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException {
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                return ((int[])receiver.unwrap(language))[(int)index];
            }

            @Specialization(guards={"isLongArray(receiver)", "receiver.isEspressoObject()"})
            static long doLong(StaticObject receiver, long index, @CachedLibrary(limit="1") InteropLibrary receiverLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException {
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                return ((long[])receiver.unwrap(language))[(int)index];
            }

            @Specialization(guards={"isFloatArray(receiver)", "receiver.isEspressoObject()"})
            static float doFloat(StaticObject receiver, long index, @CachedLibrary(limit="1") InteropLibrary receiverLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException {
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                return ((float[])receiver.unwrap(language))[(int)index];
            }

            @Specialization(guards={"isDoubleArray(receiver)", "receiver.isEspressoObject()"})
            static double doDouble(StaticObject receiver, long index, @CachedLibrary(limit="1") InteropLibrary receiverLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException {
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                return ((double[])receiver.unwrap(language))[(int)index];
            }

            @Specialization(guards={"receiver.isArray()", "receiver.isEspressoObject()", "!isPrimitiveArray(receiver)"})
            static Object doObject(StaticObject receiver, long index, @CachedLibrary(limit="1") InteropLibrary receiverLib, @Cached.Shared(value="error") @Cached BranchProfile error) throws InvalidArrayIndexException {
                EspressoLanguage language = EspressoLanguage.get((Node)receiverLib);
                if (index < 0L || (long)receiver.length(language) <= index) {
                    error.enter();
                    throw InvalidArrayIndexException.create((long)index);
                }
                return ((StaticObject[])receiver.unwrap(language))[(int)index];
            }

            @Specialization(guards={"invalidReceiver(receiver)"})
            static Object doOther(StaticObject receiver, long index) throws UnsupportedMessageException {
                throw UnsupportedMessageException.create();
            }

            public static boolean invalidReceiver(StaticObject receiver) {
                return !receiver.isArray() || !receiver.isEspressoObject();
            }
        }
    }
}

