/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode;
import com.oracle.truffle.espresso.nodes.interop.LookupInstanceFieldNode;
import com.oracle.truffle.espresso.nodes.interop.LookupVirtualMethodNode;
import com.oracle.truffle.espresso.nodes.interop.OverLoadedMethodSelectorNode;
import com.oracle.truffle.espresso.nodes.interop.ToEspressoNode;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInteropInteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInteropInteropNodesFactory;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Collect;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;

@Collect(getter="getInstance", value={InteropNodes.class})
public final class EspressoInteropInteropNodes
extends InteropNodes {
    private static final Factory factory = new Factory(InteropMessageFactories.dispatchToId(EspressoInterop.class));
    private static final InteropNodes INSTANCE = new EspressoInteropInteropNodes();

    private EspressoInteropInteropNodes() {
        super(EspressoInterop.class, BaseInteropInteropNodes.getInstance());
    }

    public static InteropNodes getInstance() {
        return INSTANCE;
    }

    @Override
    protected void registerMessages(Class<?> cls) {
        InteropMessageFactories.register(cls, InteropMessage.Message.IsBoolean, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.AsBoolean, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsNumber, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.FitsInByte, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.FitsInShort, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.FitsInInt, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.FitsInLong, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.FitsInFloat, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.FitsInDouble, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.AsByte, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.AsShort, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.AsInt, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.AsLong, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.AsFloat, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.AsDouble, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetArraySize, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.HasArrayElements, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.ReadArrayElement, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.WriteArrayElement, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsArrayElementInsertable, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.ReadMember, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.HasMembers, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsMemberReadable, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsMemberModifiable, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.WriteMember, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsMemberInsertable, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetMembers, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsMemberInvocable, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.InvokeMember, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsDate, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.AsDate, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsTime, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.AsTime, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsTimeZone, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.AsTimeZone, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.AsInstant, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsDuration, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.AsDuration, factory, true);
    }

    static final class Factory
    implements InteropMessageFactory {
        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return this.sourceDispatch;
        }

        @Override
        public final InteropMessage create(InteropMessage.Message message) {
            switch (message) {
                case IsBoolean: {
                    return EspressoInteropInteropNodesFactory.IsBooleanNodeGen.create();
                }
                case AsBoolean: {
                    return EspressoInteropInteropNodesFactory.AsBooleanNodeGen.create();
                }
                case IsNumber: {
                    return EspressoInteropInteropNodesFactory.IsNumberNodeGen.create();
                }
                case FitsInByte: {
                    return EspressoInteropInteropNodesFactory.FitsInByteNodeGen.create();
                }
                case FitsInShort: {
                    return EspressoInteropInteropNodesFactory.FitsInShortNodeGen.create();
                }
                case FitsInInt: {
                    return EspressoInteropInteropNodesFactory.FitsInIntNodeGen.create();
                }
                case FitsInLong: {
                    return EspressoInteropInteropNodesFactory.FitsInLongNodeGen.create();
                }
                case FitsInFloat: {
                    return EspressoInteropInteropNodesFactory.FitsInFloatNodeGen.create();
                }
                case FitsInDouble: {
                    return EspressoInteropInteropNodesFactory.FitsInDoubleNodeGen.create();
                }
                case AsByte: {
                    return EspressoInteropInteropNodesFactory.AsByteNodeGen.create();
                }
                case AsShort: {
                    return EspressoInteropInteropNodesFactory.AsShortNodeGen.create();
                }
                case AsInt: {
                    return EspressoInteropInteropNodesFactory.AsIntNodeGen.create();
                }
                case AsLong: {
                    return EspressoInteropInteropNodesFactory.AsLongNodeGen.create();
                }
                case AsFloat: {
                    return EspressoInteropInteropNodesFactory.AsFloatNodeGen.create();
                }
                case AsDouble: {
                    return EspressoInteropInteropNodesFactory.AsDoubleNodeGen.create();
                }
                case GetArraySize: {
                    return EspressoInteropInteropNodesFactory.GetArraySizeNodeGen.create();
                }
                case HasArrayElements: {
                    return EspressoInteropInteropNodesFactory.HasArrayElementsNodeGen.create();
                }
                case ReadArrayElement: {
                    return EspressoInteropInteropNodesFactory.ReadArrayElementNodeGen.create();
                }
                case WriteArrayElement: {
                    return EspressoInteropInteropNodesFactory.WriteArrayElementNodeGen.create();
                }
                case IsArrayElementInsertable: {
                    return EspressoInteropInteropNodesFactory.IsArrayElementInsertableNodeGen.create();
                }
                case ReadMember: {
                    return EspressoInteropInteropNodesFactory.ReadMemberNodeGen.create();
                }
                case HasMembers: {
                    return EspressoInteropInteropNodesFactory.HasMembersNodeGen.create();
                }
                case IsMemberReadable: {
                    return EspressoInteropInteropNodesFactory.IsMemberReadableNodeGen.create();
                }
                case IsMemberModifiable: {
                    return EspressoInteropInteropNodesFactory.IsMemberModifiableNodeGen.create();
                }
                case WriteMember: {
                    return EspressoInteropInteropNodesFactory.WriteMemberNodeGen.create();
                }
                case IsMemberInsertable: {
                    return EspressoInteropInteropNodesFactory.IsMemberInsertableNodeGen.create();
                }
                case GetMembers: {
                    return EspressoInteropInteropNodesFactory.GetMembersNodeGen.create();
                }
                case IsMemberInvocable: {
                    return EspressoInteropInteropNodesFactory.IsMemberInvocableNodeGen.create();
                }
                case InvokeMember: {
                    return EspressoInteropInteropNodesFactory.InvokeMemberNodeGen.create();
                }
                case IsDate: {
                    return EspressoInteropInteropNodesFactory.IsDateNodeGen.create();
                }
                case AsDate: {
                    return EspressoInteropInteropNodesFactory.AsDateNodeGen.create();
                }
                case IsTime: {
                    return EspressoInteropInteropNodesFactory.IsTimeNodeGen.create();
                }
                case AsTime: {
                    return EspressoInteropInteropNodesFactory.AsTimeNodeGen.create();
                }
                case IsTimeZone: {
                    return EspressoInteropInteropNodesFactory.IsTimeZoneNodeGen.create();
                }
                case AsTimeZone: {
                    return EspressoInteropInteropNodesFactory.AsTimeZoneNodeGen.create();
                }
                case AsInstant: {
                    return EspressoInteropInteropNodesFactory.AsInstantNodeGen.create();
                }
                case IsDuration: {
                    return EspressoInteropInteropNodesFactory.IsDurationNodeGen.create();
                }
                case AsDuration: {
                    return EspressoInteropInteropNodesFactory.AsDurationNodeGen.create();
                }
            }
            return null;
        }
    }

    static abstract class AsDurationNode
    extends InteropMessage.AsDuration {
        AsDurationNode() {
        }

        @Specialization
        static Duration asDuration(StaticObject receiver, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException {
            return EspressoInterop.asDuration(receiver, error);
        }
    }

    static abstract class IsDurationNode
    extends InteropMessage.IsDuration {
        IsDurationNode() {
        }

        @Specialization
        static boolean isDuration(StaticObject receiver) {
            return EspressoInterop.isDuration(receiver);
        }
    }

    static abstract class AsInstantNode
    extends InteropMessage.AsInstant {
        AsInstantNode() {
        }

        @Specialization
        static Instant asInstant(StaticObject receiver, @CachedLibrary(limit="1") InteropLibrary receiverLibrary, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException {
            return EspressoInterop.asInstant(receiver, receiverLibrary, error);
        }
    }

    static abstract class AsTimeZoneNode
    extends InteropMessage.AsTimeZone {
        AsTimeZoneNode() {
        }

        @Specialization
        static ZoneId asTimeZone(StaticObject receiver, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException {
            return EspressoInterop.asTimeZone(receiver, error);
        }
    }

    static abstract class IsTimeZoneNode
    extends InteropMessage.IsTimeZone {
        IsTimeZoneNode() {
        }

        @Specialization
        static boolean isTimeZone(StaticObject receiver) {
            return EspressoInterop.isTimeZone(receiver);
        }
    }

    static abstract class AsTimeNode
    extends InteropMessage.AsTime {
        AsTimeNode() {
        }

        @Specialization
        static LocalTime asTime(StaticObject receiver, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException {
            return EspressoInterop.asTime(receiver, error);
        }
    }

    static abstract class IsTimeNode
    extends InteropMessage.IsTime {
        IsTimeNode() {
        }

        @Specialization
        static boolean isTime(StaticObject receiver) {
            return EspressoInterop.isTime(receiver);
        }
    }

    static abstract class AsDateNode
    extends InteropMessage.AsDate {
        AsDateNode() {
        }

        @Specialization
        static LocalDate asDate(StaticObject receiver, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException {
            return EspressoInterop.asDate(receiver, error);
        }
    }

    static abstract class IsDateNode
    extends InteropMessage.IsDate {
        IsDateNode() {
        }

        @Specialization
        static boolean isDate(StaticObject receiver) {
            return EspressoInterop.isDate(receiver);
        }
    }

    static abstract class InvokeMemberNode
    extends InteropMessage.InvokeMember {
        InvokeMemberNode() {
        }

        @Specialization
        static Object invokeMember(StaticObject receiver, String member, Object[] arguments, @Cached(value="create($parameters)") LookupVirtualMethodNode lookupMethod, @Cached(value="create($parameters)") OverLoadedMethodSelectorNode selectorNode, @Cached(value="create($parameters)") InvokeEspressoNode invoke, @Cached(value="create($parameters)") ToEspressoNode.DynamicToEspresso toEspressoNode) throws ArityException, UnknownIdentifierException, UnsupportedTypeException {
            return EspressoInterop.invokeMember(receiver, member, arguments, lookupMethod, selectorNode, invoke, toEspressoNode);
        }
    }

    static abstract class IsMemberInvocableNode
    extends InteropMessage.IsMemberInvocable {
        IsMemberInvocableNode() {
        }

        @Specialization
        static boolean isMemberInvocable(StaticObject receiver, String member, @Cached(value="create($parameters)") LookupVirtualMethodNode lookupMethod) {
            return EspressoInterop.isMemberInvocable(receiver, member, lookupMethod);
        }
    }

    static abstract class GetMembersNode
    extends InteropMessage.GetMembers {
        GetMembersNode() {
        }

        @Specialization
        static Object getMembers(StaticObject receiver, boolean includeInternal) {
            return EspressoInterop.getMembers(receiver, includeInternal);
        }
    }

    static abstract class IsMemberInsertableNode
    extends InteropMessage.IsMemberInsertable {
        IsMemberInsertableNode() {
        }

        @Specialization
        static boolean isMemberInsertable(StaticObject receiver, String member) {
            return EspressoInterop.isMemberInsertable(receiver, member);
        }
    }

    static abstract class WriteMemberNode
    extends InteropMessage.WriteMember {
        WriteMemberNode() {
        }

        @Specialization
        static void writeMember(StaticObject receiver, String member, Object value, @Cached(value="create($parameters)") LookupInstanceFieldNode lookup, @Cached(value="create($parameters)") ToEspressoNode.DynamicToEspresso toEspresso, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedTypeException, UnknownIdentifierException, UnsupportedMessageException {
            EspressoInterop.writeMember(receiver, member, value, lookup, toEspresso, error);
        }
    }

    static abstract class IsMemberModifiableNode
    extends InteropMessage.IsMemberModifiable {
        IsMemberModifiableNode() {
        }

        @Specialization
        static boolean isMemberModifiable(StaticObject receiver, String member, @Cached(value="create($parameters)") LookupInstanceFieldNode lookup) {
            return EspressoInterop.isMemberModifiable(receiver, member, lookup);
        }
    }

    static abstract class IsMemberReadableNode
    extends InteropMessage.IsMemberReadable {
        IsMemberReadableNode() {
        }

        @Specialization
        static boolean isMemberReadable(StaticObject receiver, String member, @Cached(value="create($parameters)") LookupInstanceFieldNode lookupField, @Cached(value="create($parameters)") LookupVirtualMethodNode lookupMethod) {
            return EspressoInterop.isMemberReadable(receiver, member, lookupField, lookupMethod);
        }
    }

    static abstract class HasMembersNode
    extends InteropMessage.HasMembers {
        HasMembersNode() {
        }

        @Specialization
        static boolean hasMembers(StaticObject receiver) {
            return EspressoInterop.hasMembers(receiver);
        }
    }

    static abstract class ReadMemberNode
    extends InteropMessage.ReadMember {
        ReadMemberNode() {
        }

        @Specialization
        static Object readMember(StaticObject receiver, String member, @Cached(value="create($parameters)") LookupInstanceFieldNode lookupField, @Cached(value="create($parameters)") LookupVirtualMethodNode lookupMethod) throws UnknownIdentifierException {
            return EspressoInterop.readMember(receiver, member, lookupField, lookupMethod);
        }
    }

    static abstract class IsArrayElementInsertableNode
    extends InteropMessage.IsArrayElementInsertable {
        IsArrayElementInsertableNode() {
        }

        @Specialization
        static boolean isArrayElementInsertable(StaticObject receiver, long index) {
            return EspressoInterop.isArrayElementInsertable(receiver, index);
        }
    }

    static abstract class WriteArrayElementNode
    extends InteropMessage.WriteArrayElement {
        WriteArrayElementNode() {
        }

        @Specialization
        static void writeArrayElement(StaticObject receiver, long index, Object value, @Cached(value="create($parameters)") EspressoInterop.Nodes.WriteArrayElementImplNode writeArrayElementNode) throws UnsupportedMessageException, InvalidArrayIndexException, UnsupportedTypeException {
            EspressoInterop.writeArrayElement(receiver, index, value, writeArrayElementNode);
        }
    }

    static abstract class ReadArrayElementNode
    extends InteropMessage.ReadArrayElement {
        ReadArrayElementNode() {
        }

        @Specialization
        static Object readArrayElement(StaticObject receiver, long index, @Cached(value="create($parameters)") EspressoInterop.Nodes.ReadArrayElementImplNode readArrayElementNode) throws UnsupportedMessageException, InvalidArrayIndexException {
            return EspressoInterop.readArrayElement(receiver, index, readArrayElementNode);
        }
    }

    static abstract class HasArrayElementsNode
    extends InteropMessage.HasArrayElements {
        HasArrayElementsNode() {
        }

        @Specialization
        static boolean hasArrayElements(StaticObject receiver) {
            return EspressoInterop.hasArrayElements(receiver);
        }
    }

    static abstract class GetArraySizeNode
    extends InteropMessage.GetArraySize {
        GetArraySizeNode() {
        }

        @Specialization
        static long getArraySize(StaticObject receiver, @CachedLibrary(limit="1") InteropLibrary receiverLib, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException {
            return EspressoInterop.getArraySize(receiver, receiverLib, error);
        }
    }

    static abstract class AsDoubleNode
    extends InteropMessage.AsDouble {
        AsDoubleNode() {
        }

        @Specialization
        static double asDouble(StaticObject receiver) throws UnsupportedMessageException {
            return EspressoInterop.asDouble(receiver);
        }
    }

    static abstract class AsFloatNode
    extends InteropMessage.AsFloat {
        AsFloatNode() {
        }

        @Specialization
        static float asFloat(StaticObject receiver) throws UnsupportedMessageException {
            return EspressoInterop.asFloat(receiver);
        }
    }

    static abstract class AsLongNode
    extends InteropMessage.AsLong {
        AsLongNode() {
        }

        @Specialization
        static long asLong(StaticObject receiver) throws UnsupportedMessageException {
            return EspressoInterop.asLong(receiver);
        }
    }

    static abstract class AsIntNode
    extends InteropMessage.AsInt {
        AsIntNode() {
        }

        @Specialization
        static int asInt(StaticObject receiver) throws UnsupportedMessageException {
            return EspressoInterop.asInt(receiver);
        }
    }

    static abstract class AsShortNode
    extends InteropMessage.AsShort {
        AsShortNode() {
        }

        @Specialization
        static short asShort(StaticObject receiver) throws UnsupportedMessageException {
            return EspressoInterop.asShort(receiver);
        }
    }

    static abstract class AsByteNode
    extends InteropMessage.AsByte {
        AsByteNode() {
        }

        @Specialization
        static byte asByte(StaticObject receiver) throws UnsupportedMessageException {
            return EspressoInterop.asByte(receiver);
        }
    }

    static abstract class FitsInDoubleNode
    extends InteropMessage.FitsInDouble {
        FitsInDoubleNode() {
        }

        @Specialization
        static boolean fitsInDouble(StaticObject receiver) {
            return EspressoInterop.fitsInDouble(receiver);
        }
    }

    static abstract class FitsInFloatNode
    extends InteropMessage.FitsInFloat {
        FitsInFloatNode() {
        }

        @Specialization
        static boolean fitsInFloat(StaticObject receiver) {
            return EspressoInterop.fitsInFloat(receiver);
        }
    }

    static abstract class FitsInLongNode
    extends InteropMessage.FitsInLong {
        FitsInLongNode() {
        }

        @Specialization
        static boolean fitsInLong(StaticObject receiver) {
            return EspressoInterop.fitsInLong(receiver);
        }
    }

    static abstract class FitsInIntNode
    extends InteropMessage.FitsInInt {
        FitsInIntNode() {
        }

        @Specialization
        static boolean fitsInInt(StaticObject receiver) {
            return EspressoInterop.fitsInInt(receiver);
        }
    }

    static abstract class FitsInShortNode
    extends InteropMessage.FitsInShort {
        FitsInShortNode() {
        }

        @Specialization
        static boolean fitsInShort(StaticObject receiver) {
            return EspressoInterop.fitsInShort(receiver);
        }
    }

    static abstract class FitsInByteNode
    extends InteropMessage.FitsInByte {
        FitsInByteNode() {
        }

        @Specialization
        static boolean fitsInByte(StaticObject receiver) {
            return EspressoInterop.fitsInByte(receiver);
        }
    }

    static abstract class IsNumberNode
    extends InteropMessage.IsNumber {
        IsNumberNode() {
        }

        @Specialization
        static boolean isNumber(StaticObject receiver) {
            return EspressoInterop.isNumber(receiver);
        }
    }

    static abstract class AsBooleanNode
    extends InteropMessage.AsBoolean {
        AsBooleanNode() {
        }

        @Specialization
        static boolean asBoolean(StaticObject receiver) throws UnsupportedMessageException {
            return EspressoInterop.asBoolean(receiver);
        }
    }

    static abstract class IsBooleanNode
    extends InteropMessage.IsBoolean {
        IsBooleanNode() {
        }

        @Specialization
        static boolean isBoolean(StaticObject receiver) {
            return EspressoInterop.isBoolean(receiver);
        }
    }
}

