/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.dispatch.messages.GenerateInteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.messages.Shareable;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.ThrowableInterop;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@ExportLibrary(value=InteropLibrary.class, receiverType=StaticObject.class)
@GenerateInteropNodes
@Shareable
public class ForeignExceptionInterop
extends ThrowableInterop {
    public static Object getRawForeignObject(StaticObject object) {
        Meta meta = object.getKlass().getMeta();
        assert (object.getKlass() == meta.polyglot.ForeignException);
        return meta.java_lang_Throwable_backtrace.getObject(object).rawForeignObject(object.getKlass().getContext().getLanguage());
    }

    @ExportMessage
    public static ExceptionType getExceptionType(StaticObject object) throws UnsupportedMessageException {
        object.checkNotForeign();
        Object rawForeignException = ForeignExceptionInterop.getRawForeignObject(object);
        return InteropLibrary.getUncached().getExceptionType(rawForeignException);
    }

    @ExportMessage
    public static boolean hasExceptionCause(StaticObject object) {
        object.checkNotForeign();
        Object rawForeignException = ForeignExceptionInterop.getRawForeignObject(object);
        return InteropLibrary.getUncached().hasExceptionCause(rawForeignException);
    }

    @ExportMessage
    public static Object getExceptionCause(StaticObject object) throws UnsupportedMessageException {
        object.checkNotForeign();
        return InteropLibrary.getUncached().getExceptionCause(ForeignExceptionInterop.getRawForeignObject(object));
    }

    @ExportMessage
    public static boolean hasExceptionMessage(StaticObject object) {
        object.checkNotForeign();
        return InteropLibrary.getUncached().hasExceptionMessage(ForeignExceptionInterop.getRawForeignObject(object));
    }

    @ExportMessage
    public static Object getExceptionMessage(StaticObject object) throws UnsupportedMessageException {
        object.checkNotForeign();
        return InteropLibrary.getUncached().getExceptionMessage(ForeignExceptionInterop.getRawForeignObject(object));
    }

    @ExportMessage
    public static boolean hasExceptionStackTrace(StaticObject object) {
        object.checkNotForeign();
        return InteropLibrary.getUncached().hasExceptionStackTrace(ForeignExceptionInterop.getRawForeignObject(object));
    }

    @ExportMessage
    public static Object getExceptionStackTrace(StaticObject object) throws UnsupportedMessageException {
        object.checkNotForeign();
        return InteropLibrary.getUncached().getExceptionStackTrace(ForeignExceptionInterop.getRawForeignObject(object));
    }

    @ExportMessage
    public static RuntimeException throwException(StaticObject object) {
        object.checkNotForeign();
        throw (RuntimeException)ForeignExceptionInterop.getRawForeignObject(object);
    }
}

