/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.interop.LookupAndInvokeKnownMethodNode;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.InteropUtils;
import com.oracle.truffle.espresso.runtime.dispatch.messages.GenerateInteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.messages.Shareable;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.IterableInterop;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.InterpreterToVM;

@ExportLibrary(value=InteropLibrary.class, receiverType=StaticObject.class)
@GenerateInteropNodes
public final class ListInterop
extends IterableInterop {
    @ExportMessage
    @Shareable
    static boolean hasArrayElements(StaticObject receiver) {
        return true;
    }

    @ExportMessage
    static long getArraySize(StaticObject receiver, @Bind(value="getMeta().java_util_List_size") Method listSizeMethod, @Cached.Shared(value="size") @Cached LookupAndInvokeKnownMethodNode size) {
        return ((Integer)size.execute(receiver, listSizeMethod)).intValue();
    }

    @ExportMessage
    static Object readArrayElement(StaticObject receiver, long index, @Cached ListGet listGet, @Bind(value="getMeta().java_util_List_size") Method listSizeMethod, @Cached.Shared(value="size") @Cached LookupAndInvokeKnownMethodNode size, @Cached @Cached.Shared(value="error") BranchProfile error) throws InvalidArrayIndexException {
        if (!ListInterop.boundsCheck(receiver, index, listSizeMethod, size)) {
            error.enter();
            throw InvalidArrayIndexException.create((long)index);
        }
        return listGet.listGet(receiver, index, error);
    }

    @ExportMessage
    static void writeArrayElement(StaticObject receiver, long index, Object value, @Cached ListSet listSet, @Cached ListAdd listAdd, @Bind(value="getMeta().java_util_List_size") Method listSizeMethod, @Cached.Shared(value="size") @Cached LookupAndInvokeKnownMethodNode size, @Cached @Cached.Shared(value="error") BranchProfile error) throws InvalidArrayIndexException, UnsupportedMessageException {
        int listSize = (Integer)size.execute(receiver, listSizeMethod);
        if (!ListInterop.boundsCheck(index, listSize)) {
            if (index == (long)listSize) {
                listAdd.listAdd(receiver, value, error);
                return;
            }
            error.enter();
            throw InvalidArrayIndexException.create((long)index);
        }
        listSet.listSet(receiver, index, value, error);
    }

    @ExportMessage
    static boolean isArrayElementReadable(StaticObject receiver, long index, @Bind(value="getMeta().java_util_List_size") Method listSizeMethod, @Cached.Shared(value="size") @Cached LookupAndInvokeKnownMethodNode size) {
        return ListInterop.boundsCheck(receiver, index, listSizeMethod, size);
    }

    @ExportMessage
    static boolean isArrayElementModifiable(StaticObject receiver, long index, @Bind(value="getMeta().java_util_List_size") Method listSizeMethod, @Cached.Shared(value="size") @Cached LookupAndInvokeKnownMethodNode size) {
        return ListInterop.boundsCheck(receiver, index, listSizeMethod, size);
    }

    @ExportMessage
    static boolean isArrayElementInsertable(StaticObject receiver, long index) {
        return true;
    }

    private static boolean boundsCheck(StaticObject receiver, long index, Method listSize, LookupAndInvokeKnownMethodNode size) {
        return ListInterop.boundsCheck(index, (Integer)size.execute(receiver, listSize));
    }

    private static boolean boundsCheck(long index, int size) {
        return 0L <= index && index < (long)size;
    }

    @GenerateUncached
    static abstract class ListGet
    extends EspressoNode {
        static final int LIMIT = 3;

        ListGet() {
        }

        public Object listGet(StaticObject receiver, long index, BranchProfile error) throws InvalidArrayIndexException {
            try {
                return InteropUtils.unwrap(this.getLanguage(), this.execute(receiver, (int)index), this.getMeta());
            }
            catch (EspressoException e) {
                error.enter();
                if (InterpreterToVM.instanceOf(e.getGuestException(), receiver.getKlass().getMeta().java_lang_IndexOutOfBoundsException)) {
                    throw InvalidArrayIndexException.create((long)index);
                }
                throw e;
            }
        }

        protected abstract Object execute(StaticObject var1, int var2);

        @Specialization
        static Object doCached(StaticObject receiver, int index, @Bind(value="getMeta().java_util_List_get") Method getMethod, @Cached LookupAndInvokeKnownMethodNode lookupAndInvoke) {
            return lookupAndInvoke.execute(receiver, getMethod, new Object[]{index});
        }
    }

    @GenerateUncached
    static abstract class ListAdd
    extends EspressoNode {
        static final int LIMIT = 3;

        ListAdd() {
        }

        public void listAdd(StaticObject receiver, Object value, BranchProfile error) throws UnsupportedMessageException {
            try {
                this.execute(receiver, value);
            }
            catch (EspressoException e) {
                error.enter();
                if (InterpreterToVM.instanceOf(e.getGuestException(), receiver.getKlass().getMeta().java_lang_UnsupportedOperationException)) {
                    throw UnsupportedMessageException.create();
                }
                throw e;
            }
            catch (ArityException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere();
            }
        }

        protected abstract void execute(StaticObject var1, Object var2) throws ArityException, UnsupportedTypeException;

        @Specialization
        static void doCached(StaticObject receiver, Object value, @Bind(value="getMeta().java_util_List_add") Method addMethod, @Cached LookupAndInvokeKnownMethodNode lookupAndInvoke) {
            lookupAndInvoke.execute(receiver, addMethod, new Object[]{value});
        }
    }

    @GenerateUncached
    static abstract class ListSet
    extends EspressoNode {
        static final int LIMIT = 3;

        ListSet() {
        }

        public void listSet(StaticObject receiver, long index, Object value, BranchProfile error) throws InvalidArrayIndexException {
            try {
                this.execute(receiver, (int)index, value);
            }
            catch (EspressoException e) {
                error.enter();
                if (InterpreterToVM.instanceOf(e.getGuestException(), receiver.getKlass().getMeta().java_lang_IndexOutOfBoundsException)) {
                    throw InvalidArrayIndexException.create((long)index);
                }
                throw e;
            }
            catch (ArityException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere();
            }
        }

        protected abstract void execute(StaticObject var1, int var2, Object var3) throws ArityException, UnsupportedTypeException;

        @Specialization
        static void doCached(StaticObject receiver, int index, Object value, @Bind(value="getMeta().java_util_List_set") Method setMethod, @Cached LookupAndInvokeKnownMethodNode lookupAndInvoke) {
            lookupAndInvoke.execute(receiver, setMethod, new Object[]{index, value});
        }
    }
}

