/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.panama;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.espresso.ffi.NativeAccess;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.OS;
import com.oracle.truffle.espresso.runtime.panama.ArgumentsCalculator;
import com.oracle.truffle.espresso.runtime.panama.CapturableState;
import com.oracle.truffle.espresso.runtime.panama.Platform;
import com.oracle.truffle.espresso.runtime.panama.StorageType;
import com.oracle.truffle.espresso.runtime.panama.VMStorage;
import java.util.Arrays;
import java.util.EnumSet;

public final class DowncallStubs {
    private static final TruffleLogger LOGGER = TruffleLogger.getLogger((String)"java", DowncallStubs.class);
    public static final int MAX_STUB_COUNT = 0x7FFFFFF7;
    private final Platform platform;
    private DowncallStub[] stubs;
    private int nextId = 0;

    public DowncallStubs(Platform platform) {
        this.platform = platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public long makeStub(Klass[] pTypes, Klass rType, VMStorage[] inputRegs, VMStorage[] outRegs, boolean needsReturnBuffer, int capturedStateMask, boolean needsTransition) {
        int id;
        DowncallStubs downcallStubs = this;
        synchronized (downcallStubs) {
            id = this.nextId++;
        }
        DowncallStub stub = this.create(pTypes, rType, inputRegs, outRegs, needsReturnBuffer, capturedStateMask, needsTransition);
        DowncallStubs downcallStubs2 = this;
        synchronized (downcallStubs2) {
            if (this.stubs == null) {
                assert (id == 0);
                this.stubs = new DowncallStub[8];
            } else if (id >= this.stubs.length) {
                long newSize = (long)this.stubs.length * 2L;
                if (newSize > 0x7FFFFFF7L && (long)id >= (newSize = 0x7FFFFFF7L)) {
                    throw EspressoError.fatal("Too many stubs!");
                }
                this.stubs = Arrays.copyOf(this.stubs, (int)newSize);
            }
            this.stubs[id] = stub;
        }
        return id;
    }

    private DowncallStub create(Klass[] pTypes, Klass rType, VMStorage[] inputRegs, VMStorage[] outRegs, boolean needsReturnBuffer, int capturedStateMask, boolean needsTransition) {
        assert (pTypes.length == inputRegs.length);
        EspressoError.guarantee(!needsReturnBuffer, "unimplemented");
        EnumSet<CapturableState> capturedStates = CapturableState.fromMask(capturedStateMask);
        assert (DowncallStubs.validCapturableState(capturedStates, OS.getCurrent()));
        LOGGER.fine(() -> {
            int i;
            StringBuilder sb = new StringBuilder("Downcall stub request: ");
            if (!needsReturnBuffer) {
                sb.append("no ");
            }
            sb.append("ret buf, captured state=").append(capturedStates).append(", sig=(");
            for (i = 0; i < pTypes.length; ++i) {
                Klass pType = pTypes[i];
                sb.append(pType.getType());
                if (i >= pTypes.length - 1) continue;
                sb.append(", ");
            }
            sb.append(")").append(rType.getType()).append(", in=(");
            for (i = 0; i < inputRegs.length; ++i) {
                VMStorage inputReg = inputRegs[i];
                sb.append(this.platform.toString(inputReg));
                if (i >= inputRegs.length - 1) continue;
                sb.append(", ");
            }
            sb.append("), out=(");
            for (i = 0; i < outRegs.length; ++i) {
                VMStorage outReg = outRegs[i];
                sb.append(this.platform.toString(outReg));
                if (i >= outRegs.length - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        });
        ArgumentsCalculator argsCalc = this.platform.getArgumentsCalculator();
        int targetIndex = -1;
        int captureIndex = -1;
        int[] shuffle = new int[pTypes.length];
        NativeType[] nativeParamTypes = new NativeType[pTypes.length];
        int nativeIndex = 0;
        int nativeVarArgsIndex = -1;
        block4: for (int i = 0; i < pTypes.length; ++i) {
            int index;
            Klass nextPType;
            VMStorage nextInputReg;
            Klass pType = pTypes[i];
            VMStorage inputReg = inputRegs[i];
            StorageType regType = inputReg.type(this.platform);
            if (regType.isPlaceholder()) {
                switch (inputReg.getStubLocation(this.platform)) {
                    case TARGET_ADDRESS: {
                        targetIndex = i;
                        continue block4;
                    }
                    case CAPTURED_STATE_BUFFER: {
                        captureIndex = i;
                        continue block4;
                    }
                    default: {
                        throw EspressoError.unimplemented(inputReg.getStubLocation(this.platform).toString());
                    }
                }
            }
            if (i + 1 < pTypes.length) {
                nextInputReg = inputRegs[i + 1];
                nextPType = pTypes[i + 1];
            } else {
                nextInputReg = null;
                nextPType = null;
            }
            if (nativeVarArgsIndex < 0 && argsCalc.isVarArg(inputReg, pType, nextInputReg, nextPType)) {
                nativeVarArgsIndex = nativeIndex;
            }
            if ((index = argsCalc.getNextInputIndex(inputReg, pType, nextInputReg, nextPType)) >= 0) {
                shuffle[nativeIndex] = i;
                nativeParamTypes[nativeIndex] = inputReg.asNativeType(this.platform, pType);
                ++nativeIndex;
                continue;
            }
            if (index == -2 || this.platform.ignoreDownCallArgument(inputReg)) continue;
            throw EspressoError.shouldNotReachHere("Cannot understand argument " + i + " in downcall: " + inputReg + " for type " + pType + " calc: " + argsCalc);
        }
        NativeType nativeReturnType = NativeType.VOID;
        if (outRegs.length > 0) {
            EspressoError.guarantee(outRegs.length == 1, "unimplemented");
            if (!argsCalc.checkReturn(outRegs[0], rType)) {
                throw EspressoError.shouldNotReachHere("Cannot understand out reg in downcall: " + outRegs[0] + " for type " + rType);
            }
            nativeReturnType = outRegs[0].asNativeType(this.platform, rType);
        }
        if (targetIndex < 0) {
            throw EspressoError.shouldNotReachHere("Didn't find the target index in downcall arguments");
        }
        if (!capturedStates.isEmpty() && captureIndex < 0) {
            throw EspressoError.shouldNotReachHere("Didn't find the capture index in downcall arguments");
        }
        NativeSignature nativeSignature = nativeVarArgsIndex < 0 ? NativeSignature.create(nativeReturnType, Arrays.copyOf(nativeParamTypes, nativeIndex)) : NativeSignature.createVarArg(nativeReturnType, Arrays.copyOf(nativeParamTypes, nativeVarArgsIndex), Arrays.copyOfRange(nativeParamTypes, nativeVarArgsIndex, nativeIndex));
        DowncallStub downcallStub = new DowncallStub(targetIndex, Arrays.copyOf(shuffle, nativeIndex), nativeSignature, captureIndex, capturedStates);
        LOGGER.fine(() -> {
            StringBuilder sb = new StringBuilder("Creating downcall stub: targetIndex=");
            sb.append(downcallStub.targetIndex).append(" shuffle=").append(Arrays.toString(downcallStub.shuffle));
            sb.append(" sig=").append(downcallStub.signature).append(" capture=").append(capturedStates);
            if (downcallStub.captureIndex >= 0) {
                sb.append("@").append(downcallStub.captureIndex);
            }
            return sb.toString();
        });
        return downcallStub;
    }

    private static boolean validCapturableState(EnumSet<CapturableState> states, OS os) {
        for (CapturableState state : states) {
            assert (state.isSupported(os));
        }
        return true;
    }

    public boolean freeStub(long downcallStub) {
        int id = Math.toIntExact(downcallStub);
        if (this.stubs[id] == null) {
            return false;
        }
        this.stubs[id] = null;
        return true;
    }

    public DowncallStub getStub(long downcallStub) {
        int id = Math.toIntExact(downcallStub);
        return this.stubs[id];
    }

    public static final class DowncallStub {
        private final int targetIndex;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final int[] shuffle;
        final NativeSignature signature;
        private final int captureIndex;
        private final int captureMask;
        @CompilerDirectives.CompilationFinal
        private Object callableSignature;

        public DowncallStub(int targetIndex, int[] shuffle, NativeSignature signature, int captureIndex, EnumSet<CapturableState> capturedStates) {
            this.targetIndex = targetIndex;
            this.shuffle = shuffle;
            this.signature = signature;
            this.captureIndex = captureIndex;
            this.captureMask = CapturableState.toMask(capturedStates);
            assert (this.captureMask == 0 || captureIndex >= 0);
        }

        public long getTargetHandle(Object[] args) {
            return (Long)args[this.targetIndex];
        }

        public long getCaptureAddress(Object[] args) {
            return (Long)args[this.captureIndex];
        }

        @ExplodeLoop
        public Object[] processArgs(Object[] args) {
            Object[] nativeArgs = new Object[this.shuffle.length];
            for (int i = 0; i < this.shuffle.length; ++i) {
                nativeArgs[i] = args[this.shuffle[i]];
            }
            return nativeArgs;
        }

        @CompilerDirectives.TruffleBoundary
        public static TruffleObject resolveTarget(long targetHandle, EspressoContext context) {
            return context.getVM().getFunction(targetHandle);
        }

        public TruffleObject getTarget(Object[] args, EspressoContext context) {
            long targetHandle = this.getTargetHandle(args);
            return DowncallStub.resolveTarget(targetHandle, context);
        }

        private Object getCallableSignature(NativeAccess access) {
            if (this.callableSignature == null) {
                if (CompilerDirectives.isPartialEvaluationConstant((Object)this)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                this.callableSignature = access.getCallableSignature(this.signature, true);
            }
            return this.callableSignature;
        }

        public void captureState(Object[] args, InteropLibrary interop, EspressoContext context) {
            try {
                interop.execute((Object)context.getVM().getMokapotCaptureState(), new Object[]{this.getCaptureAddress(args), this.captureMask});
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }

        public boolean hasCapture() {
            return this.captureIndex >= 0;
        }

        public Object uncachedCall(Object[] args, EspressoContext context) {
            TruffleObject target = this.getTarget(args, context);
            NativeAccess access = context.getNativeAccess();
            try {
                Object result = access.callSignature(this.getCallableSignature(access), target, this.processArgs(args));
                if (this.hasCapture()) {
                    this.captureState(args, InteropLibrary.getUncached(), context);
                }
                return result;
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
        }
    }
}

