/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.espresso.descriptors.StaticSymbols;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.impl.ClassLoadingEnv;
import com.oracle.truffle.espresso.impl.ContextAccessImpl;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.EspressoRootNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaSubstitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionCollector;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.graalvm.collections.EconomicMap;

public final class Substitutions
extends ContextAccessImpl {
    private static final TruffleLogger logger = TruffleLogger.getLogger((String)"java", Substitutions.class);
    private static final EconomicMap<MethodRef, JavaSubstitution.Factory> STATIC_SUBSTITUTIONS = EconomicMap.create();
    private final ConcurrentHashMap<MethodRef, EspressoRootNodeFactory> runtimeSubstitutions = new ConcurrentHashMap();

    public static TruffleLogger getLogger() {
        return logger;
    }

    public static void ensureInitialized() {
    }

    public Substitutions(EspressoContext context) {
        super(context);
    }

    private static MethodRef getMethodKey(Method method) {
        return new MethodRef(method.getDeclaringKlass().getType(), method.getName(), method.getRawSignature());
    }

    private static void registerStaticSubstitution(JavaSubstitution.Factory substitutorFactory) {
        int i;
        ArrayList<Symbol<Symbol.Type>> parameterTypes = new ArrayList<Symbol<Symbol.Type>>();
        int n = i = substitutorFactory.hasReceiver() ? 1 : 0;
        while (i < substitutorFactory.parameterTypes().length) {
            String type = substitutorFactory.parameterTypes()[i];
            parameterTypes.add(StaticSymbols.putType(type));
            ++i;
        }
        Symbol<Symbol.Type> returnType = StaticSymbols.putType(substitutorFactory.returnType());
        Symbol<Symbol.Signature> signature = StaticSymbols.putSignature(returnType, parameterTypes.toArray(Symbol.EMPTY_ARRAY));
        String[] classNames = substitutorFactory.substitutionClassNames();
        String[] methodNames = substitutorFactory.getMethodNames();
        for (int i2 = 0; i2 < classNames.length; ++i2) {
            assert (classNames[i2].startsWith("Target_"));
            Symbol<Symbol.Type> classType = StaticSymbols.putType("L" + classNames[i2].substring("Target_".length()).replace('_', '/') + ";");
            Symbol<Symbol.Name> methodName = StaticSymbols.putName(methodNames[i2]);
            Substitutions.registerStaticSubstitution(classType, methodName, signature, substitutorFactory, true);
        }
    }

    private static void registerStaticSubstitution(Symbol<Symbol.Type> type, Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature, JavaSubstitution.Factory factory, boolean throwIfPresent) {
        MethodRef key = new MethodRef(type, methodName, signature);
        if (throwIfPresent && STATIC_SUBSTITUTIONS.containsKey((Object)key)) {
            throw EspressoError.shouldNotReachHere("substitution already registered" + key);
        }
        STATIC_SUBSTITUTIONS.put((Object)key, (Object)factory);
    }

    public void registerRuntimeSubstitution(Symbol<Symbol.Type> type, Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature, EspressoRootNodeFactory factory, boolean throwIfPresent) {
        MethodRef key = new MethodRef(type, methodName, signature);
        if (STATIC_SUBSTITUTIONS.containsKey((Object)key)) {
            Substitutions.getLogger().log(Level.FINE, "Runtime substitution shadowed by static one: " + key);
        }
        if (throwIfPresent && this.runtimeSubstitutions.containsKey(key)) {
            throw EspressoError.shouldNotReachHere("substitution already registered " + key);
        }
        this.runtimeSubstitutions.put(key, factory);
    }

    public void removeRuntimeSubstitution(Method method) {
        MethodRef key = Substitutions.getMethodKey(method);
        this.runtimeSubstitutions.remove(key);
    }

    public static JavaSubstitution.Factory lookupSubstitution(Method m) {
        return (JavaSubstitution.Factory)STATIC_SUBSTITUTIONS.get((Object)Substitutions.getMethodKey(m));
    }

    public EspressoRootNode get(Method method) {
        EspressoRootNode root;
        MethodRef key = Substitutions.getMethodKey(method);
        JavaSubstitution.Factory staticSubstitutionFactory = (JavaSubstitution.Factory)STATIC_SUBSTITUTIONS.get((Object)key);
        if (staticSubstitutionFactory != null && staticSubstitutionFactory.isValidFor(method.getJavaVersion()) && (root = Substitutions.createRootNodeFromSubstitution(method, staticSubstitutionFactory)) != null) {
            return root;
        }
        EspressoRootNodeFactory factory = this.runtimeSubstitutions.get(key);
        if (factory != null) {
            return factory.createNodeIfValid(method);
        }
        return null;
    }

    private static EspressoRootNode createRootNodeFromSubstitution(final Method method, JavaSubstitution.Factory staticSubstitutionFactory) {
        StaticObject classLoader = method.getDeclaringKlass().getDefiningClassLoader();
        ClassLoadingEnv env = method.getContext().getClassLoadingEnv();
        if (env.loaderIsBootOrPlatform(classLoader)) {
            return EspressoRootNode.createSubstitution(method.getMethodVersion(), staticSubstitutionFactory);
        }
        Substitutions.getLogger().warning((Supplier)new Supplier<String>(){

            @Override
            public String get() {
                StaticObject givenLoader = method.getDeclaringKlass().getDefiningClassLoader();
                return "Static substitution for " + method + " does not apply.\n\tExpected class loader: Boot (null) or platform class loader\n\tGiven class loader: " + InteropLibrary.getUncached().toDisplayString((Object)givenLoader, false) + "\n";
            }
        });
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean hasSubstitutionFor(Method method) {
        MethodRef key = Substitutions.getMethodKey(method);
        return STATIC_SUBSTITUTIONS.containsKey((Object)key) || this.runtimeSubstitutions.containsKey(key);
    }

    static {
        for (JavaSubstitution.Factory factory : SubstitutionCollector.getInstances(JavaSubstitution.Factory.class)) {
            Substitutions.registerStaticSubstitution(factory);
        }
    }

    private static final class MethodRef {
        private final Symbol<Symbol.Type> clazz;
        private final Symbol<Symbol.Name> methodName;
        private final Symbol<Symbol.Signature> signature;
        private final int hash;

        MethodRef(Symbol<Symbol.Type> clazz, Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature) {
            this.clazz = clazz;
            this.methodName = methodName;
            this.signature = signature;
            this.hash = Objects.hash(clazz, methodName, signature);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MethodRef other = (MethodRef)obj;
            return Objects.equals(this.clazz, other.clazz) && Objects.equals(this.methodName, other.methodName) && Objects.equals(this.signature, other.signature);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return Types.binaryName(this.clazz) + "#" + this.methodName + this.signature;
        }
    }

    public static interface EspressoRootNodeFactory {
        public EspressoRootNode createNodeIfValid(Method var1, boolean var2);

        default public EspressoRootNode createNodeIfValid(Method method) {
            return this.createNodeIfValid(method, false);
        }
    }
}

