/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionProfiler;
import com.oracle.truffle.espresso.vm.ModulesHelperVM;

@EspressoSubstitutions
public final class Target_java_lang_Module {
    @CompilerDirectives.TruffleBoundary
    @Substitution
    public static void addExports0(@JavaType(internalName="Ljava/lang/Module;") StaticObject from, @JavaType(value=String.class) StaticObject pn, @JavaType(internalName="Ljava/lang/Module;") StaticObject to, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(pn)) {
            throw meta.throwNullPointerException();
        }
        ModulesHelperVM.addModuleExports(from, meta.toHostString(pn).replace('.', '/'), to, meta, profiler);
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution
    public static void addExportsToAll0(@JavaType(internalName="Ljava/lang/Module;") StaticObject from, @JavaType(value=String.class) StaticObject pn, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(pn)) {
            throw meta.throwNullPointerException();
        }
        ModulesHelperVM.addModuleExports(from, meta.toHostString(pn).replace('.', '/'), StaticObject.NULL, meta, profiler);
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution
    public static void addExportsToAllUnnamed0(@JavaType(internalName="Ljava/lang/Module;") StaticObject from, @JavaType(value=String.class) StaticObject pn, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(pn)) {
            throw meta.throwNullPointerException();
        }
        ModulesHelperVM.addModuleExportsToAllUnnamed(from, meta.toHostString(pn).replace('.', '/'), profiler, meta);
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution
    public static void defineModule0(@JavaType(internalName="Ljava/lang/Module;") StaticObject module, boolean isOpen, @JavaType(value=String.class) StaticObject version, @JavaType(value=String.class) StaticObject location, @JavaType(value=Object[].class) StaticObject pns, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(module)) {
            profiler.profile(0);
            throw meta.throwNullPointerException();
        }
        if (!meta.java_lang_Module.isAssignableFrom(module.getKlass())) {
            profiler.profile(1);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "module is not an instance of java.lang.Module");
        }
        StaticObject guestName = meta.java_lang_Module_name.getObject(module);
        if (StaticObject.isNull(guestName)) {
            profiler.profile(2);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "module name cannot be null");
        }
        String hostName = meta.toHostString(guestName);
        String[] packages = Target_java_lang_Module.toStringArray(language, pns, meta);
        if (hostName.equals("java.base")) {
            profiler.profile(5);
            meta.getVM().defineJavaBaseModule(module, packages, profiler);
        } else {
            profiler.profile(6);
            meta.getVM().defineModule(module, hostName, isOpen, packages, profiler);
        }
    }

    private static String[] toStringArray(EspressoLanguage language, StaticObject packages, Meta meta) {
        String[] strs = new String[packages.length(language)];
        StaticObject[] unwrapped = (StaticObject[])packages.unwrap(language);
        for (int i = 0; i < unwrapped.length; ++i) {
            StaticObject str = unwrapped[i];
            if (StaticObject.isNull(str)) {
                throw meta.throwNullPointerException();
            }
            if (meta.java_lang_String != str.getKlass()) {
                throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "Package name array contains a non-string");
            }
            strs[i] = meta.toHostString(str).replace('.', '/');
        }
        return strs;
    }
}

