/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;

@EspressoSubstitutions
public final class Target_jdk_internal_loader_RawNativeLibraries {

    @Substitution
    static abstract class Load0
    extends SubstitutionNode {
        Load0() {
        }

        abstract boolean execute(@JavaType(internalName="Ljdk/internal/loader/RawNativeLibraries$RawNativeLibraryImpl;") StaticObject var1, @JavaType(value=String.class) StaticObject var2);

        @Specialization
        boolean doLoad(@JavaType(internalName="Ljdk/internal/loader/RawNativeLibraries$RawNativeLibraryImpl;") StaticObject impl, @JavaType(value=String.class) StaticObject name, @CachedLibrary(limit="2") InteropLibrary interop) {
            long value;
            EspressoContext context = this.getContext();
            Meta meta = context.getMeta();
            TruffleObject library = context.getVM().JVM_LoadLibrary(meta.toHostString(name), false);
            try {
                value = interop.asPointer((Object)library);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
            meta.jdk_internal_loader_RawNativeLibraries$RawNativeLibraryImpl_handle.setLong(impl, value);
            return value != 0L;
        }
    }
}

