/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.vm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.blocking.GuestInterruptedException;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.attributes.EnclosingMethodAttribute;
import com.oracle.truffle.espresso.classfile.attributes.InnerClassesAttribute;
import com.oracle.truffle.espresso.classfile.attributes.MethodParametersAttribute;
import com.oracle.truffle.espresso.classfile.attributes.PermittedSubclassesAttribute;
import com.oracle.truffle.espresso.classfile.attributes.RecordAttribute;
import com.oracle.truffle.espresso.classfile.attributes.SignatureAttribute;
import com.oracle.truffle.espresso.classfile.constantpool.NameAndTypeConstant;
import com.oracle.truffle.espresso.descriptors.ByteSequence;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.descriptors.Validation;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.ffi.Pointer;
import com.oracle.truffle.espresso.ffi.RawPointer;
import com.oracle.truffle.espresso.ffi.nfi.NativeUtils;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.EntryTable;
import com.oracle.truffle.espresso.impl.EspressoClassLoadingException;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ModuleTable;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.PackageTable;
import com.oracle.truffle.espresso.impl.SuppressFBWarnings;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.jni.JniVersion;
import com.oracle.truffle.espresso.jni.NativeEnv;
import com.oracle.truffle.espresso.jni.NoSafepoint;
import com.oracle.truffle.espresso.jvmti.JVMTI;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.meta.MetaUtil;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.EspressoRootNode;
import com.oracle.truffle.espresso.nodes.interop.ToEspressoNode;
import com.oracle.truffle.espresso.nodes.interop.ToEspressoNodeFactory;
import com.oracle.truffle.espresso.ref.EspressoReference;
import com.oracle.truffle.espresso.runtime.Attribute;
import com.oracle.truffle.espresso.runtime.Classpath;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.EspressoExitException;
import com.oracle.truffle.espresso.runtime.EspressoProperties;
import com.oracle.truffle.espresso.runtime.JavaVersion;
import com.oracle.truffle.espresso.runtime.MethodHandleIntrinsics;
import com.oracle.truffle.espresso.runtime.OS;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.CallableFromNative;
import com.oracle.truffle.espresso.substitutions.GenerateNativeEnv;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.SubstitutionProfiler;
import com.oracle.truffle.espresso.substitutions.Target_java_lang_System;
import com.oracle.truffle.espresso.substitutions.Target_java_lang_Thread;
import com.oracle.truffle.espresso.substitutions.Target_java_lang_ref_Reference;
import com.oracle.truffle.espresso.threads.State;
import com.oracle.truffle.espresso.threads.ThreadsAccess;
import com.oracle.truffle.espresso.threads.Transition;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import com.oracle.truffle.espresso.vm.Management;
import com.oracle.truffle.espresso.vm.ModulesHelperVM;
import com.oracle.truffle.espresso.vm.StackWalk;
import com.oracle.truffle.espresso.vm.VmImpl;
import com.oracle.truffle.espresso.vm.VmImplCollector;
import com.oracle.truffle.espresso.vm.structs.JavaVMAttachArgs;
import com.oracle.truffle.espresso.vm.structs.JdkVersionInfo;
import com.oracle.truffle.espresso.vm.structs.Structs;
import com.oracle.truffle.espresso.vm.structs.StructsAccess;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.IntFunction;
import java.util.logging.Level;
import org.graalvm.collections.EconomicMap;
import org.graalvm.options.OptionMap;
import org.graalvm.options.OptionValues;

@GenerateNativeEnv(target=VmImpl.class, reachableForAutoSubstitution=true)
public final class VM
extends NativeEnv {
    private final @Pointer TruffleObject disposeMokapotContext;
    private final @Pointer TruffleObject getJavaVM;
    private final @Pointer TruffleObject mokapotAttachThread;
    private final @Pointer TruffleObject mokapotCaptureState;
    private final @Pointer TruffleObject getPackageAt;
    private final long rtldDefaultValue;
    private final long processHandleValue;
    private final Structs structs;
    private final JniEnv jniEnv;
    private final Management management;
    private final JVMTI jvmti;
    private @Pointer TruffleObject mokapotEnvPtr;
    private @Pointer TruffleObject javaLibrary;
    private final Object zipLoadLock = new Object(){};
    private volatile @Pointer TruffleObject zipLibrary;
    private static final List<CallableFromNative.Factory> VM_IMPL_FACTORIES = VmImplCollector.getInstances(CallableFromNative.Factory.class);
    private static final int VM_LOOKUP_CALLBACK_ARGS = 2;
    private EconomicMap<Long, CallableFromNative.Factory> knownVmMethods = EconomicMap.create();
    private final ConcurrentHashMap<Long, @Pointer TruffleObject> handle2Lib = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, @Pointer TruffleObject> handle2Sym = new ConcurrentHashMap();
    private static final AtomicLong libraryHandles = new AtomicLong(1L);
    private static boolean hasDynamicLoaderCacheValue = false;
    private static boolean hasDynamicLoaderCacheInit = false;
    private static final int JVM_CALLER_DEPTH = -1;
    private static final String MODULES = "modules";
    private static final long ONE_BILLION = 1000000000L;
    private static final long MAX_DIFF = 0x100000000L;
    private volatile StackWalk stackWalk;

    private static String stringify(List<Path> paths) {
        StringJoiner joiner = new StringJoiner(File.pathSeparator);
        for (Path p : paths) {
            joiner.add(p.toString());
        }
        return joiner.toString();
    }

    public void attachThread(Thread hostThread) {
        if (hostThread != Thread.currentThread()) {
            this.getLogger().warning("unimplemented: attachThread for non-current thread: " + hostThread);
            return;
        }
        assert (hostThread == Thread.currentThread());
        try {
            this.getUncached().execute((Object)this.mokapotAttachThread, new Object[]{this.mokapotEnvPtr});
            this.getNativeAccess().prepareThread();
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw EspressoError.shouldNotReachHere("mokapotAttachThread failed", e);
        }
    }

    public Management getManagement() {
        return this.management;
    }

    public @Pointer TruffleObject getJavaLibrary() {
        return this.javaLibrary;
    }

    private @Pointer TruffleObject loadJavaLibraryImpl(List<Path> bootLibraryPath) {
        this.getNativeAccess().loadLibrary(bootLibraryPath, "verify", false);
        return this.getNativeAccess().loadLibrary(bootLibraryPath, "java", true);
    }

    private JavaVersion findJavaVersion(TruffleObject libJava) {
        TruffleObject jdkGetVersionInfo = this.getNativeAccess().lookupAndBindSymbol(libJava, "JDK_GetVersionInfo0", NativeSignature.create(NativeType.VOID, NativeType.POINTER, NativeType.LONG));
        if (jdkGetVersionInfo == null) {
            return null;
        }
        JdkVersionInfo.JdkVersionInfoWrapper wrapper = (JdkVersionInfo.JdkVersionInfoWrapper)this.getStructs().jdkVersionInfo.allocate(this.getNativeAccess(), this.jni());
        try {
            this.getUncached().execute((Object)jdkGetVersionInfo, new Object[]{wrapper.pointer(), this.getStructs().jdkVersionInfo.structSize()});
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw EspressoError.shouldNotReachHere(e);
        }
        int versionInfo = wrapper.jdkVersion();
        wrapper.free(this.getNativeAccess());
        int major = (versionInfo & 0xFF000000) >> 24;
        if (major == 1) {
            int minor = (versionInfo & 0xFF0000) >> 16;
            return JavaVersion.forVersion(minor);
        }
        return JavaVersion.forVersion(major);
    }

    public JavaVersion loadJavaLibrary(List<Path> searchPaths) {
        assert (this.javaLibrary == null) : "java library already initialized";
        this.javaLibrary = this.loadJavaLibraryImpl(searchPaths);
        return this.findJavaVersion(this.javaLibrary);
    }

    public void initializeJavaLibrary() {
        if (this.getJavaVersion().java8OrEarlier()) {
            EspressoError.guarantee(this.getVM() != null, "The VM must be initialized before libjava's JNI_OnLoad");
            TruffleObject jniOnLoad = this.getNativeAccess().lookupAndBindSymbol(this.javaLibrary, "JNI_OnLoad", NativeSignature.create(NativeType.INT, NativeType.POINTER, NativeType.POINTER));
            if (jniOnLoad != null) {
                try {
                    this.getUncached().execute((Object)jniOnLoad, new Object[]{this.mokapotEnvPtr, RawPointer.nullInstance()});
                }
                catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                    throw EspressoError.shouldNotReachHere(e);
                }
            }
        }
    }

    private VM(JniEnv jniEnv) {
        super(jniEnv.getContext());
        this.jniEnv = jniEnv;
        try {
            EspressoProperties props = this.getContext().getVmProperties();
            @Pointer TruffleObject mokapotLibrary = this.getNativeAccess().loadLibrary(props.jvmLibraryPath(), "jvm", true);
            assert (mokapotLibrary != null);
            @Pointer TruffleObject initializeMokapotContext = this.getNativeAccess().lookupAndBindSymbol(mokapotLibrary, "initializeMokapotContext", NativeSignature.create(NativeType.POINTER, NativeType.POINTER, NativeType.POINTER));
            this.disposeMokapotContext = this.getNativeAccess().lookupAndBindSymbol(mokapotLibrary, "disposeMokapotContext", NativeSignature.create(NativeType.VOID, NativeType.POINTER, NativeType.POINTER));
            this.management = jniEnv.getContext().getEspressoEnv().EnableManagement ? new Management(this.getContext(), mokapotLibrary) : null;
            this.structs = StructsAccess.getStructs(this.getContext(), mokapotLibrary);
            this.jvmti = new JVMTI(this.getContext(), mokapotLibrary);
            this.getJavaVM = this.getNativeAccess().lookupAndBindSymbol(mokapotLibrary, "getJavaVM", NativeSignature.create(NativeType.POINTER, NativeType.POINTER));
            this.mokapotAttachThread = this.getNativeAccess().lookupAndBindSymbol(mokapotLibrary, "mokapotAttachThread", NativeSignature.create(NativeType.VOID, NativeType.POINTER));
            this.mokapotCaptureState = this.getNativeAccess().lookupAndBindSymbol(mokapotLibrary, "mokapotCaptureState", NativeSignature.create(NativeType.VOID, NativeType.POINTER, NativeType.INT));
            @Pointer TruffleObject mokapotGetRTLDDefault = this.getNativeAccess().lookupAndBindSymbol(mokapotLibrary, "mokapotGetRTLD_DEFAULT", NativeSignature.create(NativeType.POINTER, new NativeType[0]));
            @Pointer TruffleObject mokapotGetProcessHandle = this.getNativeAccess().lookupAndBindSymbol(mokapotLibrary, "mokapotGetProcessHandle", NativeSignature.create(NativeType.POINTER, new NativeType[0]));
            this.getPackageAt = this.getNativeAccess().lookupAndBindSymbol(mokapotLibrary, "getPackageAt", NativeSignature.create(NativeType.POINTER, NativeType.POINTER, NativeType.INT));
            this.mokapotEnvPtr = this.initializeAndGetEnv(true, initializeMokapotContext, jniEnv.getNativePointer());
            this.rtldDefaultValue = this.getUncached().asPointer(this.getUncached().execute((Object)mokapotGetRTLDDefault, new Object[0]));
            this.processHandleValue = this.getUncached().asPointer(this.getUncached().execute((Object)mokapotGetProcessHandle, new Object[0]));
            this.getLogger().finest(() -> String.format("Got RTLD_DEFAULT=0x%016x and ProcessHandle=0x%016x", this.rtldDefaultValue, this.processHandleValue));
            assert (this.getUncached().isPointer((Object)this.mokapotEnvPtr));
            assert (!this.getUncached().isNull((Object)this.mokapotEnvPtr));
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    @Override
    protected String getName() {
        return "VM";
    }

    public @Pointer TruffleObject getJavaVM() {
        try {
            @Pointer TruffleObject ptr = (TruffleObject)this.getUncached().execute((Object)this.getJavaVM, new Object[]{this.mokapotEnvPtr});
            assert (this.getUncached().isPointer((Object)ptr));
            return ptr;
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("getJavaVM failed", e);
        }
    }

    public Structs getStructs() {
        return this.structs;
    }

    public JVMTI getJvmti() {
        return this.jvmti;
    }

    @Override
    protected List<CallableFromNative.Factory> getCollector() {
        return VM_IMPL_FACTORIES;
    }

    @Override
    protected int lookupCallBackArgsCount() {
        return 2;
    }

    @Override
    protected NativeSignature lookupCallbackSignature() {
        return NativeSignature.create(NativeType.POINTER, NativeType.POINTER, NativeType.POINTER);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected void processCallBackResult(String name, CallableFromNative.Factory factory, Object ... args) {
        assert (args.length == this.lookupCallBackArgsCount());
        try {
            InteropLibrary uncached = InteropLibrary.getUncached();
            Object ptr = args[1];
            if (factory != null && !uncached.isNull(ptr) && uncached.isPointer(ptr)) {
                long jvmMethodAddress = uncached.asPointer(ptr);
                this.knownVmMethods.put((Object)jvmMethodAddress, (Object)factory);
            }
        }
        catch (UnsupportedMessageException unsupportedMessageException) {
            // empty catch block
        }
    }

    @CompilerDirectives.TruffleBoundary
    public CallableFromNative.Factory lookupKnownVmMethod(long functionPointer) {
        return (CallableFromNative.Factory)this.knownVmMethods.get((Object)functionPointer);
    }

    public static VM create(JniEnv jniEnv) {
        return new VM(jniEnv);
    }

    public void dispose() {
        if (this.mokapotEnvPtr == null || this.getUncached().isNull((Object)this.mokapotEnvPtr)) {
            return;
        }
        try {
            if (this.management != null) {
                assert (this.getContext().getEspressoEnv().EnableManagement);
                this.management.dispose();
            }
            if (this.jvmti != null) {
                this.jvmti.dispose();
            }
            this.getUncached().execute((Object)this.disposeMokapotContext, new Object[]{this.mokapotEnvPtr, RawPointer.nullInstance()});
            this.mokapotEnvPtr = RawPointer.nullInstance();
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw EspressoError.shouldNotReachHere("Cannot dispose Espresso libjvm (mokapot).");
        }
        assert (this.mokapotEnvPtr == null || this.getUncached().isNull((Object)this.mokapotEnvPtr));
    }

    private StaticObject nonReflectionClassLoader(StaticObject loader) {
        if (StaticObject.notNull(loader)) {
            Meta meta = this.getMeta();
            if (meta.sun_reflect_DelegatingClassLoader.isAssignableFrom(loader.getKlass())) {
                return meta.java_lang_ClassLoader_parent.getObject(loader);
            }
        }
        return loader;
    }

    public TruffleObject getMokapotCaptureState() {
        return this.mokapotCaptureState;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    @VmImpl(isJni=true)
    public static long JVM_CurrentTimeMillis(@JavaType(value=Class.class) StaticObject ignored) {
        return System.currentTimeMillis();
    }

    @VmImpl(isJni=true)
    public static long JVM_NanoTime(@JavaType(value=Class.class) StaticObject ignored) {
        return System.nanoTime();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    @VmImpl(isJni=true)
    public static int JVM_IHashCode(@JavaType(value=Object.class) StaticObject object, @Inject EspressoLanguage lang) {
        EspressoLanguage language;
        Object foreignObject;
        InteropLibrary library;
        if (object.isForeignObject() && (library = InteropLibrary.getUncached((Object)(foreignObject = object.rawForeignObject(language = lang == null ? EspressoLanguage.get(null) : lang)))).hasIdentity(foreignObject)) {
            try {
                return library.identityHashCode(foreignObject);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere();
            }
        }
        return System.identityHashCode(MetaUtil.maybeUnwrapNull(object));
    }

    @VmImpl(isJni=true)
    public static void JVM_ArrayCopy(@JavaType(value=Class.class) StaticObject ignored, @JavaType(value=Object.class) StaticObject src, int srcPos, @JavaType(value=Object.class) StaticObject dest, int destPos, int length, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profile) {
        Target_java_lang_System.arraycopy(src, srcPos, dest, destPos, length, language, meta, profile);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    @VmImpl
    public static long JVM_TotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    @VmImpl
    public static long JVM_MaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    @VmImpl
    public static void JVM_GC() {
        System.gc();
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public @JavaType(value=String.class) StaticObject JVM_GetSystemPackage(@JavaType(value=String.class) StaticObject name) {
        String hostPkgName = this.getMeta().toHostString(name);
        if (hostPkgName.endsWith("/")) {
            hostPkgName = hostPkgName.substring(0, hostPkgName.length() - 1);
        }
        String fileName = this.getRegistries().getBootClassRegistry().getPackagePath(hostPkgName);
        return this.getMeta().toGuestString(fileName);
    }

    @VmImpl(isJni=true)
    public @JavaType(value=String[].class) StaticObject JVM_GetSystemPackages() {
        String[] packages = this.getRegistries().getBootClassRegistry().getPackages();
        StaticObject[] array = new StaticObject[packages.length];
        for (int i = 0; i < packages.length; ++i) {
            array[i] = this.getMeta().toGuestString(packages[i]);
        }
        return StaticObject.createArray(this.getMeta().java_lang_String.getArrayClass(), array, this.getContext());
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    @VmImpl
    public static long JVM_FreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    @VmImpl
    public static int JVM_ActiveProcessorCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    @VmImpl
    @NoSafepoint
    public static boolean JVM_IsNaN(double d) {
        return Double.isNaN(d);
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl
    public static boolean JVM_SupportsCX8() {
        return LongCASProbe.HOST_SUPPORTS_LONG_CAS;
    }

    @VmImpl(isJni=true)
    public @JavaType(value=String.class) StaticObject JVM_InternString(@JavaType(value=String.class) StaticObject self) {
        return this.getInterpreterToVM().intern(self);
    }

    @VmImpl
    public static boolean JVM_IsPreviewEnabled(@Inject EspressoLanguage language) {
        return language.isPreviewEnabled();
    }

    @VmImpl
    public static boolean JVM_IsForeignLinkerSupported() {
        return true;
    }

    private static Object readForeignArrayElement(StaticObject array, int index, InteropLibrary interop, EspressoLanguage language, Meta meta, SubstitutionProfiler profiler, char exceptionBranch) {
        try {
            return interop.readArrayElement(array.rawForeignObject(language), (long)index);
        }
        catch (UnsupportedMessageException e) {
            profiler.profile(exceptionBranch);
            throw meta.throwExceptionWithMessage(meta.getMeta().java_lang_ClassCastException, "The foreign object is not a readable array");
        }
        catch (InvalidArrayIndexException e) {
            profiler.profile(exceptionBranch);
            throw meta.throwExceptionWithMessage(meta.java_lang_CloneNotSupportedException, "Foreign array length changed during clone");
        }
    }

    private static StaticObject cloneForeignArray(StaticObject array, EspressoLanguage language, Meta meta, InteropLibrary interop, ToEspressoNode.DynamicToEspresso toEspressoNode, SubstitutionProfiler profiler, char exceptionBranch) {
        int length;
        assert (array.isForeignObject());
        assert (array.isArray());
        try {
            long longLength = interop.getArraySize(array.rawForeignObject(language));
            if (longLength > Integer.MAX_VALUE) {
                profiler.profile(exceptionBranch);
                throw meta.throwExceptionWithMessage(meta.java_lang_CloneNotSupportedException, "Cannot clone a foreign array whose length does not fit in int");
            }
            if (longLength < 0L) {
                profiler.profile(exceptionBranch);
                throw meta.throwExceptionWithMessage(meta.java_lang_NegativeArraySizeException, "Cannot clone a foreign array with negative length");
            }
            length = (int)longLength;
        }
        catch (UnsupportedMessageException e) {
            profiler.profile(exceptionBranch);
            throw meta.throwExceptionWithMessage(meta.java_lang_CloneNotSupportedException, "Cannot clone a non-array foreign object as an array");
        }
        ArrayKlass arrayKlass = (ArrayKlass)array.getKlass();
        Klass componentType = arrayKlass.getComponentType();
        if (componentType.isPrimitive()) {
            try {
                switch (componentType.getJavaKind()) {
                    case Boolean: {
                        boolean[] booleanArray = new boolean[length];
                        for (int i = 0; i < length; ++i) {
                            Object foreignElement = VM.readForeignArrayElement(array, i, interop, language, meta, profiler, exceptionBranch);
                            booleanArray[i] = (Boolean)toEspressoNode.execute(foreignElement, componentType);
                        }
                        return StaticObject.createArray(arrayKlass, booleanArray, meta.getContext());
                    }
                    case Byte: {
                        byte[] byteArray = new byte[length];
                        for (int i = 0; i < length; ++i) {
                            Object foreignElement = VM.readForeignArrayElement(array, i, interop, language, meta, profiler, exceptionBranch);
                            byteArray[i] = (Byte)toEspressoNode.execute(foreignElement, componentType);
                        }
                        return StaticObject.createArray(arrayKlass, byteArray, meta.getContext());
                    }
                    case Short: {
                        short[] shortArray = new short[length];
                        for (int i = 0; i < length; ++i) {
                            Object foreignElement = VM.readForeignArrayElement(array, i, interop, language, meta, profiler, exceptionBranch);
                            shortArray[i] = (Short)toEspressoNode.execute(foreignElement, componentType);
                        }
                        return StaticObject.createArray(arrayKlass, shortArray, meta.getContext());
                    }
                    case Char: {
                        char[] charArray = new char[length];
                        for (int i = 0; i < length; ++i) {
                            Object foreignElement = VM.readForeignArrayElement(array, i, interop, language, meta, profiler, exceptionBranch);
                            charArray[i] = ((Character)toEspressoNode.execute(foreignElement, componentType)).charValue();
                        }
                        return StaticObject.createArray(arrayKlass, charArray, meta.getContext());
                    }
                    case Int: {
                        int[] intArray = new int[length];
                        for (int i = 0; i < length; ++i) {
                            Object foreignElement = VM.readForeignArrayElement(array, i, interop, language, meta, profiler, exceptionBranch);
                            intArray[i] = (Integer)toEspressoNode.execute(foreignElement, componentType);
                        }
                        return StaticObject.createArray(arrayKlass, intArray, meta.getContext());
                    }
                    case Float: {
                        float[] floatArray = new float[length];
                        for (int i = 0; i < length; ++i) {
                            Object foreignElement = VM.readForeignArrayElement(array, i, interop, language, meta, profiler, exceptionBranch);
                            floatArray[i] = ((Float)toEspressoNode.execute(foreignElement, componentType)).floatValue();
                        }
                        return StaticObject.createArray(arrayKlass, floatArray, meta.getContext());
                    }
                    case Long: {
                        long[] longArray = new long[length];
                        for (int i = 0; i < length; ++i) {
                            Object foreignElement = VM.readForeignArrayElement(array, i, interop, language, meta, profiler, exceptionBranch);
                            longArray[i] = (Long)toEspressoNode.execute(foreignElement, componentType);
                        }
                        return StaticObject.createArray(arrayKlass, longArray, meta.getContext());
                    }
                    case Double: {
                        double[] doubleArray = new double[length];
                        for (int i = 0; i < length; ++i) {
                            Object foreignElement = VM.readForeignArrayElement(array, i, interop, language, meta, profiler, exceptionBranch);
                            doubleArray[i] = (Double)toEspressoNode.execute(foreignElement, componentType);
                        }
                        return StaticObject.createArray(arrayKlass, doubleArray, meta.getContext());
                    }
                    case Object: 
                    case Void: 
                    case ReturnAddress: 
                    case Illegal: {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw EspressoError.shouldNotReachHere("Unexpected primitive kind: " + componentType.getJavaKind());
                    }
                }
            }
            catch (UnsupportedTypeException e) {
                profiler.profile(exceptionBranch);
                throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "Cannot cast an element of a foreign array to the declared component type");
            }
        }
        StaticObject[] newArray = new StaticObject[length];
        for (int i = 0; i < length; ++i) {
            Object foreignElement = VM.readForeignArrayElement(array, i, interop, language, meta, profiler, exceptionBranch);
            try {
                newArray[i] = (StaticObject)toEspressoNode.execute(foreignElement, componentType);
                continue;
            }
            catch (UnsupportedTypeException e) {
                profiler.profile(exceptionBranch);
                throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "Cannot cast an element of a foreign array to the declared component type");
            }
        }
        return StaticObject.createArray(arrayKlass, newArray, meta.getContext());
    }

    @VmImpl(isJni=true)
    public static @JavaType(value=Object.class) StaticObject JVM_Clone(@JavaType(value=Object.class) StaticObject self, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        assert (StaticObject.notNull(self));
        char exceptionBranch = '\u0003';
        if (self.isArray()) {
            if (self.isForeignObject()) {
                return VM.cloneForeignArray(self, language, meta, InteropLibrary.getUncached((Object)self.rawForeignObject(language)), ToEspressoNodeFactory.DynamicToEspressoNodeGen.getUncached(), profiler, exceptionBranch);
            }
            return self.copy(meta.getContext());
        }
        if (self.isForeignObject()) {
            profiler.profile(exceptionBranch);
            throw meta.throwExceptionWithMessage(meta.java_lang_CloneNotSupportedException, "Clone not supported for non-array foreign objects");
        }
        if (!meta.java_lang_Cloneable.isAssignableFrom(self.getKlass())) {
            profiler.profile(0);
            throw meta.throwException(meta.java_lang_CloneNotSupportedException);
        }
        if (InterpreterToVM.instanceOf(self, meta.java_lang_ref_Reference) && (InterpreterToVM.instanceOf(self, meta.java_lang_ref_WeakReference) || InterpreterToVM.instanceOf(self, meta.java_lang_ref_SoftReference) || InterpreterToVM.instanceOf(self, meta.java_lang_ref_FinalReference) || InterpreterToVM.instanceOf(self, meta.java_lang_ref_PhantomReference))) {
            profiler.profile(1);
            throw meta.throwExceptionWithMessage(meta.java_lang_CloneNotSupportedException, self.getKlass().getName().toString());
        }
        StaticObject clone = self.copy(meta.getContext());
        assert (self.getKlass() instanceof ObjectKlass);
        if (((ObjectKlass)self.getKlass()).hasFinalizer(meta.getContext())) {
            profiler.profile(2);
            meta.java_lang_ref_Finalizer_register.invokeDirect(null, clone);
        }
        return clone;
    }

    @VmImpl(isJni=true)
    @SuppressFBWarnings(value={"IMSE"}, justification="Not dubious, .notifyAll is just forwarded from the guest.")
    public void JVM_MonitorNotifyAll(@JavaType(value=Object.class) StaticObject self, @Inject SubstitutionProfiler profiler) {
        try {
            InterpreterToVM.monitorNotifyAll(self.getLock(this.getContext()));
        }
        catch (IllegalMonitorStateException e) {
            profiler.profile(0);
            Meta meta = this.getMeta();
            throw meta.throwException(meta.java_lang_IllegalMonitorStateException);
        }
    }

    @VmImpl(isJni=true)
    @SuppressFBWarnings(value={"IMSE"}, justification="Not dubious, .notify is just forwarded from the guest.")
    public void JVM_MonitorNotify(@JavaType(value=Object.class) StaticObject self, @Inject SubstitutionProfiler profiler) {
        try {
            InterpreterToVM.monitorNotify(self.getLock(this.getContext()));
        }
        catch (IllegalMonitorStateException e) {
            profiler.profile(0);
            Meta meta = this.getMeta();
            throw meta.throwException(meta.java_lang_IllegalMonitorStateException);
        }
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    @SuppressFBWarnings(value={"IMSE"}, justification="Not dubious, .wait is just forwarded from the guest.")
    public void JVM_MonitorWait(@JavaType(value=Object.class) StaticObject self, long timeout, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        EspressoContext context = this.getContext();
        StaticObject currentThread = context.getCurrentPlatformThread();
        State state = timeout > 0L ? State.TIMED_WAITING : State.WAITING;
        try (Transition transition = Transition.transition(context, state);){
            boolean timedOut;
            boolean report = context.shouldReportVMEvents();
            if (report) {
                context.reportMonitorWait(self, timeout);
            }
            if (context.getEspressoEnv().EnableManagement) {
                Target_java_lang_Thread.incrementThreadCounter(currentThread, meta.HIDDEN_THREAD_WAITED_COUNT);
                timedOut = !InterpreterToVM.monitorWait(self.getLock(context), timeout, currentThread, self);
            } else {
                boolean bl = timedOut = !InterpreterToVM.monitorWait(self.getLock(context), timeout);
            }
            if (report) {
                context.reportMonitorWaited(self, timedOut);
            }
        }
        catch (GuestInterruptedException e) {
            profiler.profile(0);
            if (this.getThreadAccess().isInterrupted(currentThread, true)) {
                throw meta.throwExceptionWithMessage(meta.java_lang_InterruptedException, e.getMessage());
            }
            this.getThreadAccess().fullSafePoint(currentThread);
        }
        catch (IllegalMonitorStateException e) {
            profiler.profile(1);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalMonitorStateException, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            profiler.profile(2);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, e.getMessage());
        }
    }

    @VmImpl(isJni=true)
    public int JVM_GetClassModifiers(@JavaType(value=Class.class) StaticObject clazz) {
        Klass klass = clazz.getMirrorKlass(this.getMeta());
        if (klass.isPrimitive()) {
            int primitiveModifiers = 1041;
            assert (klass.getClassModifiers() == 1041);
            return klass.getClassModifiers();
        }
        return klass.getClassModifiers();
    }

    @VmImpl(isJni=true)
    public @JavaType(value=String.class) StaticObject JVM_InitClassName(@JavaType(value=Class.class) StaticObject self) {
        StaticObject name = this.JVM_GetClassName(self);
        this.getMeta().java_lang_Class_name.set(self, name);
        return name;
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Class[].class) StaticObject JVM_GetClassInterfaces(@JavaType(value=Class.class) StaticObject self) {
        final Klass[] superInterfaces = self.getMirrorKlass(this.getMeta()).getImplementedInterfaces();
        StaticObject instance = this.getMeta().java_lang_Class.allocateReferenceArray(superInterfaces.length, new IntFunction<StaticObject>(){

            @Override
            public StaticObject apply(int i) {
                return superInterfaces[i].mirror();
            }
        });
        return instance;
    }

    @VmImpl(isJni=true)
    public boolean JVM_IsInterface(@JavaType(value=Class.class) StaticObject self) {
        return self.getMirrorKlass(this.getMeta()).isInterface();
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Object[].class) StaticObject JVM_GetClassSigners(@JavaType(value=Class.class) StaticObject self, @Inject EspressoContext context) {
        Klass klass = self.getMirrorKlass(this.getMeta());
        if (klass.isPrimitive()) {
            return StaticObject.NULL;
        }
        StaticObject signersArray = (StaticObject)this.getMeta().HIDDEN_SIGNERS.getHiddenObject(self);
        if (signersArray == null || StaticObject.isNull(signersArray)) {
            return StaticObject.NULL;
        }
        return signersArray.copy(context);
    }

    @VmImpl(isJni=true)
    public void JVM_SetClassSigners(@JavaType(value=Class.class) StaticObject self, @JavaType(value=Object[].class) StaticObject signers) {
        Klass klass = self.getMirrorKlass(this.getMeta());
        if (!klass.isPrimitive() && !klass.isArray()) {
            this.getMeta().HIDDEN_SIGNERS.setHiddenObject(self, signers);
        }
    }

    @VmImpl(isJni=true)
    public boolean JVM_IsArrayClass(@JavaType(value=Class.class) StaticObject self) {
        return self.getMirrorKlass(this.getMeta()).isArray();
    }

    @VmImpl(isJni=true)
    public boolean JVM_IsHiddenClass(@JavaType(value=Class.class) StaticObject self) {
        return self.getMirrorKlass(this.getMeta()).isHidden();
    }

    @VmImpl(isJni=true)
    public boolean JVM_IsPrimitiveClass(@JavaType(value=Class.class) StaticObject self) {
        return self.getMirrorKlass(this.getMeta()).isPrimitive();
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Field[].class) StaticObject JVM_GetClassDeclaredFields(@JavaType(value=Class.class) StaticObject self, boolean publicOnly) {
        final Meta meta = this.getMeta();
        ArrayList<com.oracle.truffle.espresso.impl.Field> collectedMethods = new ArrayList<com.oracle.truffle.espresso.impl.Field>();
        Klass klass = self.getMirrorKlass(this.getMeta());
        klass.ensureLinked();
        for (com.oracle.truffle.espresso.impl.Field f : klass.getDeclaredFields()) {
            if (publicOnly && !f.isPublic()) continue;
            collectedMethods.add(f);
        }
        final com.oracle.truffle.espresso.impl.Field[] fields = collectedMethods.toArray(com.oracle.truffle.espresso.impl.Field.EMPTY_ARRAY);
        final EspressoContext context = meta.getContext();
        final com.oracle.truffle.espresso.impl.Method fieldInit = meta.getJavaVersion().java15OrLater() ? meta.java_lang_reflect_Field.lookupDeclaredMethod(Symbol.Name._init_, context.getSignatures().makeRaw(Symbol.Type._void, Symbol.Type.java_lang_Class, Symbol.Type.java_lang_String, Symbol.Type.java_lang_Class, Symbol.Type._int, Symbol.Type._boolean, Symbol.Type._int, Symbol.Type.java_lang_String, Symbol.Type._byte_array)) : meta.java_lang_reflect_Field.lookupDeclaredMethod(Symbol.Name._init_, context.getSignatures().makeRaw(Symbol.Type._void, Symbol.Type.java_lang_Class, Symbol.Type.java_lang_String, Symbol.Type.java_lang_Class, Symbol.Type._int, Symbol.Type._int, Symbol.Type.java_lang_String, Symbol.Type._byte_array));
        StaticObject fieldsArray = meta.java_lang_reflect_Field.allocateReferenceArray(fields.length, new IntFunction<StaticObject>(){

            @Override
            public StaticObject apply(int i) {
                StaticObject runtimeVisibleTypeAnnotations;
                com.oracle.truffle.espresso.impl.Field f = fields[i];
                StaticObject instance = meta.java_lang_reflect_Field.allocateInstance(VM.this.getContext());
                Attribute rawRuntimeVisibleAnnotations = f.getAttribute(Symbol.Name.RuntimeVisibleAnnotations);
                StaticObject runtimeVisibleAnnotations = rawRuntimeVisibleAnnotations != null ? StaticObject.wrap(rawRuntimeVisibleAnnotations.getData(), meta) : StaticObject.NULL;
                Attribute rawRuntimeVisibleTypeAnnotations = f.getAttribute(Symbol.Name.RuntimeVisibleTypeAnnotations);
                StaticObject staticObject = runtimeVisibleTypeAnnotations = rawRuntimeVisibleTypeAnnotations != null ? StaticObject.wrap(rawRuntimeVisibleTypeAnnotations.getData(), meta) : StaticObject.NULL;
                if (meta.getJavaVersion().java15OrLater()) {
                    fieldInit.invokeDirect(instance, f.getDeclaringKlass().mirror(), context.getStrings().intern(f.getName()), f.resolveTypeKlass().mirror(), f.getModifiers(), f.isTrustedFinal(), f.getSlot(), meta.toGuestString(f.getGenericSignature()), runtimeVisibleAnnotations);
                } else {
                    fieldInit.invokeDirect(instance, f.getDeclaringKlass().mirror(), context.getStrings().intern(f.getName()), f.resolveTypeKlass().mirror(), f.getModifiers(), f.getSlot(), meta.toGuestString(f.getGenericSignature()), runtimeVisibleAnnotations);
                }
                meta.HIDDEN_FIELD_KEY.setHiddenObject(instance, f);
                meta.HIDDEN_FIELD_RUNTIME_VISIBLE_TYPE_ANNOTATIONS.setHiddenObject(instance, runtimeVisibleTypeAnnotations);
                return instance;
            }
        });
        return fieldsArray;
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Constructor[].class) StaticObject JVM_GetClassDeclaredConstructors(@JavaType(value=Class.class) StaticObject self, boolean publicOnly) {
        final Meta meta = this.getMeta();
        ArrayList<com.oracle.truffle.espresso.impl.Method> collectedMethods = new ArrayList<com.oracle.truffle.espresso.impl.Method>();
        Klass klass = self.getMirrorKlass(this.getMeta());
        klass.ensureLinked();
        for (com.oracle.truffle.espresso.impl.Method m : klass.getDeclaredConstructors()) {
            if (!Symbol.Name._init_.equals(m.getName()) || publicOnly && !m.isPublic()) continue;
            collectedMethods.add(m);
        }
        final com.oracle.truffle.espresso.impl.Method[] constructors = collectedMethods.toArray(com.oracle.truffle.espresso.impl.Method.EMPTY_ARRAY);
        EspressoContext context = meta.getContext();
        final com.oracle.truffle.espresso.impl.Method constructorInit = meta.java_lang_reflect_Constructor.lookupDeclaredMethod(Symbol.Name._init_, context.getSignatures().makeRaw(Symbol.Type._void, Symbol.Type.java_lang_Class, Symbol.Type.java_lang_Class_array, Symbol.Type.java_lang_Class_array, Symbol.Type._int, Symbol.Type._int, Symbol.Type.java_lang_String, Symbol.Type._byte_array, Symbol.Type._byte_array));
        StaticObject arr = meta.java_lang_reflect_Constructor.allocateReferenceArray(constructors.length, new IntFunction<StaticObject>(){

            @Override
            public StaticObject apply(int i) {
                com.oracle.truffle.espresso.impl.Method m = constructors[i];
                Attribute rawRuntimeVisibleAnnotations = m.getAttribute(Symbol.Name.RuntimeVisibleAnnotations);
                StaticObject runtimeVisibleAnnotations = rawRuntimeVisibleAnnotations != null ? StaticObject.wrap(rawRuntimeVisibleAnnotations.getData(), meta) : StaticObject.NULL;
                Attribute rawRuntimeVisibleParameterAnnotations = m.getAttribute(Symbol.Name.RuntimeVisibleParameterAnnotations);
                StaticObject runtimeVisibleParameterAnnotations = rawRuntimeVisibleParameterAnnotations != null ? StaticObject.wrap(rawRuntimeVisibleParameterAnnotations.getData(), meta) : StaticObject.NULL;
                Attribute rawRuntimeVisibleTypeAnnotations = m.getAttribute(Symbol.Name.RuntimeVisibleTypeAnnotations);
                StaticObject runtimeVisibleTypeAnnotations = rawRuntimeVisibleTypeAnnotations != null ? StaticObject.wrap(rawRuntimeVisibleTypeAnnotations.getData(), meta) : StaticObject.NULL;
                final Klass[] rawParameterKlasses = m.resolveParameterKlasses();
                StaticObject parameterTypes = meta.java_lang_Class.allocateReferenceArray(m.getParameterCount(), new IntFunction<StaticObject>(){

                    @Override
                    public StaticObject apply(int j) {
                        return rawParameterKlasses[j].mirror();
                    }
                });
                final Klass[] rawCheckedExceptions = m.getCheckedExceptions();
                StaticObject checkedExceptions = meta.java_lang_Class.allocateReferenceArray(rawCheckedExceptions.length, new IntFunction<StaticObject>(){

                    @Override
                    public StaticObject apply(int j) {
                        return rawCheckedExceptions[j].mirror();
                    }
                });
                SignatureAttribute signatureAttribute = (SignatureAttribute)m.getAttribute(Symbol.Name.Signature);
                StaticObject genericSignature = StaticObject.NULL;
                if (signatureAttribute != null) {
                    String sig = m.getConstantPool().symbolAt(signatureAttribute.getSignatureIndex(), "signature").toString();
                    genericSignature = meta.toGuestString(sig);
                }
                StaticObject instance = meta.java_lang_reflect_Constructor.allocateInstance(VM.this.getContext());
                constructorInit.invokeDirect(instance, m.getDeclaringKlass().mirror(), parameterTypes, checkedExceptions, m.getMethodModifiers(), i, genericSignature, runtimeVisibleAnnotations, runtimeVisibleParameterAnnotations);
                meta.HIDDEN_CONSTRUCTOR_KEY.setHiddenObject(instance, m);
                meta.HIDDEN_CONSTRUCTOR_RUNTIME_VISIBLE_TYPE_ANNOTATIONS.setHiddenObject(instance, runtimeVisibleTypeAnnotations);
                return instance;
            }
        });
        return arr;
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Method[].class) StaticObject JVM_GetClassDeclaredMethods(@JavaType(value=Class.class) StaticObject self, boolean publicOnly) {
        final Meta meta = this.getMeta();
        ArrayList<com.oracle.truffle.espresso.impl.Method> collectedMethods = new ArrayList<com.oracle.truffle.espresso.impl.Method>();
        Klass klass = self.getMirrorKlass(this.getMeta());
        klass.ensureLinked();
        for (com.oracle.truffle.espresso.impl.Method m : klass.getDeclaredMethods()) {
            if (publicOnly && !m.isPublic() || Symbol.Name._init_.equals(m.getName()) || Symbol.Name._clinit_.equals(m.getName())) continue;
            collectedMethods.add(m);
        }
        final com.oracle.truffle.espresso.impl.Method[] methods = collectedMethods.toArray(com.oracle.truffle.espresso.impl.Method.EMPTY_ARRAY);
        return meta.java_lang_reflect_Method.allocateReferenceArray(methods.length, new IntFunction<StaticObject>(){

            @Override
            public StaticObject apply(int i) {
                return methods[i].makeMirror(meta);
            }
        });
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Class[].class) StaticObject JVM_GetDeclaredClasses(@JavaType(value=Class.class) StaticObject self) {
        Meta meta = this.getMeta();
        Klass klass = self.getMirrorKlass(this.getMeta());
        if (klass.isPrimitive() || klass.isArray()) {
            return meta.java_lang_Class.allocateReferenceArray(0);
        }
        ObjectKlass instanceKlass = (ObjectKlass)klass;
        InnerClassesAttribute innerClasses = (InnerClassesAttribute)instanceKlass.getAttribute(InnerClassesAttribute.NAME);
        if (innerClasses == null || innerClasses.entries().length == 0) {
            return meta.java_lang_Class.allocateReferenceArray(0);
        }
        RuntimeConstantPool pool = instanceKlass.getConstantPool();
        final ArrayList<Klass> innerKlasses = new ArrayList<Klass>();
        for (InnerClassesAttribute.Entry entry : innerClasses.entries()) {
            Klass outerKlass;
            Symbol<Symbol.Name> outerDescriptor;
            if (entry.innerClassIndex == 0 || entry.outerClassIndex == 0 || !(outerDescriptor = pool.classAt(entry.outerClassIndex).getName(pool)).equals(instanceKlass.getName()) || (outerKlass = pool.resolvedKlassAt(instanceKlass, entry.outerClassIndex)) != instanceKlass) continue;
            Klass innerKlass = pool.resolvedKlassAt(instanceKlass, entry.innerClassIndex);
            innerKlasses.add(innerKlass);
        }
        return meta.java_lang_Class.allocateReferenceArray(innerKlasses.size(), new IntFunction<StaticObject>(){

            @Override
            public StaticObject apply(int index) {
                return ((Klass)innerKlasses.get(index)).mirror();
            }
        });
    }

    private static Klass computeEnclosingClass(ObjectKlass klass) {
        InnerClassesAttribute innerClasses = (InnerClassesAttribute)klass.getAttribute(InnerClassesAttribute.NAME);
        if (innerClasses == null) {
            return null;
        }
        RuntimeConstantPool pool = klass.getConstantPool();
        boolean found = false;
        Klass outerKlass = null;
        for (InnerClassesAttribute.Entry entry : innerClasses.entries()) {
            Symbol<Symbol.Name> innerDescriptor;
            if (entry.innerClassIndex != 0 && (innerDescriptor = pool.classAt(entry.innerClassIndex).getName(pool)).equals(klass.getName())) {
                Klass innerKlass = pool.resolvedKlassAt(klass, entry.innerClassIndex);
                boolean bl = found = innerKlass == klass;
                if (found && entry.outerClassIndex != 0) {
                    outerKlass = pool.resolvedKlassAt(klass, entry.outerClassIndex);
                }
            }
            if (found) break;
        }
        return outerKlass;
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Class.class) StaticObject JVM_GetDeclaringClass(@JavaType(value=Class.class) StaticObject self) {
        if (!(self.getMirrorKlass(this.getMeta()) instanceof ObjectKlass)) {
            return StaticObject.NULL;
        }
        ObjectKlass k = (ObjectKlass)self.getMirrorKlass(this.getMeta());
        Klass outerKlass = VM.computeEnclosingClass(k);
        if (outerKlass == null) {
            return StaticObject.NULL;
        }
        return outerKlass.mirror();
    }

    @VmImpl(isJni=true)
    public @JavaType(value=String.class) StaticObject JVM_GetSimpleBinaryName(@JavaType(value=Class.class) StaticObject self) {
        Klass k = self.getMirrorKlass(this.getMeta());
        if (k.isPrimitive() || k.isArray()) {
            return StaticObject.NULL;
        }
        ObjectKlass klass = (ObjectKlass)k;
        RuntimeConstantPool pool = klass.getConstantPool();
        InnerClassesAttribute inner = klass.getInnerClasses();
        for (InnerClassesAttribute.Entry entry : inner.entries()) {
            int innerClassIndex = entry.innerClassIndex;
            if (innerClassIndex == 0 || pool.classAt(innerClassIndex).getName(pool) != klass.getName() || pool.resolvedKlassAt(k, innerClassIndex) != k) continue;
            if (entry.innerNameIndex == 0) break;
            Symbol innerName = pool.symbolAt(entry.innerNameIndex);
            return this.getMeta().toGuestString(innerName);
        }
        return StaticObject.NULL;
    }

    @VmImpl(isJni=true)
    public @JavaType(value=String.class) StaticObject JVM_GetClassSignature(@JavaType(value=Class.class) StaticObject self) {
        ObjectKlass klass;
        SignatureAttribute signature;
        if (self.getMirrorKlass(this.getMeta()) instanceof ObjectKlass && (signature = (SignatureAttribute)(klass = (ObjectKlass)self.getMirrorKlass(this.getMeta())).getAttribute(Symbol.Name.Signature)) != null) {
            String sig = klass.getConstantPool().symbolAt(signature.getSignatureIndex(), "signature").toString();
            return this.getMeta().toGuestString(sig);
        }
        return StaticObject.NULL;
    }

    @VmImpl(isJni=true)
    public @JavaType(value=byte[].class) StaticObject JVM_GetClassAnnotations(@JavaType(value=Class.class) StaticObject self) {
        Attribute annotations;
        Klass klass = self.getMirrorKlass(this.getMeta());
        if (klass instanceof ObjectKlass && (annotations = ((ObjectKlass)klass).getAttribute(Symbol.Name.RuntimeVisibleAnnotations)) != null) {
            return StaticObject.wrap(annotations.getData(), this.getMeta());
        }
        return StaticObject.NULL;
    }

    @VmImpl(isJni=true)
    public @JavaType(value=byte[].class) StaticObject JVM_GetClassTypeAnnotations(@JavaType(value=Class.class) StaticObject self) {
        Attribute annotations;
        Klass klass = self.getMirrorKlass(this.getMeta());
        if (klass instanceof ObjectKlass && (annotations = ((ObjectKlass)klass).getAttribute(Symbol.Name.RuntimeVisibleTypeAnnotations)) != null) {
            return StaticObject.wrap(annotations.getData(), this.getMeta());
        }
        return StaticObject.NULL;
    }

    @VmImpl(isJni=true)
    public @JavaType(internalName="Lsun/reflect/ConstantPool;") StaticObject JVM_GetClassConstantPool(@JavaType(value=Class.class) StaticObject self) {
        Klass klass = self.getMirrorKlass(this.getMeta());
        if (klass.isArray() || klass.isPrimitive()) {
            return StaticObject.NULL;
        }
        StaticObject cp = this.getAllocator().createNew(this.getMeta().sun_reflect_ConstantPool);
        this.getMeta().sun_reflect_ConstantPool_constantPoolOop.setObject(cp, self);
        return cp;
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public boolean JVM_DesiredAssertionStatus(@JavaType(value=Class.class) StaticObject unused, @JavaType(value=Class.class) StaticObject clazz) {
        if (StaticObject.isNull(clazz.getMirrorKlass(this.getMeta()).getDefiningClassLoader())) {
            return (Boolean)EspressoOptions.EnableSystemAssertions.getValue(this.getMeta().getContext().getEnv().getOptions());
        }
        return (Boolean)EspressoOptions.EnableAssertions.getValue(this.getMeta().getContext().getEnv().getOptions());
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Object[].class) StaticObject JVM_GetEnclosingMethodInfo(@JavaType(value=Class.class) StaticObject self, @Inject EspressoLanguage language) {
        Meta meta = this.getMeta();
        InterpreterToVM vm = meta.getInterpreterToVM();
        if (self.getMirrorKlass(this.getMeta()) instanceof ObjectKlass) {
            ObjectKlass klass = (ObjectKlass)self.getMirrorKlass(this.getMeta());
            EnclosingMethodAttribute enclosingMethodAttr = klass.getEnclosingMethod();
            if (enclosingMethodAttr == null) {
                return StaticObject.NULL;
            }
            int classIndex = enclosingMethodAttr.getClassIndex();
            if (classIndex == 0) {
                return StaticObject.NULL;
            }
            StaticObject arr = meta.java_lang_Object.allocateReferenceArray(3);
            RuntimeConstantPool pool = klass.getConstantPool();
            Klass enclosingKlass = pool.resolvedKlassAt(klass, classIndex);
            vm.setArrayObject(language, enclosingKlass.mirror(), 0, arr);
            int methodIndex = enclosingMethodAttr.getMethodIndex();
            if (methodIndex != 0) {
                NameAndTypeConstant nmt = pool.nameAndTypeAt(methodIndex);
                StaticObject name = meta.toGuestString(nmt.getName(pool));
                StaticObject desc = meta.toGuestString(nmt.getDescriptor(pool));
                vm.setArrayObject(language, name, 1, arr);
                vm.setArrayObject(language, desc, 2, arr);
            }
            return arr;
        }
        return StaticObject.NULL;
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public @JavaType(internalName="[Ljava/lang/reflect/RecordComponent;") StaticObject JVM_GetRecordComponents(@JavaType(value=Class.class) StaticObject self) {
        Klass k = self.getMirrorKlass(this.getMeta());
        if (!(k instanceof ObjectKlass)) {
            return StaticObject.NULL;
        }
        ObjectKlass klass = (ObjectKlass)k;
        RecordAttribute record = (RecordAttribute)klass.getAttribute(RecordAttribute.NAME);
        if (record == null) {
            return StaticObject.NULL;
        }
        RecordAttribute.RecordComponentInfo[] components = record.getComponents();
        return this.getMeta().java_lang_reflect_RecordComponent.allocateReferenceArray(components.length, i -> components[i].toGuestComponent(this.getMeta(), klass));
    }

    @VmImpl(isJni=true)
    public boolean JVM_IsRecord(@JavaType(value=Class.class) StaticObject self) {
        Klass klass = self.getMirrorKlass(this.getMeta());
        if (klass instanceof ObjectKlass) {
            return ((ObjectKlass)klass).isRecord();
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public @JavaType(value=Class[].class) StaticObject JVM_GetPermittedSubclasses(@JavaType(value=Class.class) StaticObject self) {
        Klass k = self.getMirrorKlass(this.getMeta());
        if (!(k instanceof ObjectKlass)) {
            return StaticObject.NULL;
        }
        ObjectKlass klass = (ObjectKlass)k;
        if (!klass.isSealed()) {
            return StaticObject.NULL;
        }
        char[] classes = ((PermittedSubclassesAttribute)klass.getAttribute(PermittedSubclassesAttribute.NAME)).getClasses();
        StaticObject[] permittedSubclasses = new StaticObject[classes.length];
        RuntimeConstantPool pool = klass.getConstantPool();
        int nClasses = 0;
        for (char index : classes) {
            Klass permitted;
            try {
                permitted = pool.resolvedKlassAt(klass, index);
            }
            catch (EspressoException e) {
                continue;
            }
            if (!(permitted instanceof ObjectKlass)) continue;
            permittedSubclasses[nClasses++] = permitted.mirror();
        }
        if (nClasses == permittedSubclasses.length) {
            return StaticObject.createArray(this.getMeta().java_lang_Class_array, permittedSubclasses, this.getContext());
        }
        return this.getMeta().java_lang_Class.allocateReferenceArray(nClasses, i -> permittedSubclasses[i]);
    }

    @VmImpl(isJni=true)
    public int JVM_GetClassAccessFlags(@JavaType(value=Class.class) StaticObject clazz) {
        Klass klass = clazz.getMirrorKlass(this.getMeta());
        if (klass.isPrimitive()) {
            int primitiveFlags = 1041;
            assert (klass.getModifiers() == 1041);
            return klass.getModifiers();
        }
        return klass.getModifiers() & Short.MAX_VALUE;
    }

    @VmImpl(isJni=true)
    public boolean JVM_AreNestMates(@JavaType(value=Class.class) StaticObject current, @JavaType(value=Class.class) StaticObject member) {
        return current.getMirrorKlass(this.getMeta()).nest() == member.getMirrorKlass(this.getMeta()).nest();
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Class.class) StaticObject JVM_GetNestHost(@JavaType(value=Class.class) StaticObject current) {
        return current.getMirrorKlass(this.getMeta()).nest().mirror();
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Class[].class) StaticObject JVM_GetNestMembers(@JavaType(value=Class.class) StaticObject current) {
        Klass k = current.getMirrorKlass(this.getMeta());
        Klass[] nestMembers = k.getNestMembers();
        StaticObject[] array = new StaticObject[nestMembers.length];
        for (int i = 0; i < nestMembers.length; ++i) {
            array[i] = nestMembers[i].mirror();
        }
        return StaticObject.createArray(this.getMeta().java_lang_Class_array, array, this.getContext());
    }

    @VmImpl(isJni=true)
    public @JavaType(internalName="Ljava/security/ProtectionDomain;") StaticObject JVM_GetProtectionDomain(@JavaType(value=Class.class) StaticObject current) {
        if (StaticObject.isNull(current)) {
            return StaticObject.NULL;
        }
        StaticObject pd = (StaticObject)this.getMeta().HIDDEN_PROTECTION_DOMAIN.getHiddenObject(current);
        return pd == null ? StaticObject.NULL : pd;
    }

    @VmImpl(isJni=true)
    public @JavaType(value=String.class) StaticObject JVM_GetClassName(@JavaType(value=Class.class) StaticObject self) {
        Klass klass = self.getMirrorKlass(this.getMeta());
        String externalName = klass.getExternalName();
        StaticObject guestString = this.getMeta().toGuestString(externalName);
        return this.getStrings().intern(guestString);
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Class.class) StaticObject JVM_GetComponentType(@JavaType(value=Class.class) StaticObject self) {
        if (self.getMirrorKlass(this.getMeta()).isArray()) {
            Klass componentType = ((ArrayKlass)self.getMirrorKlass(this.getMeta())).getComponentType();
            return componentType.mirror();
        }
        return StaticObject.NULL;
    }

    @VmImpl
    public static int DestroyJavaVM(@Inject EspressoContext context) {
        assert (context.getCurrentPlatformThread() != null);
        try {
            context.destroyVM();
        }
        catch (AbstractTruffleException abstractTruffleException) {
            // empty catch block
        }
        return 0;
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl
    public int AttachCurrentThread(@Pointer TruffleObject vmPtr_, @Pointer TruffleObject penvPtr, @Pointer TruffleObject argsPtr) {
        assert (NativeUtils.interopAsPointer(this.getJavaVM()) == NativeUtils.interopAsPointer(vmPtr_));
        return this.attachCurrentThread(penvPtr, argsPtr, false);
    }

    private int attachCurrentThread(@Pointer TruffleObject penvPtr, @Pointer TruffleObject argsPtr, boolean daemon) {
        StaticObject group = null;
        String name = null;
        if (InteropLibrary.getUncached().isNull((Object)argsPtr)) {
            this.getLogger().fine("AttachCurrentThread with null args");
        } else {
            JavaVMAttachArgs.JavaVMAttachArgsWrapper attachArgs = this.getStructs().javaVMAttachArgs.wrap(this.jni(), argsPtr);
            if (this.JVM_IsSupportedJNIVersion(attachArgs.version())) {
                group = attachArgs.group();
                name = NativeUtils.fromUTF8Ptr(attachArgs.name());
            } else {
                this.getLogger().warning(String.format("AttachCurrentThread with unsupported JavaVMAttachArgs version: 0x%08x", attachArgs.version()));
            }
        }
        StaticObject thread = this.getContext().createThread(Thread.currentThread(), group, name);
        if (daemon) {
            this.getContext().getThreadAccess().setDaemon(thread, true);
        }
        NativeUtils.writeToPointerPointer(this.getUncached(), penvPtr, this.jniEnv.getNativePointer());
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    @VmImpl
    public int DetachCurrentThread(final @Inject EspressoContext context) {
        StaticObject currentThread = context.getCurrentPlatformThread();
        if (currentThread == null) {
            return 0;
        }
        this.getLogger().fine(() -> {
            String guestName = this.getThreadAccess().getThreadName(currentThread);
            return "DetachCurrentThread: " + guestName;
        });
        com.oracle.truffle.espresso.impl.Method lastJavaMethod = (com.oracle.truffle.espresso.impl.Method)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<com.oracle.truffle.espresso.impl.Method>(){

            public com.oracle.truffle.espresso.impl.Method visitFrame(FrameInstance frameInstance) {
                com.oracle.truffle.espresso.impl.Method method = VM.this.getMethodFromFrame(frameInstance);
                if (method != null && method.getContext() == context) {
                    return method;
                }
                return null;
            }
        });
        if (lastJavaMethod != null) {
            this.getLogger().warning(() -> {
                String guestName = this.getThreadAccess().getThreadName(currentThread);
                return "DetachCurrentThread called while thread is still executing Java code (" + guestName + ")";
            });
            return -1;
        }
        StaticObject pendingException = this.jniEnv.getPendingException();
        this.jniEnv.clearPendingException();
        Meta meta = context.getMeta();
        try {
            if (pendingException != null) {
                meta.java_lang_Thread_dispatchUncaughtException.invokeDirect(currentThread, pendingException);
            }
            this.getThreadAccess().terminate(currentThread);
        }
        catch (EspressoException e) {
            try {
                StaticObject ex = e.getGuestException();
                String exception = ex.getKlass().getExternalName();
                String threadName = this.getThreadAccess().getThreadName(currentThread);
                context.getLogger().warning(String.format("Exception: %s thrown while terminating thread \"%s\"", exception, threadName));
                com.oracle.truffle.espresso.impl.Method printStackTrace = ex.getKlass().lookupMethod(Symbol.Name.printStackTrace, Symbol.Signature._void);
                printStackTrace.invokeDirect(ex, new Object[0]);
            }
            catch (EspressoException ee) {
                String exception = ee.getGuestException().getKlass().getExternalName();
                context.getLogger().warning(String.format("Exception: %s thrown while trying to print stack trace", exception));
            }
            catch (EspressoExitException espressoExitException) {
                // empty catch block
            }
        }
        catch (EspressoExitException e) {
        }
        catch (Throwable t) {
            context.getLogger().severe("Host exception thrown while trying to terminate thread");
            t.printStackTrace();
        }
        finally {
            context.unregisterThread(currentThread);
        }
        return 0;
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl
    public int GetEnv(@Pointer TruffleObject vmPtr_, @Pointer TruffleObject envPtr, int version) {
        assert (NativeUtils.interopAsPointer(this.getJavaVM()) == NativeUtils.interopAsPointer(vmPtr_));
        if (this.getUncached().isNull((Object)envPtr)) {
            return -1;
        }
        TruffleObject interopPtr = null;
        if (JVMTI.isJvmtiVersion(version) && (interopPtr = this.jvmti.create(version)) == null) {
            return -3;
        }
        if (this.JVM_IsSupportedJNIVersion(version)) {
            StaticObject currentThread = this.getContext().getCurrentPlatformThread();
            if (currentThread == null) {
                return -2;
            }
            interopPtr = this.jniEnv.getNativePointer();
        }
        if (interopPtr != null) {
            NativeUtils.writeToPointerPointer(this.getUncached(), envPtr, interopPtr);
            return 0;
        }
        return -3;
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl
    public int AttachCurrentThreadAsDaemon(@Pointer TruffleObject vmPtr_, @Pointer TruffleObject penvPtr, @Pointer TruffleObject argsPtr) {
        assert (NativeUtils.interopAsPointer(this.getJavaVM()) == NativeUtils.interopAsPointer(vmPtr_));
        return this.attachCurrentThread(penvPtr, argsPtr, true);
    }

    @VmImpl(isJni=true)
    public static @JavaType(value=String.class) StaticObject JVM_GetExtendedNPEMessage(@JavaType(value=Throwable.class) StaticObject throwable) {
        return StaticObject.NULL;
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Throwable.class) StaticObject JVM_FillInStackTrace(@JavaType(value=Throwable.class) StaticObject self, int dummy) {
        return InterpreterToVM.fillInStackTrace(self, this.getMeta());
    }

    @VmImpl(isJni=true)
    public int JVM_GetStackTraceDepth(@JavaType(value=Throwable.class) StaticObject self) {
        Meta meta = this.getMeta();
        StackTrace frames = EspressoException.getFrames(self, meta);
        if (frames == null) {
            return 0;
        }
        return frames.size;
    }

    @VmImpl(isJni=true)
    public @JavaType(value=StackTraceElement.class) StaticObject JVM_GetStackTraceElement(@JavaType(value=Throwable.class) StaticObject self, int index, @Inject SubstitutionProfiler profiler) {
        Meta meta = this.getMeta();
        if (index < 0) {
            profiler.profile(0);
            throw meta.throwException(meta.java_lang_IndexOutOfBoundsException);
        }
        StaticObject ste = meta.java_lang_StackTraceElement.allocateInstance(this.getContext());
        StackTrace frames = EspressoException.getFrames(self, meta);
        if (frames == null || index >= frames.size) {
            profiler.profile(1);
            throw meta.throwException(meta.java_lang_IndexOutOfBoundsException);
        }
        StackElement stackElement = frames.trace[index];
        if (!stackElement.hasInfo()) {
            return StaticObject.NULL;
        }
        VM.fillInElement(ste, stackElement, meta);
        return ste;
    }

    private static void checkTag(ConstantPool pool, int index, ConstantPool.Tag expected, Meta meta, SubstitutionProfiler profiler) {
        ConstantPool.Tag target = pool.tagAt(index);
        if (target != expected) {
            profiler.profile(0);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "Wrong type at constant pool index");
        }
    }

    @VmImpl(isJni=true)
    public int JVM_ConstantPoolGetSize(@JavaType(value=Object.class) StaticObject unused, @JavaType(value=Object.class) StaticObject jcpool) {
        return jcpool.getMirrorKlass(this.getMeta()).getConstantPool().length();
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Class.class) StaticObject JVM_ConstantPoolGetClassAt(@JavaType(value=Object.class) StaticObject unused, @JavaType(value=Object.class) StaticObject jcpool, int index, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        VM.checkTag(jcpool.getMirrorKlass(this.getMeta()).getConstantPool(), index, ConstantPool.Tag.CLASS, meta, profiler);
        return ((RuntimeConstantPool)jcpool.getMirrorKlass(this.getMeta()).getConstantPool()).resolvedKlassAt(null, index).mirror();
    }

    @VmImpl(isJni=true)
    public double JVM_ConstantPoolGetDoubleAt(@JavaType(value=Object.class) StaticObject unused, @JavaType(value=Object.class) StaticObject jcpool, int index, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        VM.checkTag(jcpool.getMirrorKlass(this.getMeta()).getConstantPool(), index, ConstantPool.Tag.DOUBLE, meta, profiler);
        return jcpool.getMirrorKlass(this.getMeta()).getConstantPool().doubleAt(index);
    }

    @VmImpl(isJni=true)
    public float JVM_ConstantPoolGetFloatAt(@JavaType(value=Object.class) StaticObject unused, @JavaType(value=Object.class) StaticObject jcpool, int index, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        VM.checkTag(jcpool.getMirrorKlass(this.getMeta()).getConstantPool(), index, ConstantPool.Tag.FLOAT, meta, profiler);
        return jcpool.getMirrorKlass(this.getMeta()).getConstantPool().floatAt(index);
    }

    @VmImpl(isJni=true)
    public @JavaType(value=String.class) StaticObject JVM_ConstantPoolGetStringAt(@JavaType(value=Object.class) StaticObject unused, @JavaType(value=Object.class) StaticObject jcpool, int index, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        VM.checkTag(jcpool.getMirrorKlass(this.getMeta()).getConstantPool(), index, ConstantPool.Tag.STRING, meta, profiler);
        return ((RuntimeConstantPool)jcpool.getMirrorKlass(this.getMeta()).getConstantPool()).resolvedStringAt(index);
    }

    @VmImpl(isJni=true)
    public @JavaType(value=String.class) StaticObject JVM_ConstantPoolGetUTF8At(@JavaType(value=Object.class) StaticObject unused, @JavaType(value=Object.class) StaticObject jcpool, int index, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        VM.checkTag(jcpool.getMirrorKlass(this.getMeta()).getConstantPool(), index, ConstantPool.Tag.UTF8, meta, profiler);
        return this.getMeta().toGuestString(jcpool.getMirrorKlass(this.getMeta()).getConstantPool().symbolAt(index).toString());
    }

    @VmImpl(isJni=true)
    public int JVM_ConstantPoolGetIntAt(@JavaType(value=Object.class) StaticObject unused, @JavaType(value=Object.class) StaticObject jcpool, int index, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        VM.checkTag(jcpool.getMirrorKlass(this.getMeta()).getConstantPool(), index, ConstantPool.Tag.INTEGER, meta, profiler);
        return jcpool.getMirrorKlass(this.getMeta()).getConstantPool().intAt(index);
    }

    @VmImpl(isJni=true)
    public long JVM_ConstantPoolGetLongAt(@JavaType(value=Object.class) StaticObject unused, @JavaType(value=Object.class) StaticObject jcpool, int index, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        VM.checkTag(jcpool.getMirrorKlass(this.getMeta()).getConstantPool(), index, ConstantPool.Tag.LONG, meta, profiler);
        return jcpool.getMirrorKlass(this.getMeta()).getConstantPool().longAt(index);
    }

    private Symbol<Symbol.Type> namePtrToInternal(TruffleObject namePtr) {
        String name = NativeUtils.interopPointerToString(namePtr);
        Symbol<Symbol.Type> type = null;
        if (name != null) {
            Object internalName = name;
            if (!name.startsWith("[")) {
                internalName = "L" + name + ";";
            }
            if (!Validation.validTypeDescriptor(ByteSequence.create((String)internalName), false)) {
                throw this.getMeta().throwExceptionWithMessage(this.getMeta().java_lang_NoClassDefFoundError, name);
            }
            type = this.getTypes().fromClassGetName((String)internalName);
        }
        return type;
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public @JavaType(value=Class.class) StaticObject JVM_LookupDefineClass(@JavaType(value=Class.class) StaticObject lookup, @Pointer TruffleObject namePtr, @Pointer TruffleObject bufPtr, int len, @JavaType(internalName="Ljava/security/ProtectionDomain;") StaticObject pd, boolean initialize, int flags, @JavaType(value=Object.class) StaticObject classData) {
        ObjectKlass k;
        if (StaticObject.isNull(lookup)) {
            throw this.getMeta().throwExceptionWithMessage(this.getMeta().java_lang_InternalError, "Lookup class is null");
        }
        assert (!this.getUncached().isNull((Object)bufPtr));
        assert (lookup.getMirrorKlass(this.getMeta()) instanceof ObjectKlass);
        boolean isNestMate = (flags & 1) == 1;
        boolean isHidden = (flags & 2) == 2;
        boolean isStrong = (flags & 4) == 4;
        boolean vmAnnotations = (flags & 8) == 8;
        ObjectKlass nest = null;
        if (isNestMate) {
            nest = (ObjectKlass)lookup.getMirrorKlass(this.getMeta()).nest();
        }
        if (!isHidden) {
            if (!StaticObject.isNull(classData)) {
                throw this.getMeta().throwExceptionWithMessage(this.getMeta().java_lang_IllegalArgumentException, "classData is only applicable for hidden classes");
            }
            if (isNestMate) {
                throw this.getMeta().throwExceptionWithMessage(this.getMeta().java_lang_IllegalArgumentException, "dynamic nestmate is only applicable for hidden classes");
            }
            if (!isStrong) {
                throw this.getMeta().throwExceptionWithMessage(this.getMeta().java_lang_IllegalArgumentException, "an ordinary class must be strongly referenced by its defining loader");
            }
            if (vmAnnotations) {
                throw this.getMeta().throwExceptionWithMessage(this.getMeta().java_lang_IllegalArgumentException, "vm annotations only allowed for hidden classes");
            }
            if (flags != 4) {
                throw this.getMeta().throwExceptionWithMessage(this.getMeta().java_lang_IllegalArgumentException, String.format("invalid flag 0x%x", flags));
            }
        }
        ByteBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Byte);
        byte[] bytes = new byte[len];
        buf.get(bytes);
        Symbol<Symbol.Type> type = this.namePtrToInternal(namePtr);
        StaticObject loader = lookup.getMirrorKlass(this.getMeta()).getDefiningClassLoader();
        try {
            k = isHidden ? this.getContext().getRegistries().defineKlass(type, bytes, loader, new ClassRegistry.ClassDefinitionInfo(pd, nest, classData, isStrong)) : this.getContext().getRegistries().defineKlass(type, bytes, loader, new ClassRegistry.ClassDefinitionInfo(pd));
        }
        catch (EspressoClassLoadingException e) {
            throw e.asGuestException(this.getMeta());
        }
        if (initialize) {
            k.safeInitialize();
        } else {
            k.ensureLinked();
        }
        return k.mirror();
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public @JavaType(value=Class.class) StaticObject JVM_DefineClass(@Pointer TruffleObject namePtr, @JavaType(value=ClassLoader.class) StaticObject loader, @Pointer TruffleObject bufPtr, int len, @JavaType(internalName="Ljava/security/ProtectionDomain;") StaticObject pd) {
        StaticObject clazz;
        ByteBuffer buf = NativeUtils.directByteBuffer(bufPtr, len, JavaKind.Byte);
        byte[] bytes = new byte[len];
        buf.get(bytes);
        Symbol<Symbol.Type> type = this.namePtrToInternal(namePtr);
        try {
            clazz = this.getContext().getRegistries().defineKlass(type, bytes, loader, new ClassRegistry.ClassDefinitionInfo(pd)).mirror();
        }
        catch (EspressoClassLoadingException e) {
            throw e.asGuestException(this.getMeta());
        }
        assert (clazz != null);
        return clazz;
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Class.class) StaticObject JVM_DefineClassWithSource(@Pointer TruffleObject namePtr, @JavaType(value=ClassLoader.class) StaticObject loader, @Pointer TruffleObject bufPtr, int len, @JavaType(internalName="Ljava/security/ProtectionDomain;") StaticObject pd, @Pointer TruffleObject source) {
        return this.JVM_DefineClass(namePtr, loader, bufPtr, len, pd);
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Class.class) StaticObject JVM_FindLoadedClass(@JavaType(value=ClassLoader.class) StaticObject loader, @JavaType(value=String.class) StaticObject name) {
        Symbol<Symbol.Type> type = this.getTypes().fromClassGetName(this.getMeta().toHostString(name));
        Klass klass = this.getRegistries().findLoadedClass(type, this.nonReflectionClassLoader(loader));
        if (klass == null) {
            return StaticObject.NULL;
        }
        return klass.mirror();
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public @JavaType(value=Class.class) StaticObject JVM_FindClassFromBootLoader(@Pointer TruffleObject namePtr) {
        String name = NativeUtils.interopPointerToString(namePtr);
        if (name == null) {
            return StaticObject.NULL;
        }
        Object internalName = name;
        if (!name.startsWith("[")) {
            internalName = "L" + name + ";";
        }
        if (!Validation.validTypeDescriptor(ByteSequence.create((String)internalName), false)) {
            return StaticObject.NULL;
        }
        Symbol<Symbol.Type> type = this.getTypes().fromClassGetName((String)internalName);
        if (Types.isPrimitive(type)) {
            return StaticObject.NULL;
        }
        Klass klass = this.getMeta().resolveSymbolOrNull(type, StaticObject.NULL, StaticObject.NULL);
        if (klass == null) {
            return StaticObject.NULL;
        }
        return klass.mirror();
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public @JavaType(value=Class.class) StaticObject JVM_FindClassFromCaller(@Pointer TruffleObject namePtr, boolean init, @JavaType(value=ClassLoader.class) StaticObject loader, @JavaType(value=Class.class) StaticObject caller) {
        Klass result;
        Meta meta = this.getMeta();
        Symbol<Symbol.Type> type = this.namePtrToInternal(namePtr);
        if (Types.isPrimitive(type)) {
            result = null;
        } else {
            StaticObject protectionDomain = !StaticObject.isNull(caller) && !StaticObject.isNull(loader) ? this.JVM_GetProtectionDomain(caller) : StaticObject.NULL;
            result = meta.resolveSymbolOrNull(type, loader, protectionDomain);
        }
        if (result == null) {
            throw meta.throwExceptionWithMessage(meta.java_lang_ClassNotFoundException, NativeUtils.interopPointerToString(namePtr));
        }
        if (init) {
            result.safeInitialize();
        }
        return result.mirror();
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Class.class) StaticObject JVM_FindPrimitiveClass(@Pointer TruffleObject namePtr) {
        Meta meta = this.getMeta();
        String hostName = NativeUtils.interopPointerToString(namePtr);
        return VM.findPrimitiveClass(meta, hostName);
    }

    public static @JavaType(value=Class.class) StaticObject findPrimitiveClass(Meta meta, String hostName) {
        switch (hostName) {
            case "boolean": {
                return meta._boolean.mirror();
            }
            case "byte": {
                return meta._byte.mirror();
            }
            case "char": {
                return meta._char.mirror();
            }
            case "short": {
                return meta._short.mirror();
            }
            case "int": {
                return meta._int.mirror();
            }
            case "float": {
                return meta._float.mirror();
            }
            case "double": {
                return meta._double.mirror();
            }
            case "long": {
                return meta._long.mirror();
            }
            case "void": {
                return meta._void.mirror();
            }
        }
        throw meta.throwExceptionWithMessage(meta.java_lang_ClassNotFoundException, hostName);
    }

    public @Pointer TruffleObject getFunction(long handle) {
        return this.handle2Sym.get(handle);
    }

    private static boolean hasDynamicLoaderCache() {
        if (hasDynamicLoaderCacheInit) {
            return hasDynamicLoaderCacheValue;
        }
        if (OS.getCurrent() == OS.Darwin) {
            String osVersion = System.getProperty("os.version");
            int major = 11;
            int i = osVersion.indexOf(46);
            try {
                major = Integer.parseInt(i < 0 ? osVersion : osVersion.substring(0, i));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            hasDynamicLoaderCacheValue = major >= 11;
        } else {
            hasDynamicLoaderCacheValue = false;
        }
        hasDynamicLoaderCacheInit = true;
        return hasDynamicLoaderCacheValue;
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl
    public @Pointer TruffleObject JVM_LoadLibrary(@Pointer TruffleObject namePtr) {
        String name = NativeUtils.interopPointerToString(namePtr);
        boolean throwException = !VM.hasDynamicLoaderCache();
        return this.JVM_LoadLibrary(name, throwException);
    }

    @CompilerDirectives.TruffleBoundary
    public @Pointer TruffleObject JVM_LoadLibrary(String name, boolean throwException) {
        this.getLogger().fine(() -> String.format("JVM_LoadLibrary(%s, %s)", name, throwException));
        TruffleObject lib = this.getNativeAccess().loadLibrary(Paths.get(name, new String[0]));
        if (lib == null) {
            if (throwException) {
                Meta meta = this.getMeta();
                throw meta.throwExceptionWithMessage(meta.java_lang_UnsatisfiedLinkError, name);
            }
            return RawPointer.create(0L);
        }
        long handle = VM.getLibraryHandle(lib);
        this.handle2Lib.put(handle, lib);
        this.getLogger().fine(() -> String.format("JVM_LoadLibrary: Successfully loaded '%s' with handle %x", name, handle));
        return RawPointer.create(handle);
    }

    private static long getLibraryHandle(TruffleObject lib) {
        try {
            if (InteropLibrary.getUncached().isPointer((Object)lib)) {
                return InteropLibrary.getUncached().asPointer((Object)lib);
            }
            return libraryHandles.getAndIncrement();
        }
        catch (UnsupportedMessageException e) {
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl
    public void JVM_UnloadLibrary(@Pointer TruffleObject libraryPtr) {
        long nativeLibraryPtr = NativeUtils.interopAsPointer(libraryPtr);
        TruffleObject library = this.handle2Lib.get(nativeLibraryPtr);
        if (library == null) {
            this.getLogger().severe("JVM_UnloadLibrary with unknown library (not loaded through JVM_LoadLibrary?): " + libraryPtr + " / " + Long.toHexString(nativeLibraryPtr));
        } else {
            this.getNativeAccess().unloadLibrary(library);
        }
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl
    @SuppressFBWarnings(value={"AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION"}, justification="benign race")
    public @Pointer TruffleObject JVM_FindLibraryEntry(@Pointer TruffleObject libraryPtr, @Pointer TruffleObject namePtr) {
        String name = NativeUtils.interopPointerToString(namePtr);
        long nativePtr = NativeUtils.interopAsPointer(libraryPtr);
        TruffleObject library = this.handle2Lib.get(nativePtr);
        if (library == null) {
            if (nativePtr == this.rtldDefaultValue || nativePtr == this.processHandleValue) {
                library = this.getNativeAccess().loadDefaultLibrary();
                if (library == null) {
                    this.getLogger().warning("JVM_FindLibraryEntry from default/global namespace is not supported: " + name);
                    return RawPointer.nullInstance();
                }
                this.handle2Lib.put(nativePtr, library);
            } else {
                this.getLogger().warning("JVM_FindLibraryEntry with unknown handle (" + libraryPtr + " / " + Long.toHexString(nativePtr) + "): " + name);
                return RawPointer.nullInstance();
            }
        }
        try {
            TruffleObject function = this.getNativeAccess().lookupSymbol(library, name);
            if (this.getLogger().isLoggable(Level.FINEST)) {
                InteropLibrary interop = InteropLibrary.getUncached();
                String libraryName = nativePtr == this.rtldDefaultValue || nativePtr == this.processHandleValue ? "RTLD_DEFAULT" : interop.asString(interop.toDisplayString((Object)library, false));
                String functionName = function == null ? "null" : interop.asString(interop.toDisplayString((Object)function, false));
                this.getLogger().finest("JVM_FindLibraryEntry(%s, %s) -> %s".formatted(libraryName, name, functionName));
            }
            if (function == null) {
                return RawPointer.nullInstance();
            }
            if (!this.getUncached().isPointer((Object)function)) {
                this.getUncached().toNative((Object)function);
            }
            long handle = this.getUncached().asPointer((Object)function);
            this.handle2Sym.put(handle, function);
            return function;
        }
        catch (UnsupportedMessageException e) {
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    @VmImpl
    public @Pointer TruffleObject JVM_LoadZipLibrary() {
        if (this.zipLibrary != null) {
            return this.zipLibrary;
        }
        Object object = this.zipLoadLock;
        synchronized (object) {
            TruffleObject tmpZipLib = this.getNativeAccess().loadLibrary(this.getContext().getVmProperties().bootLibraryPath(), "zip", false);
            if (tmpZipLib == null || this.getUncached().isNull((Object)tmpZipLib)) {
                this.getLogger().severe("Unable to load zip library.");
            }
            this.zipLibrary = tmpZipLib;
            return this.zipLibrary;
        }
    }

    @VmImpl
    public boolean JVM_IsSupportedJNIVersion(int version) {
        JniVersion jniVersion = JniVersion.decodeVersion(version);
        return jniVersion != null && jniVersion.getJavaVersion().compareTo(this.getJavaVersion()) <= 0;
    }

    @VmImpl
    public int JVM_GetInterfaceVersion() {
        if (this.getJavaVersion().java21OrLater()) {
            this.getLogger().warning("JVM_GetInterfaceVersion invoked for a 21+ context but it was removed in Java 21");
        }
        if (this.getJavaVersion().java8OrEarlier()) {
            return 4;
        }
        return 6;
    }

    @VmImpl(isJni=true)
    public void JVM_BeforeHalt() {
    }

    @VmImpl
    public void JVM_Halt(int code, @Inject SubstitutionProfiler location) {
        this.getContext().truffleExit(location, code);
    }

    @VmImpl
    public void JVM_Exit(int code, @Inject SubstitutionProfiler location) {
        this.getContext().truffleExit(location, code);
    }

    private static String getModuleMain(OptionValues options) {
        int slash;
        String module = (String)options.get(EspressoOptions.Module);
        if (module.length() > 0 && (slash = module.indexOf(47)) != -1) {
            module = module.substring(0, slash);
        }
        return module;
    }

    public static void setPropertyIfExists(Map<String, String> map, String propertyName, String value) {
        if (value != null && value.length() > 0) {
            map.put(propertyName, value);
        }
    }

    private static void setNumberedProperty(Map<String, String> map, String property, List<String> values) {
        int count = 0;
        for (String value : values) {
            map.put(property + "." + count++, value);
        }
    }

    private Map<String, String> buildPropertiesMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        OptionValues options = this.getContext().getEnv().getOptions();
        for (Map.Entry entry : ((OptionMap)options.get(EspressoOptions.Properties)).entrySet()) {
            if (((String)entry.getKey()).equals("sun.nio.MaxDirectMemorySize")) continue;
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        EspressoProperties props = this.getContext().getVmProperties();
        String bootClassPathProperty = this.getJavaVersion().java8OrEarlier() ? "sun.boot.class.path" : "jdk.boot.class.path.append";
        map.put(bootClassPathProperty, VM.stringify(props.bootClasspath()));
        map.put("java.class.path", VM.stringify(props.classpath()));
        map.put("java.home", props.javaHome().toString());
        map.put("java.library.path", VM.stringify(props.javaLibraryPath()));
        map.put("sun.boot.library.path", VM.stringify(props.bootLibraryPath()));
        map.put("java.ext.dirs", VM.stringify(props.extDirs()));
        if (this.getJavaVersion().modulesEnabled()) {
            VM.setPropertyIfExists(map, "jdk.module.main", VM.getModuleMain(options));
            VM.setPropertyIfExists(map, "jdk.module.path", VM.stringify((List)options.get(EspressoOptions.ModulePath)));
            VM.setNumberedProperty(map, "jdk.module.addreads", (List)options.get(EspressoOptions.AddReads));
            VM.setNumberedProperty(map, "jdk.module.addexports", (List)options.get(EspressoOptions.AddExports));
            VM.setNumberedProperty(map, "jdk.module.addopens", (List)options.get(EspressoOptions.AddOpens));
            VM.setNumberedProperty(map, "jdk.module.addmods", (List)options.get(EspressoOptions.AddModules));
            VM.setNumberedProperty(map, "jdk.module.enable.native.access", (List)options.get(EspressoOptions.EnableNativeAccess));
        }
        Object specVersion = this.getJavaVersion().java8OrEarlier() ? "1." + this.getJavaVersion() : this.getJavaVersion().toString();
        map.put("java.vm.specification.version", (String)specVersion);
        map.put("java.vm.specification.name", "Java Virtual Machine Specification");
        map.put("java.vm.specification.vendor", "Oracle Corporation");
        map.put("java.vm.version", (String)specVersion + "-" + EspressoLanguage.VM_VERSION);
        map.put("java.vm.name", "Espresso 64-Bit VM");
        map.put("java.vm.vendor", "Oracle Corporation");
        map.put("java.vm.info", "mixed mode");
        map.put("jdk.debug", "release");
        map.put("sun.nio.MaxDirectMemorySize", Long.toString((Long)options.get(EspressoOptions.MaxDirectMemorySize)));
        return map;
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public @JavaType(value=Properties.class) StaticObject JVM_InitProperties(@JavaType(value=Properties.class) StaticObject properties) {
        Map<String, String> props = this.buildPropertiesMap();
        com.oracle.truffle.espresso.impl.Method setProperty = properties.getKlass().lookupMethod(Symbol.Name.setProperty, Symbol.Signature.Object_String_String);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            setProperty.invokeWithConversions(properties, entry.getKey(), entry.getValue());
        }
        return properties;
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public @JavaType(value=String[].class) StaticObject JVM_GetProperties(@Inject EspressoLanguage language) {
        Map<String, String> props = this.buildPropertiesMap();
        StaticObject array = this.getMeta().java_lang_String.allocateReferenceArray(props.size() * 2);
        int index = 0;
        for (Map.Entry<String, String> entry : props.entrySet()) {
            this.getInterpreterToVM().setArrayObject(language, this.getMeta().toGuestString(entry.getKey()), index * 2, array);
            this.getInterpreterToVM().setArrayObject(language, this.getMeta().toGuestString(entry.getValue()), index * 2 + 1, array);
            ++index;
        }
        return array;
    }

    @VmImpl(isJni=true)
    public int JVM_GetArrayLength(@JavaType(value=Object.class) StaticObject array, @Inject EspressoLanguage language, @Inject SubstitutionProfiler profiler) {
        try {
            return Array.getLength(MetaUtil.unwrapArrayOrNull(language, array));
        }
        catch (IllegalArgumentException e) {
            profiler.profile(0);
            Meta meta = this.getMeta();
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, e.getMessage());
        }
        catch (NullPointerException e) {
            profiler.profile(1);
            throw this.getMeta().throwNullPointerException();
        }
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Object.class) StaticObject JVM_GetArrayElement(@JavaType(value=Object.class) StaticObject array, int index, @Inject EspressoLanguage language, @Inject SubstitutionProfiler profiler) {
        Meta meta = this.getMeta();
        if (StaticObject.isNull(array)) {
            profiler.profile(7);
            throw meta.throwNullPointerException();
        }
        if (array.isArray()) {
            profiler.profile(6);
            return this.getInterpreterToVM().getArrayObject(language, index, array);
        }
        if (!array.getClass().isArray()) {
            profiler.profile(5);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "Argument is not an array");
        }
        assert (array.getClass().isArray() && array.getClass().getComponentType().isPrimitive());
        if (index < 0 || index >= this.JVM_GetArrayLength(array, language, profiler)) {
            profiler.profile(4);
            throw meta.throwExceptionWithMessage(meta.java_lang_ArrayIndexOutOfBoundsException, "index");
        }
        Object elem = Array.get(array, index);
        return this.getMeta().boxPrimitive(elem);
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public @JavaType(internalName="Ljava/lang/AssertionStatusDirectives;") StaticObject JVM_AssertionStatusDirectives(@JavaType(value=Class.class) StaticObject unused) {
        Meta meta = this.getMeta();
        StaticObject instance = meta.java_lang_AssertionStatusDirectives.allocateInstance(this.getContext());
        meta.java_lang_AssertionStatusDirectives.lookupMethod(Symbol.Name._init_, Symbol.Signature._void).invokeDirect(instance, new Object[0]);
        meta.java_lang_AssertionStatusDirectives_classes.set(instance, meta.java_lang_String.allocateReferenceArray(0));
        meta.java_lang_AssertionStatusDirectives_classEnabled.set(instance, meta._boolean.allocatePrimitiveArray(0));
        meta.java_lang_AssertionStatusDirectives_packages.set(instance, meta.java_lang_String.allocateReferenceArray(0));
        meta.java_lang_AssertionStatusDirectives_packageEnabled.set(instance, meta._boolean.allocatePrimitiveArray(0));
        boolean ea = (Boolean)this.getContext().getEnv().getOptions().get(EspressoOptions.EnableAssertions);
        meta.java_lang_AssertionStatusDirectives_deflt.set(instance, ea);
        return instance;
    }

    public static int jvmCallerDepth() {
        return -1;
    }

    private boolean isTrustedFrame(FrameInstance frameInstance, PrivilegedStack stack) {
        if (stack.compare(frameInstance)) {
            StaticObject loader = stack.classLoader();
            if (StaticObject.isNull(loader)) {
                return true;
            }
            if (this.isTrustedLoader(loader)) {
                return true;
            }
        }
        return false;
    }

    private boolean isTrustedLoader(StaticObject loader) {
        StaticObject nonDelLoader = this.nonReflectionClassLoader(loader);
        StaticObject systemLoader = (StaticObject)this.getMeta().java_lang_ClassLoader_getSystemClassLoader.invokeDirect(null, new Object[0]);
        while (StaticObject.notNull(systemLoader)) {
            if (systemLoader == nonDelLoader) {
                return true;
            }
            systemLoader = this.getMeta().java_lang_ClassLoader_parent.getObject(systemLoader);
        }
        return false;
    }

    private static boolean isIgnoredBySecurityStackWalk(com.oracle.truffle.espresso.impl.Method m, Meta meta) {
        ObjectKlass holderKlass = m.getDeclaringKlass();
        if (holderKlass == meta.java_lang_reflect_Method && m.getName() == Symbol.Name.invoke) {
            return true;
        }
        if (meta.sun_reflect_MethodAccessorImpl.isAssignableFrom(holderKlass)) {
            return true;
        }
        return MethodHandleIntrinsics.isMethodHandleIntrinsic(m) || (m.getModifiers() & 0x40000) != 0;
    }

    private boolean isAuthorized(StaticObject context, Klass klass) {
        if (!StaticObject.isNull(this.getMeta().java_lang_System_securityManager.getObject(this.getMeta().java_lang_System.getStatics()))) {
            if (this.getMeta().java_security_ProtectionDomain_impliesCreateAccessControlContext == null) {
                return true;
            }
            if (((Boolean)this.getMeta().java_security_AccessControlContext_isAuthorized.get(context)).booleanValue()) {
                return true;
            }
            StaticObject pd = this.JVM_GetProtectionDomain(klass.mirror());
            if (pd != StaticObject.NULL) {
                return (Boolean)this.getMeta().java_security_ProtectionDomain_impliesCreateAccessControlContext.invokeDirect(pd, new Object[0]);
            }
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    private FrameInstance getCallerFrame(final int depth, final boolean securityStackWalk, final Meta meta) {
        if (depth == -1) {
            return this.getCallerFrame(1, securityStackWalk, meta);
        }
        assert (depth >= 0);
        return (FrameInstance)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<FrameInstance>(){
            private int n;

            public FrameInstance visitFrame(FrameInstance frameInstance) {
                com.oracle.truffle.espresso.impl.Method m = VM.this.getMethodFromFrame(frameInstance);
                if (!(m == null || securityStackWalk && VM.isIgnoredBySecurityStackWalk(m, meta))) {
                    if (this.n == depth) {
                        return frameInstance;
                    }
                    ++this.n;
                }
                return null;
            }
        });
    }

    private static EspressoRootNode getRawEspressoRootFromFrame(FrameInstance frameInstance) {
        RootCallTarget callTarget;
        RootNode rootNode;
        if (frameInstance.getCallTarget() instanceof RootCallTarget && (rootNode = (callTarget = (RootCallTarget)frameInstance.getCallTarget()).getRootNode()) instanceof EspressoRootNode) {
            return (EspressoRootNode)rootNode;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public EspressoRootNode getEspressoRootFromFrame(FrameInstance frameInstance) {
        return VM.getEspressoRootFromFrame(frameInstance, this.getContext());
    }

    @CompilerDirectives.TruffleBoundary
    public static EspressoRootNode getEspressoRootFromFrame(FrameInstance frameInstance, EspressoContext context) {
        EspressoRootNode root = VM.getRawEspressoRootFromFrame(frameInstance);
        if (root == null) {
            return null;
        }
        com.oracle.truffle.espresso.impl.Method method = root.getMethod();
        if (method.getContext() != context) {
            return null;
        }
        return root;
    }

    @CompilerDirectives.TruffleBoundary
    public com.oracle.truffle.espresso.impl.Method getMethodFromFrame(FrameInstance frameInstance) {
        EspressoRootNode root = VM.getRawEspressoRootFromFrame(frameInstance);
        if (root == null) {
            return null;
        }
        com.oracle.truffle.espresso.impl.Method method = root.getMethod();
        if (method.getContext() != this.getContext()) {
            return null;
        }
        return method;
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Class.class) StaticObject JVM_GetCallerClass(int depth, @Inject SubstitutionProfiler profiler) {
        if (depth != -1) {
            com.oracle.truffle.espresso.impl.Method callerMethod;
            FrameInstance callerFrame = this.getCallerFrame(depth, true, this.getMeta());
            if (callerFrame != null && (callerMethod = this.getMethodFromFrame(callerFrame)) != null) {
                return callerMethod.getDeclaringKlass().mirror();
            }
            return StaticObject.NULL;
        }
        final Meta meta = this.getMeta();
        final StaticObject[] exception = new StaticObject[]{null};
        com.oracle.truffle.espresso.impl.Method callerMethod = (com.oracle.truffle.espresso.impl.Method)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<com.oracle.truffle.espresso.impl.Method>(){
            private int depth = 0;

            public com.oracle.truffle.espresso.impl.Method visitFrame(FrameInstance frameInstance) {
                com.oracle.truffle.espresso.impl.Method method = VM.this.getMethodFromFrame(frameInstance);
                if (method != null) {
                    switch (this.depth) {
                        case 0: {
                            if (method != meta.sun_reflect_Reflection_getCallerClass) {
                                exception[0] = Meta.initExceptionWithMessage(meta.java_lang_InternalError, "JVM_GetCallerClass must only be called from Reflection.getCallerClass");
                                return method;
                            }
                        }
                        case 1: {
                            if (method.isCallerSensitive()) break;
                            exception[0] = Meta.initExceptionWithMessage(meta.java_lang_InternalError, "CallerSensitive annotation expected at frame " + this.depth);
                            return method;
                        }
                        default: {
                            if (VM.isIgnoredBySecurityStackWalk(method, meta)) break;
                            return method;
                        }
                    }
                    ++this.depth;
                }
                return null;
            }
        });
        StaticObject internalError = exception[0];
        if (internalError != null) {
            profiler.profile(0);
            assert (InterpreterToVM.instanceOf(internalError, meta.java_lang_InternalError));
            throw meta.throwException(internalError);
        }
        if (callerMethod == null) {
            return StaticObject.NULL;
        }
        return callerMethod.getDeclaringKlass().mirror();
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Class[].class) StaticObject JVM_GetClassContext() {
        final ArrayList result = new ArrayList();
        Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Object>(){

            public Object visitFrame(FrameInstance frameInstance) {
                com.oracle.truffle.espresso.impl.Method m = VM.this.getMethodFromFrame(frameInstance);
                if (m != null && !VM.isIgnoredBySecurityStackWalk(m, VM.this.getMeta()) && !m.isNative()) {
                    result.add(m.getDeclaringKlass().mirror());
                }
                return null;
            }
        });
        return StaticObject.createArray(this.getMeta().java_lang_Class_array, result.toArray(StaticObject.EMPTY_ARRAY), this.getContext());
    }

    private @JavaType(internalName="Ljava/security/AccessControlContext;") StaticObject createACC(@JavaType(internalName="[Ljava/security/ProtectionDomain;") StaticObject context, boolean isPriviledged, @JavaType(internalName="Ljava/security/AccessControlContext;") StaticObject priviledgedContext) {
        ObjectKlass accKlass = this.getMeta().java_security_AccessControlContext;
        StaticObject acc = accKlass.allocateInstance(this.getContext());
        this.getMeta().java_security_AccessControlContext_context.setObject(acc, context);
        this.getMeta().java_security_AccessControlContext_privilegedContext.setObject(acc, priviledgedContext);
        this.getMeta().java_security_AccessControlContext_isPrivileged.setBoolean(acc, isPriviledged);
        if (this.getMeta().java_security_AccessControlContext_isAuthorized != null) {
            this.getMeta().java_security_AccessControlContext_isAuthorized.setBoolean(acc, true);
        }
        return acc;
    }

    private @JavaType(internalName="Ljava/security/AccessControlContext;") StaticObject createDummyACC() {
        ObjectKlass pdKlass = this.getMeta().java_security_ProtectionDomain;
        StaticObject pd = pdKlass.allocateInstance(this.getContext());
        this.getMeta().java_security_ProtectionDomain_init_CodeSource_PermissionCollection.invokeDirect(pd, StaticObject.NULL, StaticObject.NULL);
        StaticObject context = StaticObject.wrap(new StaticObject[]{pd}, this.getMeta());
        return this.createACC(context, false, StaticObject.NULL);
    }

    public PrivilegedStack getPrivilegedStack() {
        return this.getContext().getLanguage().getThreadLocalState().getPrivilegedStack();
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Object.class) StaticObject JVM_DoPrivileged(@JavaType(value=Class.class) StaticObject cls, @JavaType(value=Object.class) StaticObject action, @JavaType(internalName="Ljava/security/AccessControlContext;") StaticObject context, boolean wrapException, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        StaticObject result;
        com.oracle.truffle.espresso.impl.Method run;
        if (StaticObject.isNull(action)) {
            profiler.profile(0);
            throw meta.throwNullPointerException();
        }
        FrameInstance callerFrame = this.getCallerFrame(1, false, meta);
        assert (callerFrame != null) : "No caller ?";
        ObjectKlass caller = this.getMethodFromFrame(callerFrame).getDeclaringKlass();
        StaticObject acc = context;
        if (!StaticObject.isNull(context) && !this.isAuthorized(context, caller)) {
            acc = this.createDummyACC();
        }
        if ((run = action.getKlass().lookupMethod(Symbol.Name.run, Symbol.Signature.Object)) == null || !run.isPublic() || run.isStatic()) {
            profiler.profile(1);
            throw meta.throwException(meta.java_lang_InternalError);
        }
        PrivilegedStack stack = this.getPrivilegedStack();
        stack.push(callerFrame, acc, caller);
        try {
            result = (StaticObject)run.invokeDirect(action, new Object[0]);
        }
        catch (EspressoException e) {
            profiler.profile(2);
            if (meta.java_lang_Exception.isAssignableFrom(e.getGuestException().getKlass()) && !meta.java_lang_RuntimeException.isAssignableFrom(e.getGuestException().getKlass())) {
                profiler.profile(3);
                StaticObject wrapper = meta.java_security_PrivilegedActionException.allocateInstance(this.getContext());
                this.getMeta().java_security_PrivilegedActionException_init_Exception.invokeDirect(wrapper, e.getGuestException());
                throw meta.throwException(wrapper);
            }
            profiler.profile(4);
            throw e;
        }
        finally {
            stack.pop();
        }
        return result;
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Object.class) StaticObject JVM_GetStackAccessControlContext(@JavaType(value=Class.class) StaticObject cls) {
        if (this.getJavaVersion().java11OrEarlier()) {
            return this.getACCUntil11();
        }
        return this.getACCAfter12();
    }

    private StaticObject getACCAfter12() {
        final ArrayList<StaticObject> domains = new ArrayList<StaticObject>();
        final boolean[] isPrivileged = new boolean[]{false};
        StaticObject context = (StaticObject)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<StaticObject>(){
            StaticObject prevDomain = StaticObject.NULL;

            public StaticObject visitFrame(FrameInstance frameInstance) {
                com.oracle.truffle.espresso.impl.Method m = VM.this.getMethodFromFrame(frameInstance);
                if (m != null) {
                    StaticObject domain = null;
                    StaticObject stackContext = null;
                    StaticObject domainKlass = null;
                    if (m.getDeclaringKlass() == VM.this.getMeta().java_security_AccessController && m.getName() == Symbol.Name.executePrivileged) {
                        isPrivileged[0] = true;
                        Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY);
                        stackContext = EspressoFrame.getLocalObject(frame, 1);
                        domainKlass = EspressoFrame.getLocalObject(frame, 2);
                    } else {
                        domainKlass = m.getDeclaringKlass().mirror();
                    }
                    domain = VM.this.JVM_GetProtectionDomain(domainKlass);
                    if (domain != this.prevDomain && domain != StaticObject.NULL) {
                        domains.add(domain);
                        this.prevDomain = domain;
                    }
                    if (isPrivileged[0]) {
                        return stackContext;
                    }
                }
                return null;
            }
        });
        return this.getAccFromContext(domains, isPrivileged[0], context);
    }

    private StaticObject getACCUntil11() {
        final ArrayList<StaticObject> domains = new ArrayList<StaticObject>();
        final PrivilegedStack stack = this.getPrivilegedStack();
        final boolean[] isPrivileged = new boolean[]{false};
        StaticObject context = (StaticObject)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<StaticObject>(){
            StaticObject prevDomain = StaticObject.NULL;

            public StaticObject visitFrame(FrameInstance frameInstance) {
                com.oracle.truffle.espresso.impl.Method m = VM.this.getMethodFromFrame(frameInstance);
                if (m != null) {
                    StaticObject domain;
                    if (stack.compare(frameInstance)) {
                        isPrivileged[0] = true;
                    }
                    if ((domain = VM.this.JVM_GetProtectionDomain(m.getDeclaringKlass().mirror())) != this.prevDomain && domain != StaticObject.NULL) {
                        domains.add(domain);
                        this.prevDomain = domain;
                    }
                    if (isPrivileged[0]) {
                        return stack.peekContext();
                    }
                }
                return null;
            }
        });
        return this.getAccFromContext(domains, isPrivileged[0], context);
    }

    private StaticObject getAccFromContext(ArrayList<StaticObject> domains, boolean isPrivileged, StaticObject context) {
        if (domains.isEmpty()) {
            if (isPrivileged && StaticObject.isNull(context)) {
                return StaticObject.NULL;
            }
            return this.createACC(StaticObject.NULL, isPrivileged, context == null ? StaticObject.NULL : context);
        }
        StaticObject guestContext = StaticObject.createArray(this.getMeta().java_security_ProtectionDomain.array(), domains.toArray(StaticObject.EMPTY_ARRAY), this.getContext());
        return this.createACC(guestContext, isPrivileged, context == null ? StaticObject.NULL : context);
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Object.class) StaticObject JVM_GetInheritedAccessControlContext(@JavaType(value=Class.class) StaticObject cls) {
        return this.getMeta().java_lang_Thread_inheritedAccessControlContext.getObject(this.getContext().getCurrentPlatformThread());
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Object.class) StaticObject JVM_LatestUserDefinedLoader(final @Inject Meta meta) {
        StaticObject result = (StaticObject)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<StaticObject>(){

            public StaticObject visitFrame(FrameInstance frameInstance) {
                com.oracle.truffle.espresso.impl.Method m = VM.this.getMethodFromFrame(frameInstance);
                if (m != null) {
                    ObjectKlass holder = m.getDeclaringKlass();
                    if (meta.sun_reflect_MethodAccessorImpl.isAssignableFrom(holder) || meta.sun_reflect_ConstructorAccessorImpl.isAssignableFrom(holder)) {
                        return null;
                    }
                    StaticObject loader = ((Klass)holder).getDefiningClassLoader();
                    if (VM.this.getJavaVersion().java8OrEarlier() ? StaticObject.notNull(loader) && !Symbol.Type.sun_misc_Launcher$ExtClassLoader.equals(loader.getKlass().getType()) : StaticObject.notNull(loader) && !Symbol.Type.jdk_internal_loader_ClassLoaders$PlatformClassLoader.equals(loader.getKlass().getType())) {
                        return loader;
                    }
                }
                return null;
            }
        });
        return result == null ? StaticObject.NULL : result;
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Class.class) StaticObject JVM_CurrentLoadedClass() {
        final PrivilegedStack stack = this.getPrivilegedStack();
        StaticObject mirrorKlass = (StaticObject)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<StaticObject>(){

            public StaticObject visitFrame(FrameInstance frameInstance) {
                com.oracle.truffle.espresso.impl.Method m = VM.this.getMethodFromFrame(frameInstance);
                if (m != null) {
                    ObjectKlass klass;
                    StaticObject loader;
                    if (VM.this.isTrustedFrame(frameInstance, stack)) {
                        return StaticObject.NULL;
                    }
                    if (!m.isNative() && StaticObject.notNull(loader = (klass = m.getDeclaringKlass()).getDefiningClassLoader()) && !VM.this.isTrustedLoader(loader)) {
                        return klass.mirror();
                    }
                }
                return null;
            }
        });
        return mirrorKlass == null ? StaticObject.NULL : mirrorKlass;
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Class.class) StaticObject JVM_CurrentClassLoader() {
        @JavaType(value=Class.class) StaticObject loadedClass = this.JVM_CurrentLoadedClass();
        return StaticObject.isNull(loadedClass) ? StaticObject.NULL : loadedClass.getMirrorKlass(this.getMeta()).getDefiningClassLoader();
    }

    @VmImpl(isJni=true)
    public int JVM_ClassLoaderDepth() {
        final PrivilegedStack stack = this.getPrivilegedStack();
        Integer res = (Integer)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Integer>(){
            int depth = 0;

            public Integer visitFrame(FrameInstance frameInstance) {
                com.oracle.truffle.espresso.impl.Method m = VM.this.getMethodFromFrame(frameInstance);
                if (m != null) {
                    if (VM.this.isTrustedFrame(frameInstance, stack)) {
                        return -1;
                    }
                    if (!m.isNative()) {
                        ObjectKlass klass = m.getDeclaringKlass();
                        StaticObject loader = klass.getDefiningClassLoader();
                        if (StaticObject.notNull(loader) && !VM.this.isTrustedLoader(loader)) {
                            return this.depth;
                        }
                        ++this.depth;
                    }
                }
                return null;
            }
        });
        return res == null ? -1 : res;
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public int JVM_ClassDepth(@JavaType(value=String.class) StaticObject name) {
        final Symbol<Symbol.Name> className = this.getContext().getNames().lookup(this.getMeta().toHostString(name).replace('.', '/'));
        if (className == null) {
            return -1;
        }
        Integer res = (Integer)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Integer>(){
            int depth = 0;

            public Integer visitFrame(FrameInstance frameInstance) {
                com.oracle.truffle.espresso.impl.Method m = VM.this.getMethodFromFrame(frameInstance);
                if (m != null) {
                    if (className.equals(m.getDeclaringKlass().getName())) {
                        return this.depth;
                    }
                    ++this.depth;
                }
                return null;
            }
        });
        return res == null ? -1 : res;
    }

    private static @JavaType(value=Method.class) StaticObject getGuestReflectiveMethodRoot(@JavaType(value=Method.class) StaticObject seed, Meta meta) {
        assert (InterpreterToVM.instanceOf(seed, meta.java_lang_reflect_Method));
        StaticObject curMethod = seed;
        while (curMethod != null && StaticObject.notNull(curMethod)) {
            com.oracle.truffle.espresso.impl.Method target = (com.oracle.truffle.espresso.impl.Method)meta.HIDDEN_METHOD_KEY.getHiddenObject(curMethod);
            if (target != null) {
                return curMethod;
            }
            curMethod = meta.java_lang_reflect_Method_root.getObject(curMethod);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("Could not find HIDDEN_METHOD_KEY");
    }

    private static @JavaType(value=Field.class) StaticObject getGuestReflectiveFieldRoot(@JavaType(value=Field.class) StaticObject seed, Meta meta) {
        assert (InterpreterToVM.instanceOf(seed, meta.java_lang_reflect_Field));
        StaticObject curField = seed;
        while (curField != null && StaticObject.notNull(curField)) {
            com.oracle.truffle.espresso.impl.Field target = (com.oracle.truffle.espresso.impl.Field)meta.HIDDEN_FIELD_KEY.getHiddenObject(curField);
            if (target != null) {
                return curField;
            }
            curField = meta.java_lang_reflect_Field_root.getObject(curField);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("Could not find HIDDEN_FIELD_KEY");
    }

    private static @JavaType(value=Constructor.class) StaticObject getGuestReflectiveConstructorRoot(@JavaType(value=Constructor.class) StaticObject seed, Meta meta) {
        assert (InterpreterToVM.instanceOf(seed, meta.java_lang_reflect_Constructor));
        StaticObject curConstructor = seed;
        while (curConstructor != null && StaticObject.notNull(curConstructor)) {
            com.oracle.truffle.espresso.impl.Method target = (com.oracle.truffle.espresso.impl.Method)meta.HIDDEN_CONSTRUCTOR_KEY.getHiddenObject(curConstructor);
            if (target != null) {
                return curConstructor;
            }
            curConstructor = meta.java_lang_reflect_Constructor_root.getObject(curConstructor);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("Could not find HIDDEN_CONSTRUCTOR_KEY");
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Parameter[].class) StaticObject JVM_GetMethodParameters(final @JavaType(value=Object.class) StaticObject executable, @Inject EspressoLanguage language, final @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        com.oracle.truffle.espresso.impl.Method method;
        assert (meta.java_lang_reflect_Executable.isAssignableFrom(executable.getKlass()));
        StaticObject parameterTypes = (StaticObject)executable.getKlass().lookupMethod(Symbol.Name.getParameterTypes, Symbol.Signature.Class_array).invokeDirect(executable, new Object[0]);
        int numParams = parameterTypes.length(language);
        if (numParams == 0) {
            return StaticObject.NULL;
        }
        if (meta.java_lang_reflect_Method.isAssignableFrom(executable.getKlass())) {
            method = com.oracle.truffle.espresso.impl.Method.getHostReflectiveMethodRoot(executable, meta);
        } else if (meta.java_lang_reflect_Constructor.isAssignableFrom(executable.getKlass())) {
            method = com.oracle.truffle.espresso.impl.Method.getHostReflectiveConstructorRoot(executable, meta);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
        final MethodParametersAttribute methodParameters = (MethodParametersAttribute)method.getAttribute(Symbol.Name.MethodParameters);
        if (methodParameters == null) {
            return StaticObject.NULL;
        }
        int cpLength = method.getConstantPool().length();
        for (MethodParametersAttribute.Entry entry : methodParameters.getEntries()) {
            int nameIndex = entry.getNameIndex();
            if (nameIndex < 0 || nameIndex >= cpLength) {
                profiler.profile(0);
                throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "Constant pool index out of bounds");
            }
            if (nameIndex == 0 || method.getConstantPool().tagAt(nameIndex) == ConstantPool.Tag.UTF8) continue;
            profiler.profile(1);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "Wrong type at constant pool index");
        }
        final com.oracle.truffle.espresso.impl.Method parameterInit = meta.java_lang_reflect_Parameter.lookupDeclaredMethod(Symbol.Name._init_, this.getSignatures().makeRaw(Symbol.Type._void, Symbol.Type.java_lang_String, Symbol.Type._int, Symbol.Type.java_lang_reflect_Executable, Symbol.Type._int));
        return meta.java_lang_reflect_Parameter.allocateReferenceArray(methodParameters.getEntries().length, new IntFunction<StaticObject>(){

            @Override
            public StaticObject apply(int index) {
                MethodParametersAttribute.Entry entry = methodParameters.getEntries()[index];
                StaticObject instance = meta.java_lang_reflect_Parameter.allocateInstance(VM.this.getContext());
                StaticObject guestName = entry.getNameIndex() != 0 ? meta.toGuestString(method.getConstantPool().symbolAt(entry.getNameIndex(), "parameter name").toString()) : (VM.this.getJavaVersion().java9OrLater() ? StaticObject.NULL : meta.toGuestString(""));
                parameterInit.invokeDirect(instance, guestName, entry.getAccessFlags(), executable, index);
                return instance;
            }
        });
    }

    @VmImpl(isJni=true)
    public @JavaType(value=byte[].class) StaticObject JVM_GetMethodTypeAnnotations(@JavaType(value=Executable.class) StaticObject guestReflectionMethod) {
        if (InterpreterToVM.instanceOf(guestReflectionMethod, this.getMeta().java_lang_reflect_Method)) {
            StaticObject methodRoot = VM.getGuestReflectiveMethodRoot(guestReflectionMethod, this.getMeta());
            assert (methodRoot != null);
            return (StaticObject)this.getMeta().HIDDEN_METHOD_RUNTIME_VISIBLE_TYPE_ANNOTATIONS.getHiddenObject(methodRoot);
        }
        if (InterpreterToVM.instanceOf(guestReflectionMethod, this.getMeta().java_lang_reflect_Constructor)) {
            StaticObject constructorRoot = VM.getGuestReflectiveConstructorRoot(guestReflectionMethod, this.getMeta());
            assert (constructorRoot != null);
            return (StaticObject)this.getMeta().HIDDEN_CONSTRUCTOR_RUNTIME_VISIBLE_TYPE_ANNOTATIONS.getHiddenObject(constructorRoot);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere();
    }

    @VmImpl(isJni=true)
    public @JavaType(value=byte[].class) StaticObject JVM_GetFieldTypeAnnotations(@JavaType(value=Field.class) StaticObject guestReflectionField) {
        assert (InterpreterToVM.instanceOf(guestReflectionField, this.getMeta().java_lang_reflect_Field));
        StaticObject fieldRoot = VM.getGuestReflectiveFieldRoot(guestReflectionField, this.getMeta());
        assert (fieldRoot != null);
        return (StaticObject)this.getMeta().HIDDEN_FIELD_RUNTIME_VISIBLE_TYPE_ANNOTATIONS.getHiddenObject(fieldRoot);
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl
    public int JNI_GetCreatedJavaVMs(@Pointer TruffleObject vmBufPtr, int bufLen, @Pointer TruffleObject numVMsPtr) {
        if (bufLen > 0) {
            if (this.getUncached().isNull((Object)vmBufPtr)) {
                return -1;
            }
            NativeUtils.writeToPointerPointer(this.getUncached(), vmBufPtr, this.getVM().getJavaVM());
            if (!this.getUncached().isNull((Object)numVMsPtr)) {
                NativeUtils.writeToIntPointer(this.getUncached(), numVMsPtr, 1);
            }
        }
        return 0;
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Thread[].class) StaticObject JVM_GetAllThreads(@JavaType(value=Class.class) StaticObject unused) {
        ThreadsAccess threadAccess = this.getThreadAccess();
        StaticObject[] threads = this.getContext().getActiveThreads();
        int numThreads = threads.length;
        int i = 0;
        while (i < numThreads) {
            if (threadAccess.isVirtualThread(threads[i])) {
                threads[i] = threads[numThreads - 1];
                --numThreads;
                continue;
            }
            ++i;
        }
        if (numThreads < threads.length) {
            threads = Arrays.copyOf(threads, numThreads);
        }
        return this.getMeta().getAllocator().wrapArrayAs(this.getMeta().java_lang_Thread.getArrayClass(), threads);
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl
    public synchronized @Pointer TruffleObject JVM_GetManagement(int version) {
        EspressoContext context = this.getContext();
        if (!context.getEspressoEnv().EnableManagement) {
            this.getLogger().severe("JVM_GetManagement: Experimental support for java.lang.management native APIs is disabled.\nUse '--java.EnableManagement=true' to enable experimental support for j.l.management native APIs.");
            return RawPointer.nullInstance();
        }
        assert (this.management != null);
        return this.management.getManagement(version);
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public @JavaType(value=String[].class) StaticObject JVM_GetVmArguments(@Inject EspressoLanguage language) {
        String[] vmArgs = this.getContext().getVmArguments();
        StaticObject array = this.getMeta().java_lang_String.allocateReferenceArray(vmArgs.length);
        for (int i = 0; i < vmArgs.length; ++i) {
            this.getInterpreterToVM().setArrayObject(language, this.getMeta().toGuestString(vmArgs[i]), i, array);
        }
        return array;
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public void JVM_AddModuleExports(@JavaType(internalName="Ljava/lang/Module;") StaticObject from_module, @Pointer TruffleObject pkgName, @JavaType(internalName="Ljava/lang/Module;") StaticObject to_module, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(to_module)) {
            profiler.profile(6);
            throw this.getMeta().throwNullPointerException();
        }
        if (this.getUncached().isNull((Object)pkgName)) {
            profiler.profile(0);
            throw this.getMeta().throwNullPointerException();
        }
        ModulesHelperVM.addModuleExports(from_module, NativeUtils.interopPointerToString(pkgName), to_module, this.getMeta(), profiler);
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public void JVM_AddModuleExportsToAllUnnamed(@JavaType(internalName="Ljava/lang/Module;") StaticObject from_module, @Pointer TruffleObject pkgName, @Inject SubstitutionProfiler profiler) {
        if (this.getUncached().isNull((Object)pkgName)) {
            profiler.profile(0);
            throw this.getMeta().throwNullPointerException();
        }
        ModulesHelperVM.addModuleExportsToAllUnnamed(from_module, NativeUtils.interopPointerToString(pkgName), profiler, this.getMeta());
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public void JVM_AddModuleExportsToAll(@JavaType(internalName="Ljava/lang/Module;") StaticObject from_module, @Pointer TruffleObject pkgName, @Inject SubstitutionProfiler profiler) {
        if (this.getUncached().isNull((Object)pkgName)) {
            profiler.profile(0);
            throw this.getMeta().throwNullPointerException();
        }
        ModulesHelperVM.addModuleExports(from_module, NativeUtils.interopPointerToString(pkgName), StaticObject.NULL, this.getMeta(), profiler);
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public void JVM_AddReadsModule(@JavaType(internalName="Ljava/lang/Module;") StaticObject from_module, @JavaType(internalName="Ljava/lang/Module;") StaticObject source_module, @Inject SubstitutionProfiler profiler) {
        ModuleTable.ModuleEntry toEntry;
        ModuleTable.ModuleEntry fromEntry = ModulesHelperVM.extractFromModuleEntry(from_module, this.getMeta(), profiler);
        if (fromEntry != (toEntry = ModulesHelperVM.extractToModuleEntry(source_module, this.getMeta(), profiler)) && fromEntry.isNamed()) {
            fromEntry.addReads(toEntry);
        }
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public void JVM_DefineModule(@JavaType(internalName="Ljava/lang/Module;") StaticObject module, boolean is_open, @JavaType(value=String.class) StaticObject version, @JavaType(value=String.class) StaticObject location, @Pointer TruffleObject pkgs, int num_package, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(module)) {
            profiler.profile(0);
            throw meta.throwNullPointerException();
        }
        if (num_package < 0) {
            profiler.profile(1);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "num_package must be >= 0");
        }
        if (this.getUncached().isNull((Object)pkgs) && num_package > 0) {
            profiler.profile(2);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "num_packages must be 0 if packages is null");
        }
        if (!meta.java_lang_Module.isAssignableFrom(module.getKlass())) {
            profiler.profile(3);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "module is not an instance of java.lang.Module");
        }
        StaticObject guestName = meta.java_lang_Module_name.getObject(module);
        if (StaticObject.isNull(guestName)) {
            profiler.profile(4);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "modue name cannot be null");
        }
        String hostName = meta.toHostString(guestName);
        if (hostName.equals("java.base")) {
            profiler.profile(5);
            this.defineJavaBaseModule(module, this.extractNativePackages(pkgs, num_package, profiler), profiler);
            return;
        }
        profiler.profile(6);
        this.defineModule(module, hostName, is_open, this.extractNativePackages(pkgs, num_package, profiler), profiler);
    }

    public void defineModule(StaticObject module, String moduleName, boolean is_open, String[] packages, SubstitutionProfiler profiler) {
        Meta meta = this.getMeta();
        StaticObject loader = meta.java_lang_Module_loader.getObject(module);
        if (loader != this.nonReflectionClassLoader(loader)) {
            profiler.profile(15);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "Class loader is an invalid delegating class loader");
        }
        ClassRegistry registry = this.getRegistries().getClassRegistry(loader);
        assert (registry != null);
        PackageTable packageTable = registry.packages();
        ModuleTable moduleTable = registry.modules();
        assert (moduleTable != null && packageTable != null);
        boolean loaderIsBootOrPlatform = this.getContext().getClassLoadingEnv().loaderIsBootOrPlatform(loader);
        ArrayList<Symbol<Symbol.Name>> pkgSymbols = new ArrayList<Symbol<Symbol.Name>>();
        try (EntryTable.BlockLock block = packageTable.write();){
            for (String string : packages) {
                if (!loaderIsBootOrPlatform && (string.equals("java") || string.startsWith("java/"))) {
                    profiler.profile(14);
                    throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, EspressoError.cat("Class loader (", loader.getKlass().getType(), ") tried to define prohibited package name: ", string));
                }
                Symbol<Symbol.Name> symbol = this.getNames().getOrCreate(string);
                if (packageTable.lookup(symbol) != null) {
                    profiler.profile(13);
                    throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, EspressoError.cat("Package ", string, " is already defined."));
                }
                pkgSymbols.add(symbol);
            }
            Symbol<Symbol.Name> moduleSymbol = this.getNames().getOrCreate(moduleName);
            ModuleTable.ModuleEntry moduleEntry = moduleTable.createAndAddEntry(moduleSymbol, registry, is_open, module);
            if (moduleEntry == null) {
                profiler.profile(12);
                throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, EspressoError.cat("Module ", moduleName, " is already defined"));
            }
            for (Symbol symbol : pkgSymbols) {
                PackageTable.PackageEntry pkgEntry = (PackageTable.PackageEntry)packageTable.createAndAddEntry(symbol, moduleEntry);
                assert (pkgEntry != null);
            }
            meta.HIDDEN_MODULE_ENTRY.setHiddenObject(module, moduleEntry);
        }
        if (StaticObject.isNull(loader) && this.getContext().getVmProperties().bootClassPathType().isExplodedModule()) {
            profiler.profile(11);
            this.prependModuleClasspath(moduleName);
        }
    }

    void prependModuleClasspath(String moduleName) {
        Path path = this.getContext().getVmProperties().javaHome().resolve(MODULES).resolve(moduleName);
        Classpath.Entry newEntry = Classpath.createEntry(path.toString());
        if (newEntry.isDirectory()) {
            this.getContext().getBootClasspath().prepend(newEntry);
        }
    }

    private String[] extractNativePackages(TruffleObject pkgs, int numPackages, SubstitutionProfiler profiler) {
        String[] packages = new String[numPackages];
        try {
            for (int i = 0; i < numPackages; ++i) {
                String pkg = NativeUtils.interopPointerToString((TruffleObject)this.getUncached().execute((Object)this.getPackageAt, new Object[]{pkgs, i}));
                if (!Validation.validBinaryName(pkg)) {
                    profiler.profile(7);
                    Meta meta = this.getMeta();
                    throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, EspressoError.cat("Invalid package name: ", pkg));
                }
                packages[i] = pkg;
            }
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw EspressoError.shouldNotReachHere();
        }
        return packages;
    }

    public void defineJavaBaseModule(StaticObject module, String[] packages, SubstitutionProfiler profiler) {
        Meta meta = this.getMeta();
        StaticObject loader = meta.java_lang_Module_loader.getObject(module);
        if (!StaticObject.isNull(loader)) {
            profiler.profile(10);
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "Class loader must be the bootclass loader");
        }
        PackageTable pkgTable = this.getRegistries().getBootClassRegistry().packages();
        ModuleTable.ModuleEntry javaBaseEntry = this.getRegistries().getJavaBaseModule();
        try (EntryTable.BlockLock block = pkgTable.write();){
            if (this.getRegistries().javaBaseDefined()) {
                profiler.profile(9);
                throw meta.throwException(meta.java_lang_InternalError);
            }
            for (String pkg : packages) {
                Symbol<Symbol.Name> pkgName = this.getNames().getOrCreate(pkg);
                if (pkgTable.lookup(pkgName) != null) continue;
                pkgTable.createAndAddEntry(pkgName, javaBaseEntry);
            }
            javaBaseEntry.setModule(module);
            meta.HIDDEN_MODULE_ENTRY.setHiddenObject(module, javaBaseEntry);
            this.getRegistries().processFixupList(module);
        }
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public void JVM_SetBootLoaderUnnamedModule(@JavaType(internalName="Ljava/lang/Module;") StaticObject module) {
        Meta meta = this.getMeta();
        if (StaticObject.isNull(module)) {
            throw meta.throwNullPointerException();
        }
        if (!meta.java_lang_Module.isAssignableFrom(module.getKlass())) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "module is not an instance of java.lang.module");
        }
        if (!StaticObject.isNull(meta.java_lang_Module_name.getObject(module))) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "boot loader unnamed module has a name");
        }
        if (!StaticObject.isNull(meta.java_lang_Module_loader.getObject(module))) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "Class loader must be the boot class loader");
        }
        ModuleTable.ModuleEntry bootUnnamed = this.getRegistries().getBootClassRegistry().getUnnamedModule();
        bootUnnamed.setModule(module);
        meta.HIDDEN_MODULE_ENTRY.setHiddenObject(module, bootUnnamed);
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Reference.class) StaticObject JVM_GetAndClearReferencePendingList() {
        return this.getContext().getAndClearReferencePendingList();
    }

    @VmImpl(isJni=true)
    public void JVM_WaitForReferencePendingList() {
        this.getContext().waitForReferencePendingList();
    }

    @VmImpl(isJni=true)
    public boolean JVM_HasReferencePendingList() {
        return this.getContext().hasReferencePendingList();
    }

    @VmImpl(isJni=true)
    public boolean JVM_PhantomReferenceRefersTo(@JavaType(value=Reference.class) StaticObject ref, @JavaType(value=Object.class) StaticObject object, @Inject SubstitutionProfiler profiler) {
        EspressoReference host;
        if (StaticObject.isNull(ref)) {
            profiler.profile(0);
            this.getMeta().throwNullPointerException();
        }
        if ((host = (EspressoReference)this.getMeta().HIDDEN_HOST_REFERENCE.getHiddenObject(ref)) == null) {
            return StaticObject.isNull(object);
        }
        assert (host instanceof Reference) : host;
        return ((Reference)((Object)host)).refersTo(object);
    }

    @VmImpl(isJni=true)
    public boolean JVM_ReferenceRefersTo(@JavaType(value=Reference.class) StaticObject ref, @JavaType(value=Object.class) StaticObject object, @Inject SubstitutionProfiler profiler, @Inject Meta meta, @Inject EspressoLanguage language) {
        if (StaticObject.isNull(ref)) {
            profiler.profile(0);
            this.getMeta().throwNullPointerException();
        }
        if (InterpreterToVM.instanceOf(ref, meta.java_lang_ref_WeakReference) || InterpreterToVM.instanceOf(ref, meta.java_lang_ref_SoftReference) || InterpreterToVM.instanceOf(ref, meta.java_lang_ref_PhantomReference) || InterpreterToVM.instanceOf(ref, meta.java_lang_ref_FinalReference)) {
            EspressoReference host = (EspressoReference)this.getMeta().HIDDEN_HOST_REFERENCE.getHiddenObject(ref);
            if (host == null) {
                return StaticObject.isNull(object);
            }
            assert (host instanceof Reference) : host;
            return ((Reference)((Object)host)).refersTo(object);
        }
        StaticObject referent = (StaticObject)meta.java_lang_ref_Reference_referent.get(ref);
        return InterpreterToVM.referenceIdentityEqual(referent, object, language);
    }

    @VmImpl(isJni=true)
    public void JVM_ReferenceClear(@JavaType(value=Reference.class) StaticObject ref, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(ref)) {
            profiler.profile(0);
            this.getMeta().throwNullPointerException();
        }
        Target_java_lang_ref_Reference.clear(ref, this.getMeta());
    }

    @VmImpl(isJni=true)
    public void JVM_InitializeFromArchive(@JavaType(value=Class.class) StaticObject cls) {
    }

    @VmImpl(isJni=true)
    public static boolean JVM_IsDumpingClassList() {
        return false;
    }

    @VmImpl(isJni=true)
    public static boolean JVM_IsCDSDumpingEnabled() {
        return false;
    }

    @VmImpl(isJni=true)
    public static boolean JVM_IsSharingEnabled() {
        return false;
    }

    @VmImpl
    public static long JVM_GetRandomSeedForDumping() {
        return 0L;
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public @JavaType(value=String.class) StaticObject JVM_GetTemporaryDirectory() {
        return this.getMeta().toGuestString(System.getProperty("java.io.tmpdir"));
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public static long JVM_GetNanoTimeAdjustment(@JavaType(value=Class.class) StaticObject ignored, long offset) {
        Instant now = Instant.now();
        long secs = now.getEpochSecond();
        long nanos = now.getNano();
        long diff = secs - offset;
        if (diff > 0x100000000L || diff < -4294967296L) {
            return -1L;
        }
        return diff * 1000000000L + nanos;
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public static long JVM_MaxObjectInspectionAge() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StackWalk getStackWalk() {
        StackWalk ref = this.stackWalk;
        if (ref == null) {
            EspressoError.guarantee(this.getJavaVersion().java9OrLater(), "Stack-Walking API requires Java 9+");
            VM vM = this;
            synchronized (vM) {
                ref = this.stackWalk;
                if (ref == null) {
                    this.stackWalk = ref = new StackWalk();
                }
            }
        }
        return ref;
    }

    @VmImpl(isJni=true)
    public static void JVM_InitStackTraceElement(@JavaType(value=StackTraceElement.class) StaticObject element, @JavaType(internalName="Ljava/lang/StackFrameInfo;") StaticObject info, @Inject Meta meta) {
        if (StaticObject.isNull(element) || StaticObject.isNull(info)) {
            throw meta.throwNullPointerException();
        }
        StaticObject mname = meta.java_lang_StackFrameInfo_memberName.getObject(info);
        if (StaticObject.isNull(mname)) {
            throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, "uninitialized StackFrameInfo !");
        }
        StaticObject clazz = meta.java_lang_invoke_MemberName_clazz.getObject(mname);
        com.oracle.truffle.espresso.impl.Method m = (com.oracle.truffle.espresso.impl.Method)meta.HIDDEN_VMTARGET.getHiddenObject(mname);
        if (m == null) {
            throw meta.throwExceptionWithMessage(meta.java_lang_InternalError, "uninitialized StackFrameInfo !");
        }
        int bci = meta.java_lang_StackFrameInfo_bci.getInt(info);
        VM.fillInElement(element, new EspressoStackElement(m, bci), meta);
    }

    @VmImpl(isJni=true)
    public void JVM_InitStackTraceElementArray(@JavaType(value=StackTraceElement[].class) StaticObject elements, @JavaType(value=Object.class) StaticObject throwableOrBacktrace, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(elements) || StaticObject.isNull(throwableOrBacktrace)) {
            profiler.profile(0);
            throw meta.throwNullPointerException();
        }
        assert (elements.isArray());
        StaticObject foreignWrapper = null;
        StackTrace stackTrace = null;
        if (throwableOrBacktrace.isForeignObject()) {
            foreignWrapper = throwableOrBacktrace;
        } else {
            stackTrace = (StackTrace)meta.HIDDEN_FRAMES.getHiddenObject(throwableOrBacktrace);
            if (stackTrace == StackTrace.FOREIGN_MARKER_STACK_TRACE) {
                foreignWrapper = meta.java_lang_Throwable_backtrace.getObject(throwableOrBacktrace);
            }
        }
        if (foreignWrapper != null) {
            AbstractTruffleException foreignException = (AbstractTruffleException)((Object)foreignWrapper.rawForeignObject(language));
            InteropLibrary interop = InteropLibrary.getUncached();
            try {
                Object exceptionStackTrace = interop.getExceptionStackTrace((Object)foreignException);
                int stackSize = (int)interop.getArraySize(exceptionStackTrace);
                if (elements.length(language) != stackSize) {
                    profiler.profile(1);
                    throw meta.throwException(meta.java_lang_IndexOutOfBoundsException);
                }
                for (int i = 0; i < stackSize; ++i) {
                    if (StaticObject.isNull((StaticObject)elements.get(language, i))) {
                        profiler.profile(2);
                        throw meta.throwNullPointerException();
                    }
                    this.fillInForeignElement(elements, language, interop, exceptionStackTrace, i);
                }
            }
            catch (InteropException e) {
                throw meta.throwException(meta.java_lang_IllegalArgumentException);
            }
        } else if (stackTrace != null) {
            if (elements.length(language) != stackTrace.size) {
                profiler.profile(1);
                throw meta.throwException(meta.java_lang_IndexOutOfBoundsException);
            }
            for (int i = 0; i < stackTrace.size; ++i) {
                if (StaticObject.isNull((StaticObject)elements.get(language, i))) {
                    profiler.profile(2);
                    throw meta.throwNullPointerException();
                }
                VM.fillInElement((StaticObject)elements.get(language, i), stackTrace.trace[i], meta);
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void fillInForeignElement(StaticObject elements, EspressoLanguage language, InteropLibrary interop, Object exceptionStackTrace, int i) throws UnsupportedMessageException, InvalidArrayIndexException {
        Object declaringClassName;
        Object foreignElement = interop.readArrayElement(exceptionStackTrace, (long)i);
        String languageId = "java";
        String fileName = "<unknown>";
        int lineNumber = EspressoStackElement.NATIVE_BCI;
        if (interop.hasSourceLocation(foreignElement)) {
            SourceSection sourceLocation = interop.getSourceLocation(foreignElement);
            fileName = sourceLocation.getSource().getName();
            if (sourceLocation.hasLines()) {
                lineNumber = sourceLocation.getStartLine();
            }
            languageId = sourceLocation.getSource().getLanguage();
        }
        Object object = declaringClassName = languageId.equals("java") ? "" : "<" + languageId + ">";
        if (interop.hasDeclaringMetaObject(foreignElement)) {
            Object declaringMetaObject = interop.getDeclaringMetaObject(foreignElement);
            declaringClassName = (String)declaringClassName + interop.asString(interop.getMetaQualifiedName(declaringMetaObject));
        }
        String methodName = "<unknownForeignMethod>";
        if (interop.hasExecutableName(foreignElement)) {
            methodName = interop.asString(interop.getExecutableName(foreignElement));
        }
        ForeignStackElement foreignStackElement = new ForeignStackElement((String)declaringClassName, methodName, fileName, lineNumber);
        VM.fillInElement((StaticObject)elements.get(language, i), foreignStackElement, this.getMeta());
    }

    public static void fillInElement(@JavaType(value=StackTraceElement.class) StaticObject ste, StackElement element, Meta meta) {
        com.oracle.truffle.espresso.impl.Method m = element.getMethod();
        if (m != null) {
            ObjectKlass k = m.getDeclaringKlass();
            StaticObject guestClass = k.mirror();
            StaticObject loader = k.getDefiningClassLoader();
            ModuleTable.ModuleEntry module = k.module();
            if (meta.getJavaVersion().java9OrLater()) {
                meta.java_lang_StackTraceElement_declaringClassObject.setObject(ste, guestClass);
                if (!StaticObject.isNull(loader)) {
                    StaticObject loaderName = meta.java_lang_ClassLoader_name.getObject(loader);
                    if (!StaticObject.isNull(loader)) {
                        meta.java_lang_StackTraceElement_classLoaderName.setObject(ste, loaderName);
                    }
                }
                if (module.isNamed()) {
                    meta.java_lang_StackTraceElement_moduleName.setObject(ste, meta.toGuestString(module.getName()));
                }
            }
        } else if (meta.getJavaVersion().java9OrLater()) {
            meta.java_lang_StackTraceElement_declaringClassObject.setObject(ste, meta.java_lang_Object.mirror());
        }
        meta.java_lang_StackTraceElement_declaringClass.setObject(ste, element.getGuestDeclaringClassName(meta));
        meta.java_lang_StackTraceElement_methodName.setObject(ste, meta.toGuestString(element.getMethodName()));
        meta.java_lang_StackTraceElement_fileName.setObject(ste, meta.toGuestString(element.getFileName()));
        meta.java_lang_StackTraceElement_lineNumber.setInt(ste, element.getLineNumber());
    }

    private static void checkStackWalkArguments(EspressoLanguage language, int batchSize, int startIndex, @JavaType(value=Object[].class) StaticObject frames, Meta meta) {
        if (StaticObject.isNull(frames)) {
            throw meta.throwNullPointerException();
        }
        assert (frames.isArray());
        int limit = startIndex + batchSize;
        if (frames.length(language) < limit) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "Not enough space in buffers");
        }
    }

    @VmImpl(isJni=true)
    public @JavaType(value=Object.class) StaticObject JVM_CallStackWalk(@JavaType(internalName="Ljava/lang/StackStreamFactory;") StaticObject stackStream, long mode, int skipframes, int batchSize, int startIndex, @JavaType(value=Object[].class) StaticObject frames, @Inject EspressoLanguage language, @Inject Meta meta) {
        return this.JVM_CallStackWalk19(stackStream, mode, skipframes, StaticObject.NULL, StaticObject.NULL, batchSize, startIndex, frames, language, meta);
    }

    @CompilerDirectives.TruffleBoundary
    public @JavaType(value=Object.class) StaticObject JVM_CallStackWalk19(@JavaType(internalName="Ljava/lang/StackStreamFactory;") StaticObject stackStream, long mode, int skipframes, @JavaType(internalName="Ljdk/internal/vm/ContinuationScope;") StaticObject contScope, @JavaType(internalName="Ljdk/internal/vm/Continuation;") StaticObject cont, int batchSize, int startIndex, @JavaType(value=Object[].class) StaticObject frames, @Inject EspressoLanguage language, @Inject Meta meta) {
        if (!StaticObject.isNull(contScope) && !StaticObject.isNull(cont)) {
            throw EspressoError.unimplemented("virtual thread support");
        }
        VM.checkStackWalkArguments(language, batchSize, startIndex, frames, meta);
        return this.getStackWalk().fetchFirstBatch(stackStream, mode, skipframes, batchSize, startIndex, frames, meta);
    }

    @CompilerDirectives.TruffleBoundary
    @VmImpl(isJni=true)
    public int JVM_MoreStackWalk(@JavaType(internalName="Ljava/lang/StackStreamFactory;") StaticObject stackStream, long mode, long anchor, int batchSize, int startIndex, @JavaType(value=Object[].class) StaticObject frames, @Inject EspressoLanguage language, @Inject Meta meta) {
        VM.checkStackWalkArguments(language, batchSize, startIndex, frames, meta);
        return this.getStackWalk().fetchNextBatch(stackStream, mode, anchor, batchSize, startIndex, frames, meta);
    }

    private static final class LongCASProbe {
        static final boolean HOST_SUPPORTS_LONG_CAS;
        volatile long foo;

        private LongCASProbe() {
        }

        static {
            AtomicLongFieldUpdater<LongCASProbe> updater = AtomicLongFieldUpdater.newUpdater(LongCASProbe.class, "foo");
            String updaterName = updater.getClass().getSimpleName();
            if ("CASUpdater".equals(updaterName)) {
                HOST_SUPPORTS_LONG_CAS = true;
            } else if ("LockedUpdater".equals(updaterName)) {
                HOST_SUPPORTS_LONG_CAS = false;
            } else {
                throw EspressoError.shouldNotReachHere("Unknown host long updater: " + updaterName);
            }
        }
    }

    public static class StackTrace {
        public static final StackTrace EMPTY_STACK_TRACE = new StackTrace(0);
        public static final StackTrace FOREIGN_MARKER_STACK_TRACE = new StackTrace(0);
        public StackElement[] trace;
        public int size;
        public int capacity;

        public StackTrace() {
            this(32);
        }

        private StackTrace(int size) {
            this.trace = new StackElement[size];
            this.capacity = size;
            this.size = 0;
        }

        public void add(StackElement e) {
            if (this.size < this.capacity) {
                this.trace[this.size++] = e;
            } else {
                this.trace = Arrays.copyOf(this.trace, this.capacity <<= 1);
                this.trace[this.size++] = e;
            }
        }
    }

    public static interface StackElement {
        public com.oracle.truffle.espresso.impl.Method getMethod();

        public boolean hasInfo();

        public String getDeclaringClassName();

        default public StaticObject getGuestDeclaringClassName(Meta meta) {
            return meta.toGuestString(this.getDeclaringClassName());
        }

        public String getMethodName();

        public int getLineNumber();

        public String getFileName();
    }

    public static final class PrivilegedStack {
        private final EspressoContext espressoContext;
        private Element top;

        public PrivilegedStack(EspressoContext context) {
            this.espressoContext = context;
        }

        void push(FrameInstance frame, StaticObject context, Klass klass) {
            this.top = new Element(frame, context, klass, this.top, this.espressoContext);
        }

        void pop() {
            assert (this.top != null) : "popping empty privileged stack !";
            this.top = this.top.next;
        }

        boolean compare(FrameInstance frame) {
            return this.top != null && this.top.compare(frame, this.espressoContext);
        }

        StaticObject peekContext() {
            assert (this.top != null);
            return this.top.context;
        }

        StaticObject classLoader() {
            assert (this.top != null);
            return this.top.klass.getDefiningClassLoader();
        }

        private static class Element {
            long frameID;
            StaticObject context;
            Klass klass;
            Element next;

            Element(FrameInstance frame, StaticObject context, Klass klass, Element next, EspressoContext espressoContext) {
                this.frameID = Element.getFrameId(frame, espressoContext);
                this.context = context;
                this.klass = klass;
                this.next = next;
            }

            boolean compare(FrameInstance other, EspressoContext espressoContext) {
                EspressoRootNode rootNode = VM.getEspressoRootFromFrame(other, espressoContext);
                if (rootNode != null) {
                    Frame readOnlyFrame = other.getFrame(FrameInstance.FrameAccess.READ_ONLY);
                    long frameIdOrZero = rootNode.readFrameIdOrZero(readOnlyFrame);
                    return frameIdOrZero != 0L && frameIdOrZero == this.frameID;
                }
                return false;
            }

            private static long getFrameId(FrameInstance frame, EspressoContext espressoContext) {
                EspressoRootNode rootNode = VM.getEspressoRootFromFrame(frame, espressoContext);
                Frame readOnlyFrame = frame.getFrame(FrameInstance.FrameAccess.READ_ONLY);
                return rootNode.readFrameIdOrZero(readOnlyFrame);
            }
        }
    }

    public static class EspressoStackElement
    implements StackElement {
        public static int NATIVE_BCI = -2;
        public static int UNKNOWN_BCI = -1;
        private final com.oracle.truffle.espresso.impl.Method m;
        private final int bci;

        public EspressoStackElement(com.oracle.truffle.espresso.impl.Method m, int bci) {
            this.m = m;
            this.bci = bci;
        }

        @Override
        public com.oracle.truffle.espresso.impl.Method getMethod() {
            return this.m;
        }

        @Override
        public boolean hasInfo() {
            return this.m != null;
        }

        @Override
        public String getDeclaringClassName() {
            return this.m.getDeclaringKlass().getExternalName();
        }

        @Override
        public StaticObject getGuestDeclaringClassName(Meta meta) {
            ObjectKlass declaringKlass = this.m.getDeclaringKlass();
            StaticObject mirror = declaringKlass.mirror();
            StaticObject name = (StaticObject)meta.java_lang_Class_name.get(mirror);
            if (StaticObject.notNull(name)) {
                return name;
            }
            return StackElement.super.getGuestDeclaringClassName(meta);
        }

        @Override
        public String getMethodName() {
            return this.m.getNameAsString();
        }

        @Override
        public int getLineNumber() {
            return this.m.bciToLineNumber(this.bci);
        }

        @Override
        public String getFileName() {
            return this.m.getDeclaringKlass().getSourceFile();
        }
    }

    public static class ForeignStackElement
    implements StackElement {
        private final String declaringClassName;
        private final String methodName;
        private final String fileName;
        private final int lineNumber;

        public ForeignStackElement(String declaringClassName, String methodName, String fileName, int lineNumber) {
            this.declaringClassName = declaringClassName;
            this.methodName = methodName;
            this.fileName = fileName;
            this.lineNumber = lineNumber;
        }

        @Override
        public com.oracle.truffle.espresso.impl.Method getMethod() {
            return null;
        }

        @Override
        public boolean hasInfo() {
            return true;
        }

        @Override
        public String getDeclaringClassName() {
            return this.declaringClassName;
        }

        @Override
        public String getMethodName() {
            return this.methodName;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }
    }

    public static final class GlobalFrameIDs {
        private static final AtomicLong id = new AtomicLong();

        public static long getID() {
            return id.incrementAndGet();
        }
    }
}

