/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ContextThreadLocal;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.staticobject.DefaultStaticProperty;
import com.oracle.truffle.api.staticobject.StaticProperty;
import com.oracle.truffle.api.staticobject.StaticShape;
import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.EspressoOptionsOptionDescriptors;
import com.oracle.truffle.espresso.EspressoParseError;
import com.oracle.truffle.espresso.descriptors.Names;
import com.oracle.truffle.espresso.descriptors.Signatures;
import com.oracle.truffle.espresso.descriptors.StaticSymbols;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Symbols;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.descriptors.Utf8ConstantTable;
import com.oracle.truffle.espresso.impl.SuppressFBWarnings;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.nodes.commands.DestroyVMNode;
import com.oracle.truffle.espresso.nodes.commands.ExitCodeNode;
import com.oracle.truffle.espresso.nodes.commands.GetBindingsNode;
import com.oracle.truffle.espresso.nodes.commands.ReferenceProcessRootNode;
import com.oracle.truffle.espresso.preinit.ContextPatchingException;
import com.oracle.truffle.espresso.preinit.EspressoLanguageCache;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoThreadLocalState;
import com.oracle.truffle.espresso.runtime.GuestAllocator;
import com.oracle.truffle.espresso.runtime.JavaVersion;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Substitutions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.graalvm.home.HomeFinder;
import org.graalvm.home.Version;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;

@TruffleLanguage.Registration(id="java", name="Java", implementationName="Espresso", contextPolicy=TruffleLanguage.ContextPolicy.SHARED, dependentLanguages={"nfi"}, website="https://www.graalvm.org/dev/reference-manual/java-on-truffle/")
@ProvidedTags(value={StandardTags.RootTag.class, StandardTags.RootBodyTag.class, StandardTags.StatementTag.class})
public final class EspressoLanguage
extends TruffleLanguage<EspressoContext> {
    public static final String ID = "java";
    public static final String NAME = "Java";
    public static final String IMPLEMENTATION_NAME = "Espresso";
    public static final String VM_SPECIFICATION_NAME = "Java Virtual Machine Specification";
    public static final String VM_SPECIFICATION_VENDOR = "Oracle Corporation";
    public static final String VM_VERSION = "espresso-" + String.valueOf(Version.getCurrent());
    public static final String VM_VENDOR = "Oracle Corporation";
    public static final String VM_NAME = "Espresso 64-Bit VM";
    public static final String VM_INFO = "mixed mode";
    public static final String FILE_EXTENSION = ".class";
    @CompilerDirectives.CompilationFinal
    private Utf8ConstantTable utf8Constants;
    @CompilerDirectives.CompilationFinal
    private Names names;
    @CompilerDirectives.CompilationFinal
    private Types types;
    @CompilerDirectives.CompilationFinal
    private Signatures signatures;
    private final StaticProperty arrayProperty = new DefaultStaticProperty("array");
    @CompilerDirectives.CompilationFinal
    private StaticShape<StaticObject.StaticObjectFactory> arrayShape;
    private final StaticProperty foreignProperty = new DefaultStaticProperty("foreignObject");
    @CompilerDirectives.CompilationFinal
    private StaticShape<StaticObject.StaticObjectFactory> foreignShape;
    @CompilerDirectives.CompilationFinal
    private JavaVersion javaVersion;
    @CompilerDirectives.CompilationFinal
    private EspressoOptions.VerifyMode verifyMode;
    @CompilerDirectives.CompilationFinal
    private EspressoOptions.SpecComplianceMode specComplianceMode;
    @CompilerDirectives.CompilationFinal
    private EspressoOptions.LivenessAnalysisMode livenessAnalysisMode;
    @CompilerDirectives.CompilationFinal
    private int livenessAnalysisMinimumLocals;
    @CompilerDirectives.CompilationFinal
    private boolean previewEnabled;
    @CompilerDirectives.CompilationFinal
    private boolean whiteBoxEnabled;
    @CompilerDirectives.CompilationFinal
    private GuestAllocator allocator;
    @CompilerDirectives.CompilationFinal
    private final Assumption noAllocationTracking = Assumption.create((String)"Espresso no allocation tracking assumption");
    private final EspressoLanguageCache languageCache = new EspressoLanguageCache();
    @CompilerDirectives.CompilationFinal
    private boolean isShared = false;
    @CompilerDirectives.CompilationFinal
    private volatile boolean fullyInitialized;
    private final ContextThreadLocal<EspressoThreadLocalState> threadLocalState = this.locals.createContextThreadLocal((context, thread) -> new EspressoThreadLocalState((EspressoContext)context));
    private static final TruffleLanguage.LanguageReference<EspressoLanguage> REFERENCE = TruffleLanguage.LanguageReference.create(EspressoLanguage.class);

    public EspressoLanguage() {
        JavaKind.ensureInitialized();
        Symbol.Name.ensureInitialized();
        Symbol.Type.ensureInitialized();
        Symbol.Signature.ensureInitialized();
        Substitutions.ensureInitialized();
        Symbols symbols = new Symbols(StaticSymbols.freeze());
        this.utf8Constants = new Utf8ConstantTable(symbols);
        this.names = new Names(symbols);
        this.types = new Types(symbols);
        this.signatures = new Signatures(symbols, this.types);
    }

    protected OptionDescriptors getOptionDescriptors() {
        return new EspressoOptionsOptionDescriptors();
    }

    public EspressoThreadLocalState getThreadLocalState() {
        return (EspressoThreadLocalState)this.threadLocalState.get();
    }

    public EspressoThreadLocalState getThreadLocalStateFor(Thread t) {
        return (EspressoThreadLocalState)this.threadLocalState.get(t);
    }

    protected EspressoContext createContext(TruffleLanguage.Env env) {
        boolean isPreinitLanguageInstance = env.getConfig().getOrDefault("preinit", false);
        if (isPreinitLanguageInstance) {
            this.languageCache.addCapability(EspressoLanguageCache.CacheCapability.PRE_INITIALIZED);
        }
        this.ensureInitialized(env);
        EspressoContext context = new EspressoContext(env, this);
        context.setMainArguments(env.getApplicationArguments());
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureInitialized(TruffleLanguage.Env env) {
        if (!this.fullyInitialized) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EspressoLanguage espressoLanguage = this;
            synchronized (espressoLanguage) {
                if (!this.fullyInitialized) {
                    this.initializeOptions(env);
                    this.arrayShape = this.createArrayShape();
                    this.foreignShape = this.createForeignShape();
                    this.fullyInitialized = true;
                }
            }
        }
    }

    private void initializeOptions(TruffleLanguage.Env env) {
        assert (Thread.holdsLock((Object)this));
        this.verifyMode = (EspressoOptions.VerifyMode)((Object)env.getOptions().get(EspressoOptions.Verify));
        this.specComplianceMode = (EspressoOptions.SpecComplianceMode)((Object)env.getOptions().get(EspressoOptions.SpecCompliance));
        this.livenessAnalysisMode = (EspressoOptions.LivenessAnalysisMode)((Object)env.getOptions().get(EspressoOptions.LivenessAnalysis));
        this.livenessAnalysisMinimumLocals = (Integer)env.getOptions().get(EspressoOptions.LivenessAnalysisMinimumLocals);
        this.previewEnabled = (Boolean)env.getOptions().get(EspressoOptions.EnablePreview);
        this.whiteBoxEnabled = (Boolean)env.getOptions().get(EspressoOptions.WhiteBoxAPI);
    }

    protected void initializeMultipleContexts() {
        this.languageCache.addCapability(EspressoLanguageCache.CacheCapability.SHARED);
        this.isShared = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeContext(EspressoContext context) throws Exception {
        if (context.getEnv().isPreInitialization()) {
            TruffleContext ctx = context.getEnv().newInnerContextBuilder(new String[0]).initializeCreatorContext(true).inheritAllAccess(true).config("preinit", (Object)true).build();
            Object prev = ctx.enter(null);
            try {
                EspressoContext inner = EspressoContext.get(null);
                inner.preInitializeContext();
                this.languageCache.addCapability(EspressoLanguageCache.CacheCapability.PRE_INITIALIZED);
                this.extractDataFrom(inner.getLanguage());
                this.languageCache.logCacheStatus();
                if (!inner.multiThreadingEnabled()) {
                    inner.getLazyCaches().getReferenceProcessCache().execute();
                }
                inner = null;
            }
            finally {
                ctx.leave(null, prev);
                ctx.close();
                ctx = null;
                System.gc();
            }
        } else {
            context.initializeContext();
        }
    }

    private void extractDataFrom(EspressoLanguage other) {
        this.javaVersion = other.javaVersion;
        this.utf8Constants = other.getUtf8ConstantTable();
        this.names = other.getNames();
        this.types = other.getTypes();
        this.signatures = other.getSignatures();
        this.languageCache.importFrom(other.getLanguageCache());
    }

    protected boolean patchContext(EspressoContext context, TruffleLanguage.Env newEnv) {
        if (!this.areOptionsCompatible(context.getEnv().getOptions(), newEnv.getOptions())) {
            return false;
        }
        context.patchContext(newEnv);
        try {
            context.initializeContext();
        }
        catch (ContextPatchingException e) {
            context.getLogger().severe(e.getMessage());
            return false;
        }
        return true;
    }

    protected boolean areOptionsCompatible(OptionValues oldOptions, OptionValues newOptions) {
        return EspressoLanguage.isOptionCompatible(newOptions, oldOptions, EspressoOptions.JavaHome) && EspressoLanguage.isOptionCompatible(newOptions, oldOptions, EspressoOptions.BootClasspath) && EspressoLanguage.isOptionCompatible(newOptions, oldOptions, EspressoOptions.Verify) && EspressoLanguage.isOptionCompatible(newOptions, oldOptions, EspressoOptions.SpecCompliance) && EspressoLanguage.isOptionCompatible(newOptions, oldOptions, EspressoOptions.LivenessAnalysis) && EspressoLanguage.isOptionCompatible(newOptions, oldOptions, EspressoOptions.LivenessAnalysisMinimumLocals) && EspressoLanguage.isOptionCompatible(newOptions, oldOptions, EspressoOptions.EnablePreview) && EspressoLanguage.isOptionCompatible(newOptions, oldOptions, EspressoOptions.WhiteBoxAPI);
    }

    private static boolean isOptionCompatible(OptionValues oldOptions, OptionValues newOptions, OptionKey<?> option) {
        return oldOptions.get(option).equals(newOptions.get(option));
    }

    protected void exitContext(EspressoContext context, TruffleLanguage.ExitMode exitMode, int exitCode) {
        if (!context.isInitialized()) {
            return;
        }
        if (exitMode == TruffleLanguage.ExitMode.NATURAL) {
            if (context.getVM().DetachCurrentThread(context) == 0) {
                context.createThread(Thread.currentThread(), context.getMainThreadGroup(), "DestroyJavaVM", false);
            }
            context.destroyVM();
        } else {
            context.doExit(exitCode);
        }
    }

    protected void finalizeContext(EspressoContext context) {
        context.ensureThreadsJoined();
        TruffleSafepoint sp = TruffleSafepoint.getCurrent();
        boolean prev = sp.setAllowActions(false);
        try {
            context.prepareDispose();
            context.cleanupNativeEnv();
        }
        catch (Throwable t) {
            context.getLogger().log(Level.FINER, "Exception while finalizing Espresso context", t);
            throw t;
        }
        finally {
            sp.setAllowActions(prev);
            context.setFinalized();
        }
        long elapsedTimeNanos = System.nanoTime() - context.getStartupClockNanos();
        long seconds = TimeUnit.NANOSECONDS.toSeconds(elapsedTimeNanos);
        if (seconds > 10L) {
            context.getLogger().log(Level.FINE, "Time spent in Espresso: {0} s", (Object)seconds);
        } else {
            context.getLogger().log(Level.FINE, "Time spent in Espresso: {0} ms", (Object)TimeUnit.NANOSECONDS.toMillis(elapsedTimeNanos));
        }
    }

    protected Object getScope(EspressoContext context) {
        return context.getBindings();
    }

    protected void disposeContext(EspressoContext context) {
        context.disposeContext();
    }

    protected CallTarget parse(TruffleLanguage.ParsingRequest request) throws Exception {
        assert (EspressoContext.get(null).isInitialized());
        String contents = request.getSource().getCharacters().toString();
        if ("<DestroyJavaVM>".equals(contents)) {
            DestroyVMNode node = new DestroyVMNode(this);
            return node.getCallTarget();
        }
        if ("<ExitCode>".equals(contents)) {
            ExitCodeNode node = new ExitCodeNode(this);
            return node.getCallTarget();
        }
        if ("<Bindings>".equals(contents)) {
            GetBindingsNode node = new GetBindingsNode(this);
            return node.getCallTarget();
        }
        if ("<ProcessReferences>".equals(contents)) {
            ReferenceProcessRootNode node = new ReferenceProcessRootNode(this);
            return node.getCallTarget();
        }
        throw new EspressoParseError("Espresso cannot evaluate Java sources directly, only a few special commands are supported: <Bindings> and <ProcessReferences>\nUse the \"java\" language bindings to load guest Java classes e.g. context.getBindings(\"java\").getMember(\"java.lang.Integer\")");
    }

    public Utf8ConstantTable getUtf8ConstantTable() {
        return this.utf8Constants;
    }

    public Names getNames() {
        return this.names;
    }

    public Types getTypes() {
        return this.types;
    }

    public Signatures getSignatures() {
        return this.signatures;
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    protected void initializeMultiThreading(EspressoContext context) {
    }

    protected void initializeThread(EspressoContext context, Thread thread) {
        if (context.isFinalized()) {
            context.getLogger().log(Level.FINE, "Context is already finalized, ignoring request to initialize a new thread");
            return;
        }
        context.createThread(thread);
    }

    protected void disposeThread(EspressoContext context, Thread thread) {
        context.disposeThread(thread);
    }

    public StaticProperty getArrayProperty() {
        return this.arrayProperty;
    }

    public StaticShape<StaticObject.StaticObjectFactory> getArrayShape() {
        assert (this.fullyInitialized) : "Array shape accessed before language is fully initialized";
        return this.arrayShape;
    }

    @CompilerDirectives.TruffleBoundary
    private StaticShape<StaticObject.StaticObjectFactory> createArrayShape() {
        assert (this.arrayShape == null);
        return StaticShape.newBuilder((TruffleLanguage)this).property(this.arrayProperty, Object.class, true).build(StaticObject.class, StaticObject.StaticObjectFactory.class);
    }

    public StaticProperty getForeignProperty() {
        return this.foreignProperty;
    }

    public StaticShape<StaticObject.StaticObjectFactory> getForeignShape() {
        assert (this.fullyInitialized) : "Array shape accessed before language is fully initialized";
        return this.foreignShape;
    }

    @CompilerDirectives.TruffleBoundary
    private StaticShape<StaticObject.StaticObjectFactory> createForeignShape() {
        assert (this.foreignShape == null);
        return StaticShape.newBuilder((TruffleLanguage)this).property(this.foreignProperty, Object.class, true).build(StaticObject.class, StaticObject.StaticObjectFactory.class);
    }

    public static EspressoLanguage get(Node node) {
        return (EspressoLanguage)REFERENCE.get(node);
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    public EspressoOptions.SpecComplianceMode getSpecComplianceMode() {
        return this.specComplianceMode;
    }

    public EspressoOptions.LivenessAnalysisMode getLivenessAnalysisMode() {
        return this.livenessAnalysisMode;
    }

    public EspressoOptions.VerifyMode getVerifyMode() {
        return this.verifyMode;
    }

    public int livenessAnalysisMinimumLocals() {
        return this.livenessAnalysisMinimumLocals;
    }

    public boolean isAllocationTrackingDisabled() {
        return this.noAllocationTracking.isValid();
    }

    public void invalidateAllocationTrackingDisabled() {
        this.noAllocationTracking.invalidate();
    }

    public boolean isPreviewEnabled() {
        return this.previewEnabled;
    }

    public boolean isWhiteBoxEnabled() {
        return this.whiteBoxEnabled;
    }

    public EspressoLanguageCache getLanguageCache() {
        return this.languageCache;
    }

    public GuestAllocator getAllocator() {
        return this.allocator;
    }

    public void initializeGuestAllocator(TruffleLanguage.Env env) {
        this.allocator = new GuestAllocator(this, (AllocationReporter)env.lookup(AllocationReporter.class));
    }

    @Idempotent
    public boolean isShared() {
        return this.isShared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DC_DOUBLECHECK"}, justification="non-volatile for performance reasons, javaVersion is initialized very early during context creation with an enum value, only benign races expected.")
    public void tryInitializeJavaVersion(JavaVersion version) {
        JavaVersion ref = this.javaVersion;
        if (ref == null) {
            EspressoLanguage espressoLanguage = this;
            synchronized (espressoLanguage) {
                ref = this.javaVersion;
                if (ref == null) {
                    this.javaVersion = ref = Objects.requireNonNull(version);
                }
            }
        }
        EspressoError.guarantee(version.equals(ref), "incompatible Java versions");
    }

    public StaticObject getCurrentVirtualThread() {
        return this.getThreadLocalState().getCurrentVirtualThread();
    }

    public void setCurrentVirtualThread(StaticObject thread) {
        this.getThreadLocalState().setCurrentVirtualThread(thread);
    }

    public static Path getEspressoLibs(TruffleLanguage.Env env) {
        Path libs;
        Path espressoHome = (Path)HomeFinder.getInstance().getLanguageHomes().get(ID);
        if (espressoHome != null && Files.isDirectory(libs = espressoHome.resolve("lib"), new LinkOption[0])) {
            return libs;
        }
        try {
            String resources = env.getInternalResource("espresso-libs").getAbsoluteFile().toString();
            Path libs2 = Path.of(resources, "lib");
            assert (Files.isDirectory(libs2, new LinkOption[0]));
            return libs2;
        }
        catch (IOException e) {
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    public static Path getEspressoRuntime(TruffleLanguage.Env env) {
        Path graalvmHome;
        Path espressoHome = (Path)HomeFinder.getInstance().getLanguageHomes().get(ID);
        if (espressoHome != null && Files.isDirectory(espressoHome, new LinkOption[0]) && (graalvmHome = HomeFinder.getInstance().getHomeFolder()) != null) {
            try {
                Path expectedLanguageHome = graalvmHome.resolve("languages").resolve(ID);
                if (Files.isDirectory(expectedLanguageHome, new LinkOption[0]) && Files.isSameFile(espressoHome, expectedLanguageHome)) {
                    return graalvmHome;
                }
            }
            catch (IOException e) {
                env.getLogger(EspressoContext.class).log(Level.WARNING, "Error while probing espresso and graalvm home", (Throwable)e);
            }
        }
        try {
            Path resources = Path.of(env.getInternalResource("espresso-runtime").getAbsoluteFile().toString(), new String[0]);
            assert (Files.isDirectory(resources, new LinkOption[0]));
            return resources;
        }
        catch (IOException e) {
            throw EspressoError.shouldNotReachHere(e);
        }
    }
}

