/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis;

import com.oracle.truffle.espresso.analysis.graph.LinkedBlock;
import java.util.Arrays;

public final class BlockStack {
    private static final int DEFAULT_SIZE = 4;
    private LinkedBlock[] stack = new LinkedBlock[4];
    private int pos = 0;

    public void push(LinkedBlock block) {
        if (this.pos == this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, this.stack.length << 1);
        }
        this.stack[this.pos++] = block;
    }

    public LinkedBlock pop() {
        assert (!this.isEmpty());
        return this.stack[--this.pos];
    }

    public LinkedBlock peek() {
        assert (!this.isEmpty());
        return this.stack[this.pos - 1];
    }

    public boolean isEmpty() {
        return this.pos == 0;
    }
}

