/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.bytecode;

import com.oracle.truffle.espresso.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.bytecode.BytecodeSwitch;

public final class BytecodeLookupSwitch
extends BytecodeSwitch {
    private static final int OFFSET_TO_NUMBER_PAIRS = 4;
    private static final int OFFSET_TO_FIRST_PAIR_MATCH = 8;
    private static final int OFFSET_TO_FIRST_PAIR_OFFSET = 12;
    private static final int PAIR_SIZE = 8;
    public static final BytecodeLookupSwitch INSTANCE = new BytecodeLookupSwitch();

    private BytecodeLookupSwitch() {
    }

    @Override
    public int offsetAt(BytecodeStream stream, int bci, int i) {
        assert (stream.opcode(bci) == this.getSwitchBytecode());
        return stream.readInt(BytecodeLookupSwitch.getAlignedBci(bci) + 12 + 8 * i);
    }

    @Override
    public int keyAt(BytecodeStream stream, int bci, int i) {
        assert (stream.opcode(bci) == this.getSwitchBytecode());
        return stream.readInt(BytecodeLookupSwitch.getAlignedBci(bci) + 8 + 8 * i);
    }

    @Override
    public int numberOfCases(BytecodeStream stream, int bci) {
        assert (stream.opcode(bci) == this.getSwitchBytecode());
        return stream.readInt(BytecodeLookupSwitch.getAlignedBci(bci) + 4);
    }

    @Override
    public int size(BytecodeStream stream, int bci) {
        assert (stream.opcode(bci) == this.getSwitchBytecode());
        return BytecodeLookupSwitch.getAlignedBci(bci) + 8 + 8 * this.numberOfCases(stream, bci) - bci;
    }

    @Override
    protected int getSwitchBytecode() {
        return 171;
    }
}

