/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Validation;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.perf.DebugCounter;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.logging.Level;

public interface ClassConstant
extends PoolConstant {
    public static final DebugCounter CLASS_RESOLVE_COUNT = DebugCounter.create("ClassConstant.resolve calls");

    public static ClassConstant create(int classNameIndex) {
        return new Index(classNameIndex);
    }

    public static ClassConstant preResolved(Klass klass) {
        return new PreResolved(klass);
    }

    public static ClassConstant withString(Symbol<Symbol.Name> name) {
        return new WithString(name);
    }

    public static Resolvable.ResolvedConstant resolved(Klass klass) {
        return new Resolved(klass);
    }

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.CLASS;
    }

    public Symbol<Symbol.Name> getName(ConstantPool var1);

    @Override
    default public String toString(ConstantPool pool) {
        return this.getName(pool).toString();
    }

    public static final class Index
    implements ClassConstant,
    Resolvable {
        private final char classNameIndex;

        Index(int classNameIndex) {
            this.classNameIndex = PoolConstant.u2(classNameIndex);
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            return pool.symbolAt(this.classNameIndex);
        }

        @Override
        public Resolved resolve(RuntimeConstantPool pool, int thisIndex, Klass accessingKlass) {
            CLASS_RESOLVE_COUNT.inc();
            assert (accessingKlass != null);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Symbol<Symbol.Name> klassName = this.getName(pool);
            try {
                EspressoContext context = pool.getContext();
                Symbol<Symbol.Type> type = context.getTypes().fromName(klassName);
                Klass klass = context.getMeta().resolveSymbolOrFail(type, accessingKlass.getDefiningClassLoader(), accessingKlass.protectionDomain());
                if (!Klass.checkAccess(klass.getElementalType(), accessingKlass, false)) {
                    Meta meta = context.getMeta();
                    context.getLogger().log(Level.FINE, "Access check of: " + String.valueOf(klass.getType()) + " from " + String.valueOf(accessingKlass.getType()) + " throws IllegalAccessError");
                    throw meta.throwExceptionWithMessage(meta.java_lang_IllegalAccessError, meta.toGuestString(klassName));
                }
                return new Resolved(klass);
            }
            catch (EspressoException e) {
                CompilerDirectives.transferToInterpreter();
                Meta meta = pool.getContext().getMeta();
                if (meta.java_lang_ClassNotFoundException.isAssignableFrom(e.getGuestException().getKlass())) {
                    throw meta.throwExceptionWithMessage(meta.java_lang_NoClassDefFoundError, meta.toGuestString(klassName));
                }
                throw e;
            }
            catch (VirtualMachineError e) {
                throw e;
            }
        }

        @Override
        public void validate(ConstantPool pool) {
            pool.utf8At(this.classNameIndex).validateClassName();
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar(this.classNameIndex);
        }
    }

    public static final class PreResolved
    implements ClassConstant,
    Resolvable {
        private final Klass resolved;

        PreResolved(Klass resolved) {
            this.resolved = Objects.requireNonNull(resolved);
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            return this.resolved.getName();
        }

        @Override
        public Resolved resolve(RuntimeConstantPool pool, int thisIndex, Klass accessingKlass) {
            return new Resolved(this.resolved);
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar('\u0000');
        }
    }

    public static final class WithString
    implements ClassConstant,
    Resolvable {
        private final Symbol<Symbol.Name> name;

        WithString(Symbol<Symbol.Name> name) {
            this.name = name;
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            return this.name;
        }

        @Override
        public Resolved resolve(RuntimeConstantPool pool, int thisIndex, Klass accessingKlass) {
            CLASS_RESOLVE_COUNT.inc();
            assert (accessingKlass != null);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Symbol<Symbol.Name> klassName = this.getName(pool);
            EspressoContext context = pool.getContext();
            Meta meta = context.getMeta();
            Klass klass = meta.resolveSymbolOrFail(context.getTypes().fromName(klassName), accessingKlass.getDefiningClassLoader(), accessingKlass.protectionDomain());
            if (!Klass.checkAccess(klass.getElementalType(), accessingKlass, false)) {
                context.getLogger().log(Level.FINE, "Access check of: " + String.valueOf(klass.getType()) + " from " + String.valueOf(accessingKlass.getType()) + " throws IllegalAccessError");
                throw meta.throwExceptionWithMessage(meta.java_lang_IllegalAccessError, meta.toGuestString(klassName));
            }
            return new Resolved(klass);
        }

        @Override
        public void validate(ConstantPool pool) {
            if (!Validation.validModifiedUTF8(this.name) || !Validation.validClassNameEntry(this.name)) {
                throw ConstantPool.classFormatError("Invalid class name entry: " + String.valueOf(this.name));
            }
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar('\u0000');
        }
    }

    public static final class Resolved
    implements ClassConstant,
    Resolvable.ResolvedConstant {
        private final Klass resolved;

        Resolved(Klass resolved) {
            this.resolved = Objects.requireNonNull(resolved);
        }

        @Override
        public Symbol<Symbol.Name> getName(ConstantPool pool) {
            return this.resolved.getName();
        }

        @Override
        public Klass value() {
            return this.resolved;
        }
    }
}

