/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.ffi.nfi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.espresso.ffi.Buffer;
import com.oracle.truffle.espresso.ffi.NativeAccess;
import com.oracle.truffle.espresso.ffi.NativeSignature;
import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.ffi.Pointer;
import com.oracle.truffle.espresso.ffi.RawPointer;
import com.oracle.truffle.espresso.ffi.SignatureCallNode;
import com.oracle.truffle.espresso.ffi.TruffleByteBuffer;
import com.oracle.truffle.espresso.ffi.nfi.NFISignatureCallNode;
import com.oracle.truffle.espresso.ffi.nfi.NativeUtils;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.perf.DebugCounter;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Collect;
import com.oracle.truffle.espresso.vm.UnsafeAccess;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import sun.misc.Unsafe;

public class NFINativeAccess
implements NativeAccess {
    private static final Unsafe UNSAFE = UnsafeAccess.get();
    private static final boolean CACHE_SIGNATURES = "true".equals(System.getProperty("espresso.nfi.cache_signatures", "true"));
    private final DebugCounter nfiSignaturesCreated = DebugCounter.create("NFI signatures created");
    private final Map<NativeSignature, Object> nativeSignatureCache;
    private final Map<NativeSignature, Object> javaSignatureCache;
    protected final InteropLibrary uncachedInterop = InteropLibrary.getUncached();
    protected final SignatureLibrary uncachedSignature = SignatureLibrary.getUncached();
    private final TruffleLogger logger = TruffleLogger.getLogger((String)"java", NFINativeAccess.class);
    protected final TruffleLanguage.Env env;

    protected static String nfiType(NativeType nativeType) {
        switch (nativeType) {
            case VOID: {
                return "VOID";
            }
            case BOOLEAN: 
            case BYTE: {
                return "SINT8";
            }
            case CHAR: 
            case SHORT: {
                return "SINT16";
            }
            case INT: {
                return "SINT32";
            }
            case LONG: {
                return "SINT64";
            }
            case FLOAT: {
                return "FLOAT";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case OBJECT: {
                return "SINT64";
            }
            case POINTER: {
                return "POINTER";
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("Unexpected: " + String.valueOf((Object)nativeType));
    }

    protected String nfiStringSignature(NativeSignature nativeSignature, boolean fromJava) {
        StringBuilder sb = new StringBuilder(64);
        sb.append('(');
        boolean isFirst = true;
        for (int i = 0; i < nativeSignature.getParameterCount() + nativeSignature.getVarArgsParameterCount(); ++i) {
            if (!isFirst) {
                sb.append(',');
            }
            if (i == nativeSignature.getParameterCount()) {
                sb.append("...");
            }
            sb.append(NFINativeAccess.nfiType(nativeSignature.parameterTypeAt(i)));
            isFirst = false;
        }
        sb.append(')');
        sb.append(':');
        sb.append(NFINativeAccess.nfiType(nativeSignature.getReturnType()));
        return sb.toString();
    }

    protected final TruffleLogger getLogger() {
        return this.logger;
    }

    protected Object createNFISignature(NativeSignature nativeSignature, boolean fromJava) {
        this.nfiSignaturesCreated.inc();
        Source source = Source.newBuilder((String)"nfi", (CharSequence)this.nfiStringSignature(nativeSignature, fromJava), (String)"signature").build();
        CallTarget target = this.env.parseInternal(source, new String[0]);
        return target.call(new Object[0]);
    }

    protected final Object getOrCreateNFISignature(NativeSignature nativeSignature, boolean fromJava) {
        return CACHE_SIGNATURES ? (fromJava ? this.javaSignatureCache.computeIfAbsent(nativeSignature, sig -> this.createNFISignature(nativeSignature, true)) : this.nativeSignatureCache.computeIfAbsent(nativeSignature, sig -> this.createNFISignature(nativeSignature, false))) : this.createNFISignature(nativeSignature, fromJava);
    }

    NFINativeAccess(TruffleLanguage.Env env) {
        this.env = env;
        this.javaSignatureCache = CACHE_SIGNATURES ? new ConcurrentHashMap() : null;
        this.nativeSignatureCache = CACHE_SIGNATURES ? new ConcurrentHashMap() : null;
    }

    @Override
    public @Pointer TruffleObject loadLibrary(Path libraryPath) {
        CompilerAsserts.neverPartOfCompilation();
        if ((libraryPath.isAbsolute() || libraryPath.getNameCount() > 1) && !Files.exists(libraryPath, new LinkOption[0])) {
            return null;
        }
        return this.loadLibrary0(libraryPath);
    }

    protected @Pointer TruffleObject loadLibrary0(Path libraryPath) {
        String nfiSource = String.format("load(RTLD_LAZY|RTLD_LOCAL) '%s'", libraryPath);
        return this.loadLibraryHelper(nfiSource);
    }

    @Override
    public @Pointer TruffleObject loadDefaultLibrary() {
        return this.loadLibraryHelper("default");
    }

    private static boolean isExpectedException(AbstractTruffleException e) {
        String className = ((Object)((Object)e)).getClass().getName();
        return "com.oracle.truffle.nfi.backend.libffi.NFIUnsatisfiedLinkError".equals(className) || "com.oracle.truffle.llvm.nfi.SulongNFIException".equals(className);
    }

    protected @Pointer TruffleObject loadLibraryHelper(String nfiSource) {
        Source source = Source.newBuilder((String)"nfi", (CharSequence)nfiSource, (String)"loadLibrary").build();
        CallTarget target = this.env.parseInternal(source, new String[0]);
        try {
            return (TruffleObject)target.call(new Object[0]);
        }
        catch (IllegalArgumentException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getLogger().log(Level.SEVERE, "TruffleNFI native library isolation is not supported", (Throwable)e);
            throw EspressoError.shouldNotReachHere(e);
        }
        catch (AbstractTruffleException e) {
            assert (NFINativeAccess.isExpectedException(e));
            this.getLogger().fine("AbstractTruffleException while loading library though NFI (" + nfiSource + ") : " + e.getMessage());
            return null;
        }
    }

    @Override
    public void unloadLibrary(@Pointer TruffleObject library) {
        this.getLogger().fine(String.format("JVM_UnloadLibrary: %x was not unloaded!", NativeUtils.interopAsPointer(library)));
    }

    @Override
    public @Pointer TruffleObject lookupSymbol(@Pointer TruffleObject library, String symbolName) {
        try {
            TruffleObject symbol = (TruffleObject)this.uncachedInterop.readMember((Object)library, symbolName);
            if (InteropLibrary.getUncached().isNull((Object)symbol)) {
                return null;
            }
            return symbol;
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
        catch (UnknownIdentifierException e) {
            return null;
        }
    }

    @Override
    public @Pointer TruffleObject bindSymbol(@Pointer TruffleObject symbol, NativeSignature nativeSignature) {
        if (this.uncachedInterop.isNull((Object)symbol)) {
            return null;
        }
        TruffleObject executable = (TruffleObject)this.uncachedSignature.bind(this.getCallableSignature(nativeSignature, true), (Object)symbol);
        assert (this.uncachedInterop.isExecutable((Object)executable));
        return new NativeToJavaWrapper(executable, nativeSignature);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getCallableSignature(NativeSignature nativeSignature, boolean fromJava) {
        return this.getOrCreateNFISignature(nativeSignature, fromJava);
    }

    @Override
    public Object callSignature(Object signature, @Pointer TruffleObject symbol, Object ... args) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
        return SignatureLibrary.getUncached().call(signature, (Object)symbol, args);
    }

    @Override
    public SignatureCallNode createSignatureCall(NativeSignature nativeSignature, boolean fromJava) {
        return NFISignatureCallNode.create(this.getCallableSignature(nativeSignature, fromJava));
    }

    @Override
    public @Pointer TruffleObject createNativeClosure(TruffleObject executable, NativeSignature nativeSignature) {
        assert (this.uncachedInterop.isExecutable((Object)executable));
        JavaToNativeWrapper wrappedExecutable = new JavaToNativeWrapper(executable, nativeSignature);
        TruffleObject nativeFn = (TruffleObject)this.uncachedSignature.createClosure(this.getCallableSignature(nativeSignature, false), (Object)wrappedExecutable);
        assert (this.uncachedInterop.isPointer((Object)nativeFn));
        return nativeFn;
    }

    @Override
    public void prepareThread() {
    }

    @Override
    public @Buffer TruffleObject allocateMemory(long size) {
        long address = 0L;
        try {
            address = UNSAFE.allocateMemory(size);
        }
        catch (OutOfMemoryError e) {
            return null;
        }
        return TruffleByteBuffer.wrap(RawPointer.create(address), Math.toIntExact(size));
    }

    @Override
    public @Buffer TruffleObject reallocateMemory(@Pointer TruffleObject buffer, long newSize) {
        assert (InteropLibrary.getUncached().isPointer((Object)buffer));
        long oldAddress = 0L;
        try {
            oldAddress = InteropLibrary.getUncached().asPointer((Object)buffer);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
        long newAddress = 0L;
        try {
            newAddress = UNSAFE.reallocateMemory(oldAddress, newSize);
        }
        catch (OutOfMemoryError e) {
            return null;
        }
        return TruffleByteBuffer.wrap(RawPointer.create(newAddress), Math.toIntExact(newSize));
    }

    @Override
    public void freeMemory(@Pointer TruffleObject buffer) {
        assert (InteropLibrary.getUncached().isPointer((Object)buffer));
        long address = 0L;
        try {
            address = InteropLibrary.getUncached().asPointer((Object)buffer);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
        UNSAFE.freeMemory(address);
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class NativeToJavaWrapper
    implements TruffleObject {
        private static final TruffleLogger logger = TruffleLogger.getLogger((String)"java", NativeToJavaWrapper.class);
        final TruffleObject delegate;
        final NativeSignature nativeSignature;

        NativeToJavaWrapper(TruffleObject executable, NativeSignature nativeSignature) {
            this.delegate = executable;
            this.nativeSignature = nativeSignature;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        Object doExecuteBoundary(Object[] arguments, InteropLibrary delegateInterop) throws ArityException {
            return this.doExecute(arguments, delegateInterop);
        }

        @ExplodeLoop
        Object doExecute(Object[] arguments, InteropLibrary delegateInterop) throws ArityException {
            int paramCount = this.nativeSignature.getParameterCount() + this.nativeSignature.getVarArgsParameterCount();
            CompilerAsserts.partialEvaluationConstant((int)paramCount);
            if (arguments.length != paramCount) {
                CompilerDirectives.transferToInterpreter();
                throw ArityException.create((int)paramCount, (int)paramCount, (int)arguments.length);
            }
            try {
                Object[] convertedArgs = new Object[arguments.length];
                block14: for (int i = 0; i < paramCount; ++i) {
                    NativeType param = this.nativeSignature.parameterTypeAt(i);
                    CompilerAsserts.partialEvaluationConstant((Object)((Object)param));
                    switch (param) {
                        case BOOLEAN: {
                            convertedArgs[i] = (Boolean)arguments[i] != false ? (byte)1 : 0;
                            continue block14;
                        }
                        case CHAR: {
                            convertedArgs[i] = (short)((Character)arguments[i]).charValue();
                            continue block14;
                        }
                        default: {
                            convertedArgs[i] = arguments[i];
                        }
                    }
                }
                Object ret = delegateInterop.execute((Object)this.delegate, convertedArgs);
                CompilerAsserts.partialEvaluationConstant((Object)((Object)this.nativeSignature.getReturnType()));
                switch (this.nativeSignature.getReturnType()) {
                    case BOOLEAN: {
                        ret = (Byte)ret != 0;
                        break;
                    }
                    case CHAR: {
                        ret = Character.valueOf((char)((Short)ret).shortValue());
                        break;
                    }
                    case VOID: {
                        ret = StaticObject.NULL;
                    }
                }
                return ret;
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere("This can be caused by mixing native/ffi symbols with llvm signatures and vice-versa", e);
            }
            catch (UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
            catch (AbstractTruffleException | OutOfMemoryError | StackOverflowError e) {
                throw e;
            }
            catch (Throwable t) {
                logger.log(Level.FINE, "Exception seen", t);
                throw t;
            }
        }

        @ExportMessage
        @ReportPolymorphism
        static abstract class Execute {
            static final int INLINE_CACHE_SIZE = 2;

            Execute() {
            }

            @Specialization(limit="INLINE_CACHE_SIZE", guards={"receiver == cachedReceiver"})
            protected static Object doCached(NativeToJavaWrapper receiver, Object[] arguments, @Cached(value="receiver", weak=true) NativeToJavaWrapper cachedReceiver, @CachedLibrary(value="cachedReceiver.delegate") InteropLibrary delegateInterop) throws ArityException {
                return cachedReceiver.doExecute(arguments, delegateInterop);
            }

            @Specialization(replaces={"doCached"})
            protected static Object doGeneric(NativeToJavaWrapper receiver, Object[] arguments, @CachedLibrary(value="receiver.delegate") InteropLibrary delegateInterop) throws ArityException {
                return receiver.doExecuteBoundary(arguments, delegateInterop);
            }
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class JavaToNativeWrapper
    implements TruffleObject {
        private static final TruffleLogger logger = TruffleLogger.getLogger((String)"java", JavaToNativeWrapper.class);
        final TruffleObject delegate;
        final NativeSignature nativeSignature;

        JavaToNativeWrapper(TruffleObject executable, NativeSignature nativeSignature) {
            this.delegate = executable;
            this.nativeSignature = nativeSignature;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        Object doExecuteBoundary(Object[] arguments, InteropLibrary delegateInterop) throws ArityException {
            return this.doExecute(arguments, delegateInterop);
        }

        @ExplodeLoop
        Object doExecute(Object[] arguments, InteropLibrary delegateInterop) throws ArityException {
            int paramCount = this.nativeSignature.getParameterCount() + this.nativeSignature.getVarArgsParameterCount();
            CompilerAsserts.partialEvaluationConstant((int)paramCount);
            if (arguments.length != paramCount) {
                CompilerDirectives.transferToInterpreter();
                throw ArityException.create((int)paramCount, (int)paramCount, (int)arguments.length);
            }
            try {
                Object[] convertedArgs = new Object[arguments.length];
                block13: for (int i = 0; i < paramCount; ++i) {
                    NativeType param = this.nativeSignature.parameterTypeAt(i);
                    CompilerAsserts.partialEvaluationConstant((Object)((Object)param));
                    switch (param) {
                        case BOOLEAN: {
                            convertedArgs[i] = (Byte)arguments[i] != 0;
                            continue block13;
                        }
                        case CHAR: {
                            convertedArgs[i] = Character.valueOf((char)((Short)arguments[i]).shortValue());
                            continue block13;
                        }
                        default: {
                            convertedArgs[i] = arguments[i];
                        }
                    }
                }
                Object ret = delegateInterop.execute((Object)this.delegate, convertedArgs);
                CompilerAsserts.partialEvaluationConstant((Object)((Object)this.nativeSignature.getReturnType()));
                switch (this.nativeSignature.getReturnType()) {
                    case BOOLEAN: {
                        ret = (Boolean)ret != false ? (byte)1 : 0;
                        break;
                    }
                    case CHAR: {
                        ret = (short)((Character)ret).charValue();
                        break;
                    }
                    case VOID: {
                        ret = StaticObject.NULL;
                    }
                }
                return ret;
            }
            catch (UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere(e);
            }
            catch (AbstractTruffleException | OutOfMemoryError | StackOverflowError e) {
                throw e;
            }
            catch (Throwable t) {
                logger.log(Level.FINE, "Exception seen", t);
                throw t;
            }
        }

        @ExportMessage
        @ReportPolymorphism
        static abstract class Execute {
            static final int INLINE_CACHE_SIZE = 2;

            Execute() {
            }

            @Specialization(limit="INLINE_CACHE_SIZE", guards={"receiver == cachedReceiver"})
            protected static Object doCached(JavaToNativeWrapper receiver, Object[] arguments, @Cached(value="receiver", weak=true) JavaToNativeWrapper cachedReceiver, @CachedLibrary(value="cachedReceiver.delegate") InteropLibrary delegateInterop) throws ArityException {
                return cachedReceiver.doExecute(arguments, delegateInterop);
            }

            @Specialization(replaces={"doCached"})
            protected static Object doGeneric(JavaToNativeWrapper receiver, Object[] arguments, @CachedLibrary(value="receiver.delegate") InteropLibrary delegateInterop) throws ArityException {
                return receiver.doExecuteBoundary(arguments, delegateInterop);
            }
        }
    }

    @Collect(value={NativeAccess.class})
    public static final class Provider
    implements NativeAccess.Provider {
        public static final String ID = "nfi-native";

        @Override
        public String id() {
            return ID;
        }

        @Override
        public NativeAccess create(TruffleLanguage.Env env) {
            return new NFINativeAccess(env);
        }
    }
}

