/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.HierarchyInfo;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ModuleTable;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.PackageTable;
import com.oracle.truffle.espresso.jdwp.api.MethodRef;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;

public final class ArrayKlass
extends Klass {
    private final Klass componentType;
    private final Klass elementalType;
    private final int dimension;
    @CompilerDirectives.CompilationFinal
    private Assumption redefineAssumption;
    @CompilerDirectives.CompilationFinal
    private HierarchyInfo hierarchyInfo;

    ArrayKlass(Klass componentType) {
        super(componentType.getContext(), null, componentType.getTypes().arrayOf(componentType.getType()), componentType.getElementalType().getModifiers() & 7 | 0x10 | 0x400);
        EspressoError.guarantee(componentType.getJavaKind() != JavaKind.Void, "Invalid void[] class.");
        this.componentType = componentType;
        this.elementalType = componentType.getElementalType();
        this.dimension = Types.getArrayDimensions(this.getType());
        this.redefineAssumption = componentType.getRedefineAssumption();
        assert (this.getMeta().java_lang_Class != null);
        this.initializeEspressoClass();
    }

    @Override
    public ObjectKlass getSuperKlass() {
        return this.getMeta().java_lang_Object;
    }

    @Override
    public ObjectKlass[] getSuperInterfaces() {
        return this.getMeta().ARRAY_SUPERINTERFACES;
    }

    @Override
    public int getClassModifiers() {
        return this.getElementalType().getClassModifiers() & 7 | 0x10 | 0x400;
    }

    @Override
    public Klass getElementalType() {
        return this.elementalType;
    }

    public Klass getComponentType() {
        return this.componentType;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isMember() {
        return false;
    }

    @Override
    public Klass getEnclosingType() {
        return null;
    }

    @Override
    public Method[] getDeclaredConstructors() {
        return Method.EMPTY_ARRAY;
    }

    @Override
    public Method[] getDeclaredMethods() {
        return Method.EMPTY_ARRAY;
    }

    @Override
    public MethodRef[] getDeclaredMethodRefs() {
        return Method.EMPTY_VERSION_ARRAY;
    }

    @Override
    public Method.MethodVersion[] getDeclaredMethodVersions() {
        return Method.EMPTY_VERSION_ARRAY;
    }

    @Override
    public Field[] getDeclaredFields() {
        return Field.EMPTY_ARRAY;
    }

    @Override
    public Method lookupMethod(Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature, Klass.LookupMode mode) {
        KLASS_LOOKUP_METHOD_COUNT.inc();
        return this.getSuperKlass().lookupMethod(methodName, signature, mode);
    }

    @Override
    public @JavaType(value=ClassLoader.class) StaticObject getDefiningClassLoader() {
        return this.elementalType.getDefiningClassLoader();
    }

    @Override
    public ConstantPool getConstantPool() {
        return this.getElementalType().getConstantPool();
    }

    public int getDimension() {
        return this.dimension;
    }

    boolean arrayTypeChecks(ArrayKlass other) {
        assert (this.isArray());
        int thisDim = this.getDimension();
        int otherDim = other.getDimension();
        if (otherDim > thisDim) {
            Klass thisElemental = this.getElementalType();
            return thisElemental == this.getMeta().java_lang_Object || thisElemental == this.getMeta().java_io_Serializable || thisElemental == this.getMeta().java_lang_Cloneable;
        }
        if (thisDim == otherDim) {
            Klass other1;
            Klass klass = this.getElementalType();
            if (klass == (other1 = other.getElementalType())) {
                return true;
            }
            if (klass.isPrimitive() || other1.isPrimitive()) {
                assert (klass.getContext() == other1.getContext());
                return klass == other1;
            }
            if (klass.isInterface()) {
                return klass.checkInterfaceSubclassing(other1);
            }
            int depth = klass.getHierarchyDepth();
            return other1.getHierarchyDepth() >= depth && other1.getSuperTypes()[depth] == klass;
        }
        assert (thisDim > otherDim);
        return false;
    }

    @Override
    public ModuleTable.ModuleEntry module() {
        return this.getElementalType().module();
    }

    @Override
    public PackageTable.PackageEntry packageEntry() {
        return this.getElementalType().packageEntry();
    }

    @Override
    public String getNameAsString() {
        return "[" + this.componentType.getNameAsString();
    }

    @Override
    public String getExternalName() {
        String base = super.getExternalName();
        if (this.getElementalType().isAnonymous()) {
            return this.fixupAnonymousExternalName(base);
        }
        if (this.getElementalType().isHidden()) {
            return this.convertHidden(base);
        }
        return base;
    }

    @CompilerDirectives.TruffleBoundary
    private String fixupAnonymousExternalName(String base) {
        return base.replace(";", EspressoError.cat("/", this.getElementalType().getId(), ";"));
    }

    @Override
    protected Klass[] getSuperTypes() {
        return this.getHierarchyInfo().supertypesWithSelfCache;
    }

    @Override
    protected int getHierarchyDepth() {
        return this.getHierarchyInfo().hierarchyDepth;
    }

    @Override
    protected ObjectKlass.KlassVersion[] getTransitiveInterfacesList() {
        return this.getHierarchyInfo().transitiveInterfaceCache;
    }

    private HierarchyInfo getHierarchyInfo() {
        HierarchyInfo info = this.hierarchyInfo;
        if (info == null || !this.redefineAssumption.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            info = this.hierarchyInfo = this.updateHierarchyInfo();
            this.redefineAssumption = this.getRedefineAssumption();
        }
        return info;
    }

    private HierarchyInfo updateHierarchyInfo() {
        int depth = this.getArraySuperType().getHierarchyDepth() + 1;
        Klass[] superKlassTypes = this.getArraySuperType().getSuperTypes();
        Klass[] supertypes = new Klass[superKlassTypes.length + 1];
        assert (supertypes.length == depth + 1);
        supertypes[depth] = this;
        System.arraycopy(superKlassTypes, 0, supertypes, 0, depth);
        ObjectKlass[] superItfs = this.getSuperInterfaces();
        ObjectKlass.KlassVersion[] transitiveInterfaces = new ObjectKlass.KlassVersion[superItfs.length];
        for (int i = 0; i < superItfs.length; ++i) {
            transitiveInterfaces[i] = superItfs[i].getKlassVersion();
        }
        return new HierarchyInfo(supertypes, depth, transitiveInterfaces);
    }

    private Klass getArraySuperType() {
        if (this == this.getMeta().java_lang_Object.array() || this.componentType.isPrimitive()) {
            return this.getMeta().java_lang_Object;
        }
        return this.componentType.getSupertype().array();
    }

    @Override
    public Assumption getRedefineAssumption() {
        return this.componentType.getRedefineAssumption();
    }
}

