/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ModuleTable;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.PackageTable;
import com.oracle.truffle.espresso.jdwp.api.MethodRef;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.GuestAllocator;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;

public final class PrimitiveKlass
extends Klass {
    private final JavaKind primitiveKind;

    public PrimitiveKlass(EspressoContext context, JavaKind primitiveKind) {
        super(context, primitiveKind.getPrimitiveBinaryName(), primitiveKind.getType(), 1041);
        assert (primitiveKind.isPrimitive()) : String.valueOf((Object)primitiveKind) + " not a primitive kind";
        this.primitiveKind = primitiveKind;
        assert (this.getMeta().java_lang_Class != null);
        this.initializeEspressoClass();
    }

    public JavaKind getPrimitiveJavaKind() {
        return this.primitiveKind;
    }

    @Override
    public Klass getElementalType() {
        return this;
    }

    @Override
    public @JavaType(value=ClassLoader.class) StaticObject getDefiningClassLoader() {
        return StaticObject.NULL;
    }

    @Override
    public ConstantPool getConstantPool() {
        return null;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isMember() {
        return false;
    }

    @Override
    public Klass getEnclosingType() {
        return null;
    }

    @Override
    public Method[] getDeclaredConstructors() {
        return Method.EMPTY_ARRAY;
    }

    @Override
    public Method[] getDeclaredMethods() {
        return Method.EMPTY_ARRAY;
    }

    @Override
    public MethodRef[] getDeclaredMethodRefs() {
        return Method.EMPTY_VERSION_ARRAY;
    }

    @Override
    public Method.MethodVersion[] getDeclaredMethodVersions() {
        return Method.EMPTY_VERSION_ARRAY;
    }

    @Override
    public Method lookupMethod(Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature, Klass.LookupMode lookupMode) {
        return null;
    }

    @Override
    public Field[] getDeclaredFields() {
        return Field.EMPTY_ARRAY;
    }

    @Override
    public ModuleTable.ModuleEntry module() {
        return this.getRegistries().getJavaBaseModule();
    }

    @Override
    public PackageTable.PackageEntry packageEntry() {
        return null;
    }

    @Override
    public Method getClassInitializer() {
        return null;
    }

    @Override
    public String toString() {
        return "PrimitiveKlass<" + String.valueOf((Object)this.getJavaKind()) + ">";
    }

    @Override
    public int getClassModifiers() {
        return this.getModifiers();
    }

    @CompilerDirectives.TruffleBoundary
    public StaticObject allocatePrimitiveArray(int length) {
        GuestAllocator.AllocationChecks.checkCanAllocateArray(this.getMeta(), length);
        return this.getAllocator().createNewPrimitiveArray(this, length);
    }

    @Override
    protected Klass[] getSuperTypes() {
        return new Klass[]{this};
    }

    @Override
    protected int getHierarchyDepth() {
        return 0;
    }

    @Override
    protected ObjectKlass.KlassVersion[] getTransitiveInterfacesList() {
        return ObjectKlass.EMPTY_KLASSVERSION_ARRAY;
    }
}

