/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jni;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.lang.ref.WeakReference;
import java.util.Arrays;

final class GlobalHandles {
    static final int NATIVE_MIN_GLOBAL_HANDLES = 8;
    int top = 1;
    private Object[] objects = new Object[8];

    GlobalHandles() {
    }

    public synchronized boolean destroy(int index) {
        if (index == 0) {
            return false;
        }
        Object previous = this.objects[index];
        this.objects[index] = null;
        return previous != null;
    }

    private synchronized int create(Object obj) {
        assert (obj != null);
        assert (obj instanceof StaticObject || obj instanceof WeakReference);
        if (this.top >= this.objects.length) {
            this.objects = Arrays.copyOf(this.objects, Math.multiplyExact(this.objects.length, 2), Object[].class);
        }
        assert (this.top > 0);
        int handle = this.top++;
        this.objects[handle] = obj;
        return handle;
    }

    public int createWeakGlobal(StaticObject obj) {
        if (StaticObject.isNull(obj)) {
            return 0;
        }
        return this.create(new WeakReference<StaticObject>(obj));
    }

    public int create(StaticObject obj) {
        if (StaticObject.isNull(obj)) {
            return 0;
        }
        return this.create((Object)obj);
    }

    StaticObject get(int index) {
        if (index == 0) {
            return StaticObject.NULL;
        }
        assert (index != Integer.MIN_VALUE) : "invalid handle";
        Object obj = this.objects[index];
        if (obj instanceof WeakReference) {
            Object referent = ((WeakReference)CompilerDirectives.castExact((Object)obj, WeakReference.class)).get();
            if (referent == null) {
                return StaticObject.NULL;
            }
            return (StaticObject)referent;
        }
        assert (obj != null);
        return (StaticObject)obj;
    }

    public int getObjectRefType(int handle) {
        if (handle == 0) {
            return 0;
        }
        assert (this.validHandle(handle));
        Object obj = this.objects[handle];
        if (obj == null) {
            return 0;
        }
        if (obj instanceof WeakReference) {
            return 3;
        }
        assert (obj instanceof StaticObject) : obj;
        return 2;
    }

    public boolean validHandle(int handle) {
        return handle > 0 && handle < this.top;
    }
}

