/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.bytecodes;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.NullCheck;
import com.oracle.truffle.espresso.nodes.interop.ToReference;
import com.oracle.truffle.espresso.nodes.quick.interop.ForeignArrayUtils;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@NodeInfo(shortName="AALOAD")
@GenerateUncached
public abstract class ReferenceArrayLoad
extends EspressoNode {
    public abstract StaticObject execute(StaticObject var1, int var2);

    @Specialization
    StaticObject doWithNullCheck(StaticObject array, int index, @Cached NullCheck nullCheck, @Cached WithoutNullCheck objectArrayLoad) {
        return objectArrayLoad.execute(nullCheck.execute(array), index);
    }

    @NodeInfo(shortName="AALOAD !nullcheck")
    @GenerateUncached
    public static abstract class WithoutNullCheck
    extends EspressoNode {
        protected static final int LIMIT = 2;

        public abstract StaticObject execute(StaticObject var1, int var2);

        @Specialization(guards={"array.isEspressoObject()"})
        StaticObject doEspresso(StaticObject array, int index) {
            assert (!StaticObject.isNull(array));
            return this.getContext().getInterpreterToVM().getArrayObject(this.getLanguage(), index, array);
        }

        public static ToReference createToReference(Klass array) {
            ArrayKlass arrayKlass = (ArrayKlass)array;
            return ToReference.createToReference(arrayKlass.getComponentType(), array.getMeta());
        }

        @Specialization(guards={"array.isForeignObject()", "cachedArrayKlass == array.getKlass()"})
        StaticObject doForeign(StaticObject array, int index, @Cached(value="array.getKlass()") Klass cachedArrayKlass, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached(value="createToReference(cachedArrayKlass)") ToReference toEspresso, @Cached BranchProfile exceptionProfile) {
            assert (!StaticObject.isNull(array));
            Meta meta = this.getContext().getMeta();
            Object result = ForeignArrayUtils.readForeignArrayElement(array, index, this.getLanguage(), meta, interop, exceptionProfile);
            try {
                return toEspresso.execute(result);
            }
            catch (UnsupportedTypeException e) {
                exceptionProfile.enter();
                throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "Could not cast the foreign array element to the array component type");
            }
        }

        @Specialization(replaces={"doForeign"}, guards={"array.isForeignObject()"})
        StaticObject doGeneric(StaticObject array, int index, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached ToReference.DynamicToReference toEspressoNode, @Cached BranchProfile exceptionProfile) {
            assert (!StaticObject.isNull(array));
            Meta meta = this.getContext().getMeta();
            Object result = ForeignArrayUtils.readForeignArrayElement(array, index, this.getLanguage(), meta, interop, exceptionProfile);
            try {
                ArrayKlass arrayKlass = (ArrayKlass)array.getKlass();
                return toEspressoNode.execute(result, arrayKlass.getComponentType());
            }
            catch (UnsupportedTypeException e) {
                exceptionProfile.enter();
                throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "Could not cast the foreign array element to the array component type");
            }
        }
    }
}

