/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.helper;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.helper.AbstractSetFieldNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

abstract class ObjectSetFieldNode
extends AbstractSetFieldNode {
    ObjectSetFieldNode(Field f) {
        super(f);
        assert (f.getKind() == JavaKind.Object);
    }

    @Override
    public void setField(VirtualFrame frame, BytecodeNode root, StaticObject receiver, int top, int statementIndex) {
        StaticObject value = EspressoFrame.popObject((Frame)frame, top - 1);
        root.notifyFieldModification(frame, statementIndex, this.field, receiver, value);
        this.executeSetField(receiver, value);
    }

    abstract void executeSetField(StaticObject var1, Object var2);

    @Specialization(guards={"receiver.isEspressoObject()"})
    void doEspresso(StaticObject receiver, StaticObject value) {
        this.field.setObject(receiver, value);
    }

    @Specialization(guards={"receiver.isForeignObject()"}, limit="CACHED_LIBRARY_LIMIT")
    void doForeign(StaticObject receiver, StaticObject fieldValue, @Bind(value="getLanguage()") EspressoLanguage language, @CachedLibrary(value="receiver.rawForeignObject(language)") InteropLibrary interopLibrary, @Cached BranchProfile error) {
        this.setForeignField(receiver, fieldValue.isForeignObject() ? fieldValue.rawForeignObject(language) : fieldValue, interopLibrary, language, this.getContext(), error);
    }
}

