/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.quick;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.bytecode.Bytecodes;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.nodes.EspressoFrame;
import com.oracle.truffle.espresso.nodes.bytecodes.InstanceOf;
import com.oracle.truffle.espresso.nodes.quick.QuickNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class InstanceOfQuickNode
extends QuickNode {
    @Node.Child
    InstanceOf instanceOf;
    static final int stackEffectOf_INSTANCEOF = Bytecodes.stackEffectOf(193);

    public InstanceOfQuickNode(Klass typeToCheck, int top, int curBCI) {
        super(top, curBCI);
        assert (!typeToCheck.isPrimitive());
        this.instanceOf = InstanceOf.create(typeToCheck, true);
    }

    @Override
    public int execute(VirtualFrame frame) {
        StaticObject receiver = EspressoFrame.popObject((Frame)frame, this.top - 1);
        boolean result = StaticObject.notNull(receiver) && this.instanceOf.execute(receiver.getKlass());
        EspressoFrame.putInt((Frame)frame, this.top - 1, result ? 1 : 0);
        return stackEffectOf_INSTANCEOF;
    }
}

