/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.redefinition.plugins.jdkproxy;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.jdwp.api.KlassRef;
import com.oracle.truffle.espresso.jdwp.api.RedefineInfo;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.redefinition.plugins.api.InternalRedefinitionPlugin;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JDKProxyRedefinitionPlugin
extends InternalRedefinitionPlugin {
    private final Map<KlassRef, List<ProxyCache>> cache = Collections.synchronizedMap(new HashMap());
    private DirectCallNode proxyGeneratorMethodCallNode;

    public synchronized void collectProxyArguments(EspressoLanguage language, Meta meta, @JavaType(value=String.class) StaticObject proxyName, @JavaType(value=Class[].class) StaticObject interfaces, int classModifier, DirectCallNode generatorMethodCallNode) {
        if (this.proxyGeneratorMethodCallNode == null) {
            this.proxyGeneratorMethodCallNode = generatorMethodCallNode;
        }
        this.registerClassLoadAction(meta.toHostString(proxyName), klass -> {
            ProxyCache proxyCache = new ProxyCache(klass, proxyName, interfaces, classModifier);
            Klass[] proxyInterfaces = new Klass[interfaces.length(language)];
            for (int i = 0; i < proxyInterfaces.length; ++i) {
                proxyInterfaces[i] = (Klass)meta.HIDDEN_MIRROR_KLASS.getHiddenObject((StaticObject)interfaces.get(language, i));
            }
            for (Klass proxyInterface : proxyInterfaces) {
                this.addCacheEntry(proxyCache, proxyInterface);
            }
        });
    }

    @CompilerDirectives.TruffleBoundary
    private void addCacheEntry(ProxyCache proxyCache, KlassRef proxyInterface) {
        List<ProxyCache> list = this.cache.get(proxyInterface);
        if (list == null) {
            list = Collections.synchronizedList(new ArrayList());
            this.cache.put(proxyInterface, list);
        }
        list.add(proxyCache);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public synchronized void collectExtraClassesToReload(List<RedefineInfo> redefineInfos, List<RedefineInfo> additional) {
        for (RedefineInfo redefineInfo : redefineInfos) {
            KlassRef klass = redefineInfo.getKlass();
            if (klass == null) continue;
            List list = this.cache.getOrDefault(klass, Collections.emptyList());
            for (ProxyCache proxyCache : list) {
                StaticObject result = (StaticObject)this.proxyGeneratorMethodCallNode.call(new Object[]{proxyCache.proxyName, proxyCache.interfaces, proxyCache.classModifier});
                byte[] proxyBytes = (byte[])this.getContext().getMeta().toHostBoxed(result);
                additional.add(new RedefineInfo(proxyCache.klass, proxyBytes));
            }
        }
    }

    @Override
    public boolean shouldRerunClassInitializer(ObjectKlass klass, boolean changed) {
        return changed && this.getContext().getMeta().java_lang_reflect_Proxy.isAssignable(klass);
    }

    private final class ProxyCache {
        private final KlassRef klass;
        private final StaticObject proxyName;
        private final StaticObject interfaces;
        private final int classModifier;

        ProxyCache(KlassRef klass, StaticObject proxyName, StaticObject interfaces, int classModifier) {
            this.klass = klass;
            this.proxyName = proxyName;
            this.interfaces = interfaces;
            this.classModifier = classModifier;
        }
    }
}

