/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.ref;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.ref.ClassAssembler;
import com.oracle.truffle.espresso.ref.EspressoReference;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.JavaVersion;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.UnsafeAccess;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import sun.misc.Unsafe;

public final class FinalizationSupport {
    private static final MethodHandle NEW_ESPRESSO_FINAL_REFERENCE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void ensureInitialized() {
    }

    @CompilerDirectives.TruffleBoundary
    public static EspressoReference createEspressoFinalReference(EspressoContext context, StaticObject self, StaticObject referent) {
        if (!($assertionsDisabled || context.getEspressoEnv().UseHostFinalReference && FinalizationSupport.canUseHostFinalReference())) {
            throw new AssertionError();
        }
        try {
            return NEW_ESPRESSO_FINAL_REFERENCE.invoke(self, referent, context.getReferenceQueue());
        }
        catch (OutOfMemoryError | StackOverflowError e) {
            throw e;
        }
        catch (Throwable e) {
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    public static boolean canUseHostFinalReference() {
        return NEW_ESPRESSO_FINAL_REFERENCE != null;
    }

    private static void setAccessible(AccessibleObject target, boolean value) throws Throwable {
        if (EspressoOptions.UnsafeOverride) {
            Unsafe unsafe = UnsafeAccess.get();
            Field implLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            long implLookupFieldOffset = unsafe.staticFieldOffset(implLookupField);
            Object lookupStaticFieldBase = unsafe.staticFieldBase(implLookupField);
            MethodHandles.Lookup implLookup = (MethodHandles.Lookup)unsafe.getObject(lookupStaticFieldBase, implLookupFieldOffset);
            MethodHandle overrideSetter = implLookup.findSetter(AccessibleObject.class, "override", Boolean.TYPE);
            overrideSetter.invokeWithArguments(target, value);
        } else {
            target.setAccessible(value);
        }
    }

    private static Class<?> injectClassInBootClassLoader(byte[] classBytes) throws Throwable {
        EspressoError.guarantee(JavaVersion.HOST_VERSION.java11OrLater(), "Injection mechanism only supports host Java 11+.");
        Method defineClass1 = ClassLoader.class.getDeclaredMethod("defineClass1", ClassLoader.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class, String.class);
        FinalizationSupport.setAccessible(defineClass1, true);
        Class definedClass = (Class)defineClass1.invoke(null, null, null, classBytes, 0, classBytes.length, null, null);
        FinalizationSupport.setAccessible(defineClass1, false);
        return definedClass;
    }

    private static Class<?> loadClassInDedicatedClassLoader(ClassLoader parent, final byte[] bytes) {
        return new ClassLoader((ClassLoader)parent){
            final Class<?> definedClass;
            {
                super(parent);
                this.definedClass = this.defineClass(null, bytes, 0, bytes.length);
            }

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                if (this.definedClass.getName().equals(name)) {
                    return this.definedClass;
                }
                return super.findClass(name);
            }
        }.definedClass;
    }

    static {
        boolean bl = $assertionsDisabled = !FinalizationSupport.class.desiredAssertionStatus();
        if (EspressoOptions.InjectClasses) {
            try {
                byte[] publicFinalReferenceBytes = ClassAssembler.assemblePublicFinalReference();
                Class<?> publicFinalReference = FinalizationSupport.injectClassInBootClassLoader(publicFinalReferenceBytes);
                EspressoError.guarantee("java.lang.ref.PublicFinalReference".equals(publicFinalReference.getName()), "Injected class is not named java.lang.ref.PublicFinalReference");
                EspressoError.guarantee("java.lang.ref.FinalReference".equals(publicFinalReference.getSuperclass().getName()), "Injected class does not subclass java.lang.ref.FinalReference");
                byte[] espressoFinalReferenceBytes = ClassAssembler.assembleEspressoFinalReference();
                Class<?> espressoFinalReference = FinalizationSupport.loadClassInDedicatedClassLoader(EspressoReference.class.getClassLoader(), espressoFinalReferenceBytes);
                EspressoError.guarantee("com.oracle.truffle.espresso.ref.EspressoFinalReference".equals(espressoFinalReference.getName()), "Injected class is not named com.oracle.truffle.espresso.ref.EspressoFinalReference");
                EspressoError.guarantee("java.lang.ref.PublicFinalReference".equals(espressoFinalReference.getSuperclass().getName()), "Injected class does not subclass java.lang.ref.PublicFinalReference");
                NEW_ESPRESSO_FINAL_REFERENCE = MethodHandles.privateLookupIn(espressoFinalReference, MethodHandles.lookup()).findConstructor(espressoFinalReference, MethodType.methodType(Void.TYPE, StaticObject.class, StaticObject.class, ReferenceQueue.class));
            }
            catch (Throwable t) {
                throw EspressoError.shouldNotReachHere("Error injecting while injecting classes to support finalization in the host (version " + String.valueOf(JavaVersion.HOST_VERSION) + ")", t);
            }
        } else {
            NEW_ESPRESSO_FINAL_REFERENCE = null;
        }
    }
}

