/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInteropInteropNodesFactory;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Collect;

@Collect(getter="getInstance", value={InteropNodes.class})
public final class BaseInteropInteropNodes
extends InteropNodes {
    private static final Factory factory = new Factory(InteropMessageFactories.dispatchToId(BaseInterop.class));
    private static final InteropNodes INSTANCE = new BaseInteropInteropNodes();

    private BaseInteropInteropNodes() {
        super(BaseInterop.class, null);
    }

    public static InteropNodes getInstance() {
        return INSTANCE;
    }

    @Override
    protected void registerMessages(Class<?> cls) {
        InteropMessageFactories.register(cls, InteropMessage.Message.IsNull, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsString, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.AsString, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsMetaObject, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetMetaQualifiedName, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetMetaSimpleName, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsMetaInstance, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.HasMetaObject, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetMetaObject, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.HasMetaParents, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetMetaParents, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsIdenticalOrUndefined, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.IdentityHashCode, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.HasLanguage, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetLanguage, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.ToDisplayString, factory, true);
    }

    static final class Factory
    implements InteropMessageFactory {
        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return this.sourceDispatch;
        }

        @Override
        public final InteropMessage create(InteropMessage.Message message) {
            switch (message) {
                case IsNull: {
                    return BaseInteropInteropNodesFactory.IsNullNodeGen.create();
                }
                case IsString: {
                    return BaseInteropInteropNodesFactory.IsStringNodeGen.create();
                }
                case AsString: {
                    return BaseInteropInteropNodesFactory.AsStringNodeGen.create();
                }
                case IsMetaObject: {
                    return BaseInteropInteropNodesFactory.IsMetaObjectNodeGen.create();
                }
                case GetMetaQualifiedName: {
                    return BaseInteropInteropNodesFactory.GetMetaQualifiedNameNodeGen.create();
                }
                case GetMetaSimpleName: {
                    return BaseInteropInteropNodesFactory.GetMetaSimpleNameNodeGen.create();
                }
                case IsMetaInstance: {
                    return BaseInteropInteropNodesFactory.IsMetaInstanceNodeGen.create();
                }
                case HasMetaObject: {
                    return BaseInteropInteropNodesFactory.HasMetaObjectNodeGen.create();
                }
                case GetMetaObject: {
                    return BaseInteropInteropNodesFactory.GetMetaObjectNodeGen.create();
                }
                case HasMetaParents: {
                    return BaseInteropInteropNodesFactory.HasMetaParentsNodeGen.create();
                }
                case GetMetaParents: {
                    return BaseInteropInteropNodesFactory.GetMetaParentsNodeGen.create();
                }
                case IsIdenticalOrUndefined: {
                    return BaseInteropInteropNodesFactory.IsIdenticalOrUndefinedNodeGen.create();
                }
                case IdentityHashCode: {
                    return BaseInteropInteropNodesFactory.IdentityHashCodeNodeGen.create();
                }
                case HasLanguage: {
                    return BaseInteropInteropNodesFactory.HasLanguageNodeGen.create();
                }
                case GetLanguage: {
                    return BaseInteropInteropNodesFactory.GetLanguageNodeGen.create();
                }
                case ToDisplayString: {
                    return BaseInteropInteropNodesFactory.ToDisplayStringNodeGen.create();
                }
            }
            return null;
        }
    }

    static abstract class ToDisplayStringNode
    extends InteropMessage.ToDisplayString {
        ToDisplayStringNode() {
        }

        @Specialization
        static Object toDisplayString(StaticObject object, boolean allowSideEffects) {
            return BaseInterop.toDisplayString(object, allowSideEffects);
        }
    }

    static abstract class GetLanguageNode
    extends InteropMessage.GetLanguage {
        GetLanguageNode() {
        }

        @Specialization
        static Class<? extends TruffleLanguage<?>> getLanguage(StaticObject object) {
            return BaseInterop.getLanguage(object);
        }
    }

    static abstract class HasLanguageNode
    extends InteropMessage.HasLanguage {
        HasLanguageNode() {
        }

        @Specialization
        static boolean hasLanguage(StaticObject object) {
            return BaseInterop.hasLanguage(object);
        }
    }

    static abstract class IdentityHashCodeNode
    extends InteropMessage.IdentityHashCode {
        IdentityHashCodeNode() {
        }

        @Specialization
        static int identityHashCode(StaticObject object) {
            return BaseInterop.identityHashCode(object);
        }
    }

    static abstract class IsIdenticalOrUndefinedNode
    extends InteropMessage.IsIdenticalOrUndefined {
        IsIdenticalOrUndefinedNode() {
        }

        @Specialization
        static TriState isIdenticalOrUndefined(StaticObject receiver, Object other, @Cached(value="create($parameters)") BaseInterop.IsIdenticalOrUndefinedImplNode node) {
            return BaseInterop.isIdenticalOrUndefined(receiver, other, node);
        }
    }

    static abstract class GetMetaParentsNode
    extends InteropMessage.GetMetaParents {
        GetMetaParentsNode() {
        }

        @Specialization
        static Object getMetaParents(StaticObject object, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException {
            return BaseInterop.getMetaParents(object, error);
        }
    }

    static abstract class HasMetaParentsNode
    extends InteropMessage.HasMetaParents {
        HasMetaParentsNode() {
        }

        @Specialization
        static boolean hasMetaParents(StaticObject object) {
            return BaseInterop.hasMetaParents(object);
        }
    }

    static abstract class GetMetaObjectNode
    extends InteropMessage.GetMetaObject {
        GetMetaObjectNode() {
        }

        @Specialization
        static Object getMetaObject(StaticObject object, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException {
            return BaseInterop.getMetaObject(object, error);
        }
    }

    static abstract class HasMetaObjectNode
    extends InteropMessage.HasMetaObject {
        HasMetaObjectNode() {
        }

        @Specialization
        static boolean hasMetaObject(StaticObject object) {
            return BaseInterop.hasMetaObject(object);
        }
    }

    static abstract class IsMetaInstanceNode
    extends InteropMessage.IsMetaInstance {
        IsMetaInstanceNode() {
        }

        @Specialization
        static boolean isMetaInstance(StaticObject object, Object instance, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException {
            return BaseInterop.isMetaInstance(object, instance, error);
        }
    }

    static abstract class GetMetaSimpleNameNode
    extends InteropMessage.GetMetaSimpleName {
        GetMetaSimpleNameNode() {
        }

        @Specialization
        static Object getMetaSimpleName(StaticObject object, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException {
            return BaseInterop.getMetaSimpleName(object, error);
        }
    }

    static abstract class GetMetaQualifiedNameNode
    extends InteropMessage.GetMetaQualifiedName {
        GetMetaQualifiedNameNode() {
        }

        @Specialization
        static Object getMetaQualifiedName(StaticObject object, @Cached(value="create($parameters)") BranchProfile error) throws UnsupportedMessageException {
            return BaseInterop.getMetaQualifiedName(object, error);
        }
    }

    static abstract class IsMetaObjectNode
    extends InteropMessage.IsMetaObject {
        IsMetaObjectNode() {
        }

        @Specialization
        static boolean isMetaObject(StaticObject object) {
            return BaseInterop.isMetaObject(object);
        }
    }

    static abstract class AsStringNode
    extends InteropMessage.AsString {
        AsStringNode() {
        }

        @Specialization
        static String asString(StaticObject object) throws UnsupportedMessageException {
            return BaseInterop.asString(object);
        }
    }

    static abstract class IsStringNode
    extends InteropMessage.IsString {
        IsStringNode() {
        }

        @Specialization
        static boolean isString(StaticObject object) {
            return BaseInterop.isString(object);
        }
    }

    static abstract class IsNullNode
    extends InteropMessage.IsNull {
        IsNullNode() {
        }

        @Specialization
        static boolean isNull(StaticObject object) {
            return BaseInterop.isNull(object);
        }
    }
}

